/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogSettings;

public class DialogValuesHistoryStorage {
    private final int historyLengths;
    private IDialogSettings section;
    private String sectionName;
    private static Map these = new Hashtable();

    private DialogValuesHistoryStorage(Class dialogClass, IDialogSettings pluginSettings, int historyLength) {
        this.sectionName = dialogClass.getName();
        int lastDot = this.sectionName.lastIndexOf(46);
        if (lastDot > 0) {
            this.sectionName = this.sectionName.substring(lastDot + 1);
        }
        this.section = pluginSettings.getSection(this.sectionName);
        if (this.section == null) {
            this.section = pluginSettings.addNewSection(this.sectionName);
        }
        this.historyLengths = historyLength;
    }

    public static DialogValuesHistoryStorage getInstance(Class dialogClass, IDialogSettings pluginSettings, int historyLengths) {
        DialogValuesHistoryStorage thiz = (DialogValuesHistoryStorage)these.get(dialogClass);
        if (thiz == null) {
            thiz = new DialogValuesHistoryStorage(dialogClass, pluginSettings, historyLengths);
            these.put(dialogClass, thiz);
        }
        return thiz;
    }

    public String[] getHistory(String fieldName) {
        String[] arr = this.section.getArray(this.getHistoryKey(fieldName));
        if (arr == null) {
            arr = new String[]{};
        }
        return arr;
    }

    public String getMRU(String fieldName, String defaultValue) {
        String v = this.section.get(this.getPreviousKey(fieldName));
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public int getMRU(String fieldName, int defaultValue) {
        String v = this.section.get(this.getPreviousKey(fieldName));
        if (v == null) {
            return defaultValue;
        }
        return new Integer(v);
    }

    public void remember(String fieldName, int value) {
        this.section.put(this.getPreviousKey(fieldName), value);
    }

    public void remember(String fieldName, String value) {
        Vector values = this.createVector(this.getHistory(fieldName));
        if (values.contains(value)) {
            values.remove(value);
        }
        values.add(0, value);
        while (values.size() > this.historyLengths) {
            values.remove(this.historyLengths);
        }
        String[] arr = values.toArray(new String[values.size()]);
        this.section.put(this.getHistoryKey(fieldName), arr);
        this.section.put(this.getPreviousKey(fieldName), value);
    }

    private Vector createVector(Object[] arr) {
        Vector<Object> v = new Vector<Object>();
        int ix = 0;
        while (ix < arr.length) {
            v.add(ix, arr[ix]);
            ++ix;
        }
        return v;
    }

    private String getHistoryKey(String fieldName) {
        return String.valueOf(this.sectionName) + '-' + fieldName + "-history";
    }

    private String getPreviousKey(String fieldName) {
        return String.valueOf(this.sectionName) + '-' + fieldName + "-previous";
    }
}

