/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.internal.FormTextUtil;
import com.ibm.cic.common.ui.internal.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.themes.ColorUtil;

public class CommonUIUtils {
    public static final int CompletionStatusSuccess = 0;
    public static final int CompletionStatusFail = 1;
    public static final int CompletionStatusCancel = 2;
    public static final int CompletionStatusWarning = 3;
    public static final int DEFAULT_LONG_OPERATION_DELAY = 800;
    private static final String WINDOWS_SERVER_2003 = "Windows Server 2003";

    public static boolean isWindowsServer2003() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.equalsIgnoreCase(WINDOWS_SERVER_2003);
    }

    public static Font createBoldFont(Display display, Font regularFont) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = regularFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setStyle(element.getStyle() | 1);
            ++n2;
        }
        return new Font((Device)display, fontData);
    }

    public static Color createDisabledColor(Display display) {
        RGB foreground = display.getSystemColor(24).getRGB();
        RGB background = display.getSystemColor(25).getRGB();
        RGB blended = ColorUtil.blend((RGB)foreground, (RGB)background);
        Color grey = new Color((Device)display, blended);
        return grey;
    }

    public static String generateDetailResultText(int severity, IStatus status) {
        return CommonUIUtils.generateDetailResultText(severity, status, 0, false);
    }

    public static String generateDetailResultText(int severity, IStatus status, boolean useFormTextTags) {
        return CommonUIUtils.generateDetailResultText(severity, status, 0, useFormTextTags);
    }

    public static String generateDetailResultText(int severity, IStatus status, int level, boolean useTags) {
        if (status == null) {
            return "";
        }
        if (status.getSeverity() == 8 || status.getSeverity() == 0) {
            return "";
        }
        if (status.getSeverity() != severity) {
            return "";
        }
        StringBuffer sbText = new StringBuffer();
        String openTag = "";
        String closeTag = "";
        int emspaceWidth = 8;
        try {
            emspaceWidth = CommonUIUtils.calculateStringWidth((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "M", 0);
        }
        catch (Exception exception) {}
        int indentWidth = emspaceWidth * 3;
        if (status.getMessage() != null && !status.getMessage().equals("")) {
            if (useTags) {
                if (level > 0) {
                    openTag = "<li style='text' value='' indent='" + level * indentWidth + "'>";
                    closeTag = "</li>";
                } else {
                    openTag = "<p>";
                    closeTag = "</p>";
                }
                sbText.append(openTag);
                sbText.append(FormTextUtil.escapeHTMLString(status.getMessage()));
                sbText.append(closeTag);
            } else {
                int i = 0;
                while (i < level) {
                    sbText.append("   ");
                    ++i;
                }
                sbText.append(StatusUtil.stripAnchors((String)status.getMessage()));
                sbText.append("\n");
            }
            ++level;
        }
        IStatus[] sChildren = status.getChildren();
        ArrayList<IStatus> statusBuffer = new ArrayList<IStatus>();
        int i = 0;
        while (i < sChildren.length) {
            if (!CommonUIUtils.isStatusFoundInList(sChildren[i], statusBuffer)) {
                sbText.append(CommonUIUtils.generateDetailResultText(severity, sChildren[i], level, useTags));
                statusBuffer.add(sChildren[i]);
            }
            ++i;
        }
        return sbText.toString();
    }

    private static boolean isStatusFoundInList(IStatus s1, List list) {
        int i = 0;
        while (i < list.size()) {
            IStatus s2 = (IStatus)list.get(i);
            if (MultiStatusUtil.isDeepEqualStatus((MultiStatusUtil.IStatusEqual)MultiStatusUtil.StatusEqualByMessage, (IStatus)s1, (IStatus)s2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static PreferenceDialog createPreferenceDialogOn(Shell shell, String preferencePageId, String[] displayedIds, Object data, String[] filterIds) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, null, null, null);
        final List<String> filterList = Arrays.asList(filterIds);
        TreeViewer treeViewer = dialog.getTreeViewer();
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String id;
                return !(element instanceof PreferenceNode) || !filterList.contains(id = ((PreferenceNode)element).getId());
            }
        });
        return dialog;
    }

    public static boolean runningBiDiLocale() {
        return Locale.getDefault().getLanguage().equals(new Locale(LanguageCode.ARABIC.getId()).getLanguage()) || Locale.getDefault().getLanguage().equals(new Locale(LanguageCode.HEBREW.getId()).getLanguage());
    }

    public static String escapeSpecialChars(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    buf.append(" ");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getDialogTitleBasedOnStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return Messages.DialogTitle_Error;
        }
        if (status.getSeverity() == 2) {
            return Messages.DialogTitle_Warning;
        }
        if (status.getSeverity() == 8) {
            return Messages.DialogTitle_Cancel;
        }
        if (status.getSeverity() == 1) {
            return Messages.DialogTitle_Info;
        }
        return "";
    }

    public static int calculateStringWidth(Control control, String text, int numSpace) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        StringBuffer spaces = new StringBuffer();
        int i = 0;
        while (i < numSpace) {
            spaces.append(" ");
            ++i;
        }
        int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)text)).append((String)spaces.toString()).toString()).x;
        gc.dispose();
        return width;
    }
}

