/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.ui.internal.CommonUILabelProvider;
import com.ibm.cic.common.ui.internal.dialogs.TimeTriggeredProgressMonitorDialogWithSocketMonitor;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CicCommonUiPlugin
extends AbstractUIPlugin {
    private static CicCommonUiPlugin plugin;
    private FormColors formColors;
    private FormToolkit formToolkit;
    private CommonUILabelProvider labelProvider;
    private PreferenceStore store;
    private TimeTriggeredProgressMonitorDialogWithSocketMonitor currentProgressDlg;
    private static final String PREFERENCE_FILE_EXTENSION = ".pref";
    private static BundleContext bundleContext;

    static {
        bundleContext = null;
    }

    public CicCommonUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
        if (this.formColors != null) {
            this.formColors.dispose();
        }
        if (this.store != null && this.store.needsSaving()) {
            this.store.save();
        }
        super.stop(context);
        plugin = null;
    }

    public void clearCache() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
            this.formToolkit = null;
        }
        if (this.formColors != null) {
            this.formColors.dispose();
            this.formColors = null;
        }
    }

    public static CicCommonUiPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return CicCommonUiPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)CicCommonUiPlugin.getPluginId(), (String)path);
    }

    public static void logException(Throwable e) {
        CicCommonUiPlugin.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, CicCommonUiPlugin.getPluginId(), 0, message, e);
        }
        CicCommonUiPlugin.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            if (showErrorDialog) {
                WrapDetailUIDErrorDialog.openError(CicCommonUiPlugin.getActiveWorkbenchShell(), null, null, status);
            }
            Bundle bundle = Platform.getBundle((String)CicCommonUiPlugin.getPluginId());
            Platform.getLog((Bundle)bundle).log(status);
        } else {
            MessageDialog.openInformation((Shell)CicCommonUiPlugin.getActiveWorkbenchShell(), null, (String)status.getMessage());
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CicCommonUiPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getDisplay().getActiveShell();
        }
        return DisplayKeeper.INSTANCE.getDisplay().getActiveShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = CicCommonUiPlugin.getDefault().getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    public CommonUILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new CommonUILabelProvider();
        }
        return this.labelProvider;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.store == null) {
            File dir = CicCommonSettings.getApplicationPreferenceLocation().toFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            IPath prefName = CicCommonSettings.getApplicationPreferenceLocation().append(String.valueOf(CicCommonUiPlugin.getDefault().getBundle().getSymbolicName()) + PREFERENCE_FILE_EXTENSION);
            this.store = new PreferenceStore(prefName.toString());
            try {
                if (prefName.toFile().exists()) {
                    this.store.load();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.store;
    }

    public FormToolkit getFormToolkit() {
        if (this.formToolkit == null) {
            this.formToolkit = new FormToolkit(this.getFormColors());
            this.formToolkit.setBorderStyle(2048);
        }
        return this.formToolkit;
    }

    public FormColors getFormColors() {
        if (this.formColors == null) {
            this.formColors = new FormColors(DisplayKeeper.INSTANCE.getDisplay()){

                public void initializeSectionToolBarColors() {
                    if (this.colorRegistry.containsKey("org.eclipse.ui.forms.TB_BG")) {
                        return;
                    }
                    RGB rgb = this.getBackground().getRGB();
                    this.createColor("org.eclipse.ui.forms.TB_BG", rgb);
                    this.createColor("org.eclipse.ui.forms.TB_BORDER", rgb);
                }
            };
            this.formColors.markShared();
        }
        return this.formColors;
    }

    public void runWithSocketMonitor(boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.runWithSocketMonitor(cancelable, runnable, this.getLongOperationDelay());
    }

    public void runWithSocketMonitor(boolean cancelable, IRunnableWithProgress runnable, int delayTime) throws InvocationTargetException, InterruptedException {
        Shell shell = CicCommonUiPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            TimeTriggeredProgressMonitorDialogWithSocketMonitor dialog = new TimeTriggeredProgressMonitorDialogWithSocketMonitor(shell, delayTime);
            try {
                this.currentProgressDlg = dialog;
                this.setUserInterfaceActive(false);
                dialog.run(true, cancelable, runnable);
            }
            finally {
                this.setUserInterfaceActive(true);
                this.currentProgressDlg = null;
            }
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public int getLongOperationDelay() {
        IWorkbench workbench = this.getWorkbench();
        if (workbench != null) {
            return workbench.getProgressService().getLongOperationTime();
        }
        return 800;
    }

    public Shell getTimeTriggeredProgressDlgShell() {
        Shell shell = null;
        TimeTriggeredProgressMonitorDialogWithSocketMonitor dlg = this.currentProgressDlg;
        if (dlg == null) {
            shell = CicCommonUiPlugin.getActiveWorkbenchShell();
        } else {
            dlg.open();
            shell = dlg.getShell();
        }
        return shell;
    }

    private void setUserInterfaceActive(boolean active) {
        Shell[] shells = DisplayKeeper.INSTANCE.getDisplay().getShells();
        if (active) {
            int i = 0;
            while (i < shells.length) {
                if (!shells[i].isDisposed()) {
                    shells[i].setEnabled(active);
                    if (i == shells.length - 1) {
                        shells[i].redraw(0, 0, shells[i].getSize().x, shells[i].getSize().y, true);
                    }
                    shells[i].forceFocus();
                }
                ++i;
            }
        } else {
            int i = shells.length - 1;
            while (i >= 0) {
                if (!shells[i].isDisposed()) {
                    shells[i].setEnabled(active);
                }
                --i;
            }
        }
    }
}

