/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmLicenseElementException;
import com.macrovision.flexlm.HostId;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.DupGroup;
import com.macrovision.flexlm.lictext.FlexlmDate;
import com.macrovision.flexlm.lictext.FlexlmVersion;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.PackageComponent;
import com.macrovision.flexlm.lictext.PackageLine;
import com.macrovision.flexlm.lictext.PriKey;
import com.macrovision.flexlm.lictext.ServerLine;
import com.macrovision.flexlm.lictext.TokenizedLicenseLine;
import com.macrovision.flexlm.lictext.UpgradeLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LicenseElement
implements FlexlmConstants,
FlexlmInternalConstants,
Comparable {
    private static String vendorKeyPatternString = "(\\w+)=\\(([^()]*)\\)";
    private static String vendorKeyListPatternString = "((\\w|\\.)+)=((\\w+)|\".*\")";
    private static Pattern vendorKeyPattern = Pattern.compile(vendorKeyPatternString);
    private static Pattern vendorKeyListPattern = Pattern.compile(vendorKeyListPatternString);
    private static final String[] vendorSignatureNames = new String[]{"LK", "SIGN", "SIGN2", "V7.1_LK", "V7.1_SIGN", "V7.1", "V8.0_LK", "V8.0_SIGN", "V8.0", "V8.1_LK", "V8.1_SIGN", "V8.1_SIGN2", "V8.1", "V8.4_LK", "V8.4_SIGN", "V8.4_SIGN2", "V8.4", "V10.1_LK", "V10.1_SIGN", "V10.1_SIGN2", "V10.1", "V10.8_LK", "V10.8_SIGN", "V10.8_SIGN2", "V10.8"};
    boolean authentic;
    boolean authenticationAttempted;
    LicenseCertificate certificate;
    TokenizedLicenseLine licenseLine;
    VendorInfo vInfo;
    String lineText;
    String rawLineText;
    boolean isDirty;
    int lineNumber;
    String filename;
    Vector tokens;
    int type;
    protected String name;
    protected String vendor;
    protected FlexlmVersion version;
    protected String code;
    protected String signature1;
    protected String signature2;
    protected String cvdAuth;
    protected Map cvdSignatureMap = new HashMap();
    protected FlexlmDate expirationDate;
    protected int count;
    protected HostId hostid;
    protected boolean isFeature;
    protected String vendorString;
    protected String notice;
    protected String serial;
    protected String issuer;
    protected FlexlmDate startDate;
    protected FlexlmDate issuedDate;
    protected DupGroup dupGroup;
    protected DupGroup suiteDupGroup;
    protected boolean supersedePresent;
    protected String[] namesSuperseded;
    protected boolean hostBasedPresent;
    protected boolean userBasedPresent;
    protected int hostBased;
    protected int userBased;
    protected boolean terminalServerOK;
    protected boolean oneTerminalServerOK;
    protected boolean borrowPresent;
    protected int borrow;
    protected boolean capacity;
    protected boolean floatOKPresent;
    protected HostId floatOKHostid;
    protected int minimum;
    protected int overdraft;
    protected String[] platforms;
    protected String assetInfo;
    protected String distInfo;
    protected String userInfo;
    protected String vendorInfo;
    protected String wrapBinary;
    protected int wrapQueue;
    protected String wrapArgv;
    protected int wrapTermSignal;
    protected int wrapLicLoss;
    protected int checksum;
    protected int sort;
    protected int strength;
    protected PackageComponent[] components;
    protected String componentString;
    protected String options;
    protected FlexlmVersion fromVersion;
    protected LicenseElement supersededBy;
    protected UpgradeLine upgradedBy;
    protected PackageLine expandedFrom;
    private static final int LINE_LENGTH_LIMIT = 75;
    private static final int TAB_LENGTH = 8;

    public abstract boolean isAuthentic();

    public abstract void authenticate() throws FlexlmException;

    public int compareTo(Object object) {
        return 0;
    }

    protected boolean cryptEquals(LicenseElement licenseElement) {
        byte[] byArray = this.buildCryptBuffer();
        byte[] byArray2 = licenseElement.buildCryptBuffer();
        return Arrays.equals(byArray, byArray2);
    }

    public void setStrength(int n) {
        this.strength = n < 0 ? this.vInfo.getDefaultStrength() : n;
    }

    public boolean isSuperseded() {
        return this.supersededBy != null;
    }

    protected void assignTokensToFields(TokenizedLicenseLine tokenizedLicenseLine, LicenseCertificate licenseCertificate, VendorInfo vendorInfo, int n, ArrayList arrayList, String[] stringArray) throws FlexlmException {
        Object object;
        this.certificate = licenseCertificate;
        this.licenseLine = tokenizedLicenseLine;
        this.type = this.licenseLine.getType();
        this.filename = this.licenseLine.getFilename();
        this.lineNumber = this.licenseLine.getLineNumber();
        this.lineText = this.licenseLine.getLineText();
        this.rawLineText = this.licenseLine.getRawLineText();
        this.vInfo = vendorInfo;
        this.strength = vendorInfo.getDefaultStrength();
        tokenizedLicenseLine.findPositionalsAndKeywordValues(stringArray);
        Vector vector = this.licenseLine.getPositionalParameters();
        if (vector.size() < n) {
            throw new FlexlmLicenseElementException(-505, 4001, this.filename, this.lineNumber, this.lineText, this.name);
        }
        int n2 = arrayList.indexOf("Name");
        if (n2 >= 0 && n2 < vector.size()) {
            this.name = (String)vector.elementAt(n2);
        }
        if ((n2 = arrayList.indexOf("Vendor")) >= 0 && n2 < vector.size()) {
            this.vendor = (String)vector.elementAt(n2);
        }
        if ((n2 = arrayList.indexOf("Version")) >= 0 && n2 < vector.size()) {
            this.version = new FlexlmVersion((String)vector.elementAt(n2));
        }
        if ((n2 = arrayList.indexOf("FromVersion")) >= 0 && n2 < vector.size()) {
            this.fromVersion = new FlexlmVersion((String)vector.elementAt(n2));
        }
        if ((n2 = arrayList.indexOf("Expiration")) >= 0 && n2 < vector.size()) {
            try {
                this.expirationDate = new FlexlmDate((String)vector.elementAt(n2));
            }
            catch (FlexlmLicenseElementException flexlmLicenseElementException) {
                throw new FlexlmLicenseElementException(flexlmLicenseElementException.getMajor(), flexlmLicenseElementException.getMinor(), this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((n2 = arrayList.indexOf("Count")) >= 0 && n2 < vector.size()) {
            object = (String)vector.elementAt(n2);
            if (((String)object).equalsIgnoreCase("uncounted")) {
                this.count = 0;
            } else {
                try {
                    this.count = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmLicenseElementException(-502, 4002, this.filename, this.lineNumber, this.lineText, this.name);
                }
                if (this.count < 0) {
                    throw new FlexlmLicenseElementException(-502, 4003, this.filename, this.lineNumber, this.lineText, this.name);
                }
            }
        }
        if ((n2 = arrayList.indexOf("Code")) >= 0 && n2 < vector.size()) {
            this.code = (String)vector.elementAt(n2);
        }
        if ((n2 = arrayList.indexOf("VENDOR_STRING")) >= 0 && n2 < vector.size()) {
            this.vendorString = (String)vector.elementAt(n2);
        }
        if ((n2 = arrayList.indexOf("HOSTID")) >= 0 && n2 < vector.size()) {
            this.hostid = LicenseElement.doHostid((String)vector.elementAt(n2), this.vInfo);
            if (this.hostid == null) {
                throw new FlexlmLicenseElementException(-503, 4022, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if (this.type == 4 && ((String)(object = (String)vector.elementAt(n2 = arrayList.indexOf("Keyword")))).equals("FEATURE")) {
            this.isFeature = true;
        }
        if ((object = tokenizedLicenseLine.getKeywordParameters()) == null) {
            return;
        }
        String string = (String)((Hashtable)object).get("SIGN");
        if (string != null && string.length() != 0) {
            this.signature1 = string;
        }
        if ((string = (String)((Hashtable)object).get("SIGN2")) != null && string.length() != 0) {
            this.signature2 = string;
        }
        if ((string = (String)((Hashtable)object).get("AUTH")) != null && string.length() != 0) {
            this.cvdAuth = string;
        }
        this.parseCvdAuth();
        string = (String)((Hashtable)object).get("HOSTID");
        if (string != null && string.length() != 0) {
            this.hostid = LicenseElement.doHostid(string, this.vInfo);
            if (this.hostid == null) {
                throw new FlexlmLicenseElementException(-503, 4023, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((string = (String)((Hashtable)object).get("VENDOR_STRING")) != null && string.length() != 0) {
            this.vendorString = string;
        }
        if ((string = (String)((Hashtable)object).get("NOTICE")) != null && string.length() != 0) {
            this.notice = string;
        }
        if ((string = (String)((Hashtable)object).get("SN")) != null && string.length() != 0) {
            this.serial = string;
        }
        if ((string = (String)((Hashtable)object).get("ISSUER")) != null && string.length() != 0) {
            this.issuer = string;
        }
        if ((string = (String)((Hashtable)object).get("START")) != null && string.length() != 0) {
            this.startDate = new FlexlmDate(string);
        }
        if ((string = (String)((Hashtable)object).get("ISSUED")) != null && string.length() != 0) {
            this.issuedDate = new FlexlmDate(string);
        }
        if ((string = (String)((Hashtable)object).get("DUP_GROUP")) != null && string.length() != 0) {
            this.dupGroup = new DupGroup(string);
        }
        if ((string = (String)((Hashtable)object).get("SUITE_DUP_GROUP")) != null && string.length() != 0) {
            this.suiteDupGroup = new DupGroup(string);
        }
        if ((string = (String)((Hashtable)object).get("SUPERSEDE")) != null) {
            this.supersedePresent = true;
            if (string.length() != 0) {
                this.namesSuperseded = LicenseElement.toStringArray(string);
            }
        }
        if ((string = (String)((Hashtable)object).get("HOST_BASED")) != null) {
            this.hostBasedPresent = true;
            if (string.length() != 0) {
                try {
                    this.hostBased = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmLicenseElementException(-501, 4004, this.filename, this.lineNumber, this.lineText, this.name);
                }
            } else {
                this.hostBased = this.count;
            }
        }
        if ((string = (String)((Hashtable)object).get("USER_BASED")) != null) {
            this.userBasedPresent = true;
            if (string.length() != 0) {
                try {
                    this.userBased = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmLicenseElementException(-501, 4005, this.filename, this.lineNumber, this.lineText, this.name);
                }
            } else {
                this.userBased = this.count;
            }
        }
        if ((string = (String)((Hashtable)object).get("TS_OK")) != null) {
            this.terminalServerOK = true;
        }
        if ((string = (String)((Hashtable)object).get("ONE_TS_OK")) != null) {
            this.oneTerminalServerOK = true;
        }
        if ((string = (String)((Hashtable)object).get("BORROW")) != null) {
            this.borrowPresent = true;
            if (string.length() != 0) {
                try {
                    this.borrow = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmLicenseElementException(-501, 4006, this.filename, this.lineNumber, this.lineText, this.name);
                }
            } else {
                this.borrow = 168;
            }
        }
        if ((string = (String)((Hashtable)object).get("CAPACITY")) != null) {
            this.capacity = true;
        }
        if ((string = (String)((Hashtable)object).get("FLOAT_OK")) != null) {
            if (string.length() != 0) {
                this.floatOKHostid = LicenseElement.doHostid(string, this.vInfo);
                if (this.hostid == null) {
                    throw new FlexlmLicenseElementException(-503, 4024, this.filename, this.lineNumber, this.lineText, this.name);
                }
            }
            this.floatOKPresent = true;
        }
        if ((string = (String)((Hashtable)object).get("MINIMUM")) != null && string.length() != 0) {
            try {
                this.minimum = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-501, 4008, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((string = (String)((Hashtable)object).get("OVERDRAFT")) != null && string.length() != 0) {
            try {
                this.overdraft = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-501, 4009, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((string = (String)((Hashtable)object).get("PLATFORMS")) != null && string.length() != 0) {
            this.platforms = LicenseElement.toStringArray(string);
        }
        if ((string = (String)((Hashtable)object).get("OPTIONS")) != null && string.length() > 0) {
            this.options = string;
        }
        if ((string = (String)((Hashtable)object).get("COMPONENTS")) != null && string.length() > 0) {
            this.componentString = string;
            String[] stringArray2 = LicenseElement.toStringArray(string);
            this.components = new PackageComponent[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                try {
                    this.components[i] = new PackageComponent(stringArray2[i]);
                    continue;
                }
                catch (FlexlmException flexlmException) {
                    throw new FlexlmLicenseElementException(-82, flexlmException.getMinor(), this.filename, this.lineNumber, this.lineText, this.name);
                }
            }
        }
        if ((string = (String)((Hashtable)object).get("asset_info")) != null && string.length() != 0) {
            this.assetInfo = string;
        }
        if ((string = (String)((Hashtable)object).get("dist_info")) != null && string.length() != 0) {
            this.distInfo = string;
        }
        if ((string = (String)((Hashtable)object).get("user_info")) != null && string.length() != 0) {
            this.userInfo = string;
        }
        if ((string = (String)((Hashtable)object).get("vendor_info")) != null && string.length() != 0) {
            this.vendorInfo = string;
        }
        if ((string = (String)((Hashtable)object).get("ck")) != null && string.length() != 0) {
            try {
                this.checksum = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-501, 4010, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((string = (String)((Hashtable)object).get("sort")) != null && string.length() != 0) {
            try {
                this.sort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-501, 4025, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((string = (String)((Hashtable)object).get("w_binary")) != null && string.length() != 0) {
            this.wrapBinary = string;
        }
        if ((string = (String)((Hashtable)object).get("w_argv")) != null && string.length() != 0) {
            this.wrapArgv = string;
        }
        if ((string = (String)((Hashtable)object).get("w_queue")) != null && string.length() != 0) {
            try {
                this.wrapQueue = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-501, 4075, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((string = (String)((Hashtable)object).get("w_term_signal")) != null && string.length() != 0) {
            try {
                this.wrapTermSignal = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-501, 4076, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
        if ((string = (String)((Hashtable)object).get("W_LIC_LOSS")) != null && string.length() != 0) {
            try {
                this.wrapLicLoss = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmLicenseElementException(-501, 4077, this.filename, this.lineNumber, this.lineText, this.name);
            }
        }
    }

    protected String getLineText() {
        return this.lineText;
    }

    protected String getRawLineText() {
        return this.rawLineText;
    }

    void doAuthenticate() throws FlexlmException {
        byte[] byArray;
        boolean bl;
        byte[] byArray2 = this.buildCryptBuffer();
        boolean bl2 = this.signature2 != null;
        boolean bl3 = bl = this.signature1 != null;
        if (!bl && !bl2) {
            throw new FlexlmLicenseElementException(-516, 4035, this.filename, this.lineNumber, this.lineText, this.name);
        }
        boolean bl4 = false;
        if (bl2) {
            byArray = LicenseElement.hexToBinBytes(this.signature2);
            bl4 = PriKey.pubkeyVerify(byArray2, byArray, this.vInfo, this.strength);
        }
        if (!bl4 && bl) {
            byArray = LicenseElement.hexToBinBytes(this.signature1);
            bl4 = PriKey.pubkeyVerify(byArray2, byArray, this.vInfo, this.strength);
        }
        this.authentic = bl4;
        this.authenticationAttempted = true;
        if (!bl4) {
            throw new FlexlmLicenseElementException(-8, 4048, this.filename, this.lineNumber, this.lineText, this.name);
        }
    }

    private byte[] buildCryptBuffer() {
        int n;
        int n2;
        Object[] objectArray;
        LinkedList linkedList;
        byte[] byArray = new byte[4096];
        int n3 = 0;
        n3 = this.addHostId(byArray, n3, this.hostid);
        if (this.type == 4 && !this.isFeature) {
            n3 = this.addInt(byArray, n3, -805230353);
        } else if (this.type == 3) {
            n3 = this.addInt(byArray, n3, 59629293);
        } else if (this.type == 5) {
            n3 = this.addInt(byArray, n3, 285552499);
            n3 = this.addInt(byArray, n3, this.fromVersion.getWhole());
            n3 = this.addInt(byArray, n3, this.fromVersion.getCryptFraction());
        }
        n3 = this.addInt(byArray, n3, this.count);
        if (this.count > 0 && (linkedList = this.certificate.getServers()).size() > 0) {
            ListIterator listIterator = linkedList.listIterator(0);
            objectArray = new HostId[linkedList.size()];
            int n4 = 0;
            while (listIterator.hasNext()) {
                HostId hostId = ((ServerLine)listIterator.next()).getHostId();
                if (hostId == null) continue;
                objectArray[n4++] = hostId;
            }
            if (n4 > 0) {
                Arrays.sort(objectArray, 0, n4);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                n3 = this.addHostId(byArray, n3, (HostId)objectArray[i]);
            }
        }
        n3 = this.addString(byArray, n3, null, this.name);
        n3 = this.addInt(byArray, n3, this.version.getWhole());
        n3 = this.addInt(byArray, n3, this.version.getCryptFraction());
        n3 = this.addString(byArray, n3, null, this.vendorString);
        n3 = this.addString(byArray, n3, null, this.componentString);
        n3 = this.addDate(byArray, n3, this.expirationDate);
        n3 = this.addInt(byArray, n3, 1943061895);
        if (this.dupGroup != null) {
            n3 = this.addKeywordInt(byArray, n3, "DUP_GROUP", this.dupGroup.getDupMask());
        }
        if (this.suiteDupGroup != null) {
            n3 = this.addKeywordInt(byArray, n3, "SUITE_DUP_GROUP", this.suiteDupGroup.getDupMask());
        }
        if (this.overdraft != 0) {
            n3 = this.addKeywordInt(byArray, n3, "OVERDRAFT", this.overdraft);
        }
        if ((n2 = this.getTypeMask()) != 0) {
            n3 = this.addKeywordInt(byArray, n3, "TYPE", n2);
            if (this.userBasedPresent) {
                n3 = this.addKeywordInt(byArray, n3, "USER_BASED", this.userBased);
            }
            if (this.hostBasedPresent) {
                n3 = this.addKeywordInt(byArray, n3, "HOST_BASED", this.hostBased);
            }
            if (this.minimum != 0) {
                n3 = this.addKeywordInt(byArray, n3, "MINIMUM", this.minimum);
            }
            if (this.platforms != null) {
                for (int i = 0; i < this.platforms.length; ++i) {
                    n3 = this.addString(byArray, n3, "PLATFORMS", this.platforms[i]);
                }
            }
            if (this.borrowPresent) {
                n3 = this.addKeywordInt(byArray, n3, "BORROW", this.borrow);
            }
        }
        if ((n = this.getOptionsMask()) != 0) {
            n3 = this.addKeywordInt(byArray, n3, "PKGOPT", n);
            if (this.namesSuperseded != null) {
                for (int i = 0; i < this.namesSuperseded.length; ++i) {
                    n3 = this.addString(byArray, n3, "SUPERSEDE", this.namesSuperseded[i]);
                }
            }
        }
        n3 = this.addString(byArray, n3, "ISSUER", this.issuer);
        n3 = this.addDate(byArray, n3, this.issuedDate);
        n3 = this.addString(byArray, n3, "NOTICE", this.notice);
        n3 = this.addString(byArray, n3, "SN", this.serial);
        if (this.startDate != null) {
            n3 = this.addString(byArray, n3, null, "START");
            n3 = this.addDate(byArray, n3, this.startDate);
        }
        objectArray = new byte[n3];
        System.arraycopy(byArray, 0, objectArray, 0, objectArray.length);
        return objectArray;
    }

    private int getTypeMask() {
        int n = 0;
        if (this.capacity) {
            n |= 1;
        }
        if (this.hostBasedPresent) {
            n |= 4;
        }
        if (this.userBasedPresent) {
            n |= 8;
        }
        if (this.minimum != 0) {
            n |= 0x10;
        }
        if (this.platforms != null) {
            n |= 0x20;
        }
        if (this.borrowPresent) {
            n |= 0x100;
        }
        if (this.floatOKPresent) {
            n |= 0x40;
        }
        if (this.terminalServerOK) {
            n |= 0x80;
        }
        if (this.oneTerminalServerOK) {
            n |= 0x200;
        }
        return n;
    }

    private int getOptionsMask() {
        int n = 0;
        if (this.options != null) {
            if (this.options.equals("SUITE")) {
                n |= 1;
            } else if (this.options.equals("SUITE_RESERVED")) {
                n |= 0x10;
            }
        }
        if (this.supersedePresent) {
            n |= 2;
        }
        return n;
    }

    private static HostId doHostid(String string, VendorInfo vendorInfo) {
        HostId hostId = HostId.parseHostId(string, vendorInfo);
        return hostId;
    }

    private void parseCvdAuth() {
        if (this.cvdAuth != null) {
            String string = this.cvdAuth.substring(this.cvdAuth.indexOf("{"), this.cvdAuth.lastIndexOf("}"));
            Matcher matcher = vendorKeyPattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Matcher matcher2 = vendorKeyListPattern.matcher(string3);
                while (matcher2.find()) {
                    String string4 = matcher2.group(1);
                    String string5 = matcher2.group(3).replaceAll("\"", "");
                    hashMap.put(string4, string5);
                }
                this.cvdSignatureMap.put(string2, hashMap);
            }
        }
    }

    public String getName() {
        return this.convertEncoding(this.name);
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isAFeature() {
        return this.isFeature;
    }

    public boolean isAnIncrement() {
        return !this.isAFeature();
    }

    public String getVendorName() {
        return this.convertEncoding(this.vendor);
    }

    public String getFromVersion() {
        return this.fromVersion == null ? "" : this.convertEncoding(this.fromVersion.toString());
    }

    public FlexlmVersion getFromVersionObject() {
        return this.fromVersion;
    }

    public String getVersion() {
        return this.version == null ? "" : this.convertEncoding(this.version.toString());
    }

    public FlexlmVersion getVersionObject() {
        return this.version;
    }

    public String getExpirationDate() {
        return this.convertEncoding(this.expirationDate.toString());
    }

    public FlexlmDate getExpirationDateObject() {
        return this.expirationDate;
    }

    public int getIntCount() {
        return this.count;
    }

    public String getCount() {
        if (this.count == 0) {
            return "uncounted";
        }
        return Integer.toString(this.count);
    }

    public String getCode() {
        return this.convertEncoding(this.code);
    }

    public String getSignature() {
        return this.convertEncoding(this.signature1);
    }

    public String getSignature2() {
        return this.convertEncoding(this.signature2);
    }

    public String getCvdAuth() {
        return this.convertEncoding(this.cvdAuth);
    }

    public String[] getSignatures() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.code != null) {
            arrayList.add(this.getCode());
        }
        if (this.signature1 != null) {
            arrayList.add(this.getSignature());
        }
        if (this.signature2 != null) {
            arrayList.add(this.getSignature2());
        }
        if (this.cvdAuth != null) {
            Iterator iterator = this.cvdSignatureMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next().getValue();
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next().getValue();
                    arrayList.add(this.convertEncoding(string));
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public Map getVendorSignatures(String string) {
        HashMap<String, String> hashMap = (HashMap<String, String>)this.cvdSignatureMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            if (this.code != null) {
                hashMap.put("LK", this.getCode());
            }
            if (this.signature1 != null) {
                hashMap.put("SIGN", this.getSignature());
            }
            if (this.signature2 != null) {
                hashMap.put("SIGN2", this.getSignature2());
            }
        }
        return hashMap;
    }

    public String getVendorSignature(String string) {
        Map map = this.getVendorSignatures(string);
        for (int i = 0; i < vendorSignatureNames.length; ++i) {
            if (map.get(vendorSignatureNames[i]) == null) continue;
            return (String)map.get(vendorSignatureNames[i]);
        }
        return null;
    }

    public String getFeatureIdentifier() {
        String string = null;
        if (this.code != null) {
            string = this.code;
        } else if (this.signature1 != null) {
            string = this.signature1;
        } else if (this.signature2 != null) {
            string = this.signature2;
        }
        string = string != null ? string.substring(0, string.length() < 20 ? string.length() : 20) : "";
        return this.convertEncoding(string);
    }

    public HostId getHostId() {
        return this.hostid;
    }

    public String getHostIdString() {
        return this.hostid == null ? null : this.convertEncoding(this.hostid.toString());
    }

    public String getVendorString() {
        return this.convertEncoding(this.vendorString);
    }

    public String getNotice() {
        return this.convertEncoding(this.notice);
    }

    public String getIssuer() {
        return this.convertEncoding(this.issuer);
    }

    public String getSerialNumber() {
        return this.convertEncoding(this.serial);
    }

    public String getStartDate() {
        return this.startDate == null ? null : this.convertEncoding(this.startDate.toString());
    }

    public FlexlmDate getStartDateObject() {
        return this.startDate;
    }

    public String getEncodedStartDate() {
        return null;
    }

    public String getIssuedDate() {
        return this.issuedDate == null ? null : this.convertEncoding(this.issuedDate.toString());
    }

    public FlexlmDate getIssuedDateObject() {
        return this.issuedDate;
    }

    public String getDupGroup() {
        return this.dupGroup == null ? null : this.convertEncoding(this.dupGroup.toString());
    }

    public int getDupMask() {
        return this.dupGroup == null ? 0x8000000 : this.dupGroup.getDupMask();
    }

    public String getSuiteDupGroup() {
        return this.suiteDupGroup == null ? null : this.convertEncoding(this.suiteDupGroup.toString());
    }

    public int getSuiteDupMask() {
        return this.suiteDupGroup == null ? 0x8000000 : this.suiteDupGroup.getDupMask();
    }

    public boolean supersedePresent() {
        return this.supersedePresent;
    }

    public String[] getSupersedeList() {
        return this.namesSuperseded;
    }

    public String getSupersedeListString() {
        String[] stringArray = this.getSupersedeList();
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        return this.convertEncoding("\"" + new String(stringBuffer).trim() + "\"");
    }

    public String[] getPlatformsArray() {
        return this.platforms;
    }

    public String getPlatforms() {
        String string = null;
        if (this.platforms != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.platforms.length; ++i) {
                stringBuffer.append(this.platforms[i] + " ");
            }
            string = new String(stringBuffer);
            string = string.trim();
        }
        return this.convertEncoding(string);
    }

    public boolean getTerminalServerOK() {
        return this.terminalServerOK;
    }

    public boolean getOneTerminalServerOK() {
        return this.oneTerminalServerOK;
    }

    public boolean getBorrowPresent() {
        return this.borrowPresent;
    }

    public int getBorrowCount() {
        return this.borrow;
    }

    public boolean getCapacityPresent() {
        return this.capacity;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getOverdraft() {
        return this.overdraft;
    }

    public boolean floatOkPresent() {
        return this.floatOKPresent;
    }

    public HostId getFloatOkHostid() {
        return this.floatOKHostid;
    }

    public String getFloatOkHostidString() {
        return this.floatOKHostid == null ? null : this.convertEncoding(this.floatOKHostid.toString());
    }

    public boolean isHostBased() {
        return this.hostBasedPresent;
    }

    public int getHostBasedCount() {
        return this.hostBased;
    }

    public boolean isUserBased() {
        return this.userBasedPresent;
    }

    public int getUserBasedCount() {
        return this.userBased;
    }

    public String getAssetInfo() {
        return this.convertEncoding(this.assetInfo);
    }

    public void setAssetInfo(String string) {
        this.isDirty = true;
        this.assetInfo = string;
    }

    public String getDistInfo() {
        return this.convertEncoding(this.distInfo);
    }

    public void setDistInfo(String string) {
        this.isDirty = true;
        this.distInfo = string;
    }

    public String getUserInfo() {
        return this.convertEncoding(this.userInfo);
    }

    public void setUserInfo(String string) {
        this.isDirty = true;
        this.userInfo = string;
    }

    public String getVendorInfo() {
        return this.convertEncoding(this.vendorInfo);
    }

    public void setVendorInfo(String string) {
        this.isDirty = true;
        this.vendorInfo = string;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int n) {
        this.checksum = n;
    }

    public static String[] toStringArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 1) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    protected int addInt(byte[] byArray, int n, int n2) {
        int n3 = n++;
        byArray[n3] = (byte)(byArray[n3] ^ (byte)(n2 & 0xFF));
        if (n2 > 255 || n2 < -256) {
            int n4 = n++;
            byArray[n4] = (byte)(byArray[n4] ^ (byte)(n2 >> 8 & 0xFF));
        }
        if (n2 > 32000 || n2 < -32000) {
            int n5 = n++;
            byArray[n5] = (byte)(byArray[n5] ^ (byte)(n2 >> 16 & 0xFF));
        }
        if (n2 > 16000000 || n2 < -16000000) {
            int n6 = n++;
            byArray[n6] = (byte)(byArray[n6] ^ (byte)(n2 >> 24 & 0xFF));
        }
        return n;
    }

    protected int addHostId(byte[] byArray, int n, HostId hostId) {
        Object object;
        if (hostId == null) {
            return n;
        }
        int n2 = hostId.getCryptCode();
        if (n2 != 0) {
            int n3 = hostId.getType();
            n = this.addInt(byArray, n, n3 >= 1000 ? n2 ^ n3 : n2);
        }
        if ((object = hostId.getValue()) != null) {
            if (object instanceof String) {
                n = this.addString(byArray, n, null, (String)object);
            } else if (object instanceof Integer) {
                n = this.addInt(byArray, n, (Integer)object);
            } else if (object instanceof byte[]) {
                n = this.addBytes(byArray, n, (byte[])object);
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    n = this.addInt(byArray, n, nArray[i]);
                }
            } else if (object instanceof HostId[]) {
                HostId[] hostIdArray = (HostId[])object;
                for (int i = 0; i < hostIdArray.length; ++i) {
                    n = this.addHostId(byArray, n, hostIdArray[i]);
                }
            } else {
                throw new RuntimeException("unknown type returned from HostId.getValue() (HostId =" + hostId.toString() + ")");
            }
        }
        return n;
    }

    public int addString(byte[] byArray, int n, String string, String string2) {
        if (string2 == null) {
            return n;
        }
        String string3 = string != null ? string + "=" + string2 : string2;
        String string4 = LicenseElement.normalizeWhitespace(string3, false);
        byte[] byArray2 = null;
        try {
            byArray2 = string4.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UnsupportedEncodingException on ISO-8859-1");
        }
        byte[] byArray3 = LicenseElement.toFlexUpper(byArray2);
        n = this.addBytes(byArray, n, byArray3);
        return n;
    }

    private static byte[] toFlexUpper(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length > 0) {
            byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray2.length; ++i) {
                char c;
                if ((byArray[i] & 0x80) == 0) {
                    c = (char)byArray[i];
                    c = Character.toUpperCase(c);
                    byArray2[i] = (byte)c;
                    continue;
                }
                c = byArray[i];
                switch (c) {
                    case '\uffffff83': {
                        c = (char)-125;
                        break;
                    }
                    case '\uffffff9a': {
                        c = (char)-118;
                        break;
                    }
                    case '\uffffff9c': {
                        c = (char)-116;
                        break;
                    }
                    case '\uffffff9e': {
                        c = (char)-114;
                        break;
                    }
                    case '\uffffffdf': {
                        c = (char)-33;
                        break;
                    }
                    case '\uffffffe0': {
                        c = (char)-64;
                        break;
                    }
                    case '\uffffffe1': {
                        c = (char)-63;
                        break;
                    }
                    case '\uffffffe2': {
                        c = (char)-62;
                        break;
                    }
                    case '\uffffffe3': {
                        c = (char)-61;
                        break;
                    }
                    case '\uffffffe4': {
                        c = (char)-60;
                        break;
                    }
                    case '\uffffffe5': {
                        c = (char)-59;
                        break;
                    }
                    case '\uffffffe6': {
                        c = (char)-58;
                        break;
                    }
                    case '\uffffffe7': {
                        c = (char)-57;
                        break;
                    }
                    case '\uffffffe8': {
                        c = (char)-56;
                        break;
                    }
                    case '\uffffffe9': {
                        c = (char)-55;
                        break;
                    }
                    case '\uffffffea': {
                        c = (char)-54;
                        break;
                    }
                    case '\uffffffeb': {
                        c = (char)-53;
                        break;
                    }
                    case '\uffffffec': {
                        c = (char)-52;
                        break;
                    }
                    case '\uffffffed': {
                        c = (char)-51;
                        break;
                    }
                    case '\uffffffee': {
                        c = (char)-50;
                        break;
                    }
                    case '\uffffffef': {
                        c = (char)-49;
                        break;
                    }
                    case '\ufffffff0': {
                        c = (char)-48;
                        break;
                    }
                    case '\ufffffff1': {
                        c = (char)-47;
                        break;
                    }
                    case '\ufffffff2': {
                        c = (char)-46;
                        break;
                    }
                    case '\ufffffff3': {
                        c = (char)-45;
                        break;
                    }
                    case '\ufffffff4': {
                        c = (char)-44;
                        break;
                    }
                    case '\ufffffff5': {
                        c = (char)-43;
                        break;
                    }
                    case '\ufffffff6': {
                        c = (char)-42;
                        break;
                    }
                    case '\ufffffff8': {
                        c = (char)-40;
                        break;
                    }
                    case '\ufffffff9': {
                        c = (char)-39;
                        break;
                    }
                    case '\ufffffffa': {
                        c = (char)-38;
                        break;
                    }
                    case '\ufffffffb': {
                        c = (char)-37;
                        break;
                    }
                    case '\ufffffffc': {
                        c = (char)-36;
                        break;
                    }
                    case '\ufffffffd': {
                        c = (char)-35;
                        break;
                    }
                    case '\ufffffffe': {
                        c = (char)-34;
                        break;
                    }
                    case '\uffffffff': {
                        c = (char)-97;
                        break;
                    }
                }
                byArray2[i] = c;
            }
        }
        return byArray2;
    }

    public int addBytes(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n++] = byArray2[i];
        }
        return n;
    }

    public int addDate(byte[] byArray, int n, FlexlmDate flexlmDate) {
        if (flexlmDate == null) {
            return n;
        }
        n = this.addInt(byArray, n, flexlmDate.getDay());
        int n2 = flexlmDate.getYear();
        if (n2 > 1900) {
            n2 -= 1900;
        }
        n = this.addInt(byArray, n, n2);
        byte[] byArray2 = flexlmDate.getMonth().getBytes();
        n = this.addBytes(byArray, n, byArray2);
        return n;
    }

    public int addKeywordInt(byte[] byArray, int n, String string, int n2) {
        String string2 = new String(string + "=" + n2);
        n = this.addBytes(byArray, n, string2.getBytes());
        return n;
    }

    public static String normalizeWhitespace(String string, boolean bl) {
        if (string == null || string.length() < 1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        boolean bl2 = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                if (!bl || bl2) continue;
                cArray2[n++] = 32;
                bl2 = true;
                continue;
            }
            cArray2[n++] = cArray[i];
            bl2 = false;
        }
        String string2 = new String(cArray2);
        string2 = string2.substring(0, n);
        return string2;
    }

    protected static byte[] hexToBinBytes(String string) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[string.length() / 2 + 1];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\"') continue;
            byArray[n++] = (byte)c;
            if (n != 2) continue;
            n = 0;
            int n3 = Integer.parseInt(new String(byArray), 16);
            byArray2[n2++] = (byte)n3;
        }
        if (n2 < byArray2.length) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public static void applySupersede(LinkedList linkedList, boolean bl) {
        if (linkedList == null || linkedList.size() < 1) {
            return;
        }
        LinkedList linkedList2 = (LinkedList)linkedList.clone();
        ListIterator listIterator = linkedList.listIterator();
        LinkedList<LicenseElement> linkedList3 = new LinkedList<LicenseElement>();
        while (listIterator.hasNext()) {
            LicenseElement licenseElement = (LicenseElement)listIterator.next();
            if (licenseElement.supersededBy != null || !licenseElement.supersedePresent) continue;
            String[] stringArray = licenseElement.namesSuperseded == null ? new String[]{licenseElement.name} : licenseElement.namesSuperseded;
            for (int i = 0; i < stringArray.length; ++i) {
                ListIterator listIterator2 = linkedList2.listIterator();
                while (listIterator2.hasNext()) {
                    LicenseElement licenseElement2 = (LicenseElement)listIterator2.next();
                    if (!stringArray[i].equals(licenseElement2.name) || licenseElement.equals(licenseElement2) || licenseElement2.supersededBy != null || !LicenseElement.startsAfter(licenseElement, licenseElement2)) continue;
                    licenseElement2.supersededBy = licenseElement;
                    if (!bl) continue;
                    linkedList3.add(licenseElement2);
                }
            }
        }
        if (linkedList3.size() > 0) {
            listIterator = linkedList3.listIterator();
            while (listIterator.hasNext()) {
                linkedList.remove(listIterator.next());
            }
        }
    }

    static boolean startsAfter(LicenseElement licenseElement, LicenseElement licenseElement2) {
        FlexlmDate flexlmDate;
        FlexlmDate flexlmDate2 = licenseElement.issuedDate != null ? licenseElement.issuedDate : licenseElement.startDate;
        FlexlmDate flexlmDate3 = flexlmDate = licenseElement2.issuedDate != null ? licenseElement2.issuedDate : licenseElement2.startDate;
        if (flexlmDate == null) {
            return true;
        }
        if (flexlmDate2 == null) {
            return false;
        }
        return flexlmDate2.after(flexlmDate);
    }

    void setSupersededBy(LicenseElement licenseElement) {
        this.supersededBy = licenseElement;
    }

    void setUpgradedBy(UpgradeLine upgradeLine) {
        this.upgradedBy = upgradeLine;
    }

    void setExpandedFrom(PackageLine packageLine) {
        this.expandedFrom = packageLine;
    }

    public LicenseElement getSupersededBy() {
        return this.supersededBy;
    }

    public UpgradeLine getUpgradedBy() {
        return this.upgradedBy;
    }

    public PackageLine getExpandedFrom() {
        return this.expandedFrom;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFilename() {
        return this.convertEncoding(this.filename);
    }

    public String getUnparsedLine() {
        return this.lineText;
    }

    public static String printableString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.length();
            if (n + n2 + 1 < 75) {
                stringBuffer.append(string2 + " ");
                n += n2 + 1;
                continue;
            }
            stringBuffer.append("\\\n\t" + string2 + " ");
            n = 8 + n2 + 1;
        }
        return new String(stringBuffer);
    }

    public static String getWithCaseInsensitiveKey(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string.toUpperCase());
        if (string2 == null) {
            string2 = (String)hashtable.get(string.toLowerCase());
        }
        return string2;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected String convertEncoding(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new String(string.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("convertEncoding: UnsupportedEncodingException.");
        }
    }
}

