/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.licsource;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.licsource.LicenseFile;
import com.macrovision.flexlm.lictext.LicenseGroup;
import java.io.StringReader;

public class TrustedStorage
extends LicenseFile
implements FlexlmConstants {
    private String tsName;
    private static final String TS_ACC_LIBNAME = "tsJavaAcc";

    private native String tsGetFeatureLines();

    public TrustedStorage() {
    }

    public TrustedStorage(String string, VendorInfo vendorInfo, ConnectionData connectionData) throws FlexlmException {
        this.tsName = string;
        this.vInfo = vendorInfo;
        super.setConnData(connectionData);
        this.createLists();
    }

    void createLists() throws FlexlmException {
        String string;
        this.loadTSAccLibrary();
        try {
            string = this.tsGetFeatureLines();
        }
        catch (Throwable throwable) {
            throw new FlexlmException(-530, 3103, throwable.getMessage());
        }
        if (string == null) {
            throw new FlexlmException(-532, 3104);
        }
        StringReader stringReader = new StringReader(string);
        this.licenseGroup = new LicenseGroup(stringReader, this.vInfo, false);
        this.features = this.licenseGroup.getFeaturesAvailable();
    }

    private void loadTSAccLibrary() throws FlexlmException {
        try {
            System.loadLibrary(TS_ACC_LIBNAME);
        }
        catch (Throwable throwable) {
            throw new FlexlmException(-531, 3105, throwable.getMessage());
        }
    }

    protected Feature checkout(FeatureSpecifier featureSpecifier, int n, int n2, int n3, byte[] byArray, int n4, License license) throws FlexlmException {
        return super.checkout(featureSpecifier, n, n2, n3, byArray, n4, license);
    }

    public String getName() {
        return this.tsName;
    }
}

