/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.licsource;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FeatureUsage;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmLicenseElementException;
import com.macrovision.flexlm.FlexlmListException;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.LicenseSource;
import com.macrovision.flexlm.ServerInfo;
import com.macrovision.flexlm.Userlist;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.licsource.LicenseServer;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.FlexlmVersion;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseGroup;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;

public class LicenseFile
extends LicenseSource
implements FlexlmConstants {
    private String lfName;
    VendorInfo vInfo;
    LicenseGroup licenseGroup;
    LicenseServer[] licenseServers;
    FeatureLine[] features;
    FlexlmException[] generalExceptions;
    FlexlmException[] elementExceptions;
    FlexlmException[] allExceptions;
    FlexlmException[] featureListExceptions;
    protected boolean checkDateSetback = false;
    protected long lastDateCheck = 0L;
    protected String[] unixDirs = new String[]{"/", "/tmp", "/var", "/etc", "\\"};
    protected static final long GRACE = 3600000L;
    protected static final long MIN_INTERVAL = 20000L;

    public LicenseFile() {
    }

    public LicenseFile(String string, VendorInfo vendorInfo, ConnectionData connectionData) throws FlexlmException {
        this.lfName = string;
        this.vInfo = vendorInfo;
        super.setConnData(connectionData);
        this.licenseGroup = new LicenseGroup(string, vendorInfo, true);
        this.createLists();
    }

    void createLists() throws FlexlmException {
        LinkedList<LicenseServer> linkedList;
        this.features = LicenseFile.getUncounted(this.licenseGroup.getFeaturesAvailable());
        String[] stringArray = this.licenseGroup.getServers();
        LinkedList<FlexlmException> linkedList2 = new LinkedList<FlexlmException>();
        if (stringArray != null && stringArray.length > 0) {
            linkedList = new LinkedList<LicenseServer>();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    linkedList.add(new LicenseServer(stringArray[i], this.vInfo, this.connectionData));
                    continue;
                }
                catch (FlexlmException flexlmException) {
                    linkedList2.add(flexlmException);
                }
            }
            if (linkedList.size() > 0) {
                this.licenseServers = linkedList.toArray(new LicenseServer[linkedList.size()]);
            }
        }
        linkedList = this.licenseGroup.getElementExceptions();
        LinkedList linkedList3 = this.licenseGroup.getGeneralExceptions();
        LinkedList linkedList4 = this.licenseGroup.getAllExceptions();
        if (linkedList2.size() > 0) {
            linkedList3.addAll(linkedList2);
            linkedList4.addAll(linkedList2);
        }
        if (linkedList.size() > 0) {
            this.elementExceptions = linkedList.toArray(new FlexlmException[linkedList.size()]);
        }
        if (linkedList3.size() > 0) {
            this.generalExceptions = linkedList3.toArray(new FlexlmException[linkedList3.size()]);
        }
        if (linkedList4.size() > 0) {
            this.allExceptions = linkedList4.toArray(new FlexlmException[linkedList4.size()]);
        }
        if (this.features == null && this.licenseServers == null) {
            throw new FlexlmListException(-513, 3038, this.allExceptions);
        }
    }

    protected Feature checkout(FeatureSpecifier featureSpecifier, int n, int n2, int n3, byte[] byArray, int n4, License license) throws FlexlmException {
        int n5;
        Feature feature = null;
        LinkedList<FlexlmException> linkedList = new LinkedList<FlexlmException>();
        FeatureLine[] featureLineArray = LicenseFile.findFeature(featureSpecifier, this.features);
        if (featureLineArray != null && featureLineArray.length > 0) {
            for (n5 = 0; n5 < featureLineArray.length; ++n5) {
                try {
                    LicenseSource.checkFeatureEnvironmentals(featureLineArray[n5], this.vInfo, this.connectionData);
                }
                catch (FlexlmException flexlmException) {
                    linkedList.add(flexlmException);
                    continue;
                }
                if (this.checkDateSetback && this.dateIsSetBack()) {
                    linkedList.add(new FlexlmException(-88, 3058));
                    continue;
                }
                feature = featureLineArray[n5].createFeature(this);
                license.setEffectiveLicenseSource(this);
                break;
            }
        }
        if (feature == null && this.licenseServers != null) {
            for (n5 = 0; n5 < this.licenseServers.length; ++n5) {
                try {
                    feature = this.licenseServers[n5].checkout(featureSpecifier, n, n2, n3, byArray, n4, license);
                    break;
                }
                catch (FlexlmException flexlmException) {
                    linkedList.add(flexlmException);
                    continue;
                }
            }
        }
        if (feature == null) {
            FlexlmException[] flexlmExceptionArray;
            this.addFeatureExceptionsTo(featureSpecifier.getName(), this.elementExceptions, linkedList);
            if (linkedList.size() < 1) {
                linkedList.add(new FlexlmException(-5, 3037));
            }
            if ((flexlmExceptionArray = linkedList.toArray(new FlexlmException[linkedList.size()])).length == 1) {
                throw flexlmExceptionArray[0];
            }
            throw new FlexlmListException(-513, 3039, flexlmExceptionArray);
        }
        return feature;
    }

    public void enableDateSetbackDetection(boolean bl) {
        this.checkDateSetback = bl;
    }

    protected void addFeatureExceptionsTo(String string, FlexlmException[] flexlmExceptionArray, LinkedList linkedList) {
        if (string == null || flexlmExceptionArray == null) {
            return;
        }
        for (int i = 0; i < flexlmExceptionArray.length; ++i) {
            FlexlmLicenseElementException flexlmLicenseElementException;
            FlexlmException flexlmException = flexlmExceptionArray[i];
            if (!(flexlmException instanceof FlexlmLicenseElementException) || !string.equals((flexlmLicenseElementException = (FlexlmLicenseElementException)flexlmException).getFeatureName())) continue;
            linkedList.add(flexlmLicenseElementException);
        }
    }

    public void checkin(License license) throws FlexlmException {
        LicenseSource licenseSource = license.getEffectiveLicenseSource();
        if (!this.equals(licenseSource)) {
            licenseSource.checkin(license);
        }
    }

    public String[] getFeatureList(String string) throws FlexlmException {
        Object[] objectArray;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.features != null) {
            for (int i = 0; i < this.features.length; ++i) {
                String string2 = this.features[i].getName();
                hashSet.add(string2);
            }
        }
        LinkedList<FlexlmException> linkedList = new LinkedList<FlexlmException>();
        if (this.licenseServers != null) {
            for (int i = 0; i < this.licenseServers.length; ++i) {
                objectArray = null;
                try {
                    objectArray = this.licenseServers[i].getFeatureList(string);
                }
                catch (FlexlmException flexlmException) {
                    linkedList.add(flexlmException);
                }
                if (objectArray == null) continue;
                for (int j = 0; j < objectArray.length; ++j) {
                    hashSet.add(objectArray[j]);
                }
            }
        }
        String[] stringArray = null;
        if (hashSet.size() <= 0) {
            objectArray = linkedList.toArray(new FlexlmException[linkedList.size()]);
            throw new FlexlmListException(-513, 3043, (FlexlmException[])objectArray);
        }
        stringArray = hashSet.toArray(new String[hashSet.size()]);
        return stringArray;
    }

    public String[] getFeatureList() throws FlexlmException {
        return this.getFeatureList(this.vInfo.getVendorName());
    }

    public Feature[] getFeatureDetails(String string) throws FlexlmException {
        int n;
        LinkedList<FlexlmException> linkedList = new LinkedList<FlexlmException>();
        LinkedList<Feature> linkedList2 = new LinkedList<Feature>();
        if (this.features != null) {
            for (n = 0; n < this.features.length; ++n) {
                if (!string.equals(this.features[n].getName())) continue;
                linkedList2.add(this.features[n].createFeature(this));
            }
        }
        if (this.licenseServers != null) {
            for (n = 0; n < this.licenseServers.length; ++n) {
                try {
                    LicenseFile.addArrayToList(linkedList2, this.licenseServers[n].getFeatureDetails(string));
                    continue;
                }
                catch (FlexlmException flexlmException) {
                    linkedList.add(flexlmException);
                }
            }
        }
        LicenseSource.pruneListByEnvironment(linkedList2, this.vInfo, this.connectionData);
        Feature[] featureArray = null;
        if (linkedList2.size() > 0) {
            featureArray = linkedList2.toArray(new Feature[linkedList2.size()]);
        }
        if (featureArray == null && linkedList.size() > 0) {
            this.featureListExceptions = linkedList.toArray(new FlexlmException[linkedList.size()]);
            throw new FlexlmListException(-513, 3042, this.featureListExceptions);
        }
        return featureArray;
    }

    public FeatureUsage getFeatureUsage(FeatureSpecifier featureSpecifier, String string) throws FlexlmException {
        if (this.licenseServers != null) {
            return this.licenseServers[0].getFeatureUsage(featureSpecifier, string);
        }
        throw new FlexlmException(-3, 3052);
    }

    public FeatureUsage getFeatureUsage(FeatureSpecifier featureSpecifier) throws FlexlmException {
        return this.getFeatureUsage(featureSpecifier, this.vInfo.getVendorName());
    }

    public ServerInfo getServerInfo() throws FlexlmException {
        if (this.licenseServers != null) {
            return this.licenseServers[0].getServerInfo();
        }
        throw new FlexlmException(-3, 3059);
    }

    public Userlist getUserlist(String string, String string2) throws FlexlmException {
        if (this.licenseServers != null) {
            return this.licenseServers[0].getUserlist(string, string2);
        }
        throw new FlexlmException(-3, 3062);
    }

    public void forceCheckin(String string, String string2, String string3, String string4) throws FlexlmException {
        if (this.licenseServers == null) {
            throw new FlexlmException(-3, 3072);
        }
        this.licenseServers[0].forceCheckin(string, string2, string3, string4);
    }

    public void forceCheckin(String string, int n) throws FlexlmException {
        if (this.licenseServers == null) {
            throw new FlexlmException(-3, 3073);
        }
        this.licenseServers[0].forceCheckin(string, n);
    }

    public void shutdownServer() throws FlexlmException {
        if (this.licenseServers == null) {
            throw new FlexlmException(-3, 3077);
        }
        this.licenseServers[0].shutdownServer();
    }

    public String getName() {
        return this.lfName;
    }

    public boolean checkoutQueued(FeatureSpecifier featureSpecifier) throws FlexlmException {
        return false;
    }

    public LicenseCertificate[] getLicenseCertificates() {
        return this.licenseGroup.getLicenseCertificates();
    }

    public LicenseServer[] getLicenseServers() {
        return this.licenseServers;
    }

    private static void addArrayToList(LinkedList linkedList, Object[] objectArray) {
        if (objectArray == null || linkedList == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            linkedList.add(objectArray[i]);
        }
    }

    private static FeatureLine[] findFeature(FeatureSpecifier featureSpecifier, FeatureLine[] featureLineArray) {
        FeatureLine[] featureLineArray2 = null;
        LinkedList<FeatureLine> linkedList = null;
        if (featureSpecifier != null && featureLineArray != null) {
            String string = featureSpecifier.getFeatureIdentifier();
            linkedList = new LinkedList<FeatureLine>();
            for (int i = 0; i < featureLineArray.length; ++i) {
                FeatureLine featureLine = featureLineArray[i];
                if (string != null) {
                    if (!string.equals(featureLine.getFeatureIdentifier())) continue;
                    linkedList.add(featureLine);
                    break;
                }
                String string2 = featureSpecifier.getName();
                if (!string2.equalsIgnoreCase(featureLine.getName())) continue;
                FlexlmVersion flexlmVersion = null;
                try {
                    flexlmVersion = new FlexlmVersion(featureSpecifier.getVersion());
                }
                catch (FlexlmException flexlmException) {
                    throw new RuntimeException("bad version string");
                }
                int n = flexlmVersion.compareTo(featureLine.getVersionObject());
                if (n >= 1) continue;
                linkedList.add(featureLine);
            }
        }
        if (linkedList != null && linkedList.size() > 0) {
            featureLineArray2 = linkedList.toArray(new FeatureLine[linkedList.size()]);
        }
        return featureLineArray2;
    }

    private static FeatureLine[] getUncounted(FeatureLine[] featureLineArray) {
        FeatureLine[] featureLineArray2 = null;
        if (featureLineArray != null) {
            HashSet<FeatureLine> hashSet = new HashSet<FeatureLine>();
            for (int i = 0; i < featureLineArray.length; ++i) {
                if (featureLineArray[i].getIntCount() != 0) continue;
                hashSet.add(featureLineArray[i]);
            }
            if (hashSet.size() > 0) {
                featureLineArray2 = hashSet.toArray(new FeatureLine[hashSet.size()]);
            }
        }
        return featureLineArray2;
    }

    protected boolean dateIsSetBack() {
        long l = new Date().getTime();
        if (this.lastDateCheck != 0L && l - this.lastDateCheck < 20000L) {
            return false;
        }
        this.lastDateCheck = l;
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getAbsolutePath();
            if (string.equalsIgnoreCase("A:\\")) continue;
            if (string.equals("/")) {
                for (int j = 0; j < this.unixDirs.length; ++j) {
                    boolean bl = LicenseFile.chkDir(new File(this.unixDirs[j]), l);
                    if (bl) continue;
                    return true;
                }
                break;
            }
            File file = new File(string);
            File[] fileArray2 = file.listFiles();
            if (fileArray2 == null) continue;
            for (int j = 0; j < fileArray2.length; ++j) {
                boolean bl;
                String string2 = fileArray2[j].getName();
                if (!string2.equalsIgnoreCase("winnt") && !string2.equalsIgnoreCase("windows") || (bl = LicenseFile.chkDir(fileArray2[j], l))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean chkDir(File file, long l) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                long l2 = fileArray[i].lastModified();
                if (l == 0L || l2 - l <= 3600000L) continue;
                return false;
            }
        }
        return true;
    }
}

