/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.comm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.comm.CommRev;
import com.macrovision.flexlm.comm.MessageHeader;
import com.macrovision.flexlm.licsource.LicenseServer;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Message
implements FlexlmConstants {
    private static String debugSpec = System.getProperty("FLEXLM_MESSAGE_DEBUG");
    private static String debugLogFile;
    private static boolean debugStringOutput;
    private static boolean debugByteOutput;
    public static final int M_HANDSHAKE = 65537;
    public static final int M_HEARTBEAT = 65538;
    public static final int M_HELLO = 65539;
    public static final int M_CHECKIN = 65540;
    public static final int M_LIST = 65541;
    public static final int M_CHECKOUT = 65542;
    public static final int M_SHUTDOWN = 65543;
    public static final int M_FORCE_CHECKIN = 65544;
    public static final int M_SWITCH = 65545;
    public static final int M_FORCE_CHECKIN_H = 65546;
    public static final int M_DAEMON_INFO = 65547;
    public static final int M_SENDHOSTID = 65548;
    public static final int M_REREAD = 65549;
    public static final int M_SWITCH_REPORT = 65550;
    public static final int M_NEWREPLOG = 65551;
    public static final int M_WHAT = 65552;
    public static final int M_TRY_ANOTHER = 65553;
    public static final int M_BUSY = 65554;
    public static final int M_BUSY_NEW = 65555;
    public static final int M_FEATURE_AVAILABLE = 65556;
    public static final int M_HEARTBEAT_RESPONSE = 65557;
    public static final int M_NOT_ADMIN = 65558;
    public static final int M_TOO_SOON = 65559;
    public static final int M_NO_USER = 65560;
    public static final int M_OK = 65561;
    public static final int M_LICENSE_FILE_DATA = 65562;
    public static final int M_FEAT_BUNDLE = 65563;
    public static final int M_NUSERS = 65564;
    public static final int M_GENERIC_DAEMON_INFO = 65565;
    public static final int M_QUEUED = 65566;
    public static final int M_NEED_HOSTID = 65567;
    public static final int M_USERNAME2 = 65568;
    public static final int M_USERNAME = 65569;
    public static final int M_NOSUCHFEATURE = 65570;
    public static final int M_SENDLFDATA = 65571;
    public static final int M_FULFILL_STATUS = 65572;
    public static final int M_FULFILL_STATUS_RESP = 65573;
    public static final int M_VENDOR_LIST = 65574;
    public static final int M_VENDOR_LIST_RESP = 65575;
    public static final int MSG_FLAG_ADDITIONAL_DATA = 1;
    private MessageHeader header;

    public int getType() {
        return this.header.getType();
    }

    public void send(OutputStream outputStream, int n, CommRev commRev) throws IOException {
        throw new RuntimeException("Message.send() should never be called");
    }

    public void sendIt(OutputStream outputStream, byte[] byArray, CommRev commRev, int n) throws IOException {
        commRev.setChecksum(byArray);
        Message.debug("sending: ", byArray);
        commRev.encryptMessage(byArray, n);
        outputStream.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message receiveIfAvailable(InputStream inputStream, int n, boolean bl) throws IOException, FlexlmException {
        if (!bl && !Message.isMessageAvailable(inputStream)) {
            return null;
        }
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            if (!bl && !Message.isMessageAvailable(inputStream)) {
                return null;
            }
            return Message.receive(inputStream, n);
        }
    }

    public static Message receive(InputStream inputStream) throws IOException, FlexlmException {
        return Message.receive(inputStream, 0);
    }

    public static Message receive(InputStream inputStream, int n) throws IOException, FlexlmException {
        Message message;
        byte[] byArray = Message.getHeader(inputStream, n);
        MessageHeader messageHeader = new MessageHeader(byArray);
        byte[] byArray2 = Message.getMessage(inputStream, messageHeader, n);
        CommRev commRev = CommRev.getCommRevInstance(byArray);
        commRev.decryptMessage(byArray2, messageHeader, n);
        Message.debug("receiving: ", byArray2);
        if (!commRev.checkChecksum(byArray2)) {
            throw new FlexlmException(-12, 1020);
        }
        switch (messageHeader.getType()) {
            case 65553: {
                message = commRev.decodeTryAnother(byArray2);
                break;
            }
            case 65561: {
                message = commRev.decodeOK(byArray2);
                break;
            }
            case 65567: {
                message = commRev.decodeNeedHostId(byArray2);
                break;
            }
            case 65537: {
                message = commRev.decodeHandshake(byArray2);
                break;
            }
            case 65562: {
                message = commRev.decodeLicenseFileData(byArray2);
                break;
            }
            case 65557: {
                message = commRev.decodeHeartbeatResponse(byArray2);
                break;
            }
            case 65552: {
                message = commRev.decodeWhat(byArray2);
                break;
            }
            case 65563: {
                message = commRev.decodeFeatBundle(byArray2);
                break;
            }
            case 65566: {
                message = commRev.decodeQueued(byArray2);
                break;
            }
            case 65556: {
                message = commRev.decodeFeatureAvailable(byArray2);
                break;
            }
            case 65564: {
                message = commRev.decodeNUsers(byArray2);
                break;
            }
            case 65565: {
                message = commRev.decodeGenericDaemonInfo(byArray2);
                break;
            }
            case 65569: {
                message = commRev.decodeUsername(byArray2);
                break;
            }
            case 65568: {
                message = commRev.decodeUsername2(byArray2);
                break;
            }
            case 65570: {
                message = commRev.decodeNoSuchFeature(byArray2);
                break;
            }
            case 65558: {
                message = commRev.decodeNotAdmin(byArray2);
                break;
            }
            case 65559: {
                message = commRev.decodeTooSoon(byArray2);
                break;
            }
            case 65560: {
                message = commRev.decodeNoUser(byArray2);
                break;
            }
            case 65572: {
                message = commRev.decodeFulfillStatus(byArray2);
                break;
            }
            case 65573: {
                int n2 = messageHeader.getMessageFlags();
                if (n2 == 1) {
                    byArray2 = Message.assembleFragmentedMessage(inputStream, n, commRev, byArray2);
                }
                message = commRev.decodeFulfillStatusResp(byArray2);
                break;
            }
            case 65574: {
                message = commRev.decodeVendorList(byArray2);
                break;
            }
            case 65575: {
                message = commRev.decodeVendorListResp(byArray2);
                break;
            }
            default: {
                throw new FlexlmException(-12, 1004, "unknown message type");
            }
        }
        message.header = messageHeader;
        return message;
    }

    private static byte[] assembleFragmentedMessage(InputStream inputStream, int n, CommRev commRev, byte[] byArray) throws IOException, FlexlmException {
        byte[] byArray2 = byArray;
        boolean bl = true;
        while (bl) {
            byte[] byArray3 = Message.getHeader(inputStream, n);
            MessageHeader messageHeader = new MessageHeader(byArray3);
            byte[] byArray4 = Message.getMessage(inputStream, messageHeader, n);
            commRev.decryptMessage(byArray4, messageHeader, n);
            int n2 = byArray4.length - byArray3.length;
            byArray = byArray2;
            byArray2 = new byte[byArray.length + n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(byArray4, byArray3.length, byArray2, byArray.length, n2);
            bl = messageHeader.getMessageFlags() == 1;
        }
        return byArray2;
    }

    private static boolean isMessageAvailable(InputStream inputStream) throws IOException {
        return inputStream.available() > 0;
    }

    private static byte[] getHeader(InputStream inputStream, int n) throws IOException {
        byte[] byArray = Message.readBytes(inputStream, MessageHeader.getHeaderLength());
        CommRev.decryptHeader(byArray, n);
        return byArray;
    }

    private static byte[] getMessage(InputStream inputStream, MessageHeader messageHeader, int n) throws IOException {
        int n2 = messageHeader.getMessageLength() - MessageHeader.getHeaderLength();
        byte[] byArray = Message.readBytes(inputStream, n2);
        byte[] byArray2 = messageHeader.getRawHeader();
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private static byte[] readBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
        }
        return byArray;
    }

    protected static String hexByte(byte by) {
        return Integer.toHexString(by & 0xFF);
    }

    public static String getHostname() {
        return Message.getHostIp(true);
    }

    private static String getHostIp(boolean bl) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return bl ? inetAddress.getHostName().toLowerCase() : inetAddress.getHostAddress();
    }

    private static void logMsg(String string, String string2) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string, true);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    public static String debugMessage(byte[] byArray, int n) {
        String string = null;
        if (n == 1) {
            string = "'" + new String(byArray) + "'\n";
        } else if (n == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append("(" + Message.hexByte(byArray[i]) + ")" + (char)byArray[i] + "\t");
                if ((i + 1) % 8 != 0) continue;
                stringBuffer.append("\n");
            }
            string = new String(stringBuffer + "\n");
        }
        return string;
    }

    private static void debug(String string, byte[] byArray) {
        if (debugSpec != null) {
            Object object;
            if (debugLogFile == null) {
                object = new StringTokenizer(debugSpec, ":");
                if (((StringTokenizer)object).countTokens() != 2) {
                    debugSpec = null;
                    throw new RuntimeException("bad format for debugSpec");
                }
                debugLogFile = ((StringTokenizer)object).nextToken();
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.indexOf("S") != 0) {
                    debugStringOutput = true;
                }
                if (string2.indexOf("B") != 0) {
                    debugByteOutput = true;
                }
            }
            object = null;
            if (debugByteOutput) {
                object = Message.debugMessage(byArray, 1);
            }
            if (debugStringOutput) {
                object = Message.debugMessage(byArray, 2);
            }
            Message.logMsg(debugLogFile, string + "\n" + (String)object);
        }
    }

    protected boolean isSupportedBy(LicenseServer licenseServer) throws FlexlmException {
        return true;
    }
}

