/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FlexlmException
extends Exception
implements FlexlmConstants,
FlexlmInternalConstants {
    private static final long serialVersionUID = -7590490157880838435L;
    private int majorErrorCode;
    private int minorErrorCode;
    private String secondaryMessage;

    public FlexlmException(int n, int n2) {
        super((String)null);
        this.majorErrorCode = n;
        this.minorErrorCode = n2;
    }

    public FlexlmException(int n, int n2, String string) {
        super((String)null);
        this.majorErrorCode = n;
        this.minorErrorCode = n2;
        this.secondaryMessage = string;
    }

    protected FlexlmException() {
    }

    private String getFullMessage(Locale locale, boolean bl) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        String string = bl ? this.getSecondaryMessage() : "";
        string = string != null && string.length() != 0 ? "(" + string + ")" : "";
        return this.getMessageFromBundle(resourceBundle) + " " + this.getMajorMinorString() + " " + string;
    }

    public String getBasicMessage(Locale locale) {
        return this.getFullMessage(locale, false);
    }

    public String getBasicMessage() {
        return this.getFullMessage(null, false);
    }

    public String getMessage() {
        return this.getFullMessage(null, true);
    }

    public String getMessage(Locale locale) {
        return this.getFullMessage(locale, true);
    }

    public int getMajor() {
        return this.majorErrorCode;
    }

    public int getMinor() {
        return this.minorErrorCode;
    }

    private String getMajorMinorString() {
        return "(" + this.majorErrorCode + "," + this.minorErrorCode + ")";
    }

    private String getSecondaryMessage() {
        return this.secondaryMessage == null ? "" : this.secondaryMessage;
    }

    private String getMessageFromBundle(ResourceBundle resourceBundle) {
        String string = null;
        String string2 = this.getKeyString();
        try {
            string = resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("cannot get string for key " + string2);
        }
        return string;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = null;
        if (locale == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.macrovision.flexlm.FlexlmResources");
            }
            catch (MissingResourceException missingResourceException) {
                throw new RuntimeException("cannot open properties file com.macrovision.flexlm.FlexlmResources");
            }
        }
        try {
            resourceBundle = ResourceBundle.getBundle("com.macrovision.flexlm.FlexlmResources", locale);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("cannot open properties file for locale " + locale.getDisplayName());
        }
        return resourceBundle;
    }

    private String getKeyString() {
        return Integer.toString(this.majorErrorCode);
    }
}

