/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.oac;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.api.IMStatuses;
import com.ibm.cic.agent.oac.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public abstract class AbstractIMOAC
implements ISelectionExpression {
    private static final String AGENT_OFFERING_ID = "com.ibm.cic.agent";
    private static final String OS400 = "os400";
    private static final String Z_OS = "z/OS";
    private static final String IM_OAC_EXECUTED = "im.oac.executed";
    private static final String EOL = System.getProperty("line.separator");
    private static final String COLON_SPACE = ": ";
    public static final String TEST_STATUS = "im.oac.test.status";
    public static final String $UID = "$uid";
    public static final String $EXPLANATION = "$explanation";
    public static final String $USER_ACTION = "$useraction";
    public static final String SUPPRESS_UNSUPPORTED_PLATFORM_CHECK = "im.suppress.unsupported.platform.check";
    public static final String TEST_END_OF_LIFE = "im.oac.test.eol";
    private String osName = null;
    private String osVersion = null;
    private String osArch = null;
    private static final String IM_VERSION = "im.version";

    public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
        if (!(context instanceof IAdaptable)) {
            return Status.OK_STATUS;
        }
        IAdaptable adaptable = (IAdaptable)context;
        if (this.isCheckingPrerequisites(adaptable)) {
            return Status.OK_STATUS;
        }
        Object adapter = adaptable.getAdapter(IOffering.class);
        if (!(adapter instanceof IOffering)) {
            return Status.OK_STATUS;
        }
        IOffering offering = (IOffering)adapter;
        if (!AGENT_OFFERING_ID.equals(offering.getIdentity().getId())) {
            return Status.OK_STATUS;
        }
        String offeringVersion = offering.getVersion().toString();
        return this.doOAC(offeringVersion);
    }

    protected IStatus doOAC(String offeringVersion) {
        IStatus status = this.checkForOACTestStatus(offeringVersion);
        if (!status.isOK()) {
            return status;
        }
        status = this.checkForEndOfLife();
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private boolean isCheckingPrerequisites(IAdaptable adaptable) {
        Object adapter;
        block3: {
            try {
                adapter = adaptable.getAdapter(Agent.class);
                if (adapter instanceof Agent) break block3;
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        Agent agent = (Agent)adapter;
        return agent.isCheckingPrerequisites();
    }

    private IStatus checkForEndOfLife() {
        if (this.suppressUnsupportedPlatformCheck()) {
            this.logStatus(this.createBaseStatus(2, "im.suppress.unsupported.platform.check=true"));
            return Status.OK_STATUS;
        }
        String endOfLifeVersion = null;
        boolean[] upgradedOsIsSupported = new boolean[]{true};
        String testVersion = this.getEndOfLifeTestVersion(upgradedOsIsSupported);
        if (testVersion != null) {
            endOfLifeVersion = testVersion;
        } else if (this.isWindows2000()) {
            endOfLifeVersion = "1.5.1";
        } else if (this.isSLES(9)) {
            endOfLifeVersion = "1.7";
        } else if (this.isHpuxParisc()) {
            endOfLifeVersion = "1.7.2";
            upgradedOsIsSupported[0] = false;
        } else if (this.isLinuxItaniumK1()) {
            endOfLifeVersion = "1.8";
            upgradedOsIsSupported[0] = false;
        } else if (this.isRhel4() || this.isAix5x() || this.isOS400V6R1() || this.isSolaris8() || this.isUbuntu804() || this.isZOS("01.10.00") || this.isSolaris9()) {
            endOfLifeVersion = "1.8";
        }
        if (endOfLifeVersion == null) {
            return Status.OK_STATUS;
        }
        if (!upgradedOsIsSupported[0] || this.runningImVersionIsOlder(endOfLifeVersion)) {
            return this.createStatus(Messages.IMOAC_endOfLifeError, Messages.IMOAC_endOfLifeError$uid, Messages.IMOAC_endOfLifeError$explanation, Messages.IMOAC_endOfLifeError$useraction, endOfLifeVersion, this.getOsName(), this.getOsVersion(), this.getOsArch());
        }
        return this.createStatus(Messages.IMOAC_alternateEndOfLifeError, Messages.IMOAC_alternateEndOfLifeError$uid, Messages.IMOAC_alternateEndOfLifeError$explanation, Messages.IMOAC_alternateEndOfLifeError$useraction, this.getOsName(), this.getOsVersion(), this.getOsArch());
    }

    private boolean isLinuxItaniumK1() {
        return "linux".equals(Platform.getOS()) && "ia64".equals(Platform.getOSArch());
    }

    private boolean isHpuxParisc() {
        return "hpux".equals(Platform.getOS()) && "PA_RISC".equals(Platform.getOSArch());
    }

    private boolean isRhel4() {
        String line;
        InputStreamReader reader;
        FileInputStream stream;
        if (!"linux".equals(Platform.getOS())) {
            return false;
        }
        File etcRedHatRelease = new File("/etc/redhat-release");
        try {
            stream = new FileInputStream(etcRedHatRelease);
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            reader = new InputStreamReader((InputStream)stream, "US-ASCII");
        }
        catch (IOException iOException) {
            try {
                stream.close();
            }
            catch (IOException iOException2) {}
            return false;
        }
        BufferedReader input = new BufferedReader(reader);
        try {
            try {
                line = input.readLine();
            }
            catch (IOException iOException) {
                try {
                    input.close();
                }
                catch (IOException iOException3) {
                    return false;
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                return false;
            }
            throw throwable;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            return false;
        }
        Pattern p = Pattern.compile("(.+?)\\s+release\\s+(\\d+).*");
        Matcher m = p.matcher(line);
        if (!m.matches()) {
            return false;
        }
        this.osName = m.group(1);
        this.osVersion = m.group(2);
        return this.getOsVersion().equals("4");
    }

    private boolean isUbuntu804() {
        String versionLine;
        String osLine;
        InputStreamReader reader;
        FileInputStream stream;
        if (!"linux".equals(Platform.getOS())) {
            return false;
        }
        File etcLSBRelease = new File("/etc/lsb-release");
        try {
            stream = new FileInputStream(etcLSBRelease);
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            reader = new InputStreamReader((InputStream)stream, "US-ASCII");
        }
        catch (IOException iOException) {
            try {
                stream.close();
            }
            catch (IOException iOException2) {}
            return false;
        }
        BufferedReader input = new BufferedReader(reader);
        try {
            try {
                osLine = input.readLine();
                versionLine = input.readLine();
            }
            catch (IOException iOException) {
                try {
                    input.close();
                }
                catch (IOException iOException3) {
                    return false;
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                return false;
            }
            throw throwable;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            return false;
        }
        if (osLine == null || versionLine == null) {
            return false;
        }
        Pattern p1 = Pattern.compile("DISTRIB_ID=(.+?)");
        Matcher m1 = p1.matcher(osLine);
        if (!m1.matches()) {
            return false;
        }
        this.osName = m1.group(1);
        Pattern p2 = Pattern.compile("DISTRIB_RELEASE=(.+?)");
        Matcher m2 = p2.matcher(versionLine);
        if (!m2.matches()) {
            return false;
        }
        this.osVersion = m2.group(1);
        return this.getOsName().equals("Ubuntu") && this.getOsVersion().equals("8.04");
    }

    private boolean isAix5x() {
        if (!"aix".equals(Platform.getOS())) {
            return false;
        }
        return this.getOsVersion().startsWith("5.");
    }

    private boolean isOS400V6R1() {
        if (!OS400.equals(Platform.getOS())) {
            return false;
        }
        return this.getOsVersion().startsWith("V6R1");
    }

    private boolean isSolaris8() {
        if (!"solaris".equals(Platform.getOS())) {
            return false;
        }
        return this.getOsVersion().equals("5.8");
    }

    private boolean isSolaris9() {
        if (!"solaris".equals(Platform.getOS())) {
            return false;
        }
        return this.getOsVersion().equals("5.9");
    }

    private boolean isSLES(int versionNumber) {
        if (!"linux".equals(Platform.getOS())) {
            return false;
        }
        Properties suseRelease = null;
        try {
            suseRelease = AbstractIMOAC.readProperties(new File("/etc/SuSE-release"));
        }
        catch (IOException iOException) {
            return false;
        }
        String version = suseRelease.getProperty("VERSION");
        if (version != null && Integer.valueOf(version) == versionNumber) {
            this.osName = "SUSE Linux";
            this.osVersion = version;
            return true;
        }
        return false;
    }

    private boolean isZOS(String version) {
        if (!this.getOsName().equals(Z_OS)) {
            return false;
        }
        return this.getOsVersion().equals(version);
    }

    private boolean isWindows2000() {
        if (!"win32".equals(Platform.getOS())) {
            return false;
        }
        try {
            return CicCommonSettings.isWindows2000();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean normalOacExecuted() {
        return Boolean.getBoolean(IM_OAC_EXECUTED);
    }

    protected void setNormalOacExecuted(boolean value) {
        if (value) {
            System.setProperty(IM_OAC_EXECUTED, Boolean.TRUE.toString());
        } else {
            System.getProperties().remove(IM_OAC_EXECUTED);
        }
    }

    private IStatus createStatus(String message, String uid, String explanation, String userAction, Object ... args) {
        try {
            IMStatuses.IMStatusFactory factory = IMStatuses.ERROR;
            if (uid != null && uid.length() != 0) {
                char severityChar = uid.charAt(uid.length() - 1);
                switch (severityChar) {
                    case 'I': {
                        factory = IMStatuses.INFO;
                        break;
                    }
                    case 'W': {
                        factory = IMStatuses.WARNING;
                        break;
                    }
                    case 'C': {
                        factory = IMStatuses.CANCEL;
                        break;
                    }
                }
            }
            return factory.get(uid, explanation, userAction, 0, message, args);
        }
        catch (Throwable throwable) {
            int severity = 4;
            if (uid != null && uid.length() != 0) {
                char severityChar = uid.charAt(uid.length() - 1);
                switch (severityChar) {
                    case 'I': {
                        severity = 1;
                        break;
                    }
                    case 'W': {
                        severity = 2;
                        break;
                    }
                    case 'C': {
                        severity = 8;
                        break;
                    }
                }
            }
            return this.createBaseStatus(severity, this.bind(uid, explanation, userAction, message, args));
        }
    }

    private IStatus createBaseStatus(int severity, String message) {
        return new Status(severity, AGENT_OFFERING_ID, 0, message, null);
    }

    private String bind(String uid, String explanation, String userAction, String message, Object ... args) {
        StringBuilder sb = new StringBuilder();
        if (uid != null && uid.length() > 0) {
            sb.append(uid).append(COLON_SPACE);
        }
        sb.append(NLS.bind((String)message, (Object[])args));
        if (explanation != null && explanation.length() > 0) {
            sb.append(EOL).append(EOL);
            sb.append(Messages.IMOAC_explanation).append(COLON_SPACE).append(explanation);
        }
        if (userAction != null && userAction.length() > 0) {
            sb.append(EOL).append(EOL);
            sb.append(Messages.IMOAC_userAction).append(COLON_SPACE).append(userAction);
        }
        return sb.toString();
    }

    protected void logStatus(IStatus status) {
        try {
            IMLogger.getGlobalLogger().status(status);
        }
        catch (Throwable throwable) {
            Logger.getGlobalLogger().status(status);
        }
        this.printStatus(status);
    }

    protected void printStatus(IStatus status) {
        String msg = status.getMessage();
        try {
            if (status instanceof ICicStatus) {
                ICicStatus cicStatus = (ICicStatus)status;
                msg = this.bind(cicStatus.getUid(), cicStatus.getExplanation(), cicStatus.getUserAction(), cicStatus.getMessage(), new Object[0]);
            }
        }
        catch (Throwable throwable) {}
        PrintStream stream = status.matches(12) ? System.err : System.out;
        stream.println();
        stream.println(msg);
        stream.println();
    }

    private IStatus checkForOACTestStatus(String offeringVersion) {
        String key = "im.oac.test.status_" + offeringVersion;
        String message = System.getProperty(key);
        if (message == null && (message = System.getProperty(key = TEST_STATUS)) == null) {
            return Status.OK_STATUS;
        }
        String uid = System.getProperty(String.valueOf(key) + $UID);
        String explanation = System.getProperty(String.valueOf(key) + $EXPLANATION);
        String userAction = System.getProperty(String.valueOf(key) + $USER_ACTION);
        return this.createStatus(message, uid, explanation, userAction, new Object[0]);
    }

    private boolean suppressUnsupportedPlatformCheck() {
        return Boolean.getBoolean(SUPPRESS_UNSUPPORTED_PLATFORM_CHECK);
    }

    private String getEndOfLifeTestVersion(boolean[] upgradedOsIsSupported) {
        String testVersion = System.getProperty(TEST_END_OF_LIFE);
        if (testVersion != null) {
            upgradedOsIsSupported[0] = false;
            String[] versionAndBoolean = testVersion.split(";");
            if (versionAndBoolean.length == 2) {
                testVersion = versionAndBoolean[0];
                upgradedOsIsSupported[0] = Boolean.parseBoolean(versionAndBoolean[1]);
            }
        }
        return testVersion;
    }

    private String getOsName() {
        if (this.osName == null) {
            this.osName = System.getProperty("os.name");
        }
        return this.osName;
    }

    private String getOsVersion() {
        if (this.osVersion == null) {
            this.osVersion = System.getProperty("os.version");
        }
        return this.osVersion;
    }

    private String getOsArch() {
        if (this.osArch == null) {
            this.osArch = System.getProperty("os.arch");
        }
        return this.osArch;
    }

    private static Properties readProperties(File file) throws IOException {
        Properties properties = new Properties();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
                throw e;
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return properties;
    }

    private boolean runningImVersionIsOlder(String endOfLifeVersion) {
        String imVersion = System.getProperty(IM_VERSION);
        if (imVersion == null) {
            return true;
        }
        return new Version(imVersion).compareTo(new Version(endOfLifeVersion)) < 0;
    }
}

