/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.executeAdapterData.internal;

import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.NativeAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.executeAdapterData.execAdv.AndExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.ArgExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.ArgumentsExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.ExecAdvExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.FileExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.LogExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.NotExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.OrExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.ProgressExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.StateExecuteData;
import com.ibm.cic.common.executeAdapterData.internal.IXMLConstants;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class ExecuteAdapterDataParser
extends ICommonNativeAdapterDataParser
implements IXMLConstants {
    private NativeAdapterData executeData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void initialize(IInstallableUnit iu, IErrorReporter errorReporter) {
        this.executeData = new NativeAdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(iu, this.executeData, this.elemStack, errorReporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        return super.startArtifact(this.elemStack, this.reporter, uri, name, qName, attributes, key);
    }

    public void endArtifact() {
        this.elemStack.pop();
    }

    public IArtifact startArtifactNoKey(String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        return super.startArtifactNoKey(this.elemStack, this.reporter, uri, name, qName, attributes, aca);
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("execAdv")) {
                this.handleExecAdvAttributes(attributes);
            } else if (name.equals("arguments")) {
                this.handleExecAdvArgumentsAttributes(attributes);
            } else if (name.equals("arg") && this.isExecAdvSubElement()) {
                this.handleExecAdvArgAttributes(attributes);
            } else if (name.equals("progress")) {
                this.handleExecAdvProgressAttributes(attributes);
            } else if (name.equals("state")) {
                this.handleExecAdvStateAttributes(attributes);
            } else if (name.equals("file") && this.isExecAdvSubElement()) {
                this.handleExecAdvFileAttributes(attributes);
            } else if (name.equals("log")) {
                this.handleExecAdvLogAttributes(attributes);
            } else if (name.equals("and")) {
                this.handleExecAdvAndAttributes(attributes);
            } else if (name.equals("or")) {
                this.handleExecAdvOrAttributes(attributes);
            } else if (name.equals("not")) {
                this.handleExecAdvNotAttributes(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.elemStack.pop();
    }

    public void characters(String chars) {
        String name = this.elemStack.top().name;
        boolean processed = this.processCommonCharacters(name, chars);
        if (!processed) {
            if (name.equals("arg") && this.isExecAdvSubElement()) {
                this.handleExecAdvArgText(chars);
            } else {
                this.reporter.unexpectedCharacterData(chars);
            }
        }
    }

    public IAdapterData getAdapterData() {
        return this.executeData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.executeAdapterData");
        Path path = new Path("schema/nativeAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }

    private void handleExecAdvAttributes(Attributes attributes) {
        int approximateTime;
        String workingDirectory;
        String command;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("execAdv", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "execAdv", new String[]{"failOnError", "command", "workingDirectory", "approximateTime", "description"})) {
            hasErrors = true;
        }
        String failOnErrorValue = attributes.getValue("failOnError");
        boolean failOnError = true;
        if (failOnErrorValue != null) {
            boolean bl = failOnError = !this.isAttributeFalse(failOnErrorValue);
        }
        if ((command = attributes.getValue("command")) == null) {
            this.reporter.checkRequiredAttribute("execAdv", "command", null);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            workingDirectory = ".";
        }
        if ((approximateTime = this.getApproximateTime("execAdv", attributes)) == -1) {
            hasErrors = true;
        }
        String description = attributes.getValue("description");
        if (!hasErrors) {
            ExecAdvExecuteData data = new ExecAdvExecuteData(failOnError, command, workingDirectory, approximateTime, description);
            data.setLineNumber(this.reporter.getLastCharactersLineNumber());
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvArgumentsAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!"execAdv".equals(this.getParentElementName())) {
            this.reporter.unexpectedElement("arguments", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "arguments", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            ArgumentsExecuteData data = new ArgumentsExecuteData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvArgAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!"arguments".equals(this.getParentElementName())) {
            this.reporter.unexpectedElement("arg", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "arg", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            ArgExecuteData data = new ArgExecuteData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvProgressAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!"execAdv".equals(this.getParentElementName())) {
            this.reporter.unexpectedElement("progress", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "progress", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            ProgressExecuteData data = new ProgressExecuteData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvStateAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!"progress".equals(this.getParentElementName())) {
            this.reporter.unexpectedElement("state", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "state", new String[]{"percent"})) {
            hasErrors = true;
        }
        String percentString = attributes.getValue("percent");
        int percent = 0;
        if (percentString == null) {
            this.reporter.checkRequiredAttribute("execAdv", "percent", null);
            hasErrors = true;
        } else {
            try {
                percent = Integer.parseInt(percentString);
            }
            catch (NumberFormatException numberFormatException) {
                this.reporter.invalidAttributeValue("execAdv", "percent", percentString);
            }
        }
        if (!hasErrors) {
            StateExecuteData data = new StateExecuteData(percent);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvNotAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isSubElementOf("state")) {
            this.reporter.unexpectedElement("not", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "not", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            NotExecuteData data = new NotExecuteData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvAndAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isSubElementOf("state")) {
            this.reporter.unexpectedElement("and", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "and", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            AndExecuteData data = new AndExecuteData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvOrAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isSubElementOf("state")) {
            this.reporter.unexpectedElement("or", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "or", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            OrExecuteData data = new OrExecuteData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvFileAttributes(Attributes attributes) {
        String path;
        boolean hasErrors = false;
        if (!this.isSubElementOf("state")) {
            this.reporter.unexpectedElement("file", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "execAdv", new String[]{"path", "evaluate"})) {
            hasErrors = true;
        }
        if ((path = attributes.getValue("path")) == null) {
            this.reporter.checkRequiredAttribute("file", "path", null);
            hasErrors = true;
        }
        String evaluateString = attributes.getValue("evaluate");
        boolean evaluate = true;
        if (evaluateString != null) {
            evaluate = this.isAttributeTrue(evaluateString);
        }
        if (!hasErrors) {
            FileExecuteData data = new FileExecuteData(path, evaluate);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvLogAttributes(Attributes attributes) {
        String pattern;
        String file;
        boolean hasErrors = false;
        if (!this.isSubElementOf("state")) {
            this.reporter.unexpectedElement("log", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "execAdv", new String[]{"file", "pattern", "evaluate"})) {
            hasErrors = true;
        }
        if ((file = attributes.getValue("file")) == null) {
            this.reporter.checkRequiredAttribute("log", "file", null);
            hasErrors = true;
        }
        if ((pattern = attributes.getValue("pattern")) == null) {
            this.reporter.checkRequiredAttribute("log", "pattern", null);
            hasErrors = true;
        }
        String evaluateString = attributes.getValue("evaluate");
        boolean evaluate = true;
        if (evaluateString != null) {
            evaluate = this.isAttributeTrue(evaluateString);
        }
        if (!hasErrors) {
            LogExecuteData data = new LogExecuteData(file, pattern, evaluate);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleExecAdvArgText(String text) {
        ArgExecuteData data = (ArgExecuteData)this.elemStack.top().data;
        if (data != null) {
            data.addArgText(text);
        }
    }

    private boolean isExecAdvSubElement() {
        return this.isSubElementOf("execAdv");
    }
}

