/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gpu;

import com.ibm.gpu.CUDAManager;
import com.ibm.gpu.GPUConfigurationException;
import com.ibm.gpu.GPUSortException;

public class Maths {
    public static void sortArray(int[] nArray) throws GPUConfigurationException, GPUSortException {
        if (nArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortIntsOnGivenGPU(CUDAManager.getInstance().getDefaultDevice(), nArray);
    }

    public static void sortArray(int n, int[] nArray) throws GPUSortException, GPUConfigurationException {
        if (nArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortIntsOnGivenGPU(n, nArray);
    }

    public static void sortArray(float[] fArray) throws GPUSortException, GPUConfigurationException {
        if (fArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortFloatsOnGivenGPU(CUDAManager.getInstance().getDefaultDevice(), fArray);
    }

    public static void sortArray(int n, float[] fArray) throws GPUSortException, GPUConfigurationException {
        if (fArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortFloatsOnGivenGPU(n, fArray);
    }

    public static void sortArray(long[] lArray) throws GPUSortException, GPUConfigurationException {
        if (lArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortLongsOnGivenGPU(CUDAManager.getInstance().getDefaultDevice(), lArray);
    }

    public static void sortArray(int n, long[] lArray) throws GPUSortException, GPUConfigurationException {
        if (lArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortLongsOnGivenGPU(n, lArray);
    }

    public static void sortArray(double[] dArray) throws GPUSortException, GPUConfigurationException {
        if (dArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortDoublesOnGivenGPU(CUDAManager.getInstance().getDefaultDevice(), dArray);
    }

    public static void sortArray(int n, double[] dArray) throws GPUSortException, GPUConfigurationException {
        if (dArray == null) {
            throw new GPUSortException(Maths.generateMessageForErrorCode(-10));
        }
        Maths.sortDoublesOnGivenGPU(n, dArray);
    }

    private static void sortIntsOnGivenGPU(int n, int[] nArray) throws GPUConfigurationException, GPUSortException {
        CUDAManager cUDAManager = CUDAManager.getInstance();
        cUDAManager.outputIfVerbose("Using device: " + n + " to sort int array of length: " + nArray.length);
        int n2 = Maths.sortInts(nArray, nArray.length, n);
        if (n2 != 0) {
            cUDAManager.outputIfVerbose(Maths.generateMessageForErrorCode(n2));
            throw new GPUSortException(Maths.generateMessageForErrorCode(n2));
        }
        cUDAManager.outputIfVerbose("Sorted ints on device: " + n + " successfully");
    }

    private static void sortFloatsOnGivenGPU(int n, float[] fArray) throws GPUConfigurationException, GPUSortException {
        CUDAManager cUDAManager = CUDAManager.getInstance();
        cUDAManager.outputIfVerbose("Using device: " + n + " to sort float array of length: " + fArray.length);
        int n2 = Maths.sortFloats(fArray, fArray.length, n);
        if (n2 != 0) {
            cUDAManager.outputIfVerbose(Maths.generateMessageForErrorCode(n2));
            throw new GPUSortException(Maths.generateMessageForErrorCode(n2));
        }
        cUDAManager.outputIfVerbose("Sorted floats on device " + n + " successfully");
    }

    private static void sortLongsOnGivenGPU(int n, long[] lArray) throws GPUConfigurationException, GPUSortException {
        CUDAManager cUDAManager = CUDAManager.getInstance();
        cUDAManager.outputIfVerbose("Using device: " + n + " to sort long array of length: " + lArray.length);
        int n2 = Maths.sortLongs(lArray, lArray.length, n);
        if (n2 != 0) {
            cUDAManager.outputIfVerbose(Maths.generateMessageForErrorCode(n2));
            throw new GPUSortException(Maths.generateMessageForErrorCode(n2));
        }
        cUDAManager.outputIfVerbose("Sorted longs on device " + n + " successfully");
    }

    private static void sortDoublesOnGivenGPU(int n, double[] dArray) throws GPUConfigurationException, GPUSortException {
        CUDAManager cUDAManager = CUDAManager.getInstance();
        cUDAManager.outputIfVerbose("Using device: " + n + " to sort double array of length: " + dArray.length);
        int n2 = Maths.sortDoubles(dArray, dArray.length, n);
        if (n2 != 0) {
            cUDAManager.outputIfVerbose(Maths.generateMessageForErrorCode(n2));
            throw new GPUSortException(Maths.generateMessageForErrorCode(n2));
        }
        cUDAManager.outputIfVerbose("Sorted doubles on device " + n + " " + "successfully");
    }

    private static String generateMessageForErrorCode(int n) {
        String string;
        switch (n) {
            case -1: {
                string = "CUDA error: Missing configuration.";
                break;
            }
            case -2: {
                string = "CUDA error: Memory allocation. Unable to allocate enough memory to perform the requested operation.";
                break;
            }
            case -3: {
                string = "CUDA error: Initialization error. The API call failed because the CUDA driver and runtime could not be initialized.";
                break;
            }
            case -4: {
                string = "CUDA error: Launch failure. An exception occurred on the device while executing a kernel.";
                break;
            }
            case -5: {
                string = "CUDA error: Launch timeout. This indicates that the device kernel took too long to execute.";
                break;
            }
            case -6: {
                string = "CUDA error: Launch out of resources. This indicates that a launch did not occur because it did not have appropriate resources.";
                break;
            }
            case -7: {
                string = "CUDA error: Invalid device function.";
                break;
            }
            case -8: {
                string = "CUDA error: Invalid configuration.";
                break;
            }
            case -9: {
                string = "CUDA error: Invalid device.";
                break;
            }
            case -10: {
                string = "CUDA error: Invalid value.";
                break;
            }
            case -11: {
                string = "CUDA error: Invalid pitch value.";
                break;
            }
            case -12: {
                string = "CUDA error: Invalid symbol.";
                break;
            }
            case -13: {
                string = "CUDA error: Unmap buffer object failed.";
                break;
            }
            case -14: {
                string = "CUDA error: Invalid host pointer.";
                break;
            }
            case -15: {
                string = "CUDA error: Invalid device pointer.";
                break;
            }
            case -16: {
                string = "CUDA error: Invalid texture.";
                break;
            }
            case -17: {
                string = "CUDA error: Invalid texture binding.";
                break;
            }
            case -18: {
                string = "CUDA error: Invalid channel desciptor.";
                break;
            }
            case -19: {
                string = "CUDA error: Invalid memcpy direction.";
                break;
            }
            case -20: {
                string = "CUDA error: Invalid filter setting.";
                break;
            }
            case -21: {
                string = "CUDA error: Invalid norm setting.";
                break;
            }
            case -22: {
                string = "CUDA error: Unknown error.";
                break;
            }
            case -23: {
                string = "CUDA error: Invalid resource handle.";
                break;
            }
            case -24: {
                string = "CUDA error: Insufficient driver.";
                break;
            }
            case -25: {
                string = "CUDA error: Set on active process.";
                break;
            }
            case -26: {
                string = "CUDA error: Startup failure.";
                break;
            }
            case -27: {
                string = "CUDA error: Device already in use.";
                break;
            }
            case -28: {
                string = "Thrust error.";
                break;
            }
            default: {
                string = "An unknown error occurred.";
            }
        }
        return string;
    }

    private static native int sortInts(int[] var0, int var1, int var2);

    private static native int sortFloats(float[] var0, int var1, int var2);

    private static native int sortLongs(long[] var0, int var1, int var2);

    private static native int sortDoubles(double[] var0, int var1, int var2);
}

