/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.rmi.util.EmptySet;
import com.ibm.rmi.util.ListInterface;
import com.ibm.rmi.util.list.LinkedList;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class LimitedMultiMap {
    public final int multiplicity;
    private final Map map = new HashMap();
    private int size = 0;
    private LinkedList removals = new LinkedList();
    private Hook hook;

    public LimitedMultiMap(int n) {
        this.multiplicity = n;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public boolean isFull(Object object) {
        Object v = this.map.get(object);
        if (v == null) {
            return false;
        }
        return ((FixedList)v).size == this.multiplicity;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Iterator keyIterator() {
        return this.map.keySet().iterator();
    }

    public Collection get(Object object) {
        Collection collection = (Collection)this.map.get(object);
        if (collection == null) {
            collection = EmptySet.INSTANCE;
        }
        return collection;
    }

    public Iterator valueIterator() {
        return new ValueIterator();
    }

    public void setHook(Hook hook) {
        this.hook = hook;
    }

    public Handle put(Object object, Object object2) {
        FixedList fixedList = (FixedList)this.map.get(object);
        if (fixedList == null) {
            fixedList = new FixedList(object);
            this.map.put(object, fixedList);
        }
        if (fixedList.size() == this.multiplicity) {
            throw new IllegalStateException("Limit reached for key: " + object);
        }
        if (this.hook != null) {
            this.hook.add(object, object2, fixedList.size());
        }
        fixedList.addValue(object2);
        Handle handle = new Handle(fixedList.getLastToken(), fixedList.getFreeList());
        return handle;
    }

    public boolean remove(Object object, Object object2) {
        FixedList fixedList = (FixedList)this.map.get(object);
        if (fixedList == null) {
            return false;
        }
        return fixedList.remove(object2);
    }

    public boolean remove(RemoveToken removeToken) {
        return removeToken.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRemoval(RemoveToken removeToken) {
        LinkedList linkedList = this.removals;
        synchronized (linkedList) {
            this.removals.addLast(removeToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRemoval(Object object, Object object2) {
        LinkedList linkedList = this.removals;
        synchronized (linkedList) {
            this.removals.addLast(new KeyValueRemover(object, object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performScheduledRemovals() {
        boolean bl = false;
        LinkedList linkedList = this.removals;
        synchronized (linkedList) {
            if (this.size != 0) {
                for (RemoveToken removeToken = (RemoveToken)this.removals.getFirst(); removeToken != null; removeToken = (RemoveToken)removeToken.getNext()) {
                    bl &= removeToken.remove();
                    if (this.size == 0) break;
                }
            }
            this.removals.clear();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelScheduledRemovals() {
        LinkedList linkedList = this.removals;
        synchronized (linkedList) {
            this.removals.clear();
        }
    }

    public final class FixedList
    extends AbstractCollection
    implements ListInterface {
        private int size = 0;
        private Object[] values;
        private Collection freeList;
        private Object key;

        @Override
        public Collection getFreeList() {
            return this.freeList;
        }

        FixedList(Object object) {
            this.values = new Object[LimitedMultiMap.this.multiplicity];
            this.freeList = new ConcurrentLinkedQueue();
            this.key = object;
        }

        @Override
        public java.util.Iterator iterator() {
            return new Iterator();
        }

        @Override
        public int size() {
            return this.size;
        }

        Remover getLastToken() {
            return new Remover();
        }

        boolean addValue(Object object) {
            this.values[this.size] = object;
            LimitedMultiMap.this.size++;
            ++this.size;
            return true;
        }

        @Override
        public boolean remove(Object object) {
            return this.remove(object, this.size - 1);
        }

        private final boolean remove(Object object, int n) {
            int n2;
            if (this.size == 0) {
                return false;
            }
            if (this.size > n) {
                if (this.values[n] == object) {
                    return this.removeValueAt(n, true);
                }
            } else {
                n = this.size;
            }
            for (n2 = n - 1; n2 >= 0; --n2) {
                if (this.values[n2] != object) continue;
                return this.removeValueAt(n2, true);
            }
            for (n2 = this.size - 1; n2 > n; --n2) {
                if (this.values[n2] != object) continue;
                return this.removeValueAt(n2, true);
            }
            return false;
        }

        private final boolean removeValueAt(int n, boolean bl) {
            int n2 = this.size - 1;
            if (LimitedMultiMap.this.hook != null) {
                LimitedMultiMap.this.hook.remove(this.key, this.values[n], n2);
            }
            int n3 = n2 - n;
            int n4 = n + 1;
            Object[] objectArray = this.values;
            System.arraycopy(objectArray, n4, objectArray, n, n3);
            this.values[n2] = null;
            this.size = n2;
            LimitedMultiMap.this.size--;
            if (bl && this.isEmpty()) {
                LimitedMultiMap.this.map.remove(this.key);
            }
            return true;
        }

        private class Iterator
        implements java.util.Iterator {
            int index = 0;
            Object lastValue;
            boolean autoRemove = true;

            private Iterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < FixedList.this.size;
            }

            public Object next() {
                if (FixedList.this.isEmpty()) {
                    throw new NoSuchElementException();
                }
                this.lastValue = FixedList.this.values[this.index++];
                return this.lastValue;
            }

            @Override
            public void remove() {
                if (this.lastValue == null) {
                    throw new IllegalStateException();
                }
                int n = this.index - 1;
                if (this.lastValue != FixedList.this.values[n]) {
                    throw new ConcurrentModificationException("Attempt to remove value at index " + n + ", but the expected value is not at that index");
                }
                FixedList.this.removeValueAt(n, this.autoRemove);
                this.lastValue = null;
                this.index = n;
            }
        }

        private final class Remover
        extends RemoveToken {
            int index;
            Object value;

            private Remover() {
                this.index = FixedList.this.size - 1;
                this.value = FixedList.this.values[this.index];
            }

            @Override
            boolean remove() {
                return FixedList.this.remove(this.value, this.index);
            }

            public String toString() {
                return "RemoveToken" + FixedList.this.key + "[" + this.index + "]=" + this.value;
            }
        }
    }

    public class Handle {
        RemoveToken token;
        Collection freeList;

        public Handle(RemoveToken removeToken, Collection collection) {
            this.token = removeToken;
            this.freeList = collection;
        }

        public Collection getFreeList() {
            return this.freeList;
        }

        public RemoveToken getToken() {
            return this.token;
        }
    }

    public static abstract class Hook {
        protected void add(Object object, Object object2, int n) {
        }

        protected void remove(Object object, Object object2, int n) {
        }
    }

    private class KeyValueRemover
    extends RemoveToken {
        private Object key;
        private Object value;

        KeyValueRemover(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        @Override
        boolean remove() {
            return LimitedMultiMap.this.remove(this.key, this.value);
        }
    }

    public static abstract class RemoveToken
    extends LinkedList.Item {
        abstract boolean remove();
    }

    private final class ValueIterator
    implements Iterator {
        private final Iterator lists;
        private Collection list;
        private Iterator values;

        private ValueIterator() {
            this.lists = LimitedMultiMap.this.map.values().iterator();
            this.values = EmptySet.ITERATOR;
        }

        @Override
        public boolean hasNext() {
            return this.lists.hasNext() || this.values.hasNext();
        }

        public Object next() {
            if (!this.values.hasNext()) {
                this.list = (Collection)this.lists.next();
                this.values = this.list.iterator();
                ((FixedList.Iterator)this.values).autoRemove = false;
            }
            return this.values.next();
        }

        @Override
        public void remove() {
            this.values.remove();
            if (this.list.isEmpty()) {
                this.lists.remove();
            }
        }
    }
}

