/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ThreadPool;
import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.WorkQueue;
import com.ibm.rmi.iiop.WorkerPool;

public class ThreadPoolImpl
implements ThreadPool {
    private static final String CLASS = ThreadPoolImpl.class.getName();
    private int minPoolSize;
    private int maxPoolSize;
    private long inactivityTimeout;
    private boolean isGrowable;
    private WorkerPool workerPool;
    private WorkQueue workQueue;

    @Override
    public void init(ORB oRB) {
        this.minPoolSize = oRB.getThreadPoolMinSize();
        this.maxPoolSize = oRB.getThreadPoolMaxSize();
        this.inactivityTimeout = oRB.getThreadPoolTimeOut();
        this.isGrowable = oRB.getThreadPoolIsGrowable();
        this.workerPool = new WorkerPool(this.minPoolSize, this.maxPoolSize, this.inactivityTimeout, this.isGrowable);
        this.workQueue = new WorkQueue();
        this.workerPool.setWorkQueue(this.workQueue);
        this.workQueue.setWorkerPool(this.workerPool);
        this.workerPool.initializeThreads();
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "ThreadPool initialization completed. The ThreadPool properties are set as follows: MinimumSize=" + this.minPoolSize + " threads,  MaximumSize=" + this.maxPoolSize + " threads,  InactivityTimeout=" + this.inactivityTimeout + " milliseconds ,  IsGrowable=" + this.isGrowable + ".", CLASS, "init:416");
        }
    }

    @Override
    public void cleanup() {
        this.workQueue.shutdown();
    }

    @Override
    public void startWorkerThread(WorkUnit workUnit) {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "startWorkerThread:430");
        }
        this.workQueue.addWorkToDo(workUnit);
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "startWorkerThread:436");
        }
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public boolean isGrowable() {
        return this.isGrowable;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }
}

