/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.CodeSetMapping;
import com.ibm.rmi.iiop.TcsToCharAscii;
import com.ibm.rmi.iiop.TcsToCharLatin1;
import com.ibm.rmi.iiop.TcsToCharUnicode;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;
import sun.io.ByteToCharConverter;

public class TcsToCharConverter {
    private static final String CLASS = TcsToCharConverter.class.getName();
    protected boolean byteOriented;
    protected int osfId;
    protected ByteToCharConverter sunConverter;
    protected CharsetDecoder decoder;
    protected int maxBytesPerChar = -1;
    private static boolean useNioFlag_TcsToChar = false;

    public static void setuseNioFlag_TcsToChar(boolean bl) {
        useNioFlag_TcsToChar = bl;
    }

    public TcsToCharConverter(int n) {
        this.osfId = n;
        this.byteOriented = true;
        this.sunConverter = null;
        this.decoder = null;
    }

    public boolean isByteOriented() {
        return this.byteOriented;
    }

    public char[] convertFromByte(byte[] byArray) {
        if (useNioFlag_TcsToChar) {
            if (this.decoder == null) {
                this.getDecoder();
            }
        } else if (this.sunConverter == null && this.decoder == null) {
            try {
                this.getSunConverter();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.getDecoder();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINE, "Switching to nio decoders because of - " + classNotFoundException, "TcsToCharConverter", "convertFromByte:125");
                }
                useNioFlag_TcsToChar = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.getDecoder();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINE, "Switching to nio decoders because of - " + noClassDefFoundError, "TcsToCharConverter", "convertFromByte:130");
                }
                useNioFlag_TcsToChar = true;
            }
        }
        if (this.sunConverter != null) {
            try {
                int n = byArray.length * this.sunConverter.getMaxCharsPerByte();
                char[] cArray = new char[n];
                int n2 = 0;
                this.sunConverter.reset();
                n2 += this.sunConverter.convert(byArray, 0, byArray.length, cArray, 0, n);
                if ((n2 += this.sunConverter.flush(cArray, this.sunConverter.nextCharIndex(), n)) < n) {
                    char[] cArray2 = new char[n2];
                    System.arraycopy(cArray, 0, cArray2, 0, n2);
                    return cArray2;
                }
                return cArray;
            }
            catch (sun.io.MalformedInputException malformedInputException) {
                Trc.ffdc(malformedInputException, CLASS, "convertFromByte:151");
                throw new MARSHAL("character malformed", 1229125849, CompletionStatus.COMPLETED_NO);
            }
            catch (CharConversionException charConversionException) {
                Trc.ffdc(charConversionException, CLASS, "convertFromByte:155");
                throw new DATA_CONVERSION("character not mapped to negotiated transimission code set (7)", 1330446337, CompletionStatus.COMPLETED_NO);
            }
        }
        char[] cArray = this.convertFromByteUsingNIO(byArray);
        return cArray;
    }

    public char[] convertFromByteUsingNIO(byte[] byArray) {
        if (this.decoder == null) {
            this.getDecoder();
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
            CharBuffer charBuffer = this.decoder.decode(byteBuffer);
            if (charBuffer.hasArray()) {
                if (charBuffer.position() == 0 && charBuffer.limit() == charBuffer.capacity()) {
                    return charBuffer.array();
                }
                char[] cArray = new char[charBuffer.limit() - charBuffer.position()];
                System.arraycopy(charBuffer.array(), charBuffer.position(), cArray, 0, cArray.length);
                return cArray;
            }
            char[] cArray = new char[charBuffer.limit() - charBuffer.position()];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = charBuffer.get();
            }
            return cArray;
        }
        catch (MalformedInputException malformedInputException) {
            Trc.ffdc(malformedInputException, CLASS, "convertFromByte:196");
            throw new MARSHAL("character malformed", 1229125849, CompletionStatus.COMPLETED_NO);
        }
        catch (CharacterCodingException characterCodingException) {
            Trc.ffdc(characterCodingException, CLASS, "convertFromByte:200");
            throw new DATA_CONVERSION("character not mapped to negotiated transimission code set (7)", 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    public char[] convertFromChar(char[] cArray, boolean bl) {
        return null;
    }

    private synchronized void getSunConverter() throws ClassNotFoundException {
        if (this.sunConverter == null) {
            final String string = CodeSetMapping.mapToJavaEncoding(this.osfId);
            this.sunConverter = (ByteToCharConverter)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ByteToCharConverter.getConverter((String)string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Trc.ffdc(unsupportedEncodingException, CLASS, "getSunConverter:228");
                        throw new DATA_CONVERSION("no character converter", 1229125847, CompletionStatus.COMPLETED_NO);
                    }
                }
            });
            this.sunConverter.setSubstitutionMode(false);
        }
    }

    private synchronized void getDecoder() {
        if (this.decoder == null) {
            final String string = CodeSetMapping.mapToJavaEncoding(this.osfId);
            this.decoder = (CharsetDecoder)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Charset.forName(string).newDecoder();
                }
            });
        }
    }

    public static TcsToCharConverter getConverter(int n) {
        TcsToCharConverter tcsToCharConverter;
        switch (n) {
            case 65537: 
            case 65568: {
                tcsToCharConverter = new TcsToCharLatin1(n);
                break;
            }
            case 65551: 
            case 268567780: {
                tcsToCharConverter = new TcsToCharAscii(n, '\u007f');
                break;
            }
            case 65792: 
            case 65801: {
                tcsToCharConverter = new TcsToCharUnicode(n);
                break;
            }
            default: {
                tcsToCharConverter = new TcsToCharConverter(n);
            }
        }
        return tcsToCharConverter;
    }

    protected int getMaxBytesPerChar() {
        if (this.maxBytesPerChar == -1) {
            CharToTcsConverter charToTcsConverter = CharToTcsConverter.getConverter(this.osfId);
            this.maxBytesPerChar = charToTcsConverter.getMaxBytesPerChar();
        }
        return this.maxBytesPerChar;
    }

    public boolean needToSwap(boolean bl) {
        return bl && this.osfId != 65801;
    }
}

