/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CodeSetComponentInfo;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ServerDelegate;
import com.ibm.CORBA.iiop.ServerResponse;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.PseudoRequestMessage;
import com.ibm.rmi.iiop.PseudoRequestMsgImpl;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.iiop.ServerRequestReader;
import com.ibm.rmi.iiop.ServerResponseImpl;
import com.ibm.rmi.pi.InterceptorManager;
import com.ibm.rmi.pi.ServerRequestInfoImpl;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.PortableServer.POA;

public class ServerRequestImpl
extends IIOPInputStream
implements ServerRequestReader {
    private static final String CLASS = ServerRequestImpl.class.getName();
    OutputStream replyStream;
    OutputStream exceptionReplyStream;
    protected ServerRequestInfoImpl interceptorInfo;
    private Throwable interceptorException = null;
    private final RequestMessage request;
    private final PseudoRequestMessage pseudoRequest;
    private ServerDelegate sd;
    private boolean responseDone = false;
    private Object cookie;
    private POA poa;
    private Object servant;
    private ServerResponseImpl firstResponse = null;
    private boolean needsDelayedProcessing = false;
    private InvokeHandler asynchRequestInvokeHandler = null;

    ServerRequestImpl(Connection connection, byte[] byArray, RequestMessage requestMessage, int n) throws IOException {
        super(connection, byArray, (Message)requestMessage, n);
        this.setConnectionType((byte)2);
        this.request = requestMessage;
        this.pseudoRequest = this.request;
    }

    public ServerRequestImpl(String string, boolean bl) {
        this.request = null;
        this.pseudoRequest = new PseudoRequestMsgImpl(string, bl);
    }

    @Override
    public void runInterceptors() {
        InterceptorManager interceptorManager = (InterceptorManager)((com.ibm.rmi.corba.ORB)this.orb).getInterceptorManager();
        if (interceptorManager.haveServerInterceptors()) {
            try {
                this.interceptorInfo = (ServerRequestInfoImpl)interceptorManager.createServerInfo(this, this.request, this.getConnection().getConnectionData(), false);
                interceptorManager.iterateReceiveContext(this.interceptorInfo);
            }
            catch (Throwable throwable) {
                this.interceptorException = throwable;
            }
        }
    }

    @Override
    public void throwInterceptorException() throws Throwable {
        if (this.interceptorException != null) {
            throw this.interceptorException;
        }
    }

    @Override
    public boolean hasException() {
        return this.interceptorException != null;
    }

    @Override
    public int getRequestId() {
        this.checkServerRequestIntegrity("getRequestId");
        return this.request.getRequestId();
    }

    @Override
    public boolean isOneWay() {
        return !this.pseudoRequest.isResponseExpected();
    }

    @Override
    public boolean isConnectionless() {
        return this.request == null;
    }

    @Override
    public ServiceContext[] getServiceContextList() {
        return this.pseudoRequest.getServiceContextList();
    }

    @Override
    public ServiceContext getServiceContext(int n) {
        return this.pseudoRequest.getServiceContext(n);
    }

    @Override
    public boolean setServiceContext(ServiceContext serviceContext, boolean bl) {
        return this.pseudoRequest.setServiceContext(serviceContext, bl);
    }

    @Override
    public String getOperationName() {
        return this.pseudoRequest.getOperation();
    }

    @Override
    public ObjectKey getObjectKeyObject() {
        this.checkServerRequestIntegrity("getObjectKeyObject");
        return this.request.getObjectKeyObject();
    }

    @Override
    public byte[] getObjectKey() {
        this.checkServerRequestIntegrity("getObjectKey");
        return this.request.getObjectKeyObject().getBytes();
    }

    @Override
    public byte[] getAdapterId() {
        this.checkServerRequestIntegrity("getAdapterId");
        return this.request.getAdapterId();
    }

    @Override
    public byte getGIOPMajor() {
        this.checkServerRequestIntegrity("getGIOPMajor");
        return this.request.getGIOPMajor();
    }

    @Override
    public byte getGIOPMinor() {
        this.checkServerRequestIntegrity("getGIOPMinor");
        return this.request.getGIOPMinor();
    }

    @Override
    public ServerResponse createResponse(final ServiceContext[] serviceContextArray) {
        final ServerRequestImpl serverRequestImpl = this;
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ServerResponseImpl(serverRequestImpl, serviceContextArray);
            }
        });
        if (serviceContextArray != null) {
            serverResponseImpl.setReplyHasInitialContexts();
        }
        return serverResponseImpl;
    }

    public OutputStream createReply() {
        if (this.replyStream == null) {
            this.replyStream = (OutputStream)this.createResponse(this.getServiceContextReplyList());
        }
        return this.replyStream;
    }

    public OutputStream createExceptionReply() {
        if (this.exceptionReplyStream == null) {
            this.exceptionReplyStream = (OutputStream)this.createUserExceptionResponse();
        }
        return this.exceptionReplyStream;
    }

    @Override
    public ServerResponse createUserExceptionResponse() {
        final ServerRequestImpl serverRequestImpl = this;
        return (ServerResponseImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ServerResponseImpl(serverRequestImpl, ServerRequestImpl.this.getServiceContextReplyList(), true);
            }
        });
    }

    @Override
    public ServerResponse createUnknownExceptionResponse(UnknownException unknownException) {
        ServiceContext[] serviceContextArray;
        Object object;
        ServiceContext[] serviceContextArray2 = this.getServiceContextReplyList();
        UNKNOWN uNKNOWN = new UNKNOWN("Unknown exception:" + unknownException.getMessage(), 1229127302, CompletionStatus.COMPLETED_MAYBE);
        try {
            int n;
            object = (com.ibm.CORBA.iiop.CDROutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new CDROutputStream(ServerRequestImpl.this.orb, ServerRequestImpl.this.getGIOPMajor(), ServerRequestImpl.this.getGIOPMinor());
                }
            });
            ((com.ibm.CORBA.iiop.CDROutputStream)object).putEndian();
            ((com.ibm.CORBA.iiop.CDROutputStream)object).write_value(unknownException.originalEx);
            serviceContextArray = (ServiceContext[])((com.ibm.CORBA.iiop.CDROutputStream)object).toByteArray();
            ((com.ibm.CORBA.iiop.CDROutputStream)object).releaseBuffer();
            int n2 = n = serviceContextArray2 == null ? 0 : serviceContextArray2.length;
            if (n == 0) {
                serviceContextArray2 = new ServiceContext[2];
            } else {
                ServiceContext[] serviceContextArray3 = serviceContextArray2;
                serviceContextArray2 = new ServiceContext[n + 2];
                System.arraycopy(serviceContextArray3, 0, serviceContextArray2, 0, n);
            }
            serviceContextArray2[n] = com.ibm.CORBA.iiop.ORB.createServiceContext(9, (byte[])serviceContextArray);
            serviceContextArray2[n + 1] = this.createExceptionDetailMessage(unknownException.originalEx);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Trc.ffdc((Exception)throwable, CLASS, "createUnknownExceptionResponse:333");
            }
            Trc.ffdc(throwable.toString() + throwable, CLASS, "createUnknownExceptionResponse:335");
        }
        object = this;
        serviceContextArray = serviceContextArray2;
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)AccessController.doPrivileged(new PrivilegedAction((ServerRequestReader)object, serviceContextArray, (SystemException)uNKNOWN){
            final /* synthetic */ ServerRequestReader val$request;
            final /* synthetic */ ServiceContext[] val$ctxs;
            final /* synthetic */ SystemException val$sys;
            {
                this.val$request = serverRequestReader;
                this.val$ctxs = serviceContextArray;
                this.val$sys = systemException;
            }

            public Object run() {
                return new ServerResponseImpl(this.val$request, this.val$ctxs, this.val$sys);
            }
        });
        Utility.writeSystemException((SystemException)uNKNOWN, (OutputStream)serverResponseImpl);
        return serverResponseImpl;
    }

    @Override
    public ServerResponse createSystemExceptionResponse(final SystemException systemException) {
        ServiceContext[] serviceContextArray = this.getServiceContextReplyList();
        int n = serviceContextArray == null ? 0 : serviceContextArray.length;
        final ServiceContext[] serviceContextArray2 = new ServiceContext[n + 1];
        for (int i = 0; i < n; ++i) {
            serviceContextArray2[i] = serviceContextArray[i];
        }
        serviceContextArray2[n] = this.createExceptionDetailMessage(systemException);
        final ServerRequestImpl serverRequestImpl = this;
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ServerResponseImpl(serverRequestImpl, serviceContextArray2, systemException);
            }
        });
        Utility.writeSystemException(systemException, (OutputStream)serverResponseImpl);
        return serverResponseImpl;
    }

    private String createLongExceptionDetails(Throwable throwable) {
        String string = ((com.ibm.CORBA.iiop.ORB)this.orb).getORBServerHost();
        int n = ((com.ibm.CORBA.iiop.ORB)this.orb).getServerId();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        printWriter.print("\t>> SERVER (id=");
        printWriter.print(Integer.toHexString(n));
        printWriter.print(", host=");
        printWriter.print(string);
        printWriter.println(") TRACE START:");
        printWriter.print("\t>>    ");
        printWriter.println(throwable);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            printWriter.print("\t>>\t at ");
            printWriter.println(stackTraceElementArray[i].toString());
        }
        printWriter.print("\t>> SERVER (id=");
        printWriter.print(Integer.toHexString(n));
        printWriter.print(", host=");
        printWriter.print(string);
        printWriter.println(") TRACE END.");
        printWriter.flush();
        return stringWriter.toString();
    }

    private ServiceContext createExceptionDetailMessage(Throwable throwable) {
        com.ibm.CORBA.iiop.CDROutputStream cDROutputStream = (com.ibm.CORBA.iiop.CDROutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new CDROutputStream(ServerRequestImpl.this.orb, ServerRequestImpl.this.getGIOPMajor(), ServerRequestImpl.this.getGIOPMinor());
            }
        });
        cDROutputStream.putEndian();
        if (((ORB)this.orb).isShortExceptionDetails()) {
            cDROutputStream.write_wstring(throwable.toString());
        } else {
            cDROutputStream.write_wstring(this.createLongExceptionDetails(throwable));
        }
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return com.ibm.CORBA.iiop.ORB.createServiceContext(14, byArray);
    }

    @Override
    public ServerResponse createDummyExceptionResponse(final SystemException systemException) {
        final ServerRequestImpl serverRequestImpl = this;
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ServerResponseImpl(serverRequestImpl, systemException);
            }
        });
        return serverResponseImpl;
    }

    @Override
    public ServerResponse createLocationForward(final IOR iOR) {
        final ReplyMessage replyMessage = new ReplyMessage(this.getServiceContextReplyList(), this.getRequestId(), 3, this.getGIOPMajor(), this.getGIOPMinor());
        final ServerRequestImpl serverRequestImpl = this;
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ServerResponseImpl(serverRequestImpl, replyMessage, iOR, true);
            }
        });
        return serverResponseImpl;
    }

    @Override
    public ServerResponse createNeedsAddressingMode(final short s) {
        final ReplyMessage replyMessage = new ReplyMessage(this.getServiceContextReplyList(), this.getRequestId(), 5, this.getGIOPMajor(), this.getGIOPMinor());
        final ServerRequestImpl serverRequestImpl = this;
        ServerResponseImpl serverResponseImpl = (ServerResponseImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ServerResponseImpl(serverRequestImpl, replyMessage, s);
            }
        });
        return serverResponseImpl;
    }

    @Override
    public ServerRequestInfoImpl getServerRequestInfo() {
        return this.interceptorInfo;
    }

    @Override
    public void setPostInvoke(ServerDelegate serverDelegate, POA pOA, Object object, Object object2) {
        this.sd = serverDelegate;
        this.poa = pOA;
        this.servant = object;
        this.cookie = object2;
    }

    @Override
    public void callPostInvoke() {
        if (this.sd != null) {
            this.sd.doPostinvoke(this.poa, this.getObjectKeyObject(), this.servant, this.cookie, this.getOperationName());
        }
    }

    @Override
    public boolean isResponseDone() {
        return this.responseDone;
    }

    @Override
    public void setResponseDone() {
        this.responseDone = true;
    }

    @Override
    public void cancelFirstResponse(ServerResponseImpl serverResponseImpl) {
        if (this.firstResponse == null) {
            this.firstResponse = serverResponseImpl;
        } else {
            this.firstResponse.cancelReply();
        }
    }

    @Override
    public final void consumeServiceContexts() {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "consumeServiceContexts:550");
        }
        ORB oRB = (ORB)this.orb;
        Connection connection = this.getConnection();
        if (connection != null && oRB.useChannelFramework()) {
            return;
        }
        ServiceContext[] serviceContextArray = this.getServiceContextList();
        block6: for (int i = 0; i < serviceContextArray.length; ++i) {
            switch (serviceContextArray[i].getId()) {
                case 1: {
                    CodeSetComponentInfo codeSetComponentInfo;
                    byte[] byArray = serviceContextArray[i].getContextData();
                    CDRInputStream cDRInputStream = oRB.newInputStream(byArray, byArray.length);
                    cDRInputStream.consumeEndian();
                    CodeSetComponentInfo.CodeSetContext codeSetContext = new CodeSetComponentInfo.CodeSetContext();
                    codeSetContext.read(cDRInputStream);
                    int n = codeSetContext.getCharCodeSet();
                    int n2 = codeSetContext.getWCharCodeSet();
                    if (Trc.enabled(2)) {
                        Trc.info(Trc.FINEST, "CODE_SETS: ", "char_data=", Trc.hex(n), "wchar_data=", Trc.hex(n2), CLASS, "consumeServiceContexts:573");
                    }
                    if (!(codeSetComponentInfo = oRB.getCodeSetComponentInfo()).validate(codeSetContext)) {
                        if (n == 65537 && connection != null && connection.getCharCodeSet() == 0) {
                            if (!Trc.enabled(2)) continue block6;
                            Trc.info(Trc.FINEST, "Ignoring unexpected Latin-1 codeset", CLASS, "consumeServiceContexts:585");
                            continue block6;
                        }
                        throw new DATA_CONVERSION("CodeSetComponent 0x" + Utility.bytesToHexString(byArray) + " appears to be invalid.", 1229124488, CompletionStatus.COMPLETED_NO);
                    }
                    if (connection == null) continue block6;
                    int n3 = connection.getCharCodeSet();
                    int n4 = connection.getWCharCodeSet();
                    if (n3 != 0 && n3 != n || n4 != 0 && n4 != n2) {
                        throw new MARSHAL("Codeset has already been set.", 1229125859, CompletionStatus.COMPLETED_NO);
                    }
                    connection.setCodeSets(n, n2);
                    continue block6;
                }
                case 6: {
                    byte[] byArray = serviceContextArray[i].getContextData();
                    if (Trc.enabled()) {
                        Trc.warn("SENDING_CONTEXT_RUNTIME", CLASS, "consumeServiceContexts:615");
                    }
                    if (connection == null) continue block6;
                    connection.setCodeBaseRefByteArray(byArray);
                    continue block6;
                }
                case 1229081874: {
                    byte[] byArray = serviceContextArray[i].getContextData();
                    CDRInputStream cDRInputStream = oRB.newInputStream(byArray, byArray.length);
                    cDRInputStream.consumeEndian();
                    short s = cDRInputStream.read_ushort();
                    int n = cDRInputStream.read_ulong();
                    short s2 = PartnerVersionUtil.unpackMajor(n);
                    short s3 = PartnerVersionUtil.unpackMinor(n);
                    if (Trc.enabled()) {
                        Trc.warn("IBM_ORB_VERSION", s2 + "(0x" + Integer.toHexString(s2) + "):" + s3 + ":" + s, CLASS, "consumeServiceContexts:632");
                    }
                    if (connection == null) continue block6;
                    if (n == 0) {
                        connection.setPartnerVersion(PartnerVersionUtil.getORB11(), (short)0, s);
                        continue block6;
                    }
                    connection.setPartnerVersion(s2, s3, s);
                    continue block6;
                }
                case 17: {
                    byte[] byArray = serviceContextArray[i].getContextData();
                    CDRInputStream cDRInputStream = oRB.newInputStream(byArray, byArray.length);
                    cDRInputStream.consumeEndian();
                    if (connection != null) {
                        connection.setStreamFormatVersion(cDRInputStream.read_octet());
                    }
                    if (!Trc.enabled()) continue block6;
                    Trc.warn("RMICustomMaxStreamFormat=" + this.getStreamFormatVersion(), CLASS, "consumeServiceContexts:652");
                }
            }
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "consumeServiceContexts:657");
        }
    }

    @Override
    public void close() throws IOException {
        this.replyStream = null;
        this.firstResponse = null;
        this.servant = null;
        if (this.interceptorInfo != null) {
            this.interceptorInfo.clearResponse();
        }
        super.close();
    }

    private void checkServerRequestIntegrity(String string) {
        if (this.isConnectionless()) {
            INTERNAL iNTERNAL = new INTERNAL("ServerRequest has no connection details", 1229125051, CompletionStatus.COMPLETED_NO);
            Trc.ffdc(iNTERNAL, CLASS, string + ":680");
            throw iNTERNAL;
        }
    }

    private ServiceContext[] getServiceContextReplyList() {
        if (((ORB)this.orb).useChannelFramework()) {
            return null;
        }
        return this.getConnection().getServiceContextReplyList();
    }

    @Override
    public ServerRequestInfoImpl getInterceptorInfo() {
        return this.interceptorInfo;
    }

    @Override
    public boolean needsDelayedProcessing() {
        return this.needsDelayedProcessing;
    }

    @Override
    public void setDelayedProcessing(boolean bl) {
        this.needsDelayedProcessing = bl;
    }

    @Override
    public void setAsynchronousInvokeHandler(InvokeHandler invokeHandler) {
        this.asynchRequestInvokeHandler = invokeHandler;
    }

    @Override
    public InvokeHandler getAsynchronousInvokeHandler() {
        return this.asynchRequestInvokeHandler;
    }
}

