/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.ColocatedOutputStream;
import com.ibm.rmi.iiop.QueueingOutputStream;
import java.util.LinkedList;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;

public class ColocatedInputStream
extends CDRInputStream {
    private static final long serialVersionUID = 1L;
    private static final String CLASS = ColocatedInputStream.class.getName();
    private final QueueingOutputStream queueStream;
    private int markOffset;
    private int markIndex;
    private long markBlockLength;
    private LinkedList bufsFromMark = null;
    private LinkedList resetBufs = null;

    public ColocatedInputStream(ColocatedOutputStream colocatedOutputStream) {
        super(colocatedOutputStream, null, 0);
        this.setGIOPVersion(colocatedOutputStream.getGIOPMajor(), colocatedOutputStream.getGIOPMinor(), true);
        this.queueStream = colocatedOutputStream.getQueueingStream();
        this.setClassLoader(colocatedOutputStream.getReaderClassLoader());
    }

    @Override
    public void getNextBuffer() {
        this.offset += this.index - this.start;
        if (this.resetBufs != null) {
            SavedBuf savedBuf = (SavedBuf)this.resetBufs.removeFirst();
            if (this.resetBufs.size() == 0) {
                this.resetBufs = null;
            }
            this.processNextBuffer(savedBuf.buf, savedBuf.start, savedBuf.size, false);
        } else {
            byte[] byArray = this.queueStream.getNextData();
            if (null == byArray) {
                Trc.ffdc("Null buffer for next fragment", CLASS, "getNextBuffer:82");
                throw new INTERNAL("Null buffer for next fragment", 1229125059, CompletionStatus.COMPLETED_NO);
            }
            this.processNextBuffer(byArray, 0, byArray.length, true);
        }
    }

    public void processNextBuffer(byte[] byArray, int n, int n2, boolean bl) {
        if (bl && this.bufsFromMark != null) {
            SavedBuf savedBuf = new SavedBuf(byArray, n, n2);
            this.bufsFromMark.addLast(savedBuf);
        }
        this.buf = byArray;
        this.start = n;
        this.size = n2;
        this.index = n;
    }

    @Override
    public int mark() {
        this.markOffset = this.offset;
        this.markIndex = this.index;
        this.markBlockLength = this.blockLength;
        SavedBuf savedBuf = new SavedBuf(this.buf, this.start, this.size);
        if (this.bufsFromMark != null) {
            SavedBuf savedBuf2;
            while ((savedBuf2 = (SavedBuf)this.bufsFromMark.removeFirst()).buf != this.buf || savedBuf2.start != this.start) {
            }
            if (savedBuf2.size != this.size) {
                throw new MARSHAL("Stream mark error", 1229125871, CompletionStatus.COMPLETED_NO);
            }
        } else {
            this.bufsFromMark = this.resetBufs == null ? new LinkedList() : (LinkedList)this.resetBufs.clone();
        }
        this.bufsFromMark.addFirst(savedBuf);
        return this.index;
    }

    @Override
    public void reset(int n) {
        if (n != this.markIndex) {
            throw new MARSHAL("resetIndex (" + n + ") is not equal to markIndex (" + this.markIndex + ")", 1229125823, CompletionStatus.COMPLETED_NO);
        }
        this.reset();
    }

    public void reset() {
        if (this.bufsFromMark != null) {
            this.offset = this.markOffset;
            this.index = this.markIndex;
            this.blockLength = this.markBlockLength;
            this.resetBufs = this.bufsFromMark;
            this.bufsFromMark = null;
            SavedBuf savedBuf = (SavedBuf)this.resetBufs.removeFirst();
            this.buf = savedBuf.buf;
            this.start = savedBuf.start;
            this.size = savedBuf.size;
            if (this.resetBufs.isEmpty()) {
                this.resetBufs = null;
            }
        } else {
            throw new MARSHAL("Stream reset error", 1229125823, CompletionStatus.COMPLETED_NO);
        }
    }

    public QueueingOutputStream getQueueOutputStream() {
        return this.queueStream;
    }

    private static final class SavedBuf {
        private final int start;
        private final int size;
        private final byte[] buf;

        private SavedBuf(byte[] byArray, int n, int n2) {
            this.buf = byArray;
            this.start = n;
            this.size = n2;
        }
    }
}

