/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.CharToTcsAscii;
import com.ibm.rmi.iiop.CharToTcsLatin1;
import com.ibm.rmi.iiop.CharToTcsUnicode;
import com.ibm.rmi.iiop.CodeSetMapping;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import sun.io.CharToByteConverter;

public class CharToTcsConverter {
    private static final String CLASS = CharToTcsConverter.class.getName();
    protected boolean byteOriented;
    protected int osfId;
    protected CharToByteConverter sunConverter;
    protected CharsetEncoder encoder;
    private static boolean useNioFlag_CharToTcs = false;

    public static void setuseNioFlag_CharToTcs(boolean bl) {
        useNioFlag_CharToTcs = bl;
    }

    public CharToTcsConverter(int n) {
        this.osfId = n;
        this.byteOriented = true;
        this.sunConverter = null;
        this.encoder = null;
    }

    public boolean isByteOriented() {
        return this.byteOriented;
    }

    public byte[] convertToByte(char[] cArray) {
        if (useNioFlag_CharToTcs) {
            if (this.encoder == null) {
                this.getEncoder();
            }
        } else if (this.sunConverter == null && this.encoder == null) {
            try {
                this.getSunConverter();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.getEncoder();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINE, "Switching to nio encoders because of -" + classNotFoundException, "CharToTcsConverter", "convertToByte:123");
                }
                useNioFlag_CharToTcs = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.getEncoder();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINE, "Switching to nio encoders because of  - " + noClassDefFoundError, "CharToTcsConverter", "convertToByte:128");
                }
                useNioFlag_CharToTcs = true;
            }
        }
        if (this.sunConverter != null) {
            try {
                int n = cArray.length * this.sunConverter.getMaxBytesPerChar();
                byte[] byArray = new byte[n];
                int n2 = 0;
                this.sunConverter.reset();
                n2 += this.sunConverter.convert(cArray, 0, cArray.length, byArray, 0, n);
                if ((n2 += this.sunConverter.flush(byArray, this.sunConverter.nextByteIndex(), n)) < n) {
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    return byArray2;
                }
                return byArray;
            }
            catch (CharConversionException charConversionException) {
                Trc.ffdc(charConversionException, CLASS, "convertToByte:150");
                throw new DATA_CONVERSION("character not mapped to negotiated transimission code set (7)", 1330446337, CompletionStatus.COMPLETED_NO);
            }
        }
        byte[] byArray = this.convertToByteUsingNIO(cArray);
        return byArray;
    }

    public byte[] convertToByteUsingNIO(char[] cArray) {
        if (this.encoder == null) {
            this.getEncoder();
        }
        try {
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            ByteBuffer byteBuffer = this.encoder.encode(charBuffer);
            if (byteBuffer.hasArray()) {
                if (byteBuffer.position() == 0 && byteBuffer.limit() == byteBuffer.capacity()) {
                    return byteBuffer.array();
                }
                byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
                System.arraycopy(byteBuffer.array(), byteBuffer.position(), byArray, 0, byArray.length);
                return byArray;
            }
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byteBuffer.get();
            }
            return byArray;
        }
        catch (CharacterCodingException characterCodingException) {
            Trc.ffdc(characterCodingException, CLASS, "convertToByte:193");
            throw new DATA_CONVERSION("character not mapped to negotiated transimission code set (7)", 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    public char[] convertToChar(char[] cArray, boolean bl) {
        return null;
    }

    private synchronized void getSunConverter() throws ClassNotFoundException {
        if (this.sunConverter == null) {
            final String string = CodeSetMapping.mapToJavaEncoding(this.osfId);
            this.sunConverter = (CharToByteConverter)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return CharToByteConverter.getConverter((String)string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Trc.ffdc(unsupportedEncodingException, CLASS, "getSunConverter:221");
                        throw new DATA_CONVERSION("no character converter", 1229125848, CompletionStatus.COMPLETED_NO);
                    }
                }
            });
            this.sunConverter.setSubstitutionMode(false);
        }
    }

    private synchronized void getEncoder() {
        if (this.encoder == null) {
            final String string = CodeSetMapping.mapToJavaEncoding(this.osfId);
            this.encoder = (CharsetEncoder)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Charset.forName(string).newEncoder();
                }
            });
        }
    }

    public static CharToTcsConverter getConverter(int n) {
        CharToTcsConverter charToTcsConverter;
        switch (n) {
            case 65537: 
            case 65568: {
                charToTcsConverter = new CharToTcsLatin1(n);
                break;
            }
            case 65551: 
            case 268567780: {
                charToTcsConverter = new CharToTcsAscii(n, '\u007f');
                break;
            }
            case 65792: 
            case 65801: {
                charToTcsConverter = new CharToTcsUnicode(n);
                break;
            }
            default: {
                charToTcsConverter = new CharToTcsConverter(n);
            }
        }
        return charToTcsConverter;
    }

    protected int getMaxBytesPerChar() {
        if (this.sunConverter == null && this.encoder == null) {
            try {
                this.getSunConverter();
                return this.sunConverter.getMaxBytesPerChar();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.getEncoder();
                return new Float(this.encoder.maxBytesPerChar()).intValue();
            }
        }
        return 0;
    }

    public boolean needToSwap(boolean bl) {
        return bl && this.osfId != 65801;
    }
}

