/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.HexFormatter;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.Aligner;
import com.ibm.rmi.ORB;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CDRReader;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.util.Interop;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;

public class CDRInputStream
extends CDRReader {
    private static final String CLASS = CDRInputStream.class.getName();
    public final Interop interop;
    private Connection connection = null;
    protected int index;
    protected int size;
    protected int offset;
    protected byte[] buf;
    protected int start = 0;
    private static final long serialVersionUID = 0L;

    public CDRInputStream() {
        this.interop = Interop.NO_IBM_ORB;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n) {
        this(oRB, byArray, n, false);
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, Connection connection) {
        this(oRB, byArray, n, false);
        this.connection = connection;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl) {
        this.orb = oRB;
        this.littleEndian = bl;
        this.size = n;
        this.buf = byArray;
        this.offset = 0;
        if (oRB instanceof ORB) {
            this.interop = ((ORB)oRB).getInterop(this);
            ValueHandlerImpl.THREAD_LOCAL_PV.set(this);
        } else {
            this.interop = Interop.NO_IBM_ORB;
        }
    }

    public CDRInputStream(CDROutputStream cDROutputStream, byte[] byArray, int n) {
        this(cDROutputStream.orb(), byArray, n, cDROutputStream.littleEndian(), cDROutputStream.getCharCodeSet(), cDROutputStream.getWCharCodeSet());
        this.setGIOPVersions(cDROutputStream.getGIOPMajor(), cDROutputStream.getGIOPMinor(), cDROutputStream.getPartnerMajor(), cDROutputStream.getPartnerMinor(), cDROutputStream.getPartnerExtended());
        this.setStreamFormatVersion(cDROutputStream.getStreamFormatVersion());
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, int n2, int n3) {
        this(oRB, byArray, n, false, n2, n3);
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl, int n2, int n3) {
        this(oRB, byArray, n, bl);
        this.setCodeSets(n2, n3);
    }

    public CDRInputStream(CDRInputStream cDRInputStream) {
        this.littleEndian = cDRInputStream.littleEndian;
        this.index = cDRInputStream.index;
        this.size = cDRInputStream.size;
        this.buf = cDRInputStream.buf;
        this.orb = cDRInputStream.orb;
        this.connection = cDRInputStream.connection;
        this.offset = cDRInputStream.offset;
        this.start = cDRInputStream.start;
        this.setGIOPVersion(cDRInputStream.GIOPMajor, cDRInputStream.GIOPMinor, cDRInputStream.fragmentable);
        this.setCodeSets(cDRInputStream.tcsChar, cDRInputStream.tcsWChar);
        this.interop = cDRInputStream.interop;
    }

    public CDRInputStream(CDRInputStream cDRInputStream, int n) {
        this(cDRInputStream.getORB(), cDRInputStream.buf, cDRInputStream.mark() + n);
        if (cDRInputStream.index + n <= cDRInputStream.size) {
            this.index = this.start = cDRInputStream.index;
            this.offset = cDRInputStream.get_offset();
            cDRInputStream.setOffset(cDRInputStream.mark() + n);
        } else {
            this.littleEndian = cDRInputStream.littleEndian;
            this.buf = new byte[n];
            cDRInputStream.read_octet_array(this.buf, 0, n);
            this.start = 0;
            this.index = 0;
            this.size = n;
            this.offset = cDRInputStream.get_offset() - n;
        }
        this.typeStore = cDRInputStream.getTypeStore();
        this.setGIOPVersion(cDRInputStream.GIOPMajor, cDRInputStream.GIOPMinor, cDRInputStream.fragmentable);
    }

    public com.ibm.CORBA.iiop.CDRInputStream dup() {
        final CDRInputStream cDRInputStream = this;
        return (CDRInputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new CDRInputStream(cDRInputStream);
            }
        });
    }

    @Override
    public void toAlign(Aligner aligner, int n) {
        int n2;
        if (n > 1 && (n2 = this.index - this.start & n - 1) != 0) {
            n2 = n - n2;
            this.index += n2;
        }
    }

    @Override
    public void setOffset(int n) {
        this.index = n;
    }

    @Override
    public final byte read_octet() {
        this.alignAndCheck(null, 1, 1);
        byte by = this.buf[this.index++];
        this.check_start_block(this.index);
        return by;
    }

    public final void ignoreReserved() {
        try {
            switch (this.available()) {
                case 0: {
                    this.alignAndCheck(null, 2, 2);
                    this.index += 2;
                    this.alignAndCheck(null, 1, 1);
                    ++this.index;
                    return;
                }
                case 1: {
                    ++this.index;
                    this.alignAndCheck(null, 2, 2);
                    this.index += 2;
                    return;
                }
                case 2: {
                    this.index += 2;
                    this.alignAndCheck(null, 1, 1);
                    ++this.index;
                    return;
                }
            }
            this.index += 3;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final short read_short() {
        int n;
        int n2;
        this.alignAndCheck(null, 2, 2);
        if (this.littleEndian) {
            n2 = this.buf[this.index++] << 0 & 0xFF;
            n = this.buf[this.index++] << 8 & 0xFF00;
        } else {
            n = this.buf[this.index++] << 8 & 0xFF00;
            n2 = this.buf[this.index++] << 0 & 0xFF;
        }
        return (short)(n | n2);
    }

    @Override
    public final int read_long() {
        int n;
        int n2;
        int n3;
        int n4;
        this.alignAndCheck(null, 4, 4);
        if (this.littleEndian) {
            n4 = this.buf[this.index++] & 0xFF;
            n3 = this.buf[this.index++] & 0xFF;
            n2 = this.buf[this.index++] & 0xFF;
            n = this.buf[this.index++] & 0xFF;
        } else {
            n = this.buf[this.index++] & 0xFF;
            n2 = this.buf[this.index++] & 0xFF;
            n3 = this.buf[this.index++] & 0xFF;
            n4 = this.buf[this.index++] & 0xFF;
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    @Override
    public final long read_longlong() {
        this.alignAndCheck(null, 8, 8);
        return this.read_longlong_from_long();
    }

    @Override
    public final byte fast_read_byte() {
        return this.buf[this.index++];
    }

    @Override
    public final void read_octet_array(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null) {
            throw new BAD_PARAM("NULL_PARAM (17) - Null encountered reading octet array", 1229124113, CompletionStatus.COMPLETED_NO);
        }
        for (int i = n; i < n2 + n; i += n3) {
            int n4 = n2 + n - i;
            n3 = this.alignAndCheck(null, 1, n4);
            System.arraycopy(this.buf, this.index, byArray, i, n3);
            this.index += n3;
        }
    }

    @Override
    public int get_offset() {
        return this.index - this.start + this.offset;
    }

    @Override
    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        if (this instanceof IIOPInputStream) {
            this.connection = ((IIOPInputStream)this).getConnection();
        }
        return this.connection;
    }

    public boolean wasCreatedFrom(CDRWriter cDRWriter) {
        return false;
    }

    @Override
    public final void rewind() {
        this.offset += this.index;
        this.index = this.start;
    }

    @Override
    public final boolean isAtEnd() {
        return this.index == this.size;
    }

    @Override
    public int available() throws IOException {
        return this.size - this.index;
    }

    @Override
    public int mark() {
        return this.index;
    }

    @Override
    public void reset(int n) {
        this.index = n;
    }

    @Override
    public void printBuffer() {
        for (int i = 0; i < this.size; i += 16) {
            int n = 0;
            for (int j = 0; j < 16; ++j) {
                String string;
                int n2;
                if (i + j >= this.size) {
                    n2 = 0;
                } else {
                    n2 = this.buf[i + j];
                    ++n;
                }
                if (n2 < 0) {
                    n2 = 256 + n2;
                }
                if ((string = Integer.toHexString(n2)).length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
            }
            System.out.println(new String(this.buf, i, n));
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:543");
        throw notSerializableException;
    }

    @Override
    public Interop getInterop() {
        return this.interop;
    }

    @Override
    public void closeBuffer() {
        this.buf = null;
    }

    @Override
    public int getBufferIndex() {
        return this.index;
    }

    @Override
    public int getBufferStart() {
        return this.start;
    }

    @Override
    public void skip(int n) {
        this.index += n;
    }

    @Override
    public void setEndian(boolean bl) {
    }

    public void setStreamFormatVersion(byte by) {
        this.streamFormatVersion = by;
    }

    protected void traceData(String string, String string2, String string3) {
        String string4 = HexFormatter.format(this.buf, this.start, this.index, this.size, this.offset);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, string + "\n" + string4, string2, string3);
        }
    }

    @Override
    protected int getCurrentRemaining() {
        return -1;
    }

    @Override
    protected int checkSize(int n) {
        throw new NO_IMPLEMENT();
    }
}

