/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Plugin;
import com.ibm.CORBA.iiop.ThreadPool;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.CORBA.transport.Transport;
import com.ibm.rmi.channel.IIOPChannelPluginImpl;
import com.ibm.rmi.channel.giop.GIOPChannelPluginImpl;
import com.ibm.rmi.iiop.ThreadPoolImpl;
import com.ibm.rmi.transport.ReaderPoolImpl;
import com.ibm.rmi.transport.TCPTransport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;

public final class PluginRegistry {
    private static final String CLASS = PluginRegistry.class.getName();
    private static final Plugin[] NULL_PLUGIN_ARRAY = new Plugin[0];
    private static final Map pluginNameToDefaultClass = new HashMap();
    private final Registry unloadedRegistry = new Registry();
    private final Registry loadedRegistry = new Registry();
    private final ORB orb;

    PluginRegistry(ORB oRB) {
        this.orb = oRB;
    }

    void instantiatePlugins(List list) {
        for (String string : list) {
            try {
                this.instantiatePlugin(Util.loadClass((String)string, null, null));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Trc.enabled(5)) continue;
                Trc.info(Trc.FINEST, classNotFoundException, CLASS, "instantiatePlugins:119");
            }
        }
    }

    private void instantiatePlugin(Class clazz) {
        try {
            Plugin plugin = (Plugin)clazz.newInstance();
            this.unloadedRegistry.add(plugin, clazz);
        }
        catch (InstantiationException instantiationException) {
            Trc.ffdc(instantiationException, CLASS, "instantiatePlugin:131");
        }
        catch (IllegalAccessException illegalAccessException) {
            Trc.ffdc(illegalAccessException, CLASS, "instantiatePlugin:133");
        }
        catch (ClassCastException classCastException) {
            Trc.ffdc(classCastException, CLASS, "instantiatePlugin:135");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            INITIALIZE iNITIALIZE = new INITIALIZE("Unable to load plugins", 1229124868, CompletionStatus.COMPLETED_NO);
            iNITIALIZE.initCause(throwable);
            Trc.ffdc((Throwable)iNITIALIZE, CLASS, "instantiatePlugin:143");
            throw iNITIALIZE;
        }
    }

    List getUnloadedInstanceList(String string) {
        return this.unloadedRegistry.getInstanceList(string);
    }

    Plugin[] getInstances(String string) {
        Plugin[] pluginArray = NULL_PLUGIN_ARRAY;
        List list = this.loadedRegistry.getInstanceList(string);
        if (list != null) {
            pluginArray = new Plugin[list.size()];
            pluginArray = list.toArray(pluginArray);
        }
        return pluginArray;
    }

    Plugin[] getInstances() {
        Plugin[] pluginArray = NULL_PLUGIN_ARRAY;
        Set set = this.loadedRegistry.getInstanceSet();
        if (!set.isEmpty()) {
            pluginArray = new Plugin[set.size()];
            pluginArray = set.toArray(pluginArray);
        }
        return pluginArray;
    }

    Plugin getInstance(String string) {
        Plugin plugin = null;
        List list = this.loadedRegistry.getInstanceList(string);
        if (list != null) {
            plugin = (Plugin)list.get(0);
        }
        return plugin;
    }

    void initPlugin(String string) {
        Class clazz;
        List list = this.unloadedRegistry.getInstanceList(string);
        if (list == null && this.loadedRegistry.getInstanceList(string) == null && (clazz = (Class)pluginNameToDefaultClass.get(string)) != null) {
            this.instantiatePlugin(clazz);
            list = this.unloadedRegistry.getInstanceList(string);
        }
        if (list != null) {
            this.initPlugins(list);
        } else if (Trc.enabled(5)) {
            Trc.info(Trc.FINEST, "No instance list found", CLASS, "initPlugin:198");
        }
    }

    private void initPlugins(Collection collection) {
        int n = collection.size();
        if (n > 0) {
            Plugin[] pluginArray = new Plugin[n];
            pluginArray = collection.toArray(pluginArray);
            for (int i = 0; i < pluginArray.length; ++i) {
                this.initPlugin(pluginArray[i]);
            }
        }
    }

    void initPlugins() {
        this.initPlugins(this.unloadedRegistry.getInstanceSet());
    }

    private void initPlugin(Plugin plugin) {
        String[] stringArray = this.unloadedRegistry.clearAndGetPluginNames(plugin);
        try {
            plugin.init(this.orb);
            this.loadedRegistry.add(plugin, stringArray);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            INITIALIZE iNITIALIZE = new INITIALIZE("Unable to init plugins", 1229124868, CompletionStatus.COMPLETED_NO);
            iNITIALIZE.initCause(throwable);
            Trc.ffdc((Throwable)iNITIALIZE, CLASS, "initPlugin:237");
            throw iNITIALIZE;
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Plugin registry data:");
        printWriter.print("  Unloaded registry:");
        printWriter.print(this.unloadedRegistry.toString());
        printWriter.print("  Loaded registry:");
        printWriter.print(this.loadedRegistry.toString());
        return stringWriter.toString();
    }

    static {
        pluginNameToDefaultClass.put(GIOPChannelPlugin.class.getName(), GIOPChannelPluginImpl.class);
        pluginNameToDefaultClass.put(IIOPChannelPlugin.class.getName(), IIOPChannelPluginImpl.class);
        pluginNameToDefaultClass.put(ThreadPool.class.getName(), ThreadPoolImpl.class);
        pluginNameToDefaultClass.put(Transport.class.getName(), TCPTransport.class);
        pluginNameToDefaultClass.put(ReaderPool.class.getName(), ReaderPoolImpl.class);
    }

    private static class Registry {
        final Map instanceToPluginNames = new HashMap();
        final Map pluginNameToInstanceList = new HashMap();

        private Registry() {
        }

        void add(Plugin plugin, Class clazz) {
            assert (clazz.isInstance(plugin));
            HashSet<String> hashSet = new HashSet<String>();
            for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                Class<?>[] classArray = clazz2.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    if (!Plugin.class.isAssignableFrom(classArray[i])) continue;
                    hashSet.add(classArray[i].getName());
                }
            }
            String[] stringArray = new String[hashSet.size()];
            stringArray = hashSet.toArray(stringArray);
            this.add(plugin, stringArray);
        }

        void add(Plugin plugin, String[] stringArray) {
            this.instanceToPluginNames.put(plugin, stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                ArrayList<Plugin> arrayList = (ArrayList<Plugin>)this.pluginNameToInstanceList.get(stringArray[i]);
                if (arrayList == null) {
                    arrayList = new ArrayList<Plugin>();
                    this.pluginNameToInstanceList.put(stringArray[i], arrayList);
                }
                arrayList.add(plugin);
            }
        }

        Set getInstanceSet() {
            return this.instanceToPluginNames.keySet();
        }

        List getInstanceList(String string) {
            return (List)this.pluginNameToInstanceList.get(string);
        }

        String[] clearAndGetPluginNames(Plugin plugin) {
            String[] stringArray = (String[])this.instanceToPluginNames.remove(plugin);
            for (int i = 0; i < stringArray.length; ++i) {
                List list = (List)this.pluginNameToInstanceList.get(stringArray[i]);
                list.remove(plugin);
                if (list.size() != 0) continue;
                this.pluginNameToInstanceList.remove(stringArray[i]);
            }
            return stringArray;
        }

        private void printInstanceToPluginNamesMap(PrintWriter printWriter) {
            printWriter.print("    Instance to Plugin names:");
            Iterator iterator = this.instanceToPluginNames.entrySet().iterator();
            if (!iterator.hasNext()) {
                printWriter.println("\tEmpty.");
            } else {
                printWriter.println();
            }
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter.print("\t" + entry.getKey().getClass().getName() + " -> { ");
                String[] stringArray = (String[])entry.getValue();
                printWriter.print(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    printWriter.print(", " + stringArray[i]);
                }
                printWriter.println(" }");
            }
        }

        private void printPluginNameToInstancesMap(PrintWriter printWriter) {
            Iterator iterator = this.pluginNameToInstanceList.entrySet().iterator();
            printWriter.print("    Plugin name to Instances:");
            if (!iterator.hasNext()) {
                printWriter.println("\tEmpty.");
            } else {
                printWriter.println();
            }
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter.print("\t" + entry.getKey() + " -> { ");
                Iterator iterator2 = ((List)entry.getValue()).iterator();
                printWriter.print(iterator2.next().getClass().getName());
                while (iterator2.hasNext()) {
                    printWriter.print(", " + iterator2.next().getClass().getName());
                }
                printWriter.println(" }");
            }
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (this.instanceToPluginNames.isEmpty() && this.pluginNameToInstanceList.isEmpty()) {
                printWriter.println("\tEmpty.");
            } else {
                printWriter.println();
                this.printInstanceToPluginNamesMap(printWriter);
                this.printPluginNameToInstancesMap(printWriter);
            }
            return stringWriter.toString();
        }
    }
}

