/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.CloseConnectionMessageException;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPReadContext;
import com.ibm.CORBA.channel.giop.GIOPReadSchedulingPolicy;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.jtc.orb.iiop.MessageHandler;
import com.ibm.rmi.channel.giop.GIOPCDRInputHandler;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.channel.giop.GIOPUtil;
import com.ibm.rmi.channel.giop.MessageWriter;
import com.ibm.rmi.channel.giop.NextMessageHandler;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.MessageErrorMessage;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.omg.CORBA.portable.InputStream;

public class MessageReader
extends GIOPReadContext
implements NextMessageHandler,
Runnable {
    private static final String CLASS = MessageReader.class.getName();
    private final int bufferSize;
    private static final int GIOP_HDR_LEN = 12;
    private static WsByteBuffer[] EMPTY = new WsByteBuffer[0];
    private static WsByteBuffer[][] EMPTY_SPARES = new WsByteBuffer[][]{EMPTY};
    private VirtualConnection virtualConnection;
    private TCPReadRequestContext tcpContext;
    private ThreadPool threadPool;
    private String threadPoolName;
    private final GIOPChannelPlugin giopPlugin;
    private final GIOPConnection giopConn;
    private ORB orb;
    private final byte[] giopHeaderBytes = new byte[12];
    private WsByteBuffer[][] spareBufferArrays = EMPTY_SPARES;
    private WsByteBuffer[] buffers = this.spareBufferArrays[0];
    private int bytesAvailable = 0;
    private final boolean isServer;
    private final TransportConnection transport;

    MessageReader(VirtualConnection virtualConnection, TransportConnection transportConnection, TCPReadRequestContext tCPReadRequestContext, GIOPConnection gIOPConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, String string, boolean bl) {
        this.virtualConnection = virtualConnection;
        this.transport = transportConnection;
        this.tcpContext = tCPReadRequestContext;
        this.giopConn = gIOPConnection;
        this.orb = gIOPChannelConfig.getOrb();
        this.threadPoolName = string;
        this.giopPlugin = gIOPChannelPlugin;
        this.isServer = bl;
        this.bufferSize = gIOPChannelConfig.getBufferSize();
    }

    private boolean readGIOPMessage() throws Exception {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "readGIOPMessage:204");
        }
        boolean bl = true;
        try {
            WsByteBuffer[] wsByteBufferArray = this.getJustOneMessage();
            if (wsByteBufferArray == null) {
                if (Trc.enabled(2)) {
                    Trc.complete(Trc.FINEST, "waiting for partial message, readRequired=false", CLASS, "readGIOPMessage:212");
                }
                return false;
            }
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Got whole message ", Trc.array(wsByteBufferArray), " : ", Trc.hex(wsByteBufferArray), CLASS, "readGIOPMessage:217");
            }
            WsByteBuffer[] wsByteBufferArray2 = null;
            try {
                wsByteBufferArray2 = this.giopPlugin.processIncomingMsg(this.giopConn, wsByteBufferArray);
            }
            catch (CloseConnectionMessageException closeConnectionMessageException) {
                this.giopConn.markCloseConnection(closeConnectionMessageException);
                this.giopConn.closeConnection(closeConnectionMessageException);
                if (Trc.enabled(2)) {
                    Trc.complete(Trc.FINEST, "Received GIOPCloseConnection", " - closing down connection", CLASS, "readGIOPMessage:228");
                }
                return false;
            }
            if (wsByteBufferArray2 == wsByteBufferArray) {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "Plugin returned same array.", CLASS, "readGIOPMessage:235");
                }
            } else if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Plugin returned different array ", Trc.array(wsByteBufferArray2), " : ", Trc.hex(wsByteBufferArray2), CLASS, "readGIOPMessage:240");
            }
            if (wsByteBufferArray2 != null) {
                bl = MessageReader.dealWithMessage(wsByteBufferArray2, this.giopConn, this.transport, this.giopPlugin, this, this.getOrb(), this.isServer);
            } else if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Nothing to do for this message", CLASS, "readGIOPMessage:250");
            }
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, "readRequired=", Trc.str(bl), CLASS, "readGIOPMessage:256");
            }
        }
        catch (GIOPVersionException gIOPVersionException) {
            Trc.ffdc(gIOPVersionException, CLASS, "readGIOPMessage:259");
            this.sendGIOPExceptionMessage(gIOPVersionException);
            throw gIOPVersionException;
        }
        return bl;
    }

    private static boolean dealWithMessage(WsByteBuffer[] wsByteBufferArray, GIOPConnection gIOPConnection, TransportConnection transportConnection, GIOPChannelPlugin gIOPChannelPlugin, NextMessageHandler nextMessageHandler, ORB oRB, boolean bl) throws Exception {
        boolean bl2;
        boolean bl3;
        GIOPMessageContext gIOPMessageContext;
        int n;
        block24: {
            if (Trc.enabled(2)) {
                Trc.begin1(Trc.FINEST, Trc.array(wsByteBufferArray), CLASS, "dealWithMessage:305");
            }
            int n2 = n = gIOPChannelPlugin.getGiopReadSchedulingPolicy() == GIOPReadSchedulingPolicy.LATE ? Integer.MAX_VALUE : 0;
            if (n-- == 0) {
                n = nextMessageHandler.handleNextMessageEarly();
            }
            GIOPMessageContext gIOPMessageContext2 = null;
            gIOPMessageContext = null;
            Message message = null;
            bl3 = true;
            try {
                try {
                    gIOPMessageContext2 = MessageReader.createGIOPMessageContext(oRB, gIOPConnection.getConnection(), wsByteBufferArray);
                    if (n-- == 0) {
                        n = nextMessageHandler.handleNextMessageEarly();
                    }
                    message = (Message)gIOPMessageContext2.getMessage();
                    if (gIOPConnection.isCommTraceEnabled()) {
                        Trace.dump(Utility.getMessage("Trace.inComing"), true, true, WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray), message.getSize(), 0, transportConnection);
                    }
                }
                catch (GIOPVersionException gIOPVersionException) {
                    if (Trc.enabled()) {
                        Trc.warn(gIOPVersionException, CLASS, "dealWithMessage:343");
                    }
                    throw gIOPVersionException;
                }
                catch (IOException iOException) {
                    if (Trc.enabled()) {
                        Trc.warn(iOException, CLASS, "dealWithMessage:349");
                    }
                    throw iOException;
                }
                if (!gIOPConnection.isPostInitialRequestContexts() && message.getType() == 1) {
                    gIOPConnection.setPostInitialRequestContexts(gIOPMessageContext2);
                }
                try {
                    if (gIOPMessageContext2.getServiceContexts() != null) {
                        gIOPConnection.consumeServiceContexts(gIOPMessageContext2);
                    }
                    if (gIOPMessageContext2.getSendingContextBytes() == null) {
                        ((GIOPMessageContextBase)gIOPMessageContext2).setSendingContextBytes(gIOPConnection.getCodeBaseRefBytes());
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                gIOPMessageContext = gIOPChannelPlugin.processIncomingContext(gIOPConnection, gIOPMessageContext2);
            }
            catch (Exception exception) {
                if (Trc.enabled()) {
                    Trc.warn(exception, CLASS, "dealWithMessage:377");
                }
                bl3 = false;
                if (bl) {
                    if (gIOPMessageContext2.isResponseExpected()) {
                        gIOPConnection.sendExceptionResponse(exception, gIOPMessageContext2, -1);
                    }
                }
                if (message == null) break block24;
                gIOPChannelPlugin.routeErrorResponse(gIOPConnection, message.getRequestId(), exception);
            }
        }
        if (n-- == 0) {
            n = nextMessageHandler.handleNextMessageEarly();
        }
        if (bl3 && gIOPMessageContext != null) {
            if (gIOPConnection.isServerMode(gIOPMessageContext, true)) {
                gIOPChannelPlugin.routeIncomingRequest(gIOPConnection, gIOPMessageContext);
            } else {
                gIOPChannelPlugin.routeIncomingReply(gIOPConnection, gIOPMessageContext);
            }
        }
        boolean bl4 = bl2 = n >= 0;
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, "readRequired=", Trc.str(bl2), CLASS, "dealWithMessage:409");
        }
        return bl2;
    }

    public static GIOPMessageContext createGIOPMessageContext(ORB oRB, Connection connection, WsByteBuffer[] wsByteBufferArray) throws Exception {
        GIOPCDRInputHandler gIOPCDRInputHandler = GIOPCDRInputHandler.getHandler();
        MessageHandler messageHandler = new MessageHandler(oRB, connection, wsByteBufferArray);
        gIOPCDRInputHandler.setDataHandler(messageHandler);
        Message message = GIOPMessageContextBase.createMessage(gIOPCDRInputHandler, wsByteBufferArray);
        message.read((InputStream)gIOPCDRInputHandler);
        gIOPCDRInputHandler.unsetDataHandler();
        GIOPMessageContext gIOPMessageContext = message.createMessageContext(wsByteBufferArray);
        return gIOPMessageContext;
    }

    @Override
    public int handleNextMessageEarly() {
        int n;
        block7: {
            n = 0;
            if (Trc.enabled(2)) {
                Trc.begin(Trc.FINEST, CLASS, "handleNextMessageEarly:466");
            }
            try {
                int n2 = this.getThreadPool().execute((Runnable)this);
                if (n2 == 0) {
                    n = -1;
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, CLASS, "handleNextMessageEarly:473");
                    }
                } else if (Trc.enabled()) {
                    Trc.fail(Trc.FINE, "Thread dispatch failed", CLASS, "handleNextMessageEarly:477");
                }
            }
            catch (ChannelException channelException) {
                if (!Trc.enabled()) break block7;
                Trc.fail(Trc.FINE, (Object)channelException, CLASS, "handleNextMessageEarly:482");
            }
        }
        return n;
    }

    private void arrayDuplicate(WsByteBuffer[] wsByteBufferArray, int n, WsByteBuffer[] wsByteBufferArray2, int n2, int n3) {
        assert (wsByteBufferArray.length >= n + n3);
        assert (wsByteBufferArray2.length >= n2 + n3);
        for (int i = 0; i < n3; ++i) {
            wsByteBufferArray2[n2 + i] = wsByteBufferArray[n + i].duplicate();
        }
    }

    private WsByteBuffer[] getJustOneMessage() throws IOException {
        WsByteBuffer[] wsByteBufferArray;
        int n;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, Trc.str(this.bytesAvailable), " bytes available", CLASS, "getJustOneMessage:537");
        }
        if (this.bytesAvailable < 12 && !this.retrieveData(12 - this.bytesAvailable)) {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, Trc.str(12 - this.bytesAvailable), " bytes not available for header yet", CLASS, "getJustOneMessage:543");
            }
            return null;
        }
        if (this.buffers[0].remaining() < 12) {
            MessageReader.peekBuffersInto(this.buffers, this.giopHeaderBytes);
            n = GIOPUtil.msgSize(this.giopHeaderBytes);
        } else {
            assert (this.buffers[0].remaining() >= 12);
            n = GIOPUtil.msgSize(this.buffers[0]);
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "buffers=", Trc.array(this.buffers), ", msgSize=", Trc.str(n), CLASS, "getJustOneMessage:557");
        }
        if (this.bytesAvailable < 12 + n && !this.retrieveData(12 + n - this.bytesAvailable)) {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, Trc.str(12 + n - this.bytesAvailable), " bytes not available for body yet", CLASS, "getJustOneMessage:565");
            }
            return null;
        }
        if (12 + n == this.bytesAvailable) {
            wsByteBufferArray = this.buffers;
            this.buffers = EMPTY;
            this.bytesAvailable = 0;
        } else {
            WsByteBuffer[] wsByteBufferArray2;
            int n2;
            int n3 = 0;
            int n4 = this.buffers[n3].remaining();
            for (n2 = 12 + n; n2 > n4; n2 -= n4) {
                n4 = this.buffers[++n3].remaining();
            }
            wsByteBufferArray = this.reserveBufferArray(n3 + 1);
            this.arrayDuplicate(this.buffers, 0, wsByteBufferArray, 0, n3 + 1);
            int n5 = this.buffers.length - wsByteBufferArray.length;
            if (n2 == n4) {
                wsByteBufferArray2 = new WsByteBuffer[n5];
                this.arrayDuplicate(this.buffers, n3 + 1, wsByteBufferArray2, 0, n5);
            } else {
                wsByteBufferArray2 = new WsByteBuffer[n5 + 1];
                wsByteBufferArray[n3].position(n2);
                wsByteBufferArray2[0] = wsByteBufferArray[n3].slice();
                wsByteBufferArray[n3].flip();
                this.arrayDuplicate(this.buffers, n3 + 1, wsByteBufferArray2, 1, n5);
            }
            this.emptyBufferArray(this.buffers);
            this.buffers = wsByteBufferArray2;
            this.bytesAvailable -= n + 12;
        }
        return wsByteBufferArray;
    }

    private WsByteBuffer[] reserveBufferArray(int n) {
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n];
        return wsByteBufferArray;
    }

    private void emptyBufferArray(WsByteBuffer[] wsByteBufferArray) {
        Arrays.fill(wsByteBufferArray, null);
    }

    private void releaseBufferArray(WsByteBuffer[] wsByteBufferArray) {
        WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])wsByteBufferArray);
        this.emptyBufferArray(wsByteBufferArray);
    }

    public TCPConnectionContext getInterface() {
        return this.giopConn;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "complete:733");
        }
        this.postRead();
        this.grabNewBuffers();
        try {
            this.startReading();
        }
        catch (Exception exception) {
            if (Trc.enabled()) {
                Trc.warn(exception, CLASS, "complete:747");
            }
            this.handleReadError(exception);
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "complete:753");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (Trc.enabled()) {
            Trc.warn("VC=", virtualConnection, " TCP read=", tCPReadRequestContext, iOException.toString(), CLASS, "error:766");
        }
        this.postRead();
        this.handleReadError(iOException);
    }

    protected void readFirstMessage() throws Exception {
        this.grabNewBuffers();
        try {
            this.startReading();
        }
        catch (Exception exception) {
            if (Trc.enabled()) {
                Trc.warn(exception, CLASS, "readFirstMessage:787");
            }
            this.handleReadError(exception);
            throw exception;
        }
    }

    private void startReading() throws Exception {
        boolean bl;
        while (bl = this.bytesAvailable == 0 ? this.retrieveData(12) : this.readGIOPMessage()) {
        }
    }

    private static void peekBuffersInto(WsByteBuffer[] wsByteBufferArray, byte[] byArray) {
        assert (wsByteBufferArray != null);
        assert (byArray != null);
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = Math.min(n - n2, wsByteBufferArray[n3].remaining());
            int n5 = wsByteBufferArray[n3].position();
            wsByteBufferArray[n3].get(byArray, n2, n4);
            wsByteBufferArray[n3].position(n5);
            if ((n2 += n4) == n) break;
            ++n3;
        }
    }

    private boolean retrieveData(int n) throws IOException {
        boolean bl;
        if (Trc.enabled(2)) {
            Trc.begin1(Trc.FINEST, "numBytes=", Trc.str(n), CLASS, "retrieveData:856");
        }
        if (n <= 0) {
            bl = true;
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, "Nothing to do!", CLASS, "retrieveData:861");
            }
        } else {
            this.preRead(n);
            VirtualConnection virtualConnection = this.tcpContext.read((long)n, (TCPReadCompletedCallback)this, false, -1);
            if (virtualConnection == null) {
                bl = false;
                if (Trc.enabled(2)) {
                    Trc.complete(Trc.FINEST, "no more bytes yet - call me back later", CLASS, "retrieveData:871");
                }
            } else {
                this.postRead();
                if (!this.grabNewBuffers()) {
                    bl = false;
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, "bytes not available unexpectedly", " - workaround for a TCPChannel bug", CLASS, "retrieveData:878");
                    }
                } else {
                    bl = true;
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, "bytes were available", CLASS, "retrieveData:883");
                    }
                }
            }
        }
        return bl;
    }

    protected void retrieveDataLater(int n) throws IOException {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "requested callback: numBytes=", Trc.str(n), CLASS, "retrieveDataLater:900");
        }
        this.preRead(n);
        this.tcpContext.read((long)n, (TCPReadCompletedCallback)this, true, -1);
    }

    private void preRead(int n) throws IOException {
        boolean bl = this.virtualConnection.requestPermissionToRead();
        if (!bl) {
            throw new IOException("request to read failed");
        }
        int n2 = Math.max(this.bufferSize, n);
        this.tcpContext.setBuffers(null);
        this.tcpContext.setJITAllocateSize(n2);
    }

    private void postRead() {
        this.virtualConnection.setReadStateToDone();
    }

    private boolean grabNewBuffers() {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "grabNewBuffers:957");
        }
        WsByteBuffer[] wsByteBufferArray = this.tcpContext.getBuffers();
        WsByteBuffer[] wsByteBufferArray2 = this.buffers;
        if (wsByteBufferArray == null || wsByteBufferArray.length == 0) {
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, "nothing to do", CLASS, "grabNewBuffers:963");
            }
            return false;
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "new buffers retrieved: ", Trc.array(wsByteBufferArray), CLASS, "grabNewBuffers:969");
        }
        WsByteBufferUtils.flip((WsByteBuffer[])wsByteBufferArray);
        if (this.bytesAvailable != 0) {
            this.bytesAvailable += WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "adding ", Trc.str(wsByteBufferArray.length), " new buffers to existing ", Trc.str(this.buffers.length), CLASS, "grabNewBuffers:979");
            }
            this.buffers = this.reserveBufferArray(wsByteBufferArray2.length + wsByteBufferArray.length);
            System.arraycopy(wsByteBufferArray2, 0, this.buffers, 0, wsByteBufferArray2.length);
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Copied ", Trc.array(wsByteBufferArray2), " into ", Trc.array(this.buffers), " now working on ", Trc.array(wsByteBufferArray), CLASS, "grabNewBuffers:995");
            }
            System.arraycopy(wsByteBufferArray, 0, this.buffers, wsByteBufferArray2.length, wsByteBufferArray.length);
        } else {
            this.bytesAvailable = WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
            this.buffers = this.reserveBufferArray(wsByteBufferArray.length);
            System.arraycopy(wsByteBufferArray, 0, this.buffers, 0, wsByteBufferArray.length);
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "Copied ", Trc.array(wsByteBufferArray), " into ", Trc.array(this.buffers), CLASS, "grabNewBuffers:1013");
        }
        this.emptyBufferArray(wsByteBufferArray2);
        this.emptyBufferArray(wsByteBufferArray);
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, "buffers.length=", Trc.str(this.buffers.length), " bytesAvailable=", Trc.str(this.bytesAvailable), CLASS, "grabNewBuffers:1018");
        }
        return true;
    }

    private ORB getOrb() {
        return this.orb;
    }

    private ThreadPool getThreadPool() throws ChannelException {
        if (Trc.enabled(2)) {
            Trc.begin1(Trc.FINEST, this.threadPool, CLASS, "getThreadPool:1039");
        }
        if (this.threadPool == null) {
            ChannelFramework channelFramework = ChannelFrameworkFactory.getChannelFramework();
            if (this.threadPoolName != null) {
                this.threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(this.threadPoolName);
                if (this.threadPool == null) {
                    String string = this.threadPoolName + " not found";
                    if (Trc.enabled()) {
                        Trc.warn(string, CLASS, "getThreadPool:1061");
                    }
                    throw new ChannelException(string);
                }
            } else {
                this.threadPool = channelFramework.getDefaultThreadPool();
                if (this.threadPool == null) {
                    String string = "default ThreadPool not found";
                    if (Trc.enabled()) {
                        Trc.warn(string, CLASS, "getThreadPool:1074");
                    }
                    throw new ChannelException(string);
                }
            }
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, this.threadPool, CLASS, "getThreadPool:1082");
        }
        return this.threadPool;
    }

    private void handleReadError(Exception exception) {
        this.releaseBuffers();
        this.giopConn.closeConnection(exception);
    }

    private void releaseBuffers() {
        WsByteBuffer[] wsByteBufferArray;
        if (this.buffers != null) {
            this.releaseBufferArray(this.buffers);
        }
        if ((wsByteBufferArray = this.tcpContext.getBuffers()) != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])wsByteBufferArray);
        }
    }

    private void sendGIOPExceptionMessage(GIOPVersionException gIOPVersionException) {
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new IIOPOutputStream(MessageReader.this.getOrb(), null);
            }
        });
        MessageErrorMessage messageErrorMessage = new MessageErrorMessage(1, this.getOrb().getMaxGIOPMinor());
        iIOPOutputStream.setMessage(messageErrorMessage);
        try {
            iIOPOutputStream.writeTo((MessageWriter)this.giopConn.getWriteInterface());
        }
        catch (IOException iOException) {
            Trc.ffdc(iOException, CLASS, "sendGIOPExceptionMessage:1137");
        }
    }

    @Override
    public void run() {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "run:1147");
        }
        try {
            this.startReading();
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, CLASS, "run:1152");
            }
        }
        catch (Exception exception) {
            if (Trc.enabled()) {
                Trc.fail(Trc.FINE, exception, CLASS, "run:1156");
            }
            this.handleReadError(exception);
        }
    }
}

