/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.CancelRequestException;
import com.ibm.CORBA.channel.giop.CloseConnectionMessageException;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPReadSchedulingPolicy;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.giop.FragmentQueue;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.channel.giop.HeaderWalker;
import com.ibm.rmi.channel.giop.ReplyStatusWalker;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.TransportService;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;

public class GIOPChannelPluginImpl
implements GIOPChannelPlugin {
    private static final String CLASS = GIOPChannelPluginImpl.class.getName();
    private int requestTimeout;
    private int fragmentTimeout;
    private Map appChannelMap = null;
    private Channel[] appChannels;
    private int channelCount = 0;
    private ORB orb;
    private TransportService transportService;
    private int maxAppChannel;
    private Object initLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerAppChannel(Channel channel) {
        if (this.channelCount == 0) {
            this.transportService = (TransportService)this.orb.getTransport();
            this.maxAppChannel = this.transportService.getInboundORBChannelCount();
            this.appChannels = new Channel[this.maxAppChannel];
        }
        Object object = this.initLock;
        synchronized (object) {
            this.appChannels[this.channelCount++] = channel;
            if (this.channelCount == this.maxAppChannel) {
                this.initLock.notify();
            }
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, Trc.str(this.channelCount), " of ", Trc.str(this.maxAppChannel), " channels: ", channel, CLASS, "registerAppChannel:122");
        }
    }

    private Channel getORBChannel(String string) throws ChannelException, InterruptedException {
        if (this.appChannelMap == null) {
            this.initAppChannelMap();
        }
        return (Channel)this.appChannelMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initAppChannelMap() throws ChannelException, InterruptedException {
        if (this.appChannelMap != null) {
            return;
        }
        HashMap<String, Channel> hashMap = new HashMap<String, Channel>();
        ChannelFramework channelFramework = this.transportService.getChannelFramework();
        Object object = this.initLock;
        synchronized (object) {
            if (this.channelCount < this.maxAppChannel) {
                this.initLock.wait();
            }
        }
        for (int i = 0; i < this.channelCount; ++i) {
            ChainData[] chainDataArray = channelFramework.getInternalRunningChains(this.appChannels[i].getName());
            ChannelData[] channelDataArray = chainDataArray[0].getChannelList();
            String string = null;
            for (int j = 0; j < channelDataArray.length; ++j) {
                Class clazz = channelDataArray[j].getFactoryType();
                if (!GIOPInboundChannelFactory.class.isAssignableFrom(clazz)) continue;
                string = channelFramework.getChannel(channelDataArray[j].getName()).getName();
            }
            hashMap.put(string, this.appChannels[i]);
        }
        this.appChannelMap = hashMap;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, this.appChannelMap, CLASS, "initAppChannelMap:202");
        }
        this.appChannels = null;
    }

    @Override
    public void init(ORB oRB) {
        this.orb = oRB;
        this.requestTimeout = oRB.getRequestTimeout();
        this.fragmentTimeout = oRB.getFragmentTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer[] processIncomingMsg(GIOPConnectionContext gIOPConnectionContext, WsByteBuffer[] wsByteBufferArray) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        HeaderWalker headerWalker = gIOPConnection.getHeaderWalker();
        if (Trc.enabled(2)) {
            Trc.begin1(Trc.FINEST, headerWalker, CLASS, "processIncomingMsg:258");
        }
        try {
            HeaderWalker.Progress progress;
            byte by;
            headerWalker.setBuffers(wsByteBufferArray);
            headerWalker.readGiopHeader();
            byte by2 = headerWalker.getMsgType();
            switch (by2) {
                case 2: {
                    int n = headerWalker.getRequestId();
                    CancelRequestException cancelRequestException = new CancelRequestException("GIOPCancelRequest for " + n + " received");
                    this.processExceptionInDataStore(gIOPConnection, n, cancelRequestException);
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, "Received cancel message for request ", Trc.str(n), CLASS, "processIncomingMsg:276");
                    }
                    WsByteBuffer[] wsByteBufferArray2 = null;
                    return wsByteBufferArray2;
                }
                case 5: {
                    CloseConnectionMessageException closeConnectionMessageException = new CloseConnectionMessageException("CloseConnection msg received");
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, "Expected Exception for GIOPCloseConnection", CLASS, "processIncomingMsg:287");
                    }
                    throw closeConnectionMessageException;
                }
                case 6: {
                    IOException iOException = new IOException("MessageError msg received");
                    gIOPConnection.markCloseConnection(iOException);
                    gIOPConnection.closeConnection(iOException);
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, "Received ", headerWalker.getMsgTypeName(), " - closing down connection", CLASS, "processIncomingMsg:298");
                    }
                    WsByteBuffer[] wsByteBufferArray3 = null;
                    return wsByteBufferArray3;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    by = by2;
                    progress = headerWalker.walkMessageHeader();
                    break;
                }
                case 7: {
                    Object object = null;
                    int n = -1;
                    if (headerWalker.getMajor() > 1 || headerWalker.getMinor() > 1) {
                        n = headerWalker.getRequestId();
                        object = gIOPConnection.retrieveRequestData(n);
                    }
                    if (object instanceof HeaderWalker.Progress) {
                        progress = (HeaderWalker.Progress)object;
                        by = progress.mType;
                        if (progress.isReplyStatusMode()) {
                            ReplyStatusWalker replyStatusWalker = gIOPConnection.getReplyStatusWalker();
                            replyStatusWalker.setGIOPHeaderData(headerWalker);
                            headerWalker = replyStatusWalker;
                        }
                        progress = headerWalker.continueWalk(progress);
                        break;
                    }
                    if (object instanceof FragmentQueue) {
                        FragmentQueue fragmentQueue = (FragmentQueue)object;
                        byte by3 = fragmentQueue.msgType;
                        if (headerWalker.msgHasFragmentToFollow()) {
                            fragmentQueue.addNextFragment(wsByteBufferArray);
                        } else {
                            fragmentQueue.addLastFragment(wsByteBufferArray);
                        }
                        if (Trc.enabled(2)) {
                            Trc.complete(Trc.FINEST, "Received fragment for request ", Trc.str(n), " - enqueued", CLASS, "processIncomingMsg:347");
                        }
                        WsByteBuffer[] wsByteBufferArray4 = null;
                        return wsByteBufferArray4;
                    }
                    if (object instanceof IOException) {
                        if (Trc.enabled()) {
                            Trc.fail(Trc.FINE, "Exception in dataStore ", Trc.str(n), object, CLASS, "processIncomingMsg:353");
                        }
                        throw (IOException)object;
                    }
                    if (object == null) {
                        if (Trc.enabled(2)) {
                            Trc.complete(Trc.FINEST, "discarding unexpected fragment - request id:", Trc.str(n), CLASS, "processIncomingMsg:360");
                        }
                        WsByteBuffer[] wsByteBufferArray5 = null;
                        return wsByteBufferArray5;
                    }
                    if (Trc.enabled()) {
                        Trc.fail(Trc.FINE, "Invalid request data for request ", Trc.str(n), object, CLASS, "processIncomingMsg:365");
                    }
                    throw new INTERNAL("Invalid request data stored for req id " + n + ": " + object);
                }
                default: {
                    throw new GIOPVersionException("Unknown message type = " + by2);
                }
            }
            int n = headerWalker.getRequestId();
            if (by == 1 && headerWalker.getReplyStatus() != 0 && progress == HeaderWalker.HEADER_WALK_COMPLETE) {
                gIOPConnection.clearRequestData(n);
                by2 = by;
                ReplyStatusWalker replyStatusWalker = gIOPConnection.getReplyStatusWalker();
                replyStatusWalker.setGIOPHeaderData(headerWalker);
                progress = replyStatusWalker.walkReplyExceptionData(headerWalker.getReplyStatus());
            }
            if (progress == HeaderWalker.HEADER_WALK_COMPLETE) {
                if (headerWalker.msgHasFragmentToFollow()) {
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, "Header complete - creating frag queue: ", "reqId=", Trc.str(n), CLASS, "processIncomingMsg:403");
                    }
                    FragmentQueue fragmentQueue = new FragmentQueue(n, by, this.fragmentTimeout);
                    gIOPConnection.storeRequestData(n, fragmentQueue);
                } else if (by2 == 7) {
                    gIOPConnection.clearRequestData(n);
                    if (Trc.enabled(2)) {
                        Trc.complete(Trc.FINEST, "Header complete - no frags to follow: reqId=", Trc.str(n), CLASS, "processIncomingMsg:412");
                    }
                } else if (Trc.enabled(2)) {
                    Trc.complete(Trc.FINEST, "Header complete - message not fragmented: ", "reqId=", Trc.str(n), CLASS, "processIncomingMsg:416");
                }
                headerWalker.rewindBuffers();
                WsByteBuffer[] wsByteBufferArray6 = headerWalker.getBuffers();
                return wsByteBufferArray6;
            }
            if (by2 != 7) {
                gIOPConnection.storeRequestData(n, progress);
            }
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, "Header incomplete for request ", Trc.str(n), " storing progress: ", progress, CLASS, "processIncomingMsg:429");
            }
            WsByteBuffer[] wsByteBufferArray7 = null;
            return wsByteBufferArray7;
        }
        finally {
            headerWalker.forgetBuffers();
        }
    }

    private void processExceptionInDataStore(GIOPConnection gIOPConnection, int n, IOException iOException) {
        Object object = gIOPConnection.retrieveRequestData(n);
        if (object != null) {
            if (object instanceof HeaderWalker.Progress) {
                gIOPConnection.clearRequestData(n);
            } else {
                gIOPConnection.storeException(n, iOException);
            }
        }
    }

    @Override
    public GIOPMessageContext processIncomingContext(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        return gIOPMessageContext;
    }

    @Override
    public void routeIncomingRequest(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        Object object = null;
        if (!gIOPConnection.isServer()) {
            if (this.transportService == null) {
                this.transportService = (TransportService)this.orb.getTransport();
                this.transportService.getFvdServerChannel().start();
            }
            object = this.transportService.getFvdServerChannel();
        } else {
            object = this.getORBChannel(gIOPConnection.getServerChannelName());
        }
        VirtualConnection virtualConnection = gIOPConnectionContext.getVirtualConnection();
        ConnectionLink connectionLink = object.getConnectionLink(virtualConnection);
        CallLink callLink = (CallLink)connectionLink;
        callLink.setGIOPConnectionContext(gIOPConnectionContext);
        if (gIOPMessageContext.isResponseExpected()) {
            gIOPConnection.storeCallLink(gIOPMessageContext.getRequestId(), callLink);
        }
        callLink.processMessage(gIOPMessageContext);
    }

    @Override
    public WsByteBuffer[] processOutgoingMsg(GIOPConnectionContext gIOPConnectionContext, WsByteBuffer[] wsByteBufferArray) throws Exception {
        return wsByteBufferArray;
    }

    @Override
    public GIOPMessageContext processOutgoingContext(CallLink callLink, GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        int n = gIOPMessageContext.getRequestId();
        IOException iOException = gIOPConnection.retrieveException(n);
        if (iOException != null) {
            throw iOException;
        }
        boolean bl = gIOPConnection.isServerMode(gIOPMessageContext, false);
        if (bl && !gIOPMessageContext.isFragmentToFollow()) {
            gIOPConnection.clearCallLink(gIOPMessageContext.getRequestId());
        } else if (!bl && gIOPMessageContext.isResponseExpected()) {
            long l = this.requestTimeout == 0 ? 0L : System.currentTimeMillis() + (long)this.requestTimeout;
            gIOPConnection.storeCallLink(gIOPMessageContext.getRequestId(), callLink, l);
        }
        return gIOPMessageContext;
    }

    private void cleanUpForRequestTimeout(GIOPConnectionContext gIOPConnectionContext) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        Object[] objectArray = gIOPConnection.getCallLinkKeySet();
        for (int i = 0; i < objectArray.length; ++i) {
            CallLink callLink = gIOPConnection.clearCallLinkIfTimeout(objectArray[i]);
            if (callLink == null) continue;
            callLink.errorResponse(new IOException("Timeout waiting for reply to request " + gIOPConnection.getIdForKey(objectArray[i])));
        }
    }

    @Override
    public void routeIncomingReply(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        CallLink callLink = gIOPConnection.clearCallLink(gIOPMessageContext.getRequestId());
        callLink.processMessage(gIOPMessageContext);
        this.cleanUpForRequestTimeout(gIOPConnectionContext);
    }

    @Override
    public void routeErrorResponse(GIOPConnectionContext gIOPConnectionContext, int n, Exception exception) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        this.processExceptionInDataStore((GIOPConnection)gIOPConnectionContext, n, new IOException(exception.getMessage()));
        CallLink callLink = gIOPConnection.clearCallLink(n);
        if (callLink != null) {
            callLink.errorResponse(exception);
        }
    }

    @Override
    public void routeCloseConnection(GIOPConnectionContext gIOPConnectionContext, Exception exception) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        gIOPConnection.markCloseConnection(new IOException(exception.getMessage()));
        if (!gIOPConnection.isServer()) {
            Object[] objectArray = gIOPConnection.getCallLinkKeySet();
            for (int i = 0; i < objectArray.length; ++i) {
                CallLink callLink = gIOPConnection.clearCallLinkIfWaiting(objectArray[i]);
                if (callLink == null) continue;
                callLink.errorResponse(exception);
            }
        }
    }

    @Override
    public WsByteBuffer[] getNextFragment(GIOPConnectionContext gIOPConnectionContext, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        Object object = gIOPConnection.retrieveRequestData(n);
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object == null) {
            throw new MARSHAL("No more data available", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        FragmentQueue fragmentQueue = (FragmentQueue)object;
        WsByteBuffer[] wsByteBufferArray = fragmentQueue.getNextFragment();
        if (fragmentQueue.finished()) {
            gIOPConnection.clearRequestData(n);
        }
        return wsByteBufferArray;
    }

    @Override
    public void finishRequest(GIOPConnectionContext gIOPConnectionContext, int n) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        gIOPConnection.clearRequestData(n);
        gIOPConnection.clearCallLink(n);
    }

    @Override
    public boolean isBusy(GIOPConnectionContext gIOPConnectionContext) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        return !gIOPConnection.noCallLink() || !gIOPConnection.noRequestData();
    }

    @Override
    public GIOPReadSchedulingPolicy getGiopReadSchedulingPolicy() {
        return GIOPReadSchedulingPolicy.EARLY;
    }
}

