/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel;

import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.iiop.ORB;

public class ChannelTransportConnection
implements TransportConnection {
    private GIOPConnectionContext connCtx;
    private Object connData;
    private ORB orb;
    private boolean isGIOPChannel;
    private GIOPConnectionKey key = null;

    public ChannelTransportConnection(ORB oRB) {
        this.orb = oRB;
        this.isGIOPChannel = true;
    }

    public ChannelTransportConnection(ORB oRB, GIOPConnectionContext gIOPConnectionContext) {
        this.orb = oRB;
        this.connCtx = gIOPConnectionContext;
        this.isGIOPChannel = false;
    }

    public ChannelTransportConnection(ORB oRB, GIOPConnectionContext gIOPConnectionContext, GIOPConnectionKey gIOPConnectionKey) {
        this(oRB, gIOPConnectionContext);
        this.key = gIOPConnectionKey;
    }

    public void setConnectionContext(GIOPConnectionContext gIOPConnectionContext) {
        this.connCtx = gIOPConnectionContext;
    }

    @Override
    public void removeConnection() {
        if (this.isGIOPChannel) {
            ((GIOPConnection)this.connCtx).closeConnection(new Exception("CloseConnection requested from Connection"));
        }
    }

    @Override
    public String getConnectionParameterString() {
        return ((Object)this.connCtx).toString();
    }

    @Override
    public Object getConnectionData() {
        if (this.connData == null) {
            if (this.key == null) {
                String string = IIOPChannelPlugin.class.getName();
                IIOPChannelPlugin iIOPChannelPlugin = (IIOPChannelPlugin)this.orb.getPlugin(string);
                this.connData = iIOPChannelPlugin.getServerConnectionData(this.connCtx);
            } else {
                this.connData = this.key.getConnectionData();
            }
        }
        return this.connData;
    }

    @Override
    public void connect() {
        throw new UnsupportedOperationException("connect should not be called directly");
    }

    @Override
    public String getLocalHostName() {
        return this.connCtx.getLocalHostName();
    }

    @Override
    public String getLocalHost() {
        return this.connCtx.getLocalHost();
    }

    @Override
    public int getLocalPort() {
        return this.connCtx.getLocalPort();
    }

    @Override
    public String getRemoteHost() {
        return this.connCtx.getRemoteHost();
    }

    @Override
    public String getRemoteHostName() {
        return this.connCtx.getRemoteHostName();
    }

    @Override
    public int getRemotePort() {
        return this.connCtx.getRemotePort();
    }

    @Override
    public void preWrite(boolean bl) {
    }

    @Override
    public void preReply() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" - LocalHost=").append(this.getLocalHost());
        stringBuffer.append(", LocalPort=").append(this.getLocalPort());
        stringBuffer.append(", RemoteHost=").append(this.getRemoteHost());
        stringBuffer.append(", RemotePort=").append(this.getRemotePort());
        stringBuffer.append(", key=").append(this.key);
        return stringBuffer.toString();
    }
}

