/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.viewers;

import com.ibm.cic.licensing.policy.ui.Activator;
import com.ibm.cic.licensing.policy.ui.Messages;
import com.ibm.cic.licensing.policy.ui.dialogs.TableItemEditDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class EditableTableViewer
extends Viewer
implements ICellModifier {
    private static final String PATH_ICONS = "icons/";
    private static final String PATH_LCL = "icons/elcl16/";
    private final Control control;
    protected FontMetrics fontMetrics;
    protected TableViewer tableViewer;
    protected IFormAdapter formAdapter;
    private boolean enabled = true;
    private int lastSelectionIndex = -1;
    protected static final int ADD_BUTTON = 1;
    protected static final int REMOVE_BUTTON = 2;
    protected static final int EDIT_BUTTON = 4;
    protected static final int UP_BUTTON = 8;
    protected static final int DOWN_BUTTON = 16;
    protected static final int ALL_BUTTONS = 31;
    private final int buttonsMask;
    protected ToolItem addButton = null;
    protected ToolItem removeButton = null;
    protected ToolItem editButton = null;
    protected ToolItem upButton = null;
    protected ToolItem downButton = null;

    public EditableTableViewer(Composite parent, IFormAdapter formAdapter, int buttonsMask) {
        this.buttonsMask = buttonsMask;
        this.formAdapter = formAdapter == null ? new DefaultFormAdapter() : formAdapter;
        Font font = parent.getFont();
        GC gc = new GC((Drawable)parent);
        gc.setFont(font);
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.control = this.createControl(parent);
    }

    public EditableTableViewer(Composite parent, IFormAdapter formAdapter) {
        this(parent, formAdapter, 31);
    }

    public EditableTableViewer(Composite parent) {
        this(parent, null, 31);
    }

    public Control getControl() {
        return this.control;
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.tableViewer.setSelection(selection, reveal);
    }

    protected abstract Control createControl(Composite var1);

    protected abstract TableItemEditDialog createNewDialog();

    protected abstract TableItemEditDialog createEditDialog(String[] var1);

    protected abstract Object createNewData(String[] var1);

    protected abstract void setDataValues(Object var1, String[] var2);

    protected abstract void addData(int var1, Object var2);

    protected abstract void removeData(Object var1);

    protected void handleAdd() {
        Table table = this.tableViewer.getTable();
        TableItemEditDialog d = this.createNewDialog();
        int status = d.open();
        if (status != 0) {
            return;
        }
        String[] itemValues = d.getItemValues();
        Object newData = this.createNewData(itemValues);
        if (newData != null) {
            this.tableViewer.add(newData);
            this.tableViewer.setSelection((ISelection)new StructuredSelection(newData), true);
            table.notifyListeners(13, null);
        }
    }

    protected void handleEdit() {
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getSelection();
        if (items.length != 1) {
            return;
        }
        TableItem item = items[0];
        TableItemEditDialog d = this.createEditDialog(this.getText(table, item));
        int status = d.open();
        if (status != 0) {
            return;
        }
        String[] itemValues = d.getItemValues();
        Object itemData = item.getData();
        this.setDataValues(itemData, itemValues);
        this.tableViewer.update(itemData, null);
    }

    protected void handleRemove() {
        Table table = this.tableViewer.getTable();
        int[] indices = table.getSelectionIndices();
        if (indices.length == 1) {
            int index = indices[0];
            table.deselectAll();
            this.removeData(table.getItem(index).getData());
            table.remove(index);
            int count = table.getItemCount();
            if (index < count) {
                this.setSelectionAndNotify(index);
            } else if (count != 0) {
                this.setSelectionAndNotify(count - 1);
            } else {
                table.notifyListeners(13, null);
            }
        }
    }

    protected void handleUp() {
        Table table = this.tableViewer.getTable();
        int[] indices = table.getSelectionIndices();
        if (indices.length == 1) {
            int index = indices[0];
            TableItem item = table.getItem(index);
            Object data = item.getData();
            String[] text = this.getText(table, item);
            this.removeData(data);
            table.remove(index);
            item = new TableItem(table, 0, --index);
            this.addData(index, data);
            item.setData(data);
            item.setText(text);
            this.setSelectionAndNotify(index);
        }
    }

    protected void handleDown() {
        Table table = this.tableViewer.getTable();
        int[] indices = table.getSelectionIndices();
        if (indices.length == 1) {
            int index = indices[0];
            TableItem item = table.getItem(index);
            Object data = item.getData();
            String[] text = this.getText(table, item);
            this.removeData(data);
            table.remove(index);
            item = new TableItem(table, 0, ++index);
            this.addData(index, data);
            item.setData(data);
            item.setText(text);
            this.setSelectionAndNotify(index);
        }
    }

    protected String[] getText(Table table, TableItem item) {
        int count = table.getColumnCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = item.getText(i);
            ++i;
        }
        return result;
    }

    protected void createTable(Composite parent, String labelText, int heightHintInChars) {
        Font font = parent.getFont();
        Color background = parent.getBackground();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.formAdapter.getMarginPixels();
        layout.marginHeight = this.formAdapter.getMarginPixels();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)gridData);
        outerContainer.setFont(font);
        outerContainer.setBackground(background);
        Label label = new Label(outerContainer, 0);
        label.setText(labelText);
        label.setFont(font);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setBackground(background);
        this.createButtons(outerContainer);
        Table table = new Table(outerContainer, 68356);
        gridData = new GridData(1808);
        gridData.heightHint = this.fontMetrics.getHeight() * heightHintInChars;
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = EditableTableViewer.this.tableViewer.getTable().getSelectionIndices();
                int index = indices.length == 1 ? indices[0] : -1;
                EditableTableViewer.this.lastSelectionIndex = index;
                EditableTableViewer.this.updateButtons();
            }
        });
        this.formAdapter.paintBordersFor(outerContainer);
    }

    protected void initializeCellEditors() {
        Table table = this.tableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        String[] props = new String[columns.length];
        CellEditor[] cellEditors = new CellEditor[columns.length];
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            props[i] = column.getText();
            Object data = column.getData();
            cellEditors[i] = data != null ? (CellEditor)data : new TextCellEditor((Composite)table);
            ++i;
        }
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setColumnProperties(props);
        this.tableViewer.setCellModifier((ICellModifier)this);
    }

    protected boolean buttonRequired(int button) {
        return (this.buttonsMask & button) == button;
    }

    protected void createButtons(Composite outerContainer) {
        Color background = outerContainer.getBackground();
        ToolBar buttonBar = new ToolBar(outerContainer, 0x800100);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        buttonBar.setBackground(background);
        if (this.buttonRequired(1)) {
            this.addButton = this.createPushButton(buttonBar, Activator.getImageDescriptor("icons/elcl16/add.gif"), Messages.addButtonText, Messages.addButtonTooltip);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableViewer.this.handleAdd();
                }
            });
        }
        if (this.buttonRequired(2)) {
            this.removeButton = this.createPushButton(buttonBar, Activator.getImageDescriptor("icons/elcl16/remove.gif"), Messages.removeButtonText, Messages.removeButtonTooltip);
            this.removeButton.setEnabled(false);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableViewer.this.handleRemove();
                }
            });
        }
        if (this.buttonRequired(4)) {
            this.editButton = this.createPushButton(buttonBar, Activator.getImageDescriptor("icons/elcl16/edit.gif"), Messages.editButtonText, Messages.editButtonTooltip);
            this.editButton.setEnabled(false);
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableViewer.this.handleEdit();
                }
            });
        }
        if (this.buttonRequired(8)) {
            this.upButton = this.createPushButton(buttonBar, Activator.getImageDescriptor("icons/elcl16/up.gif"), Messages.upButtonText, Messages.upButtonTooltip);
            this.upButton.setEnabled(false);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableViewer.this.handleUp();
                }
            });
        }
        if (this.buttonRequired(16)) {
            this.downButton = this.createPushButton(buttonBar, Activator.getImageDescriptor("icons/elcl16/down.gif"), Messages.downButtonText, Messages.downButtonTooltip);
            this.downButton.setEnabled(false);
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableViewer.this.handleDown();
                }
            });
        }
    }

    protected void updateButtons() {
        Table table = this.tableViewer.getTable();
        int[] indices = table.getSelectionIndices();
        if (this.enabled && indices.length == 1) {
            int index = indices[0];
            this.setButtonEnabled(this.removeButton, true);
            this.setButtonEnabled(this.editButton, true);
            this.setButtonEnabled(this.upButton, index > 0);
            this.setButtonEnabled(this.downButton, index + 1 < table.getItemCount());
        } else {
            this.setButtonEnabled(this.removeButton, false);
            this.setButtonEnabled(this.editButton, false);
            this.setButtonEnabled(this.upButton, false);
            this.setButtonEnabled(this.downButton, false);
        }
    }

    protected ToolItem createPushButton(ToolBar parent, ImageDescriptor imageDesc, String label, String tooltip) {
        ToolItem button = new ToolItem(parent, 8 | this.formAdapter.getButtonStyle());
        button.setToolTipText(tooltip);
        if (imageDesc != null) {
            final Image image = imageDesc.createImage();
            if (image != null) {
                button.setImage(image);
                button.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        image.dispose();
                    }
                });
            } else {
                button.setText(label);
            }
        }
        return button;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.formAdapter.isPreferencePage()) {
            Table table = this.tableViewer.getTable();
            table.setEnabled(enabled);
            if (!enabled) {
                table.deselectAll();
            }
        }
        this.setButtonEnabled(this.addButton, enabled);
        this.updateButtons();
    }

    public boolean canModify(Object element, String property) {
        if (!this.enabled) {
            return false;
        }
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int index = indices.length == 1 ? indices[0] : -1;
        boolean result = this.lastSelectionIndex == index;
        this.lastSelectionIndex = index;
        return result;
    }

    private void setButtonEnabled(ToolItem button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    private void setSelectionAndNotify(int index) {
        Table table = this.tableViewer.getTable();
        table.setSelection(index);
        table.notifyListeners(13, null);
    }

    protected static abstract class AbstractTableLabelProvider
    implements ITableLabelProvider {
        protected AbstractTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static class DefaultFormAdapter
    implements IFormAdapter {
        public int getMarginPixels() {
            return 0;
        }

        public void paintBordersFor(Composite parent) {
        }

        public int getButtonStyle() {
            return 0;
        }

        public boolean isPreferencePage() {
            return true;
        }
    }

    public static interface IFormAdapter {
        public int getMarginPixels();

        public void paintBordersFor(Composite var1);

        public int getButtonStyle();

        public boolean isPreferencePage();
    }
}

