/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.dialogs;

import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.policy.ui.Messages;
import com.ibm.cic.licensing.policy.ui.dialogs.TableItemEditDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OfferingDialog
extends TableItemEditDialog {
    private String[] offeringIds;
    private LicensePolicyData.OfferingData[] offeringData;
    private Point dialogSize;

    public OfferingDialog(Shell parentShell, String title, String[] initialValues) {
        super(parentShell, title, new String[]{Messages.offeringIdLabelText, Messages.offeringVersionLabelText}, initialValues);
    }

    public OfferingDialog(Shell parentShell, String title, String[] initialValues, String[] offeringIds) {
        this(parentShell, title, initialValues);
        this.offeringIds = offeringIds;
    }

    public OfferingDialog(Shell parentShell, String title, LicensePolicyData.OfferingData[] offeringData) {
        super(parentShell, title, new String[]{Messages.nameLabelText, Messages.internalVersion, Messages.offeringIdLabelText}, null);
        this.offeringData = offeringData;
    }

    public OfferingDialog(Shell shell, String title, LicensePolicyData.OfferingData[] offeringData, Point dialogSize) {
        this(shell, title, offeringData);
        this.dialogSize = dialogSize;
    }

    public void create() {
        super.create();
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        }
    }

    private Control oldCreateItemControl(Composite parent, int itemIndex) {
        Combo combo;
        if (itemIndex == 0) {
            if (this.offeringIds == null) {
                return super.createItemControl(parent, itemIndex);
            }
            combo = new Combo(parent, 4);
            combo.setItems(this.offeringIds);
        } else {
            if (this.offeringIds == null) {
                return super.createItemControl(parent, itemIndex);
            }
            combo = new Combo(parent, 4);
        }
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(parent.getFont());
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OfferingDialog.this.validateInput();
            }
        });
        return combo;
    }

    private Control newCreateItemControl(Composite parent, int itemIndex) {
        if (itemIndex == 0) {
            Combo combo = new Combo(parent, 12);
            String[] names = new String[this.offeringData.length];
            int i = 0;
            while (i < this.offeringData.length) {
                names[i] = this.offeringData[i].getName();
                ++i;
            }
            combo.setItems(names);
            combo.setLayoutData((Object)new GridData(768));
            combo.setFont(parent.getFont());
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OfferingDialog.this.validateInput();
                }
            });
            return combo;
        }
        Control text = super.createItemControl(parent, itemIndex);
        text.setEnabled(false);
        return text;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        if (this.offeringData != null) {
            final Combo name = (Combo)this.itemControl[0];
            final Text version = (Text)this.itemControl[1];
            final Text id = (Text)this.itemControl[2];
            name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    int sIdx = name.getSelectionIndex();
                    if (sIdx != -1) {
                        version.setText(OfferingDialog.this.offeringData[sIdx].getVersion().toString());
                        id.setText(OfferingDialog.this.offeringData[sIdx].getId());
                    }
                }
            });
        }
        return control;
    }

    protected Control createItemControl(Composite parent, int itemIndex) {
        if (this.offeringData == null) {
            return this.oldCreateItemControl(parent, itemIndex);
        }
        return this.newCreateItemControl(parent, itemIndex);
    }

    protected String getItemControlText(int itemIndex) {
        if (!(this.itemControl[itemIndex] instanceof Combo)) {
            return super.getItemControlText(itemIndex);
        }
        Combo combo = (Combo)this.itemControl[itemIndex];
        return combo.getText();
    }
}

