/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.core;

import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.api.IPostSessionContext;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.api.PostSessionExtender;
import com.ibm.cic.common.core.model.IOffering;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RecordIMDetails
extends PostSessionExtender {
    private ILogger logger = IMLogger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());
    public static final String AGENT_INSTALL_LOCATION = "agent.install.location";
    public static final String ACCESS_RIGHTS = "accessRights";
    private static final String propertiesStr = "properties";
    private static final String installerStr = "installer";
    private static final String propertiesFile = "install.properties";
    private static final String iuMessagesFile = "iumessages.properties";
    private static final String omnibusID = "com.ibm.tivoli.omnibus.core";
    private Properties imProps = new Properties();

    public IStatus runPostInstall(IPostSessionContext context, IProgressMonitor monitor) {
        return this.doRunPostAction(context, monitor);
    }

    public IStatus runPostUninstall(IPostSessionContext context, IProgressMonitor monitor) {
        return this.doRunPostAction(context, monitor);
    }

    private IStatus doRunPostAction(IPostSessionContext context, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (context.getAgent().isSkipInstall()) {
            return status;
        }
        for (IAgentJob job : context.getJobs()) {
            IOffering offering = job.getOffering();
            if (offering == null || !offering.getIdentity().getId().startsWith(omnibusID) || !this.jobComplete(job)) continue;
            if (job.isInstall() || job.isModify() || job.isRollback() || job.isUpdate()) {
                this.populateIMProperties(context);
                this.writeIMInfoFile(context);
                continue;
            }
            if (!job.isUninstall()) continue;
            this.cleanUpIMInfoFile(context);
        }
        return status;
    }

    private void cleanUpIMInfoFile(IPostSessionContext context) {
        File installDir = new File(context.getProfile().getInstallLocation());
        File propertiesDir = new File(installDir, propertiesStr);
        File installerDir = new File(propertiesDir, installerStr);
        File imInfoFile = new File(installerDir, propertiesFile);
        File iumessage = new File(installerDir, iuMessagesFile);
        if (!iumessage.exists()) {
            Boolean deleted = true;
            if (imInfoFile.exists()) {
                deleted = imInfoFile.delete();
            }
            if (deleted.booleanValue() && (deleted = Boolean.valueOf(installerDir.delete())).booleanValue() && (deleted = Boolean.valueOf(propertiesDir.delete())).booleanValue()) {
                installDir.delete();
            }
        }
    }

    private boolean jobComplete(IAgentJob job) {
        IOffering jobOffering;
        if (job.isUninstall()) {
            return true;
        }
        IProfile profile = job.getAssociatedProfile();
        IOffering profileOffering = profile.findOffering((jobOffering = job.getOffering()).getIdentity().getId());
        return profileOffering != null && jobOffering.getVersion().equals((Object)profileOffering.getVersion());
    }

    private void populateIMProperties(IPostSessionContext context) {
        this.imProps.setProperty("USER", System.getProperty("user.name"));
        this.imProps.setProperty("IMHOME", context.getProfile().getData(AGENT_INSTALL_LOCATION));
        this.imProps.setProperty("IMDATA", context.getProfile().getData("cic.appDataLocation"));
        this.imProps.setProperty("IMMODE", context.getProfile().getData(ACCESS_RIGHTS));
        this.imProps.setProperty("NCHOME", context.getProfile().getInstallLocation());
    }

    private void writeIMInfoFile(IPostSessionContext context) {
        File installDir = new File(context.getProfile().getInstallLocation());
        File propertiesDir = new File(installDir, propertiesStr);
        File installerDir = new File(propertiesDir, installerStr);
        File imInfoFile = new File(installerDir, propertiesFile);
        String imMsg = "Automatically Generated: Installation Manager information";
        try {
            if (!installerDir.exists()) {
                installerDir.mkdirs();
            }
            FileOutputStream imOutStream = new FileOutputStream(imInfoFile);
            this.imProps.store(imOutStream, imMsg);
            imOutStream.flush();
            imOutStream.close();
        }
        catch (Exception e) {
            this.logger.info("Unable to write to file " + imInfoFile.toString() + "\nException caught: " + e.getMessage());
        }
    }
}

