/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import org.osgi.framework.Bundle;

public class SigVerifier {
    private static final char[] hexSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String publicKey = "30819F300D06092A864886F70D010101050003818D0030818902818100B24A9B5BBA01C0CD650963700B5A1B9208F8555E7C1B5017EC444C58422B410959F2E15D43714D92031DB66C7F5D48CD17ECD74C39B17BE2BF9677BED0A0F02D6B24AA14BA8279109B1668478154A2FA919E0A2A53A6E79E7D2933D805FC023FBDC76EEDAA306C5F52ED35654B0EC8A712105637AF11FA210E99FFFA8C658E6D0203010001";

    public static String byteArrayToHexString(byte[] input) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length) {
            sb.append(SigVerifier.byteToHex(input[i]));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String input) {
        if (input.length() % 2 != 0) {
            return null;
        }
        byte[] result = new byte[input.length() / 2];
        int i = 0;
        while (i * 2 < input.length()) {
            String currStr = input.substring(i * 2, i * 2 + 2);
            result[i] = SigVerifier.hexToByte(currStr);
            ++i;
        }
        return result;
    }

    public static String byteToHex(byte b) {
        int lowerByte = b & 0xF;
        int upperByte = b >> 4 & 0xF;
        char[] result = new char[]{hexSet[upperByte], hexSet[lowerByte]};
        return new String(result);
    }

    public static byte hexToByte(String str) {
        int result = 0;
        if (str.length() != 2) {
            throw new NumberFormatException("String not in right format: " + str);
        }
        result = Integer.parseInt(str, 16);
        return (byte)result;
    }

    public static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length()];
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            result[i] = (byte)c;
            ++i;
        }
        return result;
    }

    public static String byteArrayToString(byte[] barray) {
        return new String(barray);
    }

    public static boolean isCfgFileValid(Bundle bundle, String fileName, String digest) {
        byte[] publicKeyByteArray = SigVerifier.hexStringToByteArray(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyByteArray);
        InputStream fin = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey key = keyFactory.generatePublic(x509KeySpec);
            Signature sig_verify = Signature.getInstance("MD5withRSA");
            sig_verify.initVerify(key);
            URL url = bundle.getResource(fileName);
            fin = url.openStream();
            byte[] buf = new byte[8192];
            int size = 0;
            while ((size = fin.read(buf)) != -1) {
                sig_verify.update(buf, 0, size);
            }
            byte[] signature = SigVerifier.hexStringToByteArray(digest);
            boolean bl = sig_verify.verify(signature);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

