/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.PPLicUserUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Timer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class LicUserUtils {
    private static boolean isRunningHeadless = true;
    private static Timer timer;
    private static boolean uiActive;
    public static final String AGENT_APPDATA_LOCATION_KEY = "cic.appDataLocation";
    protected static final String ALLUSERS = "All Users";
    protected static final String LUM = "LUM";
    protected static final String NODELOCK = "nodelock";
    protected static final String POLICY_FILE = "license.opt";
    public static final String LICENSE = "license";
    public static final String FLEXLM_TS_FILE_NAME = "flexuse.ts";
    public static final String SDPLIC_COOKIE_FILE_NAME = ".sdplic";

    static {
        uiActive = false;
    }

    private static IPath getAllUserLicenseLocation() {
        return PPLicUserUtils.getPolicy().getAllUserProductLocation().append(LICENSE);
    }

    private static IPath getRuntimeAgentAppDataLicenseLocation() {
        String agentDataLocation = System.getProperty(AGENT_APPDATA_LOCATION_KEY);
        if (agentDataLocation != null && agentDataLocation.length() > 0) {
            if (agentDataLocation.startsWith("file:")) {
                agentDataLocation = agentDataLocation.substring("file:".length());
            }
            return new Path(agentDataLocation).append(LICENSE);
        }
        if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.logNtrace(4, "cic.appDataLocation is not defined in config.ini.");
        }
        return LicUserUtils.getRuntimeLicenseLocationFromCookie(LicUserUtils.getCommunicationChannelLocation().append(SDPLIC_COOKIE_FILE_NAME));
    }

    private static IPath getRuntimeLicenseLocationFromCookie(IPath path) {
        Properties prop = LicUserUtils.loadProperties(path.toFile().getAbsolutePath());
        String licdatapath = prop.getProperty(AGENT_APPDATA_LOCATION_KEY);
        if (licdatapath != null) {
            return new Path(licdatapath);
        }
        return LicUserUtils.getAllUserLicenseLocation();
    }

    public static IPath getRuntimeLicenseLocation() {
        return LicUserUtils.getRuntimeAgentAppDataLicenseLocation();
    }

    public static IPath getRuntimeLumNodeLockFile() {
        return LicUserUtils.getRuntimeLicenseLocation().append(LUM).append(NODELOCK);
    }

    public static IPath getRuntimeLicensePolicyFile() {
        return LicUserUtils.getRuntimeLicenseLocation().append(POLICY_FILE);
    }

    public static IPath getRuntimeFlexlmTSFile() {
        return PPLicUserUtils.getPolicy().getUserLicenseLocation().append(FLEXLM_TS_FILE_NAME);
    }

    public static IPath getRuntimeFlexlmTSParentDir() {
        return new Path(LicUserUtils.getRuntimeFlexlmTSFile().toFile().getParent());
    }

    public static String getPluginID(Plugin aPlugin, String defaultStr) {
        String value = defaultStr;
        if (aPlugin != null && aPlugin.getBundle() != null) {
            value = aPlugin.getBundle().getSymbolicName();
        } else if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.trace("getPluginID returned default string " + defaultStr);
        }
        return value;
    }

    public static String getPluginName(Plugin aPlugin, String defaultStr) {
        String value = defaultStr;
        if (aPlugin != null) {
            Bundle bundle = aPlugin.getBundle();
            if (bundle != null) {
                String bsn = bundle.getSymbolicName();
                value = bundle.getHeaders(Platform.getNL()) != null ? String.valueOf((String)bundle.getHeaders(Platform.getNL()).get("Bundle-Name")) + " (" + bsn + ")" : bsn;
            }
        } else if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.trace("getPluginName returned default string " + defaultStr);
        }
        return value;
    }

    public static boolean isUiActive() {
        return uiActive;
    }

    public static void setUiActive(boolean uiActive) {
        LicUserUtils.uiActive = uiActive;
    }

    public static boolean isRunningHeadless() {
        return isRunningHeadless;
    }

    public static void setRunningHeadless(boolean isHeadless) {
        isRunningHeadless = isHeadless;
    }

    public static Timer getTimer() {
        if (timer == null) {
            timer = new Timer(true);
        }
        return timer;
    }

    public static Properties loadProperties(String filename) {
        Properties prop;
        block14: {
            prop = new Properties();
            if (new File(filename).exists()) {
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(filename);
                        prop.load(stream);
                    }
                    catch (IOException ioe) {
                        if (Logger.isTracing(Logger.DEBUG_EXCEPTIONS)) {
                            Logger.logNtrace(ioe.getMessage(), ioe);
                        }
                        if (stream == null) break block14;
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return prop;
    }

    public static boolean storeProperties(String filename, String key, String value) {
        Properties prop = LicUserUtils.loadProperties(filename);
        prop.setProperty(key, value);
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(filename);
                prop.store(stream, null);
            }
            catch (IOException ioe) {
                if (Logger.isTracing(Logger.DEBUG_EXCEPTIONS)) {
                    Logger.logNtrace(ioe.getMessage(), ioe);
                }
                if (stream != null) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static IPath getCommunicationChannelLocation() {
        return PPLicUserUtils.getPolicy().getCommChannelDir();
    }

    public static IPath getInstallTimeLumNodeLockFile(IPath agentDataLicensePath) {
        return agentDataLicensePath.append(LUM).append(NODELOCK);
    }

    public static IPath getInstallTimeLicensePolicyFile(IPath agentDataLicensePath) {
        return agentDataLicensePath.append(POLICY_FILE);
    }

    public static Version getMajorMinorMicroVersion(Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    public static Version getMajorMinorVersion(Version version) {
        return new Version(version.getMajor(), version.getMinor(), 0);
    }
}

