/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import java.io.DataOutput;
import java.io.IOException;

public abstract class PortableHeapDumpRecord {
    public static final byte ONE_BYTE_REF = 0;
    public static final byte TWO_BYTE_REF = 1;
    public static final byte FOUR_BYTE_REF = 2;
    public static final byte EIGHT_BYTE_REF = 3;
    public static final int ADDRESS_SHIFT_SIZE = 2;
    protected final long _baseAddress;
    protected final ReferenceIterator _references;
    protected final byte _referenceFieldSize;
    protected final long _gapPreceding;
    protected final byte _gapSize;
    protected int _numberOfReferences;

    protected PortableHeapDumpRecord(long address, long previousAddress, ReferenceIterator references) {
        this._baseAddress = address;
        if (references != null) {
            this._references = this.getDifferenceReferences(references, address);
            this._referenceFieldSize = this.calculateReferenceFieldSize(references);
        } else {
            this._references = null;
            this._referenceFieldSize = 0;
        }
        this._gapPreceding = PortableHeapDumpRecord.getAddressDifference(address, previousAddress);
        this._gapSize = PortableHeapDumpRecord.sizeofReference(this._gapPreceding);
    }

    private byte calculateReferenceFieldSize(ReferenceIterator references) {
        byte toReturn = 0;
        references.reset();
        this._numberOfReferences = 0;
        while (references.hasNext()) {
            Long thisRef = references.next();
            byte thisSize = PortableHeapDumpRecord.sizeofReference(thisRef);
            if (thisSize > toReturn) {
                toReturn = thisSize;
            }
            ++this._numberOfReferences;
        }
        return toReturn;
    }

    protected static byte sizeofReference(long reference) {
        if (reference > Integer.MAX_VALUE || reference < Integer.MIN_VALUE) {
            return 3;
        }
        if (reference > 32767L || reference < -32768L) {
            return 2;
        }
        if (reference > 127L || reference < -128L) {
            return 1;
        }
        return 0;
    }

    protected ReferenceIterator getDifferenceReferences(final ReferenceIterator input, final long base) {
        return new ReferenceIterator(){

            public boolean hasNext() {
                return input.hasNext();
            }

            public Long next() {
                Long toConvert = input.next();
                if (toConvert == null) {
                    return null;
                }
                return new Long(PortableHeapDumpRecord.getAddressDifference(toConvert, base));
            }

            public void reset() {
                input.reset();
            }
        };
    }

    protected static long getAddressDifference(long address, long base) {
        return address - base >> 2;
    }

    protected final void writeReferences(DataOutput out) throws IOException {
        this._references.reset();
        if (!this._references.hasNext()) {
            return;
        }
        switch (this._referenceFieldSize) {
            case 0: {
                while (this._references.hasNext()) {
                    Long thisRef = this._references.next();
                    out.writeByte(thisRef.byteValue());
                }
                break;
            }
            case 1: {
                while (this._references.hasNext()) {
                    Long thisRef = this._references.next();
                    out.writeShort(thisRef.shortValue());
                }
                break;
            }
            case 2: {
                while (this._references.hasNext()) {
                    Long thisRef = this._references.next();
                    out.writeInt(thisRef.intValue());
                }
                break;
            }
            case 3: {
                while (this._references.hasNext()) {
                    Long thisRef = this._references.next();
                    out.writeLong(thisRef);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Error size byte invalid");
            }
        }
    }

    protected void writeReference(DataOutput dos, byte size, long reference) throws IOException {
        switch (size) {
            case 0: {
                dos.writeByte((byte)reference);
                break;
            }
            case 1: {
                dos.writeShort((short)reference);
                break;
            }
            case 2: {
                dos.writeInt((int)reference);
                break;
            }
            case 3: {
                dos.writeLong(reference);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong size argument!");
            }
        }
    }

    protected abstract void writeHeapDump(DataOutput var1) throws IOException;
}

