/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.jvm.dtfjview.CombinedContext;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.ISessionContextManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdmpviewContextManager
implements ISessionContextManager {
    private Map<URI, ArrayList<ICombinedContext>> contextTracker = new LinkedHashMap<URI, ArrayList<ICombinedContext>>();
    private int maxContextID = 0;
    private boolean hasChanged = false;

    public ICombinedContext createContext(Image image, int major, int minor, ImageAddressSpace space, ImageProcess proc, JavaRuntime rt) {
        ArrayList<ICombinedContext> existingContexts = this.contextTracker.get(image.getSource());
        CombinedContext combinedctx = new CombinedContext(major, minor, image, space, proc, rt, this.maxContextID);
        combinedctx.refresh();
        ++this.maxContextID;
        if (existingContexts == null) {
            existingContexts = new ArrayList();
            this.contextTracker.put(image.getSource(), existingContexts);
        }
        existingContexts.add(combinedctx);
        this.hasChanged = true;
        return combinedctx;
    }

    @Override
    public void removeContexts(Image image) {
        this.removeContexts(image.getSource());
    }

    @Override
    public void removeContexts(URI source) {
        if (this.contextTracker.containsKey(source)) {
            for (ICombinedContext context : this.contextTracker.get(source)) {
                context.getImage().close();
            }
            this.contextTracker.remove(source);
            this.hasChanged = true;
        }
    }

    @Override
    public void removeAllContexts() {
        ArrayList<URI> sources = new ArrayList<URI>();
        for (URI source : this.contextTracker.keySet()) {
            sources.add(source);
        }
        for (URI source : sources) {
            this.removeContexts(source);
        }
    }

    @Override
    public Map<URI, ArrayList<ICombinedContext>> getContexts() {
        return Collections.unmodifiableMap(this.contextTracker);
    }

    @Override
    public boolean hasMultipleContexts() {
        switch (this.contextTracker.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return this.contextTracker.values().size() > 1;
            }
        }
        return true;
    }

    @Override
    public ICombinedContext getContext(int id) {
        if (id < 0 || id > this.maxContextID) {
            return null;
        }
        for (ArrayList<ICombinedContext> contexts : this.contextTracker.values()) {
            for (ICombinedContext context : contexts) {
                if (context.getID() != id) continue;
                return context;
            }
        }
        return null;
    }

    @Override
    public boolean hasChanged() {
        boolean value = this.hasChanged;
        this.hasChanged = false;
        return value;
    }
}

