/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class SendMessage
implements NTLMConstants {
    protected static final Logger log = CustomNTLM.log;

    protected static int writeData(byte[] buf, int offsetPtr, int pos, byte[] data) {
        SendMessage.writeInt(buf, offsetPtr, pos);
        int i = 0;
        while (i < data.length) {
            buf[pos + i] = data[i];
            ++i;
        }
        return pos + data.length;
    }

    protected static int writeInt(byte[] buf, int offsetPtr, int pos) {
        return BitUtil.toLittleEndian(buf, offsetPtr, pos);
    }

    protected static int field(ByteArrayOutputStream bs, int len) {
        SendMessage.writeShort(bs, len);
        SendMessage.writeShort(bs, len);
        int offsetPtr = bs.size();
        SendMessage.fill(bs, 4);
        return offsetPtr;
    }

    protected static void writeShort(ByteArrayOutputStream bs, int s) {
        bs.write(s & 0xFF);
        bs.write((s & 0xFF00) >>> 8);
    }

    protected static void writeInt(ByteArrayOutputStream bs, int i) throws IOException {
        byte[] bytes = BitUtil.toLittleEndian(i);
        bs.write(bytes);
    }

    protected static void fill(ByteArrayOutputStream bs, int n) {
        int i = 0;
        while (i < n) {
            bs.write(0);
            ++i;
        }
    }
}

