/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.ChallengeMessage;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class NTLMCrypto {
    private static final String HMAC_M_D5 = "HmacMD5";
    public static final IClientNonceProvider defaultClientNonceProvider;
    private static IClientNonceProvider clientNonceProvider;
    public static final IWindowsTimeProvider defaultTimeProvider;
    private static IWindowsTimeProvider timeProvider;

    static {
        clientNonceProvider = defaultClientNonceProvider = new IClientNonceProvider(){

            @Override
            public byte[] nonce(ChallengeMessage challenge) throws Exception {
                byte[] bytes = challenge.getBytes();
                ByteArrayOutputStream bs = new ByteArrayOutputStream(bytes.length + 20);
                bs.write(bytes);
                int serverRandom = BitUtil.LEtoInt(challenge.getChallenge(), 2);
                long random = System.currentTimeMillis() - (long)serverRandom;
                byte[] brandom = BitUtil.toLittleEndian(random);
                bs.write(brandom);
                byte[] bytes2 = bs.toByteArray();
                DigestValue dv = ContentInfoComputation.computeDigest((String)"md5", (byte[])bytes2);
                return BitUtil.subArray(dv.getDigestBytesCopy(), 0, 8);
            }
        };
        timeProvider = defaultTimeProvider = new IWindowsTimeProvider(){

            @Override
            public byte[] time() {
                long t = this.currenttime();
                byte[] buf = new byte[8];
                int pos = 0;
                pos = BitUtil.toLittleEndian(buf, pos, (int)t);
                pos = BitUtil.toLittleEndian(buf, pos, (int)t);
                if (!$assertionsDisabled && pos != 8) {
                    throw new AssertionError();
                }
                return buf;
            }

            private long currenttime() {
                long ms = System.currentTimeMillis();
                long _100ns = ms * 1000L * 10L;
                long _100nsDeltaFileTimeToJavaTime = 116444736000000000L;
                return _100ns + _100nsDeltaFileTimeToJavaTime;
            }
        };
    }

    public static IClientNonceProvider getClientNonceProvider() {
        return clientNonceProvider;
    }

    public static void setClientNonceProvider(IClientNonceProvider clientNonceProvider) {
        NTLMCrypto.clientNonceProvider = clientNonceProvider;
    }

    public static IWindowsTimeProvider getWindowsTimeProvider() {
        return timeProvider;
    }

    public static void setWindowsTimeProvider(IWindowsTimeProvider timeProvider) {
        NTLMCrypto.timeProvider = timeProvider;
    }

    public static byte[] currenttime() {
        return NTLMCrypto.getWindowsTimeProvider().time();
    }

    public static byte[] DES(byte[] k, byte[] d) throws GeneralSecurityException {
        Cipher ecipher = Cipher.getInstance("DES/ECB/NoPadding");
        k = NTLMCrypto.setupKey(k);
        ecipher.init(1, new SecretKeySpec(k, "DES"));
        return ecipher.doFinal(d);
    }

    public static byte[] DESL(byte[] k, byte[] d) throws GeneralSecurityException {
        byte[] k0_6 = BitUtil.subArray(k, 0, 7);
        byte[] k7_13 = BitUtil.subArray(k, 7, 14);
        byte[] k14_15 = BitUtil.subArray(k, 14, 16);
        byte[] k14_15Z = BitUtil.extendArray(k14_15, 5);
        byte[] b1 = NTLMCrypto.DES(k0_6, d);
        byte[] b2 = NTLMCrypto.DES(k7_13, d);
        byte[] b3 = NTLMCrypto.DES(k14_15Z, d);
        return BitUtil.concat(new byte[][]{b1, b2, b3});
    }

    private static byte[] setupKey(byte[] key56) {
        byte[] key64 = new byte[]{(byte)(key56[0] & 0xFE), (byte)((key56[0] & 1) << 7 | NTLMCrypto.u(key56[1]) >> 1 & 0xFE), (byte)((key56[1] & 3) << 6 | NTLMCrypto.u(key56[2]) >> 2 & 0xFE), (byte)((key56[2] & 7) << 5 | NTLMCrypto.u(key56[3]) >> 3 & 0xFE), (byte)((key56[3] & 0xF) << 4 | NTLMCrypto.u(key56[4]) >> 4 & 0xFE), (byte)((key56[4] & 0x1F) << 3 | NTLMCrypto.u(key56[5]) >> 5 & 0xFE), (byte)((key56[5] & 0x3F) << 2 | NTLMCrypto.u(key56[6]) >> 6 & 0xFE), (byte)((key56[6] & 0x7F) << 1)};
        return key64;
    }

    private static int u(byte b) {
        return b & 0xFF;
    }

    private static byte[] leUnicode16(String password) throws UnsupportedEncodingException {
        byte[] bytes = password.getBytes("UTF-16LE");
        return bytes;
    }

    public static byte[] NTOWFv1(String password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] upassword = NTLMCrypto.leUnicode16(password);
        return NTLMCrypto.MD4(upassword);
    }

    private static byte[] MD4(byte[] d) throws NoSuchAlgorithmException {
        MessageDigest algorithm = MessageDigest.getInstance("MD4");
        algorithm.reset();
        algorithm.update(d);
        byte[] md4Bytes = algorithm.digest();
        return md4Bytes;
    }

    public static byte[] MD5(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest algorithm = MessageDigest.getInstance("MD5");
        algorithm.reset();
        algorithm.update(bytes);
        byte[] md5Bytes = algorithm.digest();
        return md5Bytes;
    }

    public static byte[] HMAC_MD5(byte[] K, byte[] M) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(HMAC_M_D5);
        mac.init(new SecretKeySpec(K, HMAC_M_D5));
        byte[] result = mac.doFinal(M);
        return result;
    }

    public static byte[] NTOWFv2(String password, String username, String domain) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        return NTLMCrypto.HMAC_MD5(NTLMCrypto.MD4(NTLMCrypto.leUnicode16(password)), BitUtil.concat(new byte[][]{NTLMCrypto.leUnicode16(username.toUpperCase()), NTLMCrypto.leUnicode16(domain)}));
    }

    public static byte[] v2LmChallengeResponse(byte[] responseKeyLM, byte[] serverChallenge, byte[] clientChallenge) throws InvalidKeyException, NoSuchAlgorithmException {
        return BitUtil.concat(new byte[][]{NTLMCrypto.HMAC_MD5(responseKeyLM, BitUtil.concat(new byte[][]{serverChallenge, clientChallenge})), clientChallenge});
    }

    public static byte[] v2NtChallengeResponse(byte[] responseKeyNT, byte[] time, byte[] targetInfo, byte[] serverChallenge, byte[] clientChallenge) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        assert (time.length == 8);
        assert (serverChallenge.length == 8);
        assert (clientChallenge.length == 8);
        byte[] temp = BitUtil.concat(new byte[][]{{1, 1}, new byte[6], time, clientChallenge, new byte[4], targetInfo, new byte[4]});
        byte[] NTProofStr = NTLMCrypto.HMAC_MD5(responseKeyNT, BitUtil.concat(new byte[][]{serverChallenge, temp}));
        return BitUtil.concat(new byte[][]{NTProofStr, temp});
    }

    public static interface IClientNonceProvider {
        public byte[] nonce(ChallengeMessage var1) throws Exception;
    }

    public static interface IWindowsTimeProvider {
        public byte[] time();
    }
}

