/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.eclipse.core.runtime.Plugin;

public class HttpClientEvents {
    private final ArrayList listeners;
    private static final Logger log = Logger.getLogger(HttpClientEvents.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final HttpClientEvents INSTANCE = new HttpClientEvents();
    public static final HttpClientListener FIRE = HttpClientEvents.INSTANCE.MY_FIRE;
    private final FireEvents MY_FIRE = new FireEvents();

    public static String toStringWithId(HttpMethod method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append(' ');
        try {
            sb.append(method.getURI());
        }
        catch (URIException uRIException) {
            sb.append("unknown URI");
        }
        sb.append(':');
        sb.append(method.getStatusLine());
        return sb.toString();
    }

    private HttpClientEvents() {
        this.listeners = new ArrayList(10);
    }

    public synchronized void addListener(HttpClientListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(HttpClientListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized HttpClientListener[] getListeners() {
        return this.listeners.toArray(new HttpClientListener[this.listeners.size()]);
    }

    class FireEvents
    extends HttpClientListener {
        FireEvents() {
        }

        @Override
        public void onEvent(HttpClientEvent event) {
            HttpClientListener[] aListeners;
            log.debug((Object)event);
            HttpClientListener[] httpClientListenerArray = aListeners = HttpClientEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                HttpClientListener listener = httpClientListenerArray[n2];
                try {
                    listener.onEvent(event);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }
    }

    public static abstract class HttpClientEvent {
        private final HttpMethod method;

        protected HttpClientEvent(HttpMethod method) {
            this.method = method;
        }

        public HttpMethod getMethod() {
            return this.method;
        }
    }

    public static abstract class HttpClientListener {
        public void onEvent(HttpClientEvent event) {
        }
    }

    public static class UnauthorizedEvent
    extends HttpClientEvent {
        public UnauthorizedEvent(HttpMethod method) {
            super(method);
        }

        public String toString() {
            return "UnauthorizedEvent " + HttpClientEvents.toStringWithId(this.getMethod());
        }
    }
}

