/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient;

import com.ibm.cic.common.core.internal.downloads.NullHasIsCanceledMonitor;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.AbstractHostInfo;
import com.ibm.cic.common.downloads.ByteRange;
import com.ibm.cic.common.downloads.ByteRangeMonitorInputStream;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.CredentialStore;
import com.ibm.cic.common.downloads.DownloadByteRangeOutOfBoundsException;
import com.ibm.cic.common.downloads.DownloadCanceledException;
import com.ibm.cic.common.downloads.DownloadEvents;
import com.ibm.cic.common.downloads.DownloadException;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadHandlerDefaultRetryLevel;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.DownloadProperties;
import com.ibm.cic.common.downloads.DownloadProtocolException;
import com.ibm.cic.common.downloads.DownloadRangeNotSatisfiableException;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.DownloadStatusException;
import com.ibm.cic.common.downloads.HostInfo;
import com.ibm.cic.common.downloads.HttpRangeUtil;
import com.ibm.cic.common.downloads.HttpUserAgent;
import com.ibm.cic.common.downloads.ICanOpenStream;
import com.ibm.cic.common.downloads.ICanOpenStreamAtRange;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.downloads.IDownloadStream;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.NonsecureConnectionManager;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.downloads.ProgressInputStream;
import com.ibm.cic.common.downloads.ProxyInfo;
import com.ibm.cic.common.downloads.ProxySupport;
import com.ibm.cic.common.downloads.RequestStatus;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.downloads.handlerImpl.AuthenticationContext;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHooks;
import com.ibm.cic.common.downloads.handlerImpl.DownloadStream;
import com.ibm.cic.common.downloads.handlerImpl.RequestRetryHandler;
import com.ibm.cic.common.downloads.messages.IProtocolHeader;
import com.ibm.cic.common.downloads.messages.IProtocolMessage;
import com.ibm.cic.common.downloads.messages.IProtocolMessageNormalizer;
import com.ibm.cic.common.downloads.messages.SimpleProtocolMessage;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.EventFiringProtocolSocketFactory;
import com.ibm.cic.common.transports.httpclient.EventFiringSSLProtocolSocketFactory;
import com.ibm.cic.common.transports.httpclient.HttpClientEvents;
import com.ibm.cic.common.transports.httpclient.HttpClientLogging;
import com.ibm.cic.common.transports.httpclient.HttpClientStatusBasedRetryCode;
import com.ibm.cic.common.transports.httpclient.HttpCredentialsProvider;
import com.ibm.cic.common.transports.httpclient.Messages;
import com.ibm.cic.common.transports.httpclient.MethodMessageHelper;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.CircularRedirectException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.DateUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class HttpClientDownloadHandler
extends DownloadHandler
implements ICanOpenStream,
ICanOpenStreamAtRange,
IProtocolMessageNormalizer {
    private static final String XML = "xml";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String PROTOCOL_HTTP = "http";
    private static final String LOCALE = Locale.getDefault().toString();
    public static final String RANGE = "Range";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String GZIP = "gzip";
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final String LOCATION_RESPONSE_HEADER = "Location";
    private static HttpClient fHttpClient = null;
    private static final ProxySupport proxySupport;
    private static final String SOCKS_SERVER_GENERAL_FAILURE = "socks server general failure";
    private static final String RESET_CONNECTION = "reset";
    private static final String SOFTWARE_CONNECTION_ABORT = "software caused connection abort";
    private static final String UNRECOGNIZED_WINDOWS_SOCKET_ERROR = "unrecognized windows sockets error";
    private static final String SYSTEM_CALL_INVALID_PARAMETER = "a system call received a parameter that is not valid";
    private static final String POSSIBLE_INVALID_ADDRESS = "connect:could be due to invalid address";
    public static final int RETRY_ALWAYS = 1;
    public static final int RETRY_NEVER = 2;
    public static final int RETRY_NORMAL = 3;
    private static final String REPOSITORY_XML = "repository.xml";
    private static final String CIC = "cic";

    static {
        HttpClientDownloadHandler.initLogging();
        Protocol.registerProtocol((String)PROTOCOL_HTTP, (Protocol)new Protocol(PROTOCOL_HTTP, (ProtocolSocketFactory)new EventFiringProtocolSocketFactory(), 80));
        Protocol.registerProtocol((String)PROTOCOL_HTTPS, (Protocol)new Protocol(PROTOCOL_HTTPS, (ProtocolSocketFactory)new EventFiringSSLProtocolSocketFactory(), 443));
        final MultiThreadedHttpConnectionManager cm = new MultiThreadedHttpConnectionManager();
        fHttpClient = new HttpClient((HttpConnectionManager)cm);
        fHttpClient.getParams().setParameter("http.authentication.credential-provider", (Object)HttpCredentialsProvider.INSTANCE);
        fHttpClient.getParams().setConnectionManagerTimeout((long)(PreferencesHolder.INSTANCE.getConnectTimeout() * 1000));
        fHttpClient.getHttpConnectionManager().getParams().setConnectionTimeout(PreferencesHolder.INSTANCE.getConnectTimeout() * 1000);
        fHttpClient.getParams().setSoTimeout(PreferencesHolder.INSTANCE.getReadTimeout() * 1000);
        CustomNTLM.init(fHttpClient, false);
        boolean disablePreemptiveAuth = UserOptions.CIC_HTTP_DISABLE_PREEMPTIVATE_AUTHENTICATION.isSet();
        if (disablePreemptiveAuth |= PreferencesHolder.INSTANCE.isHttpPreemptiveAuthenticationDisabled()) {
            fHttpClient.getParams().setAuthenticationPreemptive(false);
            DownloadHandler.dlTrace.getLog().info(Messages.HttpClientDownloadHandler_disablingPreemptiveAuthenticationAsConfigured);
        } else {
            fHttpClient.getParams().setAuthenticationPreemptive(true);
        }
        cm.getParams().setTcpNoDelay(true);
        cm.getParams().setStaleCheckingEnabled(false);
        int threads = UserOptions.getAddThreads();
        HttpConnectionManagerParams params = cm.getParams();
        if (threads > 0) {
            UserOptions.CIC_REPO_ADD_THREADS.set(threads);
            params.setDefaultMaxConnectionsPerHost(threads);
            int maxTotalConnections = Math.max(threads, 20);
            params.setMaxTotalConnections(maxTotalConnections);
        }
        CredentialStore.INSTANCE.addCredentialStoreListener(new CredentialStore.ICredentialStoreListener(){

            public void clearCachedCredentials() {
                fHttpClient.getState().clearCredentials();
                fHttpClient.getState().clearProxyCredentials();
                fHttpClient.getState().clearCookies();
            }

            public boolean isAnyCredentialSaved() {
                AuthScope authScope = new AuthScope(AuthScope.ANY);
                return fHttpClient.getState().getCredentials(authScope) != null || fHttpClient.getState().getProxyCredentials(authScope) != null;
            }
        });
        NonsecureConnectionManager.INSTANCE.addListener(new NonsecureConnectionManager.IDropConnectionsListener(){

            public void dropConnections() {
                cm.closeIdleConnections(0L);
            }
        });
        proxySupport = new ProxySupport(true, true, true);
    }

    public static HttpClient getHttpClient() {
        return fHttpClient;
    }

    public ProxySupport getProxySupport() {
        return proxySupport;
    }

    private boolean enableGzipAcceptEncodingOption() {
        return UserOptions.CIC_ENABLE_GZIP_HTTP_REQUEST_HEADER.isSet() | PreferencesHolder.INSTANCE.isGzipAcceptEncodingEnabled();
    }

    protected static void initLogging() {
        HttpClientLogging.init();
    }

    private AuthenticationContext getAuthenticationContext(HttpHost httpHost) {
        String protoScheme = httpHost.getProtocol().getScheme();
        ProxyInfo pi = PreferencesHolder.INSTANCE.getProxyInfo(protoScheme);
        AuthenticationContext.CompositeAuthContext cac = new AuthenticationContext.CompositeAuthContext();
        cac.add((AuthenticationContext)new HttpClientAuthContext().init(fHttpClient, httpHost));
        if (pi.isNoProxy() || pi.getHost().length() == 0) {
            cac.add((AuthenticationContext)new NoHttpClientProxy().init(fHttpClient));
            AuthenticationContext.NoSocksProxy.INSTANCE.init();
        } else if (pi.useSocks()) {
            cac.add((AuthenticationContext)new AuthenticationContext.SocksAuthenticationContext().init(pi));
            cac.add((AuthenticationContext)new NoHttpClientProxy().init(fHttpClient));
        } else {
            cac.add((AuthenticationContext)new HttpClientProxyAuthContext().init(fHttpClient, pi));
            AuthenticationContext.NoSocksProxy.INSTANCE.init();
        }
        return cac;
    }

    private static int retrySocketException(boolean assumeNetworkNotReconnected, SocketException exception) {
        if (assumeNetworkNotReconnected ? exception instanceof NoRouteToHostException || exception instanceof PortUnreachableException || exception instanceof ConnectException : exception instanceof ConnectException) {
            return 2;
        }
        String msg = exception.getMessage().toLowerCase();
        if (msg.indexOf(RESET_CONNECTION) != -1) {
            return 1;
        }
        if (msg.indexOf(SOFTWARE_CONNECTION_ABORT) != -1) {
            return 1;
        }
        if (msg.indexOf(UNRECOGNIZED_WINDOWS_SOCKET_ERROR) != -1) {
            return 1;
        }
        if (msg.indexOf(SYSTEM_CALL_INVALID_PARAMETER) != -1) {
            return 1;
        }
        if (msg.indexOf(SOCKS_SERVER_GENERAL_FAILURE) != -1) {
            return 2;
        }
        if (msg.indexOf(POSSIBLE_INVALID_ADDRESS) != -1) {
            return 2;
        }
        return 3;
    }

    public DownloadRetryLevel retryLevel(Exception exception) {
        if (exception instanceof HttpClientStatusException) {
            return HttpClientStatusBasedRetryCode.getStatusCodeRetryCode((HttpClientStatusException)((Object)exception));
        }
        if (exception instanceof NoHttpResponseException) {
            return DownloadRetryLevel.RETRY_LEVEL_NETWORK_TIMEOUT_OR_DROPPED;
        }
        if (exception instanceof URIException) {
            return DownloadRetryLevel.RETRY_LEVEL_INVALID_REQUEST;
        }
        if (exception instanceof CircularRedirectException) {
            return DownloadRetryLevel.RETRY_LEVEL_RESPONSE_UNEXPECTED_STATUS;
        }
        if (exception instanceof HttpException) {
            if (exception instanceof AuthenticationException) {
                return DownloadRetryLevel.RETRY_LEVEL_BUG;
            }
            return DownloadRetryLevel.RETRY_LEVEL_RESPONSE_UNEXPECTED_STATUS;
        }
        return super.retryLevel(exception);
    }

    private void initMethod(HttpMethod method, AuthenticationContext authContext, IHasIsCanceled cancelMonitor) throws URIException {
        if (method instanceof MethodMessageHelper.IMethodWithRequestLine) {
            MethodMessageHelper.IMethodWithRequestLine withRequestLine = (MethodMessageHelper.IMethodWithRequestLine)method;
            withRequestLine.resetRequestLine();
        }
        method.getParams().setParameter("http.method.retry-handler", (Object)new MethodRetryHandler(authContext, cancelMonitor));
        method.setFollowRedirects(false);
        method.setRequestHeader(ACCEPT_LANGUAGE, LOCALE);
        String userAgent = HttpUserAgent.INSTANCE.getUserAgent();
        if (userAgent != null) {
            method.setRequestHeader("User-Agent", userAgent);
        }
        this.addGzipAcceptEncodingHeader(method);
    }

    private static boolean enableGzipForPath(String path) {
        if (UserOptions.CIC_ENABLE_GZIP_HTTP_REQUEST_HEADER_FOR_XML.isSet()) {
            return HttpClientDownloadHandler.enableGzipForPathXml(path);
        }
        return path.endsWith(REPOSITORY_XML);
    }

    private static boolean enableGzipForPathXml(String path) {
        String name = PathUtil.getSimpleName((String)path);
        if (!PathUtil.hasExtension((String)name, (String)XML, (boolean)true)) {
            return false;
        }
        int dotCount = 0;
        int i = 0;
        while (i < name.length() && dotCount <= 1) {
            if (name.charAt(i) == '.') {
                ++dotCount;
            }
            ++i;
        }
        return dotCount == true;
    }

    public void addGzipAcceptEncodingHeader(HttpMethod method) throws URIException {
        Header header = method.getRequestHeader(RANGE);
        if (header != null) {
            return;
        }
        String path = method.getPath();
        if (this.enableGzipAcceptEncodingOption() && HttpClientDownloadHandler.enableGzipForPath(path)) {
            method.addRequestHeader(ACCEPT_ENCODING, GZIP);
        }
    }

    protected IContentInfo implementDownload(DownloadHandlerRequest.DownloadRequest request, ITransferMonitor transferPerformance, long[] outBytesRead) throws MalformedURLException, IOException, FileNotFoundException {
        return DownloadHandlerUtil.downloadUsingOpenStreamAtRange((ICanOpenStreamAtRange)this, (DownloadHandlerRequest.DownloadRequest)request, (ITransferMonitor)transferPerformance, (long[])outBytesRead);
    }

    protected IContentInfo implementDownload(DownloadHandlerRequest.DownloadSinkRequest request, ITransferMonitor transferPerformance, long[] outBytesRead) throws MalformedURLException, FileNotFoundException, UnknownHostException, DownloadException, IOException {
        return DownloadHandlerUtil.downloadUsingOpenStreamAtRange((ICanOpenStreamAtRange)this, (DownloadHandlerRequest.DownloadSinkRequest)request, (ITransferMonitor)transferPerformance, (long[])outBytesRead);
    }

    private int executeMethod(DownloadHandlerRequest request, HttpMethod method) throws HttpException, IOException {
        URI uri = method.getURI();
        HttpHost httpHost = new HttpHost(uri);
        AuthenticationContext ac = this.getAuthenticationContext(httpHost);
        IHasIsCanceled cancelMonitor = HttpClientDownloadHandler.getCancelMonitor((DownloadHandlerRequest)request);
        this.initMethod(method, ac, cancelMonitor);
        LinkedHashSet traversedUrls = new LinkedHashSet();
        try {
            int n = this.doExecuteMethod(request, method, ac, traversedUrls, cancelMonitor);
            return n;
        }
        finally {
            traversedUrls.clear();
            ac.release();
        }
    }

    private int doExecuteMethod(DownloadHandlerRequest request, HttpMethod method, AuthenticationContext ac, Set traversedUrls, IHasIsCanceled cancelMonitor) throws HttpException, IOException {
        int rc;
        DownloadCanceledException canceledWithoutException;
        block13: {
            if (traversedUrls.contains(method.getURI().toString())) {
                throw new CircularRedirectException("Detected circular redirection: " + method.getURI().toString());
            }
            if (cancelMonitor.isCanceled()) {
                throw DownloadCanceledException.create((DownloadHandlerRequest)request, null);
            }
            final IDownloadListener fire = DownloadEvents.getFire((IDownloadContext)request.getDownloadContext());
            traversedUrls.add(method.getURI().toString());
            final IDownloadListener.Access access = this.getAccess(request, method);
            HttpClientEvents.HttpClientListener httpListener = new HttpClientEvents.HttpClientListener(){

                @Override
                public void onEvent(HttpClientEvents.HttpClientEvent event) {
                    if (event instanceof HttpClientEvents.UnauthorizedEvent) {
                        fire.receivedUnauthorizedResponse(access);
                    }
                    super.onEvent(event);
                }
            };
            HttpClientEvents.INSTANCE.addListener(httpListener);
            canceledWithoutException = null;
            rc = -1;
            try {
                try {
                    fire.beforeSendRequest(access);
                    rc = this.doExecuteHandleIllegalStateException(method);
                    if (ac.checkThreadCanceled(true)) {
                        ac.onState(RequestStatus.ASK_CREDENTIAL_CANCELED, null);
                        fire.sendRequestCanceled(access);
                        canceledWithoutException = DownloadCanceledException.createAuthenticationCanceled((DownloadHandlerRequest)request, (Exception)((Object)new HttpClientStatusException(method, rc)));
                        break block13;
                    }
                    ac.onState(RequestStatus.SUCCEEDED, null);
                    fire.receivedResponse(access, (Object)method.getStatusLine());
                    if (!this.isRedirectNeeded(rc)) break block13;
                    this.setupRedirection(method);
                    HttpHost httpHost = new HttpHost(method.getURI());
                    AuthenticationContext acRedirected = this.getAuthenticationContext(httpHost);
                    try {
                        this.initMethod(method, acRedirected, cancelMonitor);
                        rc = this.doExecuteMethod(request, method, acRedirected, traversedUrls, cancelMonitor);
                    }
                    finally {
                        acRedirected.release();
                    }
                }
                catch (HttpException e) {
                    this.handleCancelOfMethodExecution(request, ac, cancelMonitor, access, (Exception)((Object)e));
                    throw e;
                }
                catch (IOException e) {
                    this.handleCancelOfMethodExecution(request, ac, cancelMonitor, access, e);
                    throw e;
                }
            }
            finally {
                HttpClientEvents.INSTANCE.removeListener(httpListener);
            }
        }
        if (canceledWithoutException != null) {
            throw canceledWithoutException;
        }
        return rc;
    }

    public int doExecuteHandleIllegalStateException(HttpMethod method) throws IOException, HttpException {
        try {
            return fHttpClient.executeMethod(method);
        }
        catch (IllegalStateException e) {
            HttpHost httpHost = new HttpHost(method.getURI());
            ProxyInfo pi = PreferencesHolder.INSTANCE.getProxyInfo(httpHost.getProtocol().getScheme());
            if (!pi.isNoProxy() && !pi.useSocks() && fHttpClient.getParams().isAuthenticationPreemptive()) {
                fHttpClient.getParams().setAuthenticationPreemptive(false);
                Logger log = DownloadHandler.dlTrace.getLog();
                if (log.isDebugLoggable()) {
                    log.debug(Messages.HttpClientDownloadHandler_retryingAfterDisablingPreemptiveAuthentication, new Object[]{e});
                } else {
                    DownloadHandler.dlTrace.getLog().info(Messages.HttpClientDownloadHandler_retryingAfterDisablingPreemptiveAuthentication);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                fHttpClient.getHttpConnectionManager().closeIdleConnections(0L);
                return this.doExecuteHandleIllegalStateException(method);
            }
            throw e;
        }
    }

    private void handleCancelOfMethodExecution(DownloadHandlerRequest request, AuthenticationContext ac, IHasIsCanceled cancelMonitor, IDownloadListener.Access access, Exception e) throws DownloadCanceledException {
        IDownloadListener fire = DownloadEvents.getFire((IDownloadContext)request.getDownloadContext());
        if (ac.checkThreadCanceled(true)) {
            ac.onState(RequestStatus.ASK_CREDENTIAL_CANCELED, null);
            fire.sendRequestCanceled(access);
            throw DownloadCanceledException.createAuthenticationCanceled((DownloadHandlerRequest)request, (Exception)e);
        }
        if (cancelMonitor.isCanceled()) {
            ac.onState(RequestStatus.EXCEPTION, (Throwable)e);
            fire.sendRequestCanceled(access);
            throw DownloadCanceledException.create((DownloadHandlerRequest)request, (Exception)e);
        }
        ac.onState(RequestStatus.EXCEPTION, (Throwable)e);
        fire.sendRequestException(access, e);
    }

    private IDownloadListener.Access getAccess(DownloadHandlerRequest request, HttpMethod method) throws URIException {
        String urlString = method.getURI().toString();
        String protocol = method.getURI().getScheme();
        String host = method.getURI().getHost();
        int port = method.getURI().getPort();
        IDownloadListener.IHostReceiver receiver = IDownloadListener.IReceiverFactory.INSTANCE.createHostReceiver(urlString, protocol, host, port);
        return new IDownloadListener.Access(request, (IDownloadListener.IReceiver)receiver);
    }

    private boolean isRedirectNeeded(int rc) {
        switch (rc) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    private void setupRedirection(HttpMethod method) throws URIException, ProtocolException {
        Header header = method.getResponseHeader(LOCATION_RESPONSE_HEADER);
        if (header == null) {
            throw new ProtocolException("HTTP redirect response missing location header");
        }
        method.releaseConnection();
        String location = header.getValue();
        dlTrace.println("Detected redirect response");
        dlTrace.println("Old url: " + method.getURI().toString());
        dlTrace.println("New url: " + location);
        URI newUri = new URI(location, true);
        method.setURI(newUri);
    }

    private static long getContentLength(HttpMethod method) {
        Header clHeader = method.getResponseHeader("content-length");
        String contentLength = clHeader != null ? clHeader.getValue() : null;
        long remoteLength = -1L;
        if (contentLength != null && contentLength.length() > 0) {
            remoteLength = Long.parseLong(contentLength);
        }
        return remoteLength;
    }

    private static long getLastModified(HttpMethod method) {
        Header header = method.getResponseHeader("last-modified");
        String value = header != null ? header.getValue() : null;
        long lastModified = 0L;
        if (value != null && value.length() > 0) {
            try {
                lastModified = DateUtil.parseDate((String)value).getTime();
            }
            catch (Exception e) {
                DownloadHandler.dlTrace.getLog().error((Throwable)e);
            }
        }
        return lastModified;
    }

    private static String getContentRangeValue(HttpMethod method) {
        Header h = method.getResponseHeader("content-range");
        String value = h != null ? h.getValue() : null;
        return value;
    }

    private static HttpRangeUtil.ByteContentRange getNonRequiredContentRange(String urlString, HttpMethod method) {
        HttpRangeUtil.ByteContentRange contentRange = HttpRangeUtil.getNonRequiredContentRange((String)urlString, (String)HttpClientDownloadHandler.getContentRangeValue(method));
        return contentRange;
    }

    private static HttpRangeUtil.ByteContentRange getRequiredContentRange(String urlString, HttpMethod method) throws DownloadProtocolException {
        HttpRangeUtil.ByteContentRange contentRange = HttpRangeUtil.getRequiredContentRange((String)urlString, (String)HttpClientDownloadHandler.getContentRangeValue(method));
        return contentRange;
    }

    public IDownloadStream openStreamAtRange(final DownloadHandlerRequest.OpenStreamForRangeRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws MalformedURLException, IOException, DownloadProtocolException {
        String urlString = request.getUrlString();
        ByteRange requestedRange = request.getByteRange();
        DownloadHandlerUtil.pluginTrace.entering((Object)urlString);
        traceHeartBeat.heartbeat();
        if (outContentInfo != null && outContentInfo.length != 1) {
            throw new IllegalArgumentException();
        }
        MethodMessageHelper.CicGetMethod method = new MethodMessageHelper.CicGetMethod(urlString){

            @Override
            protected DownloadHandlerRequest getDownloadRequest() {
                return request;
            }
        };
        try {
            InputStream identityStream;
            long transferSize;
            long actualSize;
            int statusCode;
            if (!requestedRange.isFullRange()) {
                String rangeHeaderValue = HttpRangeUtil.getHttpRangeRequestHeaderValue((ByteRange)requestedRange);
                method.setRequestHeader(RANGE, rangeHeaderValue);
                dlTrace.getLog().debug(".. setRequestHeader({0}={1})", new Object[]{RANGE, rangeHeaderValue});
            }
            if ((statusCode = this.executeMethod((DownloadHandlerRequest)request, (HttpMethod)method)) == 401) {
                throw new HttpClientStatusException((HttpMethod)method, statusCode);
            }
            if (statusCode == 404) {
                this.consumeResponseBody(urlString, (HttpMethod)method);
                throw new FileNotFoundException(urlString);
            }
            if (statusCode != 200 && statusCode != 206) {
                Object returnException = new HttpClientStatusException((HttpMethod)method, statusCode);
                if (statusCode == 416) {
                    HttpRangeUtil.ByteContentRange contentRange = HttpClientDownloadHandler.getNonRequiredContentRange(urlString, (HttpMethod)method);
                    long actualSize2 = contentRange != null ? contentRange.getInstanceLength() : -1L;
                    String msg = HttpRangeUtil.getContentRangeNotSatisfiableMsg((String)urlString, (ByteRange)requestedRange, (long)actualSize2);
                    returnException = new DownloadByteRangeOutOfBoundsException(msg, actualSize2, (Exception)returnException);
                    if (actualSize2 != -1L) {
                        try {
                            ByteRangeMonitorInputStream.checkForStartOutOfBoundsException((String)urlString, (ByteRange)requestedRange, (long)contentRange.getInstanceLength(), (Exception)returnException);
                        }
                        catch (DownloadByteRangeOutOfBoundsException e) {
                            returnException = e;
                        }
                    }
                }
                this.consumeResponseBody(urlString, (HttpMethod)method);
                DownloadHandlerUtil.pluginTrace.throwing((Throwable)returnException);
                throw returnException;
            }
            ByteRange servedRange = null;
            if (statusCode == 206) {
                HttpRangeUtil.ByteContentRange contentRange = null;
                try {
                    contentRange = HttpClientDownloadHandler.getRequiredContentRange(urlString, (HttpMethod)method);
                }
                catch (DownloadProtocolException e) {
                    this.consumeResponseBody(urlString, (HttpMethod)method);
                    throw e;
                }
                assert (contentRange != null);
                actualSize = contentRange.getInstanceLength();
                servedRange = HttpRangeUtil.convertContentRangeToByteRange((HttpRangeUtil.ByteContentRange)contentRange);
                transferSize = servedRange.sizeOrUnknown();
                identityStream = method.getResponseBodyAsStream();
            } else {
                assert (statusCode == 200);
                if (this.isCompressedResponse((HttpMethod)method)) {
                    actualSize = -1L;
                    servedRange = ByteRange.RANGE_ALL_BYTES;
                    identityStream = new BufferedInputStream(new GZIPInputStream(method.getResponseBodyAsStream()));
                    transferSize = HttpClientDownloadHandler.getContentLength((HttpMethod)method);
                    dlTrace.getLog().debug("Response is compressed: " + urlString);
                } else {
                    actualSize = HttpClientDownloadHandler.getContentLength((HttpMethod)method);
                    servedRange = actualSize == -1L ? ByteRange.RANGE_ALL_BYTES : ByteRange.remainingRange((long)0L, (long)actualSize);
                    transferSize = servedRange.sizeOrUnknown();
                    identityStream = method.getResponseBodyAsStream();
                }
            }
            if (actualSize == -1L) {
                dlTrace.getLog().debug("{0}: Length NOT available");
            }
            InputStream hookedStream = DownloadHooks.openedStreamAtRange((InputStream)identityStream, (DownloadHandlerRequest.OpenStreamForRangeRequest)request, (ByteRange)requestedRange, (ByteRange)servedRange, (long)actualSize);
            ByteRange adjustedRequestedRange = requestedRange;
            if (statusCode == 200 && !requestedRange.isFullRange()) {
                adjustedRequestedRange = requestedRange.extendsToSpecifiedEOF() ? ByteRange.remainingRange((long)0L, (long)requestedRange.getEnd()) : ByteRange.RANGE_ALL_BYTES;
            }
            HttpClientByteRangeMonitorInputStream httpRangeInputStream = this.checkRangesAndwrapMonitorInputStream((HttpMethod)method, urlString, adjustedRequestedRange, actualSize, hookedStream);
            IDownloadListener.Access access = this.getAccess((DownloadHandlerRequest)request, (HttpMethod)method);
            ProgressInputStream.EmitDownloadEvents emitEvents = new ProgressInputStream.EmitDownloadEvents(access, DownloadEvents.getFire((IDownloadContext)request.getDownloadContext()));
            ProgressInputStream in = new ProgressInputStream(emitEvents, (InputStream)((Object)httpRangeInputStream), actualSize, transferSize, transferPerformance, true);
            if (outContentInfo != null) {
                long transferLength = servedRange.sizeOrUnknown();
                if (transferLength != -1L) {
                    SimpleContentInfo ci = new SimpleContentInfo();
                    ci.setSize(transferLength);
                    outContentInfo[0] = ci;
                } else {
                    outContentInfo[0] = ContentInfo.EMPTY_CONTENT_INFO;
                }
            }
            DownloadStream dlStream = new DownloadStream((Object)urlString, requestedRange, servedRange, (InputStream)in, this.isCompressedResponse((HttpMethod)method));
            dlTraceHappy.getLog().debug("SUCCESS: opened stream {0} at {1}", new Object[]{urlString, dlStream});
            DownloadHandlerUtil.pluginTrace.exiting();
            traceHeartBeat.heartbeat();
            return dlStream;
        }
        catch (ProtocolException pe) {
            method.releaseConnection();
            throw new DownloadProtocolException((Exception)((Object)pe));
        }
        catch (IOException e) {
            method.releaseConnection();
            throw e;
        }
    }

    private boolean isCompressedResponse(HttpMethod method) {
        Header header = method.getResponseHeader(CONTENT_ENCODING);
        return header != null && GZIP.equals(header.getValue().toLowerCase(Locale.ENGLISH));
    }

    private HttpClientByteRangeMonitorInputStream checkRangesAndwrapMonitorInputStream(HttpMethod method, String urlString, ByteRange requestedRange, long actualSize, InputStream inputStream) throws DownloadRangeNotSatisfiableException {
        ByteRange effectiveRange = null;
        try {
            ByteRangeMonitorInputStream.checkForStartOutOfBoundsException((String)urlString, (ByteRange)requestedRange, (long)actualSize, null);
            effectiveRange = ByteRangeMonitorInputStream.checkAndGetEffectiveRange((String)urlString, (ByteRange)requestedRange, (long)actualSize);
        }
        catch (DownloadRangeNotSatisfiableException e) {
            this.consumeResponseBody(urlString, method);
            throw e;
        }
        HttpClientByteRangeMonitorInputStream monitoredStream = new HttpClientByteRangeMonitorInputStream(urlString, method, inputStream, requestedRange, effectiveRange, actualSize);
        return monitoredStream;
    }

    private void consumeResponseBody(String urlString, HttpMethod method) {
        long contentLength = HttpClientDownloadHandler.getContentLength(method);
        if (contentLength > 2048L) {
            try {
                dlTrace.getLog().debug("aborting get: {0}", new Object[]{urlString});
                method.abort();
            }
            finally {
                method.releaseConnection();
            }
        }
        try {
            try {
                InputStream is = method.getResponseBodyAsStream();
                if (is != null) {
                    byte[] buf = new byte[4096];
                    while (is.read(buf) != -1) {
                    }
                }
            }
            catch (IOException ioe) {
                DownloadHandlerUtil.pluginTrace.catching((Throwable)ioe);
                method.releaseConnection();
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public InputStream openStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws MalformedURLException, DownloadException, IOException, FileNotFoundException, UnknownHostException {
        return super.privateOpenStream(request, transferPerformance, outContentInfo);
    }

    protected InputStream implementOpenStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        DownloadHandlerRequest.OpenStreamForRangeRequest rangeRequest = DownloadHandlerRequest.FACTORY.createOpenStreamForRange(request.getDownloadContext(), request.getUrlString(), ByteRange.RANGE_ALL_BYTES);
        rangeRequest.setParentRequest((DownloadHandlerRequest)request);
        IDownloadStream dlStream = this.openStreamAtRange(rangeRequest, transferPerformance, outContentInfo);
        return dlStream.getInputStream();
    }

    public boolean implementExists(final DownloadHandlerRequest.ExistsRequest request) throws MalformedURLException, IOException, UnknownHostException {
        String urlString = request.getUrlString();
        DownloadHandlerUtil.pluginTrace.entering((Object)urlString);
        traceHeartBeat.heartbeat();
        MethodMessageHelper.CicHeadMethod method = new MethodMessageHelper.CicHeadMethod(urlString){

            @Override
            protected DownloadHandlerRequest getDownloadRequest() {
                return request;
            }
        };
        try {
            boolean exists = true;
            int statusCode = this.executeMethod((DownloadHandlerRequest)request, (HttpMethod)method);
            if (statusCode == 404) {
                exists = false;
            } else if (statusCode != 200) {
                throw new HttpClientStatusException((HttpMethod)method, statusCode);
            }
            if (HttpClientDownloadHandler.dlTraceHappy.enabled) {
                if (exists) {
                    dlTraceHappy.println("SUCCESS: stream {0} exists, response={1}", urlString, Integer.toString(statusCode));
                } else {
                    dlTraceHappy.println("SUCCESS: stream {0} does NOT exist, response={1}", urlString, Integer.toString(statusCode));
                }
            }
            DownloadHandlerUtil.pluginTrace.exiting((Object)exists);
            boolean bl = exists;
            return bl;
        }
        catch (IOException e) {
            DownloadHandlerUtil.rethrowExpectedException((IOException)e);
            DownloadHandlerUtil.pluginTrace.catching((Throwable)e);
            dlTrace.println("exists() Catching exception: {0} : {1}.", urlString, String.valueOf(e.getClass().toString()) + ':' + e.toString());
            DownloadHandlerUtil.pluginTrace.println("... rethrowing");
            throw e;
        }
        finally {
            method.releaseConnection();
            traceHeartBeat.heartbeat();
        }
    }

    public boolean canQueryProperties() {
        return true;
    }

    protected DownloadProperties implementQueryProperties(final DownloadHandlerRequest.QueryContentInfoRequest request) throws MalformedURLException, FileNotFoundException, UnknownHostException, IOException {
        String urlString = request.getUrlString();
        DownloadHandlerUtil.pluginTrace.entering((Object)urlString);
        traceHeartBeat.heartbeat();
        MethodMessageHelper.CicHeadMethod method = new MethodMessageHelper.CicHeadMethod(urlString){

            @Override
            protected DownloadHandlerRequest getDownloadRequest() {
                return request;
            }
        };
        try {
            DownloadProperties dlp = DownloadProperties.EMPTY_DOWNLOAD_PROPERTIES;
            int statusCode = this.executeMethod((DownloadHandlerRequest)request, (HttpMethod)method);
            if (statusCode == 404) {
                throw new FileNotFoundException(urlString);
            }
            if (statusCode != 200) {
                throw new HttpClientStatusException((HttpMethod)method, statusCode);
            }
            long size = HttpClientDownloadHandler.getContentLength((HttpMethod)method);
            long lastModified = HttpClientDownloadHandler.getLastModified((HttpMethod)method);
            dlp.setContentInfo((IContentInfo)new SimpleContentInfo(size));
            dlp.setLastModified(lastModified);
            if (HttpClientDownloadHandler.dlTraceHappy.enabled) {
                dlTraceHappy.getLog().debug("SUCCESS: queryProperties {0} exists, received={1}", new Object[]{urlString, dlp});
            }
            DownloadProperties downloadProperties = dlp;
            return downloadProperties;
        }
        catch (IOException e) {
            DownloadHandlerUtil.rethrowExpectedException((IOException)e);
            DownloadHandlerUtil.pluginTrace.catching((Throwable)e);
            dlTrace.println("queryInfo() Catching exception: {0} : {1}.", urlString, String.valueOf(e.getClass().toString()) + ':' + e.toString());
            DownloadHandlerUtil.pluginTrace.println("... rethrowing");
            throw e;
        }
        finally {
            method.releaseConnection();
            traceHeartBeat.heartbeat();
        }
    }

    public File sendPostMessage(IDownloadContext ctxt, String urlString, NameValuePair[] pairs) throws HttpException, IOException {
        assert (urlString != null);
        DownloadHandlerUtil.pluginTrace.entering((Object)urlString);
        traceHeartBeat.heartbeat();
        PostMethod method = this.createAndInitializePostMethod(urlString);
        PostMessageNameValuePairsRequest request = new PostMessageNameValuePairsRequest(ctxt, urlString, pairs);
        method.setDoAuthentication(true);
        try {
            int statusCode;
            if (pairs != null) {
                method.setRequestBody(pairs);
            }
            if ((statusCode = this.executeMethod(request, (HttpMethod)method)) != 200) {
                throw new HttpClientStatusException((HttpMethod)method, statusCode);
            }
            if (HttpClientDownloadHandler.dlTraceHappy.enabled) {
                dlTraceHappy.println("SUCCESS: Post succeeded {0}, response={1}", urlString, Integer.toString(statusCode));
            }
            File responseFile = this.readResponse((HttpMethod)method);
            DownloadHandlerUtil.pluginTrace.exiting();
            File file = responseFile;
            return file;
        }
        finally {
            method.releaseConnection();
            traceHeartBeat.heartbeat();
        }
    }

    public File sendPostMessage(IDownloadContext ctxt, String urlString, InputStream in) throws HttpException, IOException {
        assert (urlString != null);
        DownloadHandlerUtil.pluginTrace.entering((Object)urlString);
        traceHeartBeat.heartbeat();
        PostMethod method = this.createAndInitializePostMethod(urlString);
        PostMessageRequest request = new PostMessageRequest(ctxt, urlString);
        method.setDoAuthentication(true);
        try {
            method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(in));
            int statusCode = this.executeMethod(request, (HttpMethod)method);
            if (statusCode != 200) {
                throw new HttpClientStatusException((HttpMethod)method, statusCode);
            }
            if (HttpClientDownloadHandler.dlTraceHappy.enabled) {
                dlTraceHappy.println("SUCCESS: Post succeeded {0}, response={1}", urlString, Integer.toString(statusCode));
            }
            File responseFile = this.readResponse((HttpMethod)method);
            DownloadHandlerUtil.pluginTrace.exiting();
            File file = responseFile;
            return file;
        }
        finally {
            method.releaseConnection();
            traceHeartBeat.heartbeat();
        }
    }

    public PostMethod createAndInitializePostMethod(String urlString) throws URIException {
        PostMethod method = new PostMethod(urlString);
        HttpHost httpHost = new HttpHost(method.getURI());
        AuthenticationContext ac = this.getAuthenticationContext(httpHost);
        this.initMethod((HttpMethod)method, ac, NullHasIsCanceledMonitor.INSTANCE);
        return method;
    }

    private File readResponse(HttpMethod method) throws IOException {
        File file = this.readRawResponse(method);
        file = this.uncompressRawResponseIfRequired(method, file);
        file.deleteOnExit();
        return file;
    }

    public File uncompressRawResponseIfRequired(HttpMethod method, File file) throws IOException {
        if (this.isCompressedResponse(method) && file.length() > 0L) {
            File gunzipFile = File.createTempFile(CIC, null);
            BufferedOutputStream os = null;
            BufferedInputStream is = null;
            try {
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                    os = new BufferedOutputStream(new FileOutputStream(gunzipFile));
                    Util.gunzipAndCopy((InputStream)is, (OutputStream)os);
                }
                catch (IOException ex) {
                    FileUtil.delete((File)gunzipFile);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.delete((File)file);
                throw throwable;
            }
            FileUtil.close((Closeable)is);
            FileUtil.close((Closeable)os);
            FileUtil.delete((File)file);
            file = gunzipFile;
        }
        return file;
    }

    public File readRawResponse(HttpMethod method) throws IOException {
        File file = File.createTempFile(CIC, null);
        BufferedInputStream is = new BufferedInputStream(method.getResponseBodyAsStream());
        try {
            FileUtil.copyStream((InputStream)is, (File)file, (IProgressMonitor)new NullProgressMonitor());
            File file2 = file;
            return file2;
        }
        catch (IOException ex) {
            FileUtil.delete((File)file);
            throw ex;
        }
        finally {
            FileUtil.close((Closeable)is);
            is = null;
        }
    }

    public IProtocolMessage normalizeMessage(IProtocolMessage message) {
        SimpleProtocolMessage.Builder builder = SimpleProtocolMessage.builder((IProtocolMessage)message);
        IProtocolHeader[] iProtocolHeaderArray = message.getHeaders();
        int n = iProtocolHeaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProtocolHeader header = iProtocolHeaderArray[n2];
            String headerKey = this.nameToKey(header.getName());
            for (String value : HttpClientDownloadHandler.normalizedHeaderValue(header)) {
                builder.header(headerKey, header.getName(), value);
            }
            ++n2;
        }
        return builder.build();
    }

    private static List<String> normalizedHeaderValue(IProtocolHeader header) {
        HeaderElement[] elements = HeaderElement.parseElements((String)header.getValue());
        ArrayList<String> values = new ArrayList<String>(elements.length);
        HeaderElement[] headerElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            NameValuePair[] params;
            HeaderElement element = headerElementArray[n2];
            StringBuffer normValue = new StringBuffer(header.getValue().length());
            normValue.append(element.getName());
            String v = element.getValue();
            if (v != null) {
                normValue.append('=').append(v);
            }
            if ((params = element.getParameters()) != null && params.length > 0) {
                NameValuePair[] nameValuePairArray = params;
                int n3 = params.length;
                int n4 = 0;
                while (n4 < n3) {
                    NameValuePair nvp = nameValuePairArray[n4];
                    normValue.append(';');
                    normValue.append(nvp.getName());
                    if (nvp.getValue() != null) {
                        normValue.append('=').append(nvp.getValue());
                    }
                    ++n4;
                }
            }
            values.add(normValue.toString());
            ++n2;
        }
        return values;
    }

    public String nameToKey(String headerName) {
        return headerName.toLowerCase(Locale.ENGLISH);
    }

    static class HttpClientAuthContext
    extends AuthenticationContext {
        private HostInfo hostInfo;

        HttpClientAuthContext() {
        }

        public HttpClientAuthContext init(HttpClient httpClient, HttpHost httpHost) {
            this.hostInfo = new HostInfo(httpHost.getHostName(), httpHost.getPort());
            httpClient.getHostConfiguration().setHost(httpHost);
            if (DownloadHandlerUtil.traceProxySettings.enabled) {
                DownloadHandlerUtil.traceProxySettings.println("Set httpClient Host: {0}.", httpClient.getHostConfiguration().toString());
            }
            HttpCredentialsProvider.INSTANCE.getAuthenticator().addHostInfo((AbstractHostInfo)this.hostInfo);
            return this;
        }

        public void release() {
            HttpCredentialsProvider.INSTANCE.getAuthenticator().removeHostInfo((AbstractHostInfo)this.hostInfo);
        }

        public void onState(RequestStatus state, Throwable exception) {
            super.onState(state, exception);
            HttpCredentialsProvider.INSTANCE.getAuthenticator().setResult((AbstractHostInfo)this.hostInfo, state);
        }

        public boolean checkThreadCanceled(boolean reset) {
            return HttpCredentialsProvider.INSTANCE.getAuthenticator().checkThreadCanceled((AbstractHostInfo)this.hostInfo, reset);
        }

        public int getAskedCount() {
            return HttpCredentialsProvider.INSTANCE.getAuthenticator().getAskedCount();
        }
    }

    static class HttpClientByteRangeMonitorInputStream
    extends ByteRangeMonitorInputStream {
        private HttpMethod method;

        public HttpClientByteRangeMonitorInputStream(String source, HttpMethod method, InputStream in, ByteRange requestedRange, ByteRange effectiveRange, long actualSize) {
            super(source, in, requestedRange, effectiveRange, actualSize);
            this.method = method;
        }

        public String toString() {
            return this.source;
        }

        protected void doCloseAtEOF() throws IOException {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            finally {
                if (this.method != null) {
                    dlTraceHappy.println("releasing connection for stream :" + this.toString());
                    this.method.releaseConnection();
                    this.method = null;
                }
            }
        }

        protected void doCloseBeforeEOF() {
            if (this.method != null) {
                try {
                    dlTrace.println("aborting get:" + this.toString());
                    this.method.abort();
                }
                finally {
                    this.method.releaseConnection();
                    this.method = null;
                }
            }
        }
    }

    static class HttpClientProxyAuthContext
    extends AuthenticationContext {
        private ProxyInfo proxyInfo;

        HttpClientProxyAuthContext() {
        }

        public HttpClientProxyAuthContext init(HttpClient httpClient, ProxyInfo curProxyInfo) {
            this.proxyInfo = curProxyInfo;
            ProxyHost proxyHost = new ProxyHost(curProxyInfo.getHost(), curProxyInfo.getPort());
            httpClient.getHostConfiguration().setProxyHost(proxyHost);
            if (DownloadHandlerUtil.traceProxySettings.enabled) {
                DownloadHandlerUtil.traceProxySettings.println("Set httpClient proxyHost: {0}.", httpClient.getHostConfiguration().toString());
            }
            HttpCredentialsProvider.INSTANCE.getAuthenticator().addHostInfo((AbstractHostInfo)this.proxyInfo);
            return this;
        }

        public void release() {
            HttpCredentialsProvider.INSTANCE.getAuthenticator().removeHostInfo((AbstractHostInfo)this.proxyInfo);
        }

        public void onState(RequestStatus state, Throwable exception) {
            super.onState(state, exception);
            HttpCredentialsProvider.INSTANCE.getAuthenticator().setResult((AbstractHostInfo)this.proxyInfo, state);
        }

        public boolean checkThreadCanceled(boolean reset) {
            return HttpCredentialsProvider.INSTANCE.getAuthenticator().checkThreadCanceled((AbstractHostInfo)this.proxyInfo, reset);
        }

        public int getAskedCount() {
            return HttpCredentialsProvider.INSTANCE.getAuthenticator().getAskedCount();
        }
    }

    public static class HttpClientStatusException
    extends DownloadStatusException {
        private final int statusCode;
        private final HttpMethod method;

        HttpClientStatusException(HttpMethod method, int statusCode) {
            super(NLS.bind((String)"{0} ({1})", (Object)method.getStatusText(), (Object)statusCode));
            this.statusCode = statusCode;
            this.method = method;
        }

        public int getHttpStatusCode() {
            return this.statusCode;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public Object getProtocolCode() {
            return this.statusCode;
        }
    }

    private static class MethodRetryHandler
    extends RequestRetryHandler
    implements HttpMethodRetryHandler {
        private final HttpMethodRetryHandler defaultHandler = new DefaultHttpMethodRetryHandler(1000, false);
        private final IHasIsCanceled cancelMonitor;

        public MethodRetryHandler(AuthenticationContext authContext, IHasIsCanceled cancelMonitor) {
            super(authContext, cancelMonitor, 3);
            this.cancelMonitor = cancelMonitor;
        }

        public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
            SSLException sslException;
            if (this.cancelMonitor.isCanceled()) {
                return false;
            }
            if (exception instanceof DownloadCanceledException) {
                return false;
            }
            if (this.authContext.checkThreadCanceled(false)) {
                return false;
            }
            if (exception instanceof SocketException) {
                boolean assumeNetworkNotReconnected = true;
                SocketException socketException = (SocketException)exception;
                int retrySocketExceptionCode = HttpClientDownloadHandler.retrySocketException(assumeNetworkNotReconnected, socketException);
                if (retrySocketExceptionCode == 1) {
                    return true;
                }
                if (retrySocketExceptionCode == 2) {
                    return false;
                }
            }
            if (exception instanceof SSLException && DownloadHandlerDefaultRetryLevel.isSSLSecurityException((SSLException)(sslException = (SSLException)exception))) {
                return false;
            }
            try {
                boolean retry = super.shouldRetry((Object)method, method.getURI().toString(), exception, executionCount);
                if (!(exception instanceof SocketTimeoutException)) {
                    retry = retry && this.defaultHandler.retryMethod(method, exception, executionCount);
                }
                return retry;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    static class NoHttpClientProxy
    extends AuthenticationContext {
        NoHttpClientProxy() {
        }

        public static void clearHttpProxyInfo(HttpClient httpClient) {
            httpClient.getHostConfiguration().setProxyHost(null);
            if (DownloadHandlerUtil.traceProxySettings.enabled) {
                DownloadHandlerUtil.traceProxySettings.println("Cleared httpClient proxyHost: {0}.", httpClient.getHostConfiguration().toString());
            }
            httpClient.getState().clearProxyCredentials();
            if (DownloadHandlerUtil.traceProxySettings.enabled) {
                DownloadHandlerUtil.traceProxySettings.println("Remaining credentials after clearing httpClient proxy Credentials: {0}.", httpClient.getState().toString());
            }
        }

        NoHttpClientProxy init(HttpClient httpClient) {
            NoHttpClientProxy.clearHttpProxyInfo(httpClient);
            return this;
        }

        public boolean checkThreadCanceled(boolean reset) {
            return false;
        }

        public int getAskedCount() {
            return 0;
        }
    }

    public static final class PostMessageNameValuePairsRequest
    extends DownloadHandlerRequest {
        private final NameValuePair[] fPairs;

        protected PostMessageNameValuePairsRequest(IDownloadContext ctxt, String urlString, NameValuePair[] pairs) {
            super(ctxt, urlString);
            this.fPairs = pairs;
        }

        public String toString() {
            return "post-name-value-pairs:" + this.getUrlString();
        }

        public NameValuePair[] getNameValuePairs() {
            return this.fPairs;
        }

        public String getLocalizedRequest() {
            return this.toString();
        }
    }

    public static final class PostMessageRequest
    extends DownloadHandlerRequest {
        protected PostMessageRequest(IDownloadContext ctxt, String urlString) {
            super(ctxt, urlString);
        }

        public String toString() {
            return "post:" + this.getUrlString();
        }

        public String getLocalizedRequest() {
            return this.toString();
        }
    }
}

