/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.extObjectInputStream;

public class SealedObject
implements Serializable {
    static final long serialVersionUID = 4482838265551344752L;
    private byte[] encryptedContent = null;
    private String sealAlg = null;
    private String paramsAlg = null;
    protected byte[] encodedParams = null;
    private static final String[] z;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        try {
            this.encryptedContent = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        if (cipher.getParameters() != null) {
            this.encodedParams = cipher.getParameters().getEncoded();
            this.paramsAlg = cipher.getParameters().getAlgorithm();
        }
        this.sealAlg = cipher.getAlgorithm();
    }

    protected SealedObject(SealedObject sealedObject) {
        this.encryptedContent = (byte[])sealedObject.encryptedContent.clone();
        this.sealAlg = sealedObject.sealAlg;
        this.paramsAlg = sealedObject.paramsAlg;
        this.encodedParams = (byte[])(sealedObject.encodedParams != null ? (byte[])sealedObject.encodedParams.clone() : null);
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException(z[1]);
        }
        try {
            return this.a(key, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(z[2]);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try (extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);){
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException(z[1]);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(z[0]);
        }
        try {
            return this.a(key, string);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object a(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            try {
                algorithmParameters = string != null ? AlgorithmParameters.getInstance(this.paramsAlg, string) : AlgorithmParameters.getInstance(this.paramsAlg);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (string == null) {
                    throw new NoSuchAlgorithmException(this.paramsAlg + z[3]);
                }
                throw new NoSuchProviderException(noSuchProviderException.getMessage());
            }
            algorithmParameters.init(this.encodedParams);
        }
        try {
            cipher = string != null ? Cipher.getInstance(this.sealAlg, string) : Cipher.getInstance(this.sealAlg);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(z[4]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (string == null) {
                throw new NoSuchAlgorithmException(this.sealAlg + z[3]);
            }
            throw new NoSuchProviderException(noSuchProviderException.getMessage());
        }
        try {
            if (algorithmParameters != null) {
                cipher.init(2, key, algorithmParameters);
            } else {
                cipher.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try (extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);){
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.encryptedContent != null) {
            this.encryptedContent = (byte[])this.encryptedContent.clone();
        }
        if (this.encodedParams != null) {
            this.encodedParams = (byte[])this.encodedParams.clone();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\f0\u0012;m\u000f>A8v\u000e/\b,a\u0013";
        int n2 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block16;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 97;
                                break;
                            }
                            case 1: {
                                n8 = 89;
                                break;
                            }
                            case 2: {
                                n8 = 97;
                                break;
                            }
                            case 3: {
                                n8 = 72;
                                break;
                            }
                            default: {
                                n8 = 4;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\n<\u0018hm\u0012y\u000f=h\r";
                    n2 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u00005\u0006'v\b-\t%$\u000f6\u0015hb\u000e,\u000f,";
                    n2 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "A7\u000e<$\u00076\u0014&`";
                    n2 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "18\u0005,m\u000f>A<l\u0000-A?e\u0012y\u0014;a\u0005y\b&$\u0012<\u0000$m\u000f>A't\u0004+\u0000<m\u000e7A&k\u0015y\u0000>e\b5\u0000*h\u0004";
                    n2 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }
}

