/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.install.launcher;

import com.ibm.cic.install.info.ILocation;
import com.ibm.cic.install.info.IPackage;
import com.ibm.cic.install.info.InstallInfoUtils;
import com.ibm.cic.install.launcher.internal.Activator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class InstallationManagerLauncher {
    public static final String INPUT_ARG = "-input";
    public static final String RESTART_PACKAGE_ARG = "-restartPackage";

    public static Process runInstallationManager(String[] args) throws CoreException {
        String[] cmd = new String[args.length + 1];
        cmd[0] = InstallInfoUtils.getInstallationManagerLauncherPath();
        System.arraycopy(args, 0, cmd, 1, args.length);
        try {
            return Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            throw InstallationManagerLauncher.newCoreException(e.toString(), e);
        }
    }

    public static Process runApplyLicense() throws CoreException {
        String inputFile = InstallationManagerLauncher.getManageLicensesInputFile();
        return InstallationManagerLauncher.runInstallationManager(new String[]{INPUT_ARG, inputFile});
    }

    public static Process runUninstall(String offeringId, boolean uninstallFeature) throws CoreException {
        ILocation location = InstallInfoUtils.getCurrentLocation();
        String profileId = location.getId();
        String inputFile = uninstallFeature ? InstallationManagerLauncher.getModifyInputFile(profileId, offeringId) : InstallationManagerLauncher.getUninstallInputFile(profileId, offeringId);
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(INPUT_ARG);
        argList.add(inputFile);
        IPackage imPkg = InstallInfoUtils.getInstallationManagerPackage();
        Version version = imPkg.getVersion();
        Version earliestVersionWithRestartPackageArg = new Version("1.2.0.20080430_0100");
        if (earliestVersionWithRestartPackageArg.compareTo(version) <= 0) {
            argList.add(RESTART_PACKAGE_ARG);
        }
        String[] args = argList.toArray(new String[argList.size()]);
        return InstallationManagerLauncher.runInstallationManager(args);
    }

    public static String getInputFile(String command) throws CoreException {
        try {
            File file = File.createTempFile("im-input-", ".xml");
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<agent-input>");
            writer.println(command);
            writer.println("</agent-input>");
            writer.close();
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            throw InstallationManagerLauncher.newCoreException(e.toString(), e);
        }
    }

    public static String getManageLicensesInputFile() throws CoreException {
        return InstallationManagerLauncher.getInputFile("<license/>");
    }

    public static String getOfferingOperationInputFile(String operation, String profileId, String offeringId) throws CoreException {
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(operation).append('>');
        sb.append("<offering profile='").append(profileId).append('\'');
        if (offeringId != null) {
            sb.append(" id='").append(offeringId).append('\'');
        }
        sb.append("/>");
        sb.append("</").append(operation).append('>');
        return InstallationManagerLauncher.getInputFile(sb.toString());
    }

    public static String getUninstallInputFile(String profileId, String offeringId) throws CoreException {
        return InstallationManagerLauncher.getOfferingOperationInputFile("uninstall", profileId, offeringId);
    }

    public static String getModifyInputFile(String profileId, String offeringId) throws CoreException {
        return InstallationManagerLauncher.getOfferingOperationInputFile("modify", profileId, offeringId);
    }

    private static CoreException newCoreException(String msg, Throwable t) {
        Status status = new Status(4, Activator.getPluginId(), 4, msg, t);
        return new CoreException((IStatus)status);
    }

    private InstallationManagerLauncher() {
    }
}

