/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import java.security.MessageDigest;
import java.util.Arrays;

public class PKCS12GenDeprecatedKey {
    public static byte[] pfxComputeKeyIVBuffer(byte[] bmppassword, byte[] salt, int iterationCount, int generatedBytes, MessageDigest digestAlgorithm) {
        return PKCS12GenDeprecatedKey.computeKey(bmppassword, salt, iterationCount, generatedBytes, digestAlgorithm, 64, (byte)2);
    }

    public static byte[] pfxComputeKeyMaterialBuffer(byte[] bmppassword, byte[] salt, int iterationCount, int generatedBytes, MessageDigest digestAlgorithm) {
        return PKCS12GenDeprecatedKey.computeKey(bmppassword, salt, iterationCount, generatedBytes, digestAlgorithm, 64, (byte)1);
    }

    private static byte[] computeKey(byte[] password, byte[] salt, int iterationCount, int generatedBytes, MessageDigest digestAlgorithm, int digestBlock, byte diversifier) {
        byte[] myA;
        int i;
        int passwdLen = password.length;
        int saltLen = salt.length;
        byte[] passwdPtr = password;
        byte[] saltPtr = salt;
        int digestSize = digestAlgorithm.getDigestLength();
        int cPasswdLen = (int)Math.ceil((double)passwdLen / (double)digestBlock) * digestBlock;
        int cSaltLen = (int)Math.ceil((double)saltLen / (double)digestBlock) * digestBlock;
        byte[] concat = new byte[digestBlock + cPasswdLen + cSaltLen];
        Arrays.fill(concat, 0, digestBlock, diversifier);
        int j = 0;
        for (i = digestBlock; i < digestBlock + cSaltLen; ++i) {
            concat[i] = saltPtr[j];
            j = (j + 1) % saltLen;
        }
        j = 0;
        for (i = digestBlock + cSaltLen; i < digestBlock + cSaltLen + cPasswdLen; ++i) {
            concat[i] = passwdPtr[j];
            j = (j + 1) % passwdLen;
        }
        byte[] pmyA = myA = new byte[(int)Math.ceil((double)generatedBytes / (double)digestSize) * digestSize];
        for (i = 0; i < generatedBytes; i += digestSize) {
            byte[] bmyDSP = (byte[])concat.clone();
            byte[] tmpKeyBuffer = digestAlgorithm.digest(bmyDSP);
            j = iterationCount;
            while (--j > 0) {
                tmpKeyBuffer = digestAlgorithm.digest(tmpKeyBuffer);
            }
            System.arraycopy(tmpKeyBuffer, 0, pmyA, i, digestSize);
            if (i + digestSize >= generatedBytes) continue;
            for (int r = cPasswdLen + cSaltLen; r >= digestBlock; r -= digestBlock) {
                int accu = 1;
                for (int k = digestBlock - 1; k >= 0; --k) {
                    concat[k + r] = (byte)((accu += (pmyA[i + k % digestSize] & 0xFF) + (concat[k + r] & 0xFF)) & 0xFF);
                    accu >>= 8;
                }
            }
        }
        byte[] keyBuffer = new byte[generatedBytes];
        System.arraycopy(pmyA, 0, keyBuffer, 0, generatedBytes);
        return keyBuffer;
    }
}

