/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import java.math.BigInteger;
import java.util.Random;

public final class IDLCKeyGen
extends CryptoTransform {
    private BigInteger aC;
    private BigInteger aB;
    private BigInteger ay;
    private int aA = 0;
    private int az = 0;

    public IDLCKeyGen() {
        super("IDLCKeyGen");
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n, objectArray, random);
        if (n != 5 || random == null || objectArray == null || objectArray.length != 3) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        byte[] byArray = (byte[])objectArray[0];
        byte[] byArray2 = (byte[])objectArray[1];
        byte[] byArray3 = (byte[])objectArray[2];
        this.a(byArray, byArray2, byArray3);
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            this.aC = new BigInteger(1, byArray);
            this.aB = new BigInteger(1, byArray2);
            this.ay = new BigInteger(1, byArray3);
            this.aA = byArray2.length;
            this.az = byArray.length;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("invalid parameters.");
        }
    }

    public int outputSize(int n, boolean bl) {
        return 0;
    }

    public void reset() {
        super.reset();
        this.aC = null;
        this.aB = null;
        this.ay = null;
        this.aA = 0;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        byte[] byArray2;
        byte[] byArray3;
        if (this.rnd == null || this.ay == null || this.aB == null) {
            throw new IllegalStateException("no rnd or parameters");
        }
        byte[] byArray4 = new byte[2 * this.aA];
        this.rnd.nextBytes(byArray4);
        BigInteger bigInteger = new BigInteger(1, byArray4);
        BigInteger bigInteger2 = bigInteger.mod(this.aB);
        byte[] byArray5 = bigInteger2.toByteArray();
        if (byArray5.length > this.aA) {
            byArray3 = new byte[this.aA];
            System.arraycopy(byArray5, byArray5.length - this.aA, byArray3, 0, this.aA);
        } else {
            byArray3 = byArray5;
        }
        BigInteger bigInteger3 = this.ay.modPow(bigInteger2, this.aC);
        byte[] byArray6 = bigInteger3.toByteArray();
        if (byArray6.length > this.az) {
            byArray2 = new byte[this.az];
            System.arraycopy(byArray6, byArray6.length - this.az, byArray2, 0, this.az);
        } else {
            byArray2 = byArray6;
        }
        return new Object[]{byArray3, byArray2};
    }
}

