/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSADP;
import com.certicom.ecc.rsa.RSAEP;
import com.certicom.ecc.rsa.RSAPrimitive;
import com.certicom.ecc.rsa.RSAPrivateKey;
import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.rsa.outputSizeSelectable;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RSA
extends CryptoTransform {
    private RSAPrimitive byte;
    private CryptoTransform else;
    private int goto;
    private byte[] char;
    private boolean case;

    public RSA() {
        super("RSA");
    }

    private byte[] do(byte[] byArray, int n) {
        BigInteger bigInteger = Conversion.OS2IP(byArray);
        BigInteger bigInteger2 = this.byte.calc(bigInteger);
        return Conversion.I2OSP(bigInteger2, n);
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n, objectArray, random);
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            this.reset();
            throw new IllegalArgumentException("wrong mode");
        }
        if (objectArray != null && objectArray.length >= 2) {
            String string = (String)objectArray[1];
            if (string.equals("RawExpRsa")) {
                this.case = true;
            }
            if (this.case && (n == 1 || n == 2)) {
                this.reset();
                throw new IllegalArgumentException("rawExpRsa supports only encrypt/decrypt");
            }
            boolean bl = objectArray[0] instanceof RSAPublicKey;
            if (n == 1 && bl) {
                this.reset();
                throw new IllegalArgumentException("wrong key for sign.");
            }
            if (n == 2 && !bl) {
                this.reset();
                throw new IllegalArgumentException("wrong key for verify.");
            }
            if (bl) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)objectArray[0];
                if (!(this.byte instanceof RSAEP)) {
                    this.byte = new RSAEP(rSAPublicKey);
                } else {
                    this.byte.setKey(rSAPublicKey);
                }
                this.goto = rSAPublicKey.n().bitLength() + 7 >>> 3;
            } else {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)objectArray[0];
                if (!(this.byte instanceof RSADP)) {
                    this.byte = new RSADP(rSAPrivateKey);
                } else {
                    this.byte.setKey(rSAPrivateKey);
                }
                this.goto = rSAPrivateKey.hasExponents() ? rSAPrivateKey.n().bitLength() + 7 >>> 3 : rSAPrivateKey.p().multiply(rSAPrivateKey.q()).bitLength() + 7 >>> 3;
            }
            if (this.case) {
                return;
            }
            if (this.else == null || !this.else.getAlgorithm().equals(string)) {
                this.else = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, (String)objectArray[1]);
            }
            Object[] objectArray2 = null;
            if (objectArray.length >= 3) {
                objectArray2 = (Object[])objectArray[2];
            }
            this.else.init(5, objectArray2, random);
        }
    }

    public int inputSize() {
        if (this.mode == 3 || this.mode == 4) {
            if (this.case) {
                return this.goto;
            }
            if (this.else instanceof outputSizeSelectable) {
                return ((outputSizeSelectable)((Object)this.else)).maxIn(this.goto - 1);
            }
            return this.goto;
        }
        if (this.mode == 1 || this.mode == 2) {
            return 0;
        }
        throw new IllegalStateException("wrong mode.");
    }

    public int outputSize(int n, boolean bl) {
        if (this.mode == 3 || this.mode == 1 && bl) {
            return this.goto;
        }
        if (this.mode == 4) {
            if (this.case) {
                return this.goto;
            }
            return this.else.outputSize(this.goto - 1, true);
        }
        if (this.mode == 2 || this.mode == 1 && !bl) {
            return 0;
        }
        throw new IllegalStateException("wrong mode");
    }

    public void reset() {
        super.reset();
        if (this.byte != null) {
            this.byte.reset();
        }
        if (this.else != null) {
            this.else.reset();
        }
        this.goto = 0;
        this.char = null;
        this.case = false;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.mode == 3 || this.mode == 4 || this.mode == 1 || this.mode == 2) {
            int n4;
            if (this.case) {
                if (byArray == null || n2 != this.goto) {
                    throw new IllegalArgumentException("in size != modulus size.");
                }
                if (byArray2 == null || byArray2.length - n3 != this.goto) {
                    throw new IllegalArgumentException("out size != modulus size");
                }
                byte[] byArray3 = new byte[this.goto];
                System.arraycopy(byArray, n, byArray3, 0, this.goto);
                byArray3 = this.do(byArray3, this.goto);
                System.arraycopy(byArray3, 0, byArray2, n3, this.goto);
                return this.goto;
            }
            byte[] byArray4 = null;
            if (!(bl || this.mode != 3 && this.mode != 4)) {
                throw new IllegalArgumentException("ENC/DEC not incremental");
            }
            if (this.mode != 4) {
                if (bl) {
                    byArray4 = new byte[this.goto - 1];
                }
                try {
                    this.else.transform(byArray, n, n2, byArray4, 0, bl);
                    if (this.mode == 2 && bl) {
                        this.char = byArray4;
                        return 0;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.mode != 2) {
                        throw illegalArgumentException;
                    }
                    return 0;
                }
                if (!bl) {
                    return 0;
                }
                n4 = this.goto;
            } else {
                byArray4 = new byte[n2];
                System.arraycopy(byArray, n, byArray4, 0, byArray4.length);
                n4 = this.goto - 1;
            }
            byArray4 = this.do(byArray4, n4);
            if (this.mode == 4) {
                byArray4 = this.else.transform(byArray4, 0, byArray4.length, true);
            }
            System.arraycopy(byArray4, 0, byArray2, n3, byArray4.length);
            return byArray4.length;
        }
        throw new IllegalStateException("wrong mode");
    }

    public boolean verify(byte[] byArray, int n, int n2) {
        if (this.mode != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (n2 != this.goto || this.char == null) {
            return false;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = this.do(byArray2, this.goto - 1);
        if (this.char.length != byArray3.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.char.length && this.char[n3] == byArray3[n3]) {
            ++n3;
        }
        return n3 == this.char.length;
    }
}

