/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.rsa.RSAPrivateKey;
import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.system.SystemConfig;
import com.trustpoint.security.provider.RSAPrivateKeyCrtImpl;
import com.trustpoint.security.provider.RSAPublicKeyImpl;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RSAKeyFactorySpi
extends KeyFactorySpi {
    private static final Class if = class$java$security$spec$RSAPrivateCrtKeySpec != null ? class$java$security$spec$RSAPrivateCrtKeySpec : (class$java$security$spec$RSAPrivateCrtKeySpec = RSAKeyFactorySpi.class$("java.security.spec.RSAPrivateCrtKeySpec"));
    private static final Class a = class$java$security$spec$RSAPublicKeySpec != null ? class$java$security$spec$RSAPublicKeySpec : (class$java$security$spec$RSAPublicKeySpec = RSAKeyFactorySpi.class$("java.security.spec.RSAPublicKeySpec"));
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new b((RSAPrivateCrtKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new a((RSAPublicKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof java.security.interfaces.RSAPublicKey && a.isAssignableFrom(clazz)) {
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
            return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        if (key instanceof RSAPrivateCrtKey && if.isAssignableFrom(clazz)) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }
        throw new InvalidKeySpecException("do not support " + key.getClass().getName());
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof b) {
            return key;
        }
        if (key instanceof a) {
            return key;
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new b((RSAPrivateCrtKey)key);
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            return new a((java.security.interfaces.RSAPublicKey)key);
        }
        throw new InvalidKeyException("invalid key" + key.getClass().getName());
    }

    static class b
    extends RSAPrivateKey
    implements RSAPrivateCrtKey {
        protected b(RSAPrivateKey rSAPrivateKey) {
            super(rSAPrivateKey.n(), rSAPrivateKey.e(), rSAPrivateKey.d(), rSAPrivateKey.p(), rSAPrivateKey.q(), rSAPrivateKey.dP(), rSAPrivateKey.dQ(), rSAPrivateKey.qInv());
        }

        protected b(RSAPrivateCrtKey rSAPrivateCrtKey) {
            super(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }

        protected b(RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
            super(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public BigInteger getCrtCoefficient() {
            return this.qInv();
        }

        public byte[] getEncoded() {
            if (SystemConfig.getConfig().getFormat() == 10) {
                throw new IllegalStateException("need Trustpoint toolkit.");
            }
            return new RSAPrivateKeyCrtImpl(this.n(), this.e(), this.d(), this.p(), this.q(), this.dP(), this.dQ(), this.qInv()).getEncoded();
        }

        public String getFormat() {
            return "RAW";
        }

        public BigInteger getModulus() {
            return this.n();
        }

        public BigInteger getPrimeExponentP() {
            return this.dP();
        }

        public BigInteger getPrimeExponentQ() {
            return this.dQ();
        }

        public BigInteger getPrimeP() {
            return this.p();
        }

        public BigInteger getPrimeQ() {
            return this.q();
        }

        public BigInteger getPrivateExponent() {
            return this.d();
        }

        public BigInteger getPublicExponent() {
            return this.e();
        }
    }

    static class a
    extends RSAPublicKey
    implements java.security.interfaces.RSAPublicKey {
        protected a(java.security.interfaces.RSAPublicKey rSAPublicKey) {
            super(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }

        protected a(RSAPublicKeySpec rSAPublicKeySpec) {
            super(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public byte[] getEncoded() {
            if (SystemConfig.getConfig().getFormat() == 10) {
                throw new IllegalStateException("need Trustpoint toolkit.");
            }
            return new RSAPublicKeyImpl(this.n(), this.e()).getEncoded();
        }

        public String getFormat() {
            return "RAW";
        }

        public BigInteger getModulus() {
            return this.n();
        }

        public BigInteger getPublicExponent() {
            return this.e();
        }
    }
}

