/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.jcae.CurveList;
import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ECKPGenSpi
extends KeyPairGenerator {
    private SecureRandom for;
    private AlgorithmParameterSpec if;
    private CryptoTransform do = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "KEYGEN");
    private int int = SystemConfig.getConfig().getFormat();
    private int a = SystemConfig.getConfig().getPtCompression();

    public ECKPGenSpi() {
        super("ECDSA");
    }

    public KeyPair generateKeyPair() {
        if (this.for == null) {
            this.for = new SecureRandom();
        }
        if (this.if == null) {
            this.if = CurveList.byName("sect163k1");
        }
        if (this.do.getMode() == 0) {
            try {
                this.initialize(this.if, this.for);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {}
        }
        ECKey[] eCKeyArray = (ECKey[])this.do.transformToObject(null, 0, 0, true);
        return new KeyPair(new ECPublicKey(this.int, this.a, (com.certicom.ecc.interfaces.ECPublicKey)eCKeyArray[1]), new ECPrivateKey(this.int, (com.certicom.ecc.interfaces.ECPrivateKey)eCKeyArray[0]));
    }

    public void initialize(int n, SecureRandom secureRandom) {
        try {
            this.initialize(CurveList.bySize(n, 2), secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ECParams)) {
            throw new InvalidAlgorithmParameterException("wrong params");
        }
        this.if = algorithmParameterSpec;
        this.for = secureRandom;
        this.do.init(5, new Object[]{this.if}, this.for);
    }
}

