/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.asn1;

import com.certicom.ecc.asn1.ECConverter;
import com.certicom.ecc.asn1.Parameters;
import com.certicom.ecc.asn1.SECGPrivKeyCodec;
import com.trustpoint.asn.AsnException;
import com.trustpoint.asn.AsnObject;
import com.trustpoint.asn.AsnObjectId;
import com.trustpoint.asn.AsnOctetString;
import com.trustpoint.asn.AsnSequence;
import com.trustpoint.pkcs.pkcs8.PrivateKeyAlgorithmIdentifier;
import com.trustpoint.pkcs.pkcs8.PrivateKeyInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PKCSPrivKeyCodec
extends SECGPrivKeyCodec {
    private static final AsnObjectId if = new AsnObjectId("1.2.840.10045.2.1");

    public PKCSPrivKeyCodec() {
        super("PKCS#8");
    }

    protected void decode() {
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
        try {
            privateKeyInfo.decode(byArray, 1);
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot decode key: " + asnException.getLocalizedMessage());
        }
        AsnSequence asnSequence = (AsnSequence)privateKeyInfo.getValue(1);
        if (!asnSequence.getValue(0).equals(if)) {
            throw new IllegalArgumentException(String.valueOf(privateKeyInfo.getAlgorithm()) + " not an ECPrivateKey.");
        }
        AsnOctetString asnOctetString = (AsnOctetString)privateKeyInfo.getValue(2);
        byArray = asnOctetString.getValue();
        if (this.data.length > byArray.length) {
            System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        } else {
            this.data = byArray;
        }
        this.doff = byArray.length;
        byArray = null;
        super.decode();
    }

    protected void encode() {
        super.encode();
        Parameters parameters = ECConverter.toParameters(this.curve);
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new PrivateKeyAlgorithmIdentifier(if, (AsnObject)parameters), new AsnOctetString((byte[])this.result[1]), null);
        try {
            this.result[1] = privateKeyInfo.encode(2);
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot encode key" + asnException.getLocalizedMessage());
        }
    }
}

