/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.asn1;

import com.certicom.ecc.asn1.ECConverter;
import com.certicom.ecc.asn1.Parameters;
import com.certicom.ecc.codec.ECCodec;
import com.trustpoint.asn.AsnBitString;
import com.trustpoint.asn.AsnException;
import com.trustpoint.asn.AsnObject;
import com.trustpoint.asn.AsnObjectId;
import com.trustpoint.pkix.pkix1explicit.AlgorithmIdentifier;
import com.trustpoint.pkix.pkix1explicit.PublicKeyAlgorithmIdentifier;
import com.trustpoint.pkix.pkix1explicit.SubjectPublicKeyInfo;

public class ECPubKeyCodec
extends ECCodec {
    private static final AsnObjectId a = new AsnObjectId("1.2.840.10045.2.1");

    public ECPubKeyCodec() {
        super("X.509");
    }

    protected void decode() {
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo();
        try {
            subjectPublicKeyInfo.decode(byArray, 1);
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot decode key: " + asnException.getLocalizedMessage());
        }
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)subjectPublicKeyInfo.getValue(0);
        if (!algorithmIdentifier.getValue(0).equals(a)) {
            throw new IllegalArgumentException(String.valueOf(subjectPublicKeyInfo.getAlgorithm()) + " not ECPublicKey.");
        }
        Object[] objectArray = ECConverter.toValues((Parameters)algorithmIdentifier.getValue(1));
        if (objectArray == null || objectArray.length == 1) {
            this.initResult(3);
            this.result[1] = objectArray == null ? "ImplicitlyCA" : objectArray[0];
        } else {
            this.initResult(3 + objectArray.length);
            this.result[1] = "ECParameters";
            int n = 3;
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.result[n] = objectArray[n2];
                ++n;
                ++n2;
            }
        }
        this.result[2] = subjectPublicKeyInfo.getRawKey();
        objectArray = null;
    }

    protected void encode() {
        this.initResult(this.outputSize());
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        Parameters parameters = ECConverter.toParameters(this.curve);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new PublicKeyAlgorithmIdentifier(a, (AsnObject)parameters), new AsnBitString(byArray));
        try {
            byArray = subjectPublicKeyInfo.encode(2);
            this.result[1] = byArray;
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot encode key: " + asnException.getLocalizedMessage());
        }
    }

    protected void initResult(int n) {
        super.initResult(n);
        this.result[0] = "ECPublicKey";
    }

    public int outputSize() {
        return super.outputSize() + 1;
    }
}

