/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.ui.extensions;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.VariableSubstitution;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.licenses.Messages;
import com.ibm.cic.agent.ui.extensions.AbstractAgentWizardPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.ws.sync.core.SyncLocation;
import com.ibm.ws.sync.core.internal.SyncUtil;
import com.ibm.ws.sync.internal.ui.SyncUIUtil;
import com.ibm.ws.sync.ui.extensions.ImportWASWizard;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ImportWASWizardPage
extends AbstractAgentWizardPage {
    private ManagedForm managedForm;
    private Button browseButton;
    private Combo wasPathCombo;
    private IStatus validateLocationStatus;
    private IStatus getRepositoryGroupStatus;
    private IStatus lookupStatus;
    private boolean canFlipToNextPage = false;
    private SyncLocation syncLocation = null;
    private static final Logger log = Logger.getLogger(ImportWASWizardPage.class);
    private static final String PRODUCT_NAME_PREFIX = "- ";

    protected ImportWASWizardPage() {
        super(Messages.InstallLocationPage_title);
    }

    protected ImportWASWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        final Composite outer = new Composite(parent, 0);
        outer.setLayout((Layout)new FillLayout());
        FormToolkit toolkit = CicCommonUiPlugin.getDefault().getFormToolkit();
        this.managedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(outer));
        Composite formBody = this.managedForm.getForm().getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 15;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        formBody.setLayout((Layout)layout);
        toolkit.setBorderStyle(0);
        Composite instructionContainer = toolkit.createComposite(formBody, 2048);
        GridLayout instructionLayout = new GridLayout();
        instructionLayout.marginTop = 5;
        instructionLayout.numColumns = 1;
        instructionContainer.setLayout((Layout)instructionLayout);
        instructionContainer.setLayoutData((Object)new TableWrapData(256));
        FormText specifyLocationText = toolkit.createFormText(instructionContainer, false);
        GridData detailGridData = new GridData(770);
        detailGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        GC gc1 = new GC((Drawable)specifyLocationText);
        Point textSize = gc1.stringExtent(" ");
        gc1.dispose();
        detailGridData.heightHint = textSize.y * 4;
        specifyLocationText.setLayoutData((Object)detailGridData);
        specifyLocationText.setText(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_specifyLocationInfo, true, false);
        if (!com.ibm.ws.sync.internal.ui.Messages.ImportWAS_additionalInfo.equalsIgnoreCase("<form></form>")) {
            FormText additionalInfoText = toolkit.createFormText(instructionContainer, false);
            GridData additionalInfoGridData = new GridData(770);
            additionalInfoGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            additionalInfoGridData.heightHint = textSize.y * 3;
            additionalInfoText.setLayoutData((Object)additionalInfoGridData);
            additionalInfoText.setText(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_additionalInfo, true, false);
        }
        Composite inputContainer = toolkit.createComposite(formBody);
        GridLayout inputLayout = new GridLayout();
        inputLayout.marginTop = 5;
        inputLayout.numColumns = 3;
        inputContainer.setLayout((Layout)inputLayout);
        inputContainer.setLayoutData((Object)new TableWrapData(256));
        Label installedDirectoryLabel = toolkit.createLabel(inputContainer, "", 0);
        installedDirectoryLabel.setText(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_InstalledDirectory);
        this.wasPathCombo = new Combo(inputContainer, 4);
        this.wasPathCombo.setLayoutData((Object)new GridData(1808));
        this.wasPathCombo.setItems(SyncUIUtil.getAllWASLocations());
        this.wasPathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String directory = ((Combo)e.widget).getText();
                if (directory.length() > 0) {
                    File wasPath = new File(directory);
                    if (wasPath.exists()) {
                        ImportWASWizardPage.this.canFlipToNextPage = true;
                    } else {
                        ImportWASWizardPage.this.canFlipToNextPage = SyncUtil.findExistingProfile((String)directory) != null;
                    }
                } else {
                    ImportWASWizardPage.this.canFlipToNextPage = false;
                }
                ImportWASWizardPage.this.updateButtons();
                if (ImportWASWizardPage.this.getErrorMessage() != null) {
                    ImportWASWizardPage.this.setErrorMessage(null);
                }
                if (ImportWASWizardPage.this.getMessage() != null) {
                    ImportWASWizardPage.this.setMessage(null);
                }
            }
        });
        this.browseButton = toolkit.createButton(inputContainer, com.ibm.cic.agent.internal.ui.Messages.CommonLocationPage_browseButton, 8);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(outer.getShell());
                dialog.setText(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_commonDialogTitle);
                dialog.setMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_SelectDirectory);
                String dir = ImportWASWizardPage.this.wasPathCombo.getText().trim();
                String deprocessedDir = TextProcessor.deprocess((String)dir);
                dialog.setFilterPath(deprocessedDir);
                String directory = dialog.open();
                if (directory != null) {
                    String trimedDirectory = directory.trim();
                    String displayDirectory = TextProcessor.process((String)trimedDirectory);
                    ImportWASWizardPage.this.wasPathCombo.setText(displayDirectory);
                }
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)outer);
    }

    public boolean canFlipToNextPage() {
        return this.canFlipToNextPage;
    }

    public boolean isPageComplete() {
        return this.canFlipToNextPage;
    }

    private boolean performLookup(final String wasPath) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                IRunnableWithProgress runnableLookup;
                                block13: {
                                    block12: {
                                        IRunnableWithProgress runnablePrepare = new IRunnableWithProgress(){

                                            public void run(IProgressMonitor monitor) {
                                                monitor.beginTask(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_importing, 3);
                                                try {
                                                    ImportWASWizardPage.this.syncLocation = new SyncLocation(wasPath);
                                                    ((ImportWASWizard)ImportWASWizardPage.this.getWizard()).setSyncLocation(ImportWASWizardPage.this.syncLocation);
                                                    ImportWASWizardPage.this.validateLocationStatus = ImportWASWizardPage.this.syncLocation.validateLocation();
                                                    if (ImportWASWizardPage.this.validateLocationStatus.getSeverity() == 4) {
                                                        Profile profile = SyncUtil.findExistingProfile((String)wasPath);
                                                        if (profile != null) {
                                                            CicMultiStatus status = Statuses.ST.createMultiStatus(4, "PACKAGE_GROUP_NOT_AVALIABLE", new Object[0]);
                                                            status.add((IStatus)new Status(4, "com.ibm.ws.sync.ui", profile.getProfileId()));
                                                            ImportWASWizardPage.this.validateLocationStatus = (IStatus)status;
                                                        }
                                                        return;
                                                    }
                                                    monitor.worked(1);
                                                    ImportWASWizardPage.this.getRepositoryGroupStatus = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(true, monitor);
                                                    if (ImportWASWizardPage.this.getRepositoryGroupStatus.matches(8)) {
                                                        return;
                                                    }
                                                    if (monitor.isCanceled()) {
                                                        ImportWASWizardPage.this.getRepositoryGroupStatus = Status.CANCEL_STATUS;
                                                        return;
                                                    }
                                                    monitor.worked(2);
                                                }
                                                finally {
                                                    monitor.done();
                                                }
                                            }
                                        };
                                        runnableLookup = new IRunnableWithProgress(){

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public void run(IProgressMonitor monitor) {
                                                monitor.beginTask(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_importing, 2);
                                                try {
                                                    List offerings = SyncUtil.getAllOfferingsFromRegisteredRepositories((IProgressMonitor)monitor);
                                                    if (offerings.size() < 1) {
                                                        ImportWASWizardPage.this.getRepositoryGroupStatus = (IStatus)new Status(4, "com.ibm.ws.sync.ui", com.ibm.ws.sync.internal.ui.Messages.ImportWAS_NoOffering);
                                                        return;
                                                    }
                                                    monitor.worked(1);
                                                    ImportWASWizardPage.this.lookupStatus = (IStatus)ImportWASWizardPage.this.syncLocation.performLookup(monitor);
                                                    if (!monitor.isCanceled()) return;
                                                    ImportWASWizardPage.this.lookupStatus = Status.CANCEL_STATUS;
                                                    return;
                                                }
                                                finally {
                                                    monitor.done();
                                                }
                                            }
                                        };
                                        log.info(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_performing_lookup, new Object[]{wasPath});
                                        try {
                                            this.validateLocationStatus = ICicStatus.OK_STATUS;
                                            this.getRepositoryGroupStatus = ICicStatus.OK_STATUS;
                                            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnablePrepare);
                                            if (this.validateLocationStatus.getSeverity() != 4) break block12;
                                            this.showAndLogErrorMessage(this.validateLocationStatus, false);
                                            return false;
                                        }
                                        catch (Exception e) {
                                            AgentUI.reportException((Throwable)e);
                                            return false;
                                        }
                                    }
                                    if (!this.getRepositoryGroupStatus.matches(8)) break block13;
                                    return false;
                                }
                                if (this.getRepositoryGroupStatus.getSeverity() == 4) {
                                    SyncUIUtil.displayMessages(this.getRepositoryGroupStatus, true);
                                    this.getRepositoryGroupStatus = Status.OK_STATUS;
                                }
                                this.lookupStatus = null;
                                CicCommonUiPlugin.getDefault().runWithSocketMonitor(false, runnableLookup);
                                if (this.getRepositoryGroupStatus.getSeverity() != 4) break block14;
                                this.showAndLogErrorMessage(this.getRepositoryGroupStatus, true);
                                return false;
                            }
                            if (this.lookupStatus != null) break block15;
                            return false;
                        }
                        if (!this.lookupStatus.matches(8)) break block16;
                        return false;
                    }
                    IStatus missingOfferingStatus = this.checkMissingOfferings(this.syncLocation);
                    if (missingOfferingStatus.getSeverity() != 4) break block17;
                    this.showAndLogErrorMessage(missingOfferingStatus, false);
                    return false;
                }
                if (this.lookupStatus.getSeverity() != 4) break block18;
                this.showAndLogErrorMessage(this.lookupStatus, false);
                return false;
            }
            if (this.syncLocation.requiresSynchronization()) break block19;
            String msg = this.getMessage();
            this.setMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_already_imported, com.ibm.ws.sync.internal.ui.Messages.ImportWAS_already_imported.equals(msg) ? 2 : 1);
            return false;
        }
        IStatus allowImport = this.syncLocation.verifyImportProfile();
        if (allowImport.getSeverity() == 4) {
            this.showAndLogErrorMessage(allowImport, false);
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage() {
        if (this.performLookup(this.wasPathCombo.getText().trim())) {
            return super.getNextPage();
        }
        this.updateButtons();
        return this;
    }

    public String getDefaultCommonLocation() {
        IOffering baseOffering;
        String defaultCommonLocation = null;
        if (this.syncLocation != null && (baseOffering = this.syncLocation.getBaseOffering()) != null && (defaultCommonLocation = PlatformUtils.getDefaultSharedLocation((IOffering)baseOffering)) != null) {
            try {
                defaultCommonLocation = VariableSubstitution.getInstance().performVariableSubstitutions(defaultCommonLocation, AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
            }
            catch (Exception exception) {
                defaultCommonLocation = null;
            }
        }
        if (defaultCommonLocation == null || defaultCommonLocation.length() == 0) {
            defaultCommonLocation = PlatformUtils.getDefaultSharedLocation(null);
        }
        return defaultCommonLocation;
    }

    private IStatus checkMissingOfferings(SyncLocation sl) {
        IProfile syncProfile = sl.getProfile();
        if (syncProfile == null) {
            SyncLocation.InstalledOffering[] offeringsToInstall = this.syncLocation.getOfferingsToInstall();
            if (offeringsToInstall.length < 1 || this.syncLocation.getBaseOffering() == null) {
                SyncLocation.InstalledOffering[] unknownInstalledOfferings;
                CicMultiStatus noBaseOfferingStatus = Statuses.ST.createMultiStatus("ERROR_SYNC_NO_BASE_OFFERING", new Object[0]);
                SyncLocation.InstalledOffering[] installedOfferingArray = unknownInstalledOfferings = this.syncLocation.getUnknownInstalledOfferings();
                int n = unknownInstalledOfferings.length;
                int n2 = 0;
                while (n2 < n) {
                    SyncLocation.InstalledOffering unknownInstalledOffering = installedOfferingArray[n2];
                    noBaseOfferingStatus.add((IStatus)new Status(4, "com.ibm.ws.sync.ui", PRODUCT_NAME_PREFIX + unknownInstalledOffering.getProductName()));
                    ++n2;
                }
                return noBaseOfferingStatus;
            }
        } else {
            int n;
            int n3;
            Object[] objectArray;
            CicMultiStatus missingOfferingStatus = Statuses.ST.createMultiStatus("ERROR_RESYNC_MISSING_OFFERING", new Object[0]);
            if (!sl.isBaseOfferingInstalled()) {
                SyncLocation.InstalledOffering[] unknownInstalledOfferings;
                objectArray = unknownInstalledOfferings = sl.getUnknownInstalledOfferings();
                n3 = unknownInstalledOfferings.length;
                n = 0;
                while (n < n3) {
                    SyncLocation.InstalledOffering unknownInstalledOffering = objectArray[n];
                    missingOfferingStatus.add((IStatus)new Status(4, "com.ibm.ws.sync.ui", PRODUCT_NAME_PREFIX + unknownInstalledOffering.getProductName()));
                    ++n;
                }
            }
            String[] offeringsWithoutARepository = sl.getAllOfferingsWithoutARepository();
            objectArray = offeringsWithoutARepository;
            n3 = offeringsWithoutARepository.length;
            n = 0;
            while (n < n3) {
                SyncLocation.InstalledOffering element = objectArray[n];
                missingOfferingStatus.add((IStatus)new Status(4, "com.ibm.ws.sync.ui", PRODUCT_NAME_PREFIX + (String)element));
                ++n;
            }
            return missingOfferingStatus;
        }
        return Status.OK_STATUS;
    }

    private void showAndLogErrorMessage(IStatus status, boolean repositoryError) {
        if (status.isMultiStatus()) {
            if (repositoryError) {
                this.setErrorMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_testConnection_notConnected);
                log.status(status);
            } else if (status.getMessage().equals("PACKAGE_GROUP_NOT_AVALIABLE")) {
                IStatus[] children = status.getChildren();
                this.setErrorMessage(NLS.bind((String)com.ibm.ws.sync.internal.ui.Messages.ImportWAS_package_group_not_available_1, (Object)children[0].getMessage()));
                log.error(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_package_group_not_available, new Object[]{children[0].getMessage()});
            } else if (status.getMessage().equals("ERROR_RESYNC_MISSING_OFFERING")) {
                this.setErrorMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_resynchronization_error_1);
                ArrayList<String> offferingNames = new ArrayList<String>();
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childStatus = iStatusArray[n2];
                    String offeringName = childStatus.getMessage();
                    offferingNames.add(offeringName.replaceFirst(PRODUCT_NAME_PREFIX, ""));
                    ++n2;
                }
                log.status((IStatus)Statuses.ERROR.get(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_synchronization_error, new Object[]{Util.toString(offferingNames, (Util.Formatter)new Util.Formatter(", "))}));
            } else if (status.getMessage().equals("ERROR_SYNC_NO_BASE_OFFERING")) {
                this.setErrorMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_synchronization_error_1);
                ArrayList<String> offferingNames = new ArrayList<String>();
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IStatus childStatus = iStatusArray[n3];
                    String offeringName = childStatus.getMessage();
                    offferingNames.add(offeringName.replaceFirst(PRODUCT_NAME_PREFIX, ""));
                    ++n3;
                }
                log.status((IStatus)Statuses.ERROR.get(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_synchronization_error, new Object[]{Util.toString(offferingNames, (Util.Formatter)new Util.Formatter(", "))}));
            } else {
                String msg = status.getMessage();
                if (msg == null || msg.length() < 1) {
                    IStatus[] children = status.getChildren();
                    if (children.length < 1) {
                        this.setErrorMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_import_error);
                        log.status((IStatus)Statuses.ERROR.get(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_import_error, new Object[0]));
                    } else {
                        this.setErrorMessage(children[0].getMessage());
                        log.status(children[0]);
                        if (children.length == 1) {
                            this.canFlipToNextPage = false;
                            return;
                        }
                    }
                } else {
                    this.setErrorMessage(status.getMessage());
                    log.status(status);
                }
            }
            SyncUIUtil.displayMessages(status, repositoryError);
        } else {
            this.setErrorMessage(status.getMessage());
            log.status(status);
        }
        this.canFlipToNextPage = false;
    }

    public IStatus performFinish(IProgressMonitor monitor) {
        return null;
    }
}

