/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUILabelProvider;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.ws.sync.internal.ui.ImportFix;
import com.ibm.ws.sync.internal.ui.ImportOffering;
import com.ibm.ws.sync.internal.ui.Messages;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SummaryPackageLabelProvider
extends LabelProvider
implements ITableColorProvider,
ITableLabelProvider {
    private final CommonUILabelProvider commonLabelProvider = CicCommonUiPlugin.getDefault().getLabelProvider();
    private final Color disabledColor;

    public SummaryPackageLabelProvider(Display display) {
        this.disabledColor = CommonUIUtils.createDisabledColor((Display)display);
        this.commonLabelProvider.connect((Object)this);
    }

    public void dispose() {
        this.disabledColor.dispose();
        this.commonLabelProvider.disconnect((Object)this);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof ImportFix || element instanceof IFix) {
                return CicCommonUiPlugin.getDefault().getLabelProvider().get(CommonImages.DESC_FIX_OBJ);
            }
            IOffering offering = null;
            if (element instanceof ImportOffering[]) {
                offering = ((ImportOffering[])element)[0].getOffering();
            } else if (element instanceof ImportOffering) {
                offering = ((ImportOffering)element).getOffering();
            } else if (element instanceof IOffering) {
                offering = (IOffering)element;
            }
            if (offering != null) {
                if (Agent.isSelfContainedOffering((IOffering)offering)) {
                    return CicCommonUiPlugin.getDefault().getLabelProvider().get(CommonImages.DESC_OFFERING_OBJ);
                }
                return CicCommonUiPlugin.getDefault().getLabelProvider().get(CommonImages.DESC_EXTENSION_OBJ);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Object colElement;
        Class<?> type = element.getClass();
        Object object = colElement = type.isArray() ? ((Object[])element)[0] : element;
        if (columnIndex == 0) {
            return this.getText(colElement);
        }
        if (columnIndex == 1) {
            return this.getStatusText(colElement);
        }
        if (columnIndex == 2) {
            return this.getVendorText(colElement);
        }
        return "";
    }

    public String getText(Object element) {
        String text = "";
        if (element instanceof ImportOffering) {
            ImportOffering offeringNode = (ImportOffering)element;
            IOffering offering = offeringNode.getOffering();
            text = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering);
        } else if (element instanceof ImportFix) {
            ImportFix fixNode = (ImportFix)element;
            IFix fix = fixNode.getFix();
            text = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)fix);
        } else {
            text = super.getText(element);
        }
        return text;
    }

    public String getStatusText(Object element) {
        String text = "";
        if (element instanceof ImportOffering) {
            ImportOffering offeringNode = (ImportOffering)element;
            text = offeringNode.isOfferingInInventory() ? Messages.ImportWAS_status_in_inventory : Messages.ImportWAS_status_will_be_imported;
        } else if (element instanceof ImportFix) {
            ImportFix fixNode = (ImportFix)element;
            text = fixNode.isFixInInventory() ? Messages.ImportWAS_status_in_inventory : Messages.ImportWAS_status_will_be_imported;
        }
        return text;
    }

    public String getVendorText(Object element) {
        String text = "";
        if (element instanceof ImportOffering) {
            ImportOffering offeringNode = (ImportOffering)element;
            text = offeringNode.getVendor();
        } else if (element instanceof ImportFix) {
            ImportFix fixNode = (ImportFix)element;
            text = fixNode.getVendor();
        }
        return text;
    }

    public Color getForeground(Object element, int columnIndex) {
        if ((columnIndex == 0 || columnIndex == 1 || columnIndex == 2) && (element instanceof ImportOffering ? ((ImportOffering)element).isOfferingInInventory() : element instanceof ImportFix && ((ImportFix)element).isFixInInventory())) {
            return this.disabledColor;
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

