/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.lang.management.ManagementUtils;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class ThreadInfo {
    private long threadId;
    private String threadName;
    private Thread.State threadState;
    private boolean suspended;
    private boolean inNative;
    private long blockedCount;
    private long blockedTime;
    private long waitedCount;
    private long waitedTime;
    private String lockName;
    private long lockOwnerId = -1L;
    private String lockOwnerName;
    private StackTraceElement[] stackTraces = new StackTraceElement[0];
    private LockInfo lockInfo;
    private LockInfo[] lockedSynchronizers = new LockInfo[0];
    private MonitorInfo[] lockedMonitors = new MonitorInfo[0];
    private String TOSTRING_VALUE;

    private ThreadInfo(long l, String string, Thread.State state, boolean bl, boolean bl2, long l2, long l3, long l4, long l5, String string2, long l6, String string3, StackTraceElement[] stackTraceElementArray, LockInfo lockInfo, MonitorInfo[] monitorInfoArray, LockInfo[] lockInfoArray) {
        this.threadId = l;
        this.threadName = string;
        this.threadState = state;
        this.suspended = bl;
        this.inNative = bl2;
        this.blockedCount = l2;
        this.blockedTime = l3;
        this.waitedCount = l4;
        this.waitedTime = l5;
        this.lockName = string2;
        this.lockOwnerId = l6;
        this.lockOwnerName = string3;
        this.stackTraces = stackTraceElementArray;
        this.lockInfo = lockInfo;
        this.lockedMonitors = monitorInfoArray;
        this.lockedSynchronizers = lockInfoArray;
    }

    private ThreadInfo(Thread thread, int n, boolean bl, boolean bl2, long l, long l2, long l3, long l4, StackTraceElement[] stackTraceElementArray, Object object, Thread thread2) {
        this.threadId = thread.getId();
        this.threadName = thread.getName();
        this.threadState = Thread.State.values()[n];
        this.suspended = bl;
        this.inNative = bl2;
        this.blockedCount = l;
        this.blockedTime = l2;
        this.waitedCount = l3;
        this.waitedTime = l4;
        if (thread2 != null) {
            this.lockOwnerId = thread2.getId();
            this.lockOwnerName = thread2.getName();
        }
        this.stackTraces = stackTraceElementArray;
        if (object != null) {
            this.lockName = object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
        }
    }

    private ThreadInfo(Thread thread, int n, boolean bl, boolean bl2, long l, long l2, long l3, long l4, StackTraceElement[] stackTraceElementArray, Object object, Thread thread2, MonitorInfo[] monitorInfoArray, LockInfo[] lockInfoArray) {
        this(thread, n, bl, bl2, l, l2, l3, l4, stackTraceElementArray, object, thread2);
        this.lockedMonitors = monitorInfoArray;
        this.lockedSynchronizers = lockInfoArray;
        if (object != null) {
            this.lockInfo = new LockInfo(object.getClass().getName(), System.identityHashCode(object));
        }
        if (this.lockInfo != null) {
            this.lockName = this.lockInfo.toString();
        }
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTraces;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public MonitorInfo[] getLockedMonitors() {
        return this.lockedMonitors;
    }

    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }

    public static ThreadInfo from(CompositeData compositeData) {
        ThreadInfo threadInfo = null;
        if (compositeData != null) {
            StackTraceElement[] stackTraceElementArray;
            String string;
            long l;
            String string2;
            long l2;
            long l3;
            long l4;
            long l5;
            boolean bl;
            boolean bl2;
            Thread.State state;
            String string3;
            long l6;
            if (!ManagementUtils.getThreadInfoCompositeType().isValue(compositeData)) {
                throw new IllegalArgumentException("CompositeData is not of the expected type.");
            }
            try {
                l6 = (Long)compositeData.get("threadId");
                string3 = (String)compositeData.get("threadName");
                String string4 = (String)compositeData.get("threadState");
                try {
                    state = Thread.State.valueOf(string4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("CompositeData contains an unexpected threadState value.", illegalArgumentException);
                }
                bl2 = (Boolean)compositeData.get("suspended");
                bl = (Boolean)compositeData.get("inNative");
                l5 = (Long)compositeData.get("blockedCount");
                l4 = (Long)compositeData.get("blockedTime");
                l3 = (Long)compositeData.get("waitedCount");
                l2 = (Long)compositeData.get("waitedTime");
                string2 = compositeData.get("lockName") != null ? (String)compositeData.get("lockName") : null;
                l = (Long)compositeData.get("lockOwnerId");
                string = compositeData.get("lockOwnerName") != null ? (String)compositeData.get("lockOwnerName") : null;
                CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("stackTrace");
                stackTraceElementArray = ManagementUtils.getStackTracesFromCompositeDataArray(compositeDataArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalArgumentException("CompositeData object does not contain expected key");
            }
            LockInfo lockInfo = ThreadInfo.recoverLockInfoAttribute(compositeData, string2);
            MonitorInfo[] monitorInfoArray = ThreadInfo.recoverLockedMonitors(compositeData);
            LockInfo[] lockInfoArray = ThreadInfo.recoverLockedSynchronizers(compositeData);
            threadInfo = new ThreadInfo(l6, string3, state, bl2, bl, l5, l4, l3, l2, string2, l, string, stackTraceElementArray, lockInfo, monitorInfoArray, lockInfoArray);
        }
        return threadInfo;
    }

    private static LockInfo[] recoverLockedSynchronizers(CompositeData compositeData) {
        LockInfo[] lockInfoArray;
        try {
            CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("lockedSynchronizers");
            lockInfoArray = ManagementUtils.getLockInfosFromCompositeDataArray(compositeDataArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            lockInfoArray = new LockInfo[]{};
        }
        return lockInfoArray;
    }

    private static MonitorInfo[] recoverLockedMonitors(CompositeData compositeData) {
        MonitorInfo[] monitorInfoArray;
        try {
            CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("lockedMonitors");
            monitorInfoArray = ManagementUtils.getMonitorInfosFromCompositeDataArray(compositeDataArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            monitorInfoArray = new MonitorInfo[]{};
        }
        return monitorInfoArray;
    }

    private static LockInfo recoverLockInfoAttribute(CompositeData compositeData, String string) {
        LockInfo lockInfo = null;
        try {
            CompositeData compositeData2;
            CompositeData compositeData3 = compositeData2 = compositeData.get("lockInfo") != null ? (CompositeData)compositeData.get("lockInfo") : null;
            if (compositeData2 != null) {
                if (!ManagementUtils.getLockInfoCompositeType().isValue(compositeData2)) {
                    throw new IllegalArgumentException("CompositeData is not of the expected type.");
                }
                lockInfo = new LockInfo((String)compositeData2.get("className"), (Integer)compositeData2.get("identityHashCode"));
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            lockInfo = ThreadInfo.createLockInfoFromLockName(string);
        }
        return lockInfo;
    }

    public String toString() {
        if (this.TOSTRING_VALUE == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.threadName + " " + this.threadId + " " + (Object)((Object)this.threadState));
            if (this.stackTraces != null && this.stackTraces.length > 0) {
                stringBuilder.append("\n");
                for (StackTraceElement stackTraceElement : this.stackTraces) {
                    stringBuilder.append(stackTraceElement.toString());
                    stringBuilder.append("\n");
                }
            } else {
                stringBuilder.append(" null\n");
            }
            this.TOSTRING_VALUE = stringBuilder.toString();
        }
        return this.TOSTRING_VALUE;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ThreadInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ThreadInfo threadInfo = (ThreadInfo)object;
        if (threadInfo.getBlockedCount() != this.getBlockedCount()) {
            return false;
        }
        if (threadInfo.getBlockedTime() != this.getBlockedTime()) {
            return false;
        }
        if (threadInfo.getLockName() != null && this.getLockName() != null ? !threadInfo.getLockName().equals(this.getLockName()) : threadInfo.getLockName() != this.getLockName()) {
            return false;
        }
        if (threadInfo.getLockOwnerId() != this.getLockOwnerId()) {
            return false;
        }
        if (threadInfo.getLockOwnerName() != null && this.getLockOwnerName() != null ? !threadInfo.getLockOwnerName().equals(this.getLockOwnerName()) : threadInfo.getLockOwnerName() != this.getLockOwnerName()) {
            return false;
        }
        if (threadInfo.getLockInfo() != null && this.getLockInfo() != null ? !threadInfo.getLockInfo().toString().equals(this.getLockInfo().toString()) : threadInfo.getLockInfo() != this.getLockInfo()) {
            return false;
        }
        if (!Arrays.equals(threadInfo.getStackTrace(), this.getStackTrace())) {
            return false;
        }
        if (threadInfo.getThreadId() != this.getThreadId()) {
            return false;
        }
        if (!threadInfo.getThreadName().equals(this.getThreadName())) {
            return false;
        }
        if (!threadInfo.getThreadState().equals((Object)this.getThreadState())) {
            return false;
        }
        if (threadInfo.getWaitedCount() != this.getWaitedCount()) {
            return false;
        }
        if (threadInfo.getWaitedTime() != this.getWaitedTime()) {
            return false;
        }
        if (threadInfo.isInNative() != this.isInNative()) {
            return false;
        }
        return threadInfo.isSuspended() == this.isSuspended();
    }

    public int hashCode() {
        return new String(Long.toString(this.getBlockedCount()) + Long.toString(this.getBlockedTime()) + this.getLockName() + Long.toString(this.getLockOwnerId()) + this.getLockOwnerName() + Integer.toString(this.getStackTrace().length) + Long.toString(this.getThreadId()) + this.getThreadName() + this.getThreadState().toString() + Long.toString(this.getWaitedCount()) + Long.toString(this.getWaitedTime()) + Boolean.toString(this.isInNative()) + Boolean.toString(this.isSuspended())).hashCode();
    }

    private static LockInfo createLockInfoFromLockName(String string) {
        StringTokenizer stringTokenizer;
        LockInfo lockInfo = null;
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, "@")).countTokens() == 2) {
            try {
                lockInfo = new LockInfo(stringTokenizer.nextToken(), Integer.valueOf(stringTokenizer.nextToken(), 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return lockInfo;
    }
}

