/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.ManagementUtils;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class OpenTypeMappingIHandler
implements InvocationHandler {
    private MBeanServerConnection connection;
    private ObjectName mxBeanObjectName;
    private MBeanInfo info;

    public OpenTypeMappingIHandler(MBeanServerConnection mBeanServerConnection, String string, String string2) throws IOException {
        this.connection = mBeanServerConnection;
        this.setObjectName(string2);
        this.checkBeanIsRegistered();
        this.setInfo(string);
    }

    private void setInfo(String string) {
        this.info = ManagementUtils.getMBeanInfo(string);
        if (this.info == null) {
            throw new IllegalArgumentException("Unknown MXBean type : " + string);
        }
    }

    private void setObjectName(String string) {
        try {
            this.mxBeanObjectName = new ObjectName(string);
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            throw new IllegalArgumentException("Bean name not in valid format.", exception);
        }
    }

    private void checkBeanIsRegistered() throws IOException {
        if (!this.connection.isRegistered(this.mxBeanObjectName)) {
            throw new IllegalArgumentException("Not registered : " + this.mxBeanObjectName);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        switch (this.getInvokeType(method.getName())) {
            case ATTRIBUTE_GETTER: {
                object2 = this.invokeAttributeGetter(method);
                break;
            }
            case ATTRIBUTE_SETTER: {
                object2 = this.invokeAttributeSetter(method, objectArray);
                break;
            }
            case NOTIFICATION_OP: {
                object2 = this.invokeNotificationEmitterOperation(method, objectArray);
                break;
            }
            default: {
                object2 = "toString".equals(method.getName()) && (objectArray == null || objectArray.length == 0) ? "MXBeanProxy(" + this.connection + "[" + this.mxBeanObjectName + "])" : ("getObjectName".equals(method.getName()) && (objectArray == null || objectArray.length == 0) ? this.mxBeanObjectName : this.invokeOperation(method, objectArray));
            }
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object invokeNotificationEmitterOperation(Method method, final Object[] objectArray) throws InstanceNotFoundException, IOException, ListenerNotFoundException {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = null;
        if (method.getName().equals("addNotificationListener")) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceNotFoundException, IOException {
                        OpenTypeMappingIHandler.this.connection.addNotificationListener(OpenTypeMappingIHandler.this.mxBeanObjectName, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                        return null;
                    }
                });
                return mBeanNotificationInfoArray;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)throwable;
                }
                if (!(throwable instanceof IOException)) return mBeanNotificationInfoArray;
                throw (IOException)throwable;
            }
            catch (RuntimeMBeanException runtimeMBeanException) {
                throw runtimeMBeanException.getTargetException();
            }
        }
        if (method.getName().equals("getNotificationInfo")) {
            return this.info.getNotifications();
        }
        if (!method.getName().equals("removeNotificationListener")) return mBeanNotificationInfoArray;
        if (objectArray.length == 1) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceNotFoundException, ListenerNotFoundException, IOException {
                        OpenTypeMappingIHandler.this.connection.removeNotificationListener(OpenTypeMappingIHandler.this.mxBeanObjectName, (NotificationListener)objectArray[0]);
                        return null;
                    }
                });
                return mBeanNotificationInfoArray;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)throwable;
                }
                if (throwable instanceof ListenerNotFoundException) {
                    throw (ListenerNotFoundException)throwable;
                }
                if (!(throwable instanceof IOException)) return mBeanNotificationInfoArray;
                throw (IOException)throwable;
            }
            catch (RuntimeMBeanException runtimeMBeanException) {
                throw runtimeMBeanException.getTargetException();
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException, ListenerNotFoundException, IOException {
                    OpenTypeMappingIHandler.this.connection.removeNotificationListener(OpenTypeMappingIHandler.this.mxBeanObjectName, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                    return null;
                }
            });
            return mBeanNotificationInfoArray;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)throwable;
            }
            if (!(throwable instanceof IOException)) return mBeanNotificationInfoArray;
            throw (IOException)throwable;
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
    }

    private Object invokeOperation(final Method method, final Object[] objectArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object object;
        Object object2 = null;
        try {
            object2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
                    return OpenTypeMappingIHandler.this.connection.invoke(OpenTypeMappingIHandler.this.mxBeanObjectName, method.getName(), objectArray, OpenTypeMappingIHandler.this.getOperationSignature(method));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException.getCause();
            if (object instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)object;
            }
            if (object instanceof MBeanException) {
                throw (MBeanException)object;
            }
            if (object instanceof ReflectionException) {
                throw (ReflectionException)object;
            }
            if (object instanceof IOException) {
                throw (IOException)object;
            }
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        String string = method.getReturnType().getName();
        object = this.getOperationOpenReturnType(method);
        if (!string.equals(object)) {
            object2 = ManagementUtils.convertFromOpenType(object2, Class.forName((String)object), Class.forName(string));
        }
        return object2;
    }

    private String getOperationOpenReturnType(Method method) {
        String string = null;
        String[] stringArray = this.getOperationSignature(method);
        MBeanOperationInfo[] mBeanOperationInfoArray = this.info.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            MBeanParameterInfo[] mBeanParameterInfoArray;
            MBeanOperationInfo mBeanOperationInfo = mBeanOperationInfoArray[i];
            if (!mBeanOperationInfo.getName().equals(method.getName()) || (mBeanParameterInfoArray = mBeanOperationInfo.getSignature()).length != stringArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                if (mBeanParameterInfoArray[j].getType().equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            string = mBeanOperationInfo.getReturnType();
            break;
        }
        return string;
    }

    private String[] getOperationSignature(Method method) {
        String[] stringArray = null;
        Class<?>[] classArray = method.getParameterTypes();
        stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            stringArray[i] = clazz.getName();
        }
        return stringArray;
    }

    private Object invokeAttributeSetter(final Method method, final Object[] objectArray) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, InvalidAttributeValueException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
                    OpenTypeMappingIHandler.this.connection.setAttribute(OpenTypeMappingIHandler.this.mxBeanObjectName, new Attribute(OpenTypeMappingIHandler.this.getAttribName(method), objectArray[0]));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        return null;
    }

    private Object invokeAttributeGetter(final Method method) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object object = null;
        String string = method.getReturnType().getName();
        String string2 = this.getAttrOpenType(method.getName());
        try {
            object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
                    return OpenTypeMappingIHandler.this.connection.getAttribute(OpenTypeMappingIHandler.this.mxBeanObjectName, OpenTypeMappingIHandler.this.getAttribName(method));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        if (!string.equals(string2)) {
            object = ManagementUtils.convertFromOpenType(object, Class.forName(string2), Class.forName(string));
        }
        return object;
    }

    private String getAttribName(Method method) {
        MBeanAttributeInfo mBeanAttributeInfo;
        int n;
        String string;
        String string2 = null;
        String string3 = method.getName();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.info.getAttributes();
        if (string3.startsWith("get")) {
            string = string3.substring("get".length());
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(string) || !mBeanAttributeInfo.isReadable()) continue;
                string2 = mBeanAttributeInfo.getName();
                break;
            }
        }
        if (string2 == null && string3.startsWith("is")) {
            string = string3.substring("is".length());
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(string) || !mBeanAttributeInfo.isReadable() || !mBeanAttributeInfo.isIs()) continue;
                string2 = mBeanAttributeInfo.getName();
                break;
            }
        }
        if (string2 == null && string3.startsWith("set")) {
            string = string3.substring("set".length());
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(string) || !mBeanAttributeInfo.isWritable()) continue;
                string2 = mBeanAttributeInfo.getName();
                break;
            }
        }
        return string2;
    }

    private String getAttrOpenType(String string) {
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttribInfo(string);
        return mBeanAttributeInfo.getType();
    }

    private MBeanAttributeInfo getAttribInfo(String string) {
        MBeanAttributeInfo mBeanAttributeInfo;
        int n;
        String string2;
        MBeanAttributeInfo mBeanAttributeInfo2 = null;
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.info.getAttributes();
        if (string.startsWith("get")) {
            string2 = string.substring("get".length());
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(string2) || !mBeanAttributeInfo.isReadable()) continue;
                mBeanAttributeInfo2 = mBeanAttributeInfo;
                break;
            }
        }
        if (mBeanAttributeInfo2 == null && string.startsWith("is")) {
            string2 = string.substring("is".length());
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(string2) || !mBeanAttributeInfo.isReadable() || !mBeanAttributeInfo.isIs()) continue;
                mBeanAttributeInfo2 = mBeanAttributeInfo;
                break;
            }
        }
        return mBeanAttributeInfo2;
    }

    private InvokeType getInvokeType(String string) {
        MBeanAttributeInfo mBeanAttributeInfo;
        int n;
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        Object object;
        InvokeType invokeType = null;
        if (string.startsWith("get")) {
            object = string.substring("get".length());
            mBeanAttributeInfoArray = this.info.getAttributes();
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(object) || !mBeanAttributeInfo.isReadable()) continue;
                invokeType = InvokeType.ATTRIBUTE_GETTER;
                break;
            }
        }
        if (invokeType == null && string.startsWith("is")) {
            object = string.substring("is".length());
            mBeanAttributeInfoArray = this.info.getAttributes();
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(object) || !mBeanAttributeInfo.isReadable() || !mBeanAttributeInfo.isIs()) continue;
                invokeType = InvokeType.ATTRIBUTE_GETTER;
                break;
            }
        }
        if (invokeType == null && string.startsWith("set")) {
            object = string.substring("set".length());
            mBeanAttributeInfoArray = this.info.getAttributes();
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanAttributeInfo = mBeanAttributeInfoArray[n];
                if (!mBeanAttributeInfo.getName().equals(object) || !mBeanAttributeInfo.isWritable()) continue;
                invokeType = InvokeType.ATTRIBUTE_SETTER;
                break;
            }
        }
        if (invokeType == null) {
            object = NotificationEmitter.class.getMethods();
            for (int i = 0; i < ((Method[])object).length; ++i) {
                if (!object[i].getName().equals(string)) continue;
                invokeType = InvokeType.NOTIFICATION_OP;
                break;
            }
        }
        if (invokeType == null) {
            invokeType = InvokeType.OPERATION;
        }
        return invokeType;
    }

    static enum InvokeType {
        ATTRIBUTE_GETTER,
        ATTRIBUTE_SETTER,
        NOTIFICATION_OP,
        OPERATION;

    }
}

