/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.services.SourcePriorityNameMapping;
import org.eclipse.ui.services.IEvaluationReference;

public class EvaluationReference
extends RunAndTrack
implements IEvaluationReference {
    final IEclipseContext context;
    final Expression expression;
    final IPropertyChangeListener listener;
    final String property;
    final int sourcePriority;
    boolean cache;
    boolean participating = true;
    boolean postingChanges = true;
    boolean hasRun = false;
    Runner runner = new Runner();

    public EvaluationReference(IEclipseContext context, Expression expression, IPropertyChangeListener listener, String property) {
        this.context = context;
        this.expression = expression;
        this.listener = listener;
        this.property = property;
        this.sourcePriority = SourcePriorityNameMapping.computeSourcePriority(expression);
    }

    public void clearResult() {
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int getSourcePriority() {
        return this.sourcePriority;
    }

    public boolean evaluate(IEvaluationContext context) {
        if (this.expression == null) {
            this.cache = true;
        } else {
            this.runner.localContext = context;
            SafeRunner.run((ISafeRunnable)this.runner);
        }
        return this.cache;
    }

    public void setResult(boolean result) {
        this.cache = result;
    }

    public boolean changed(IEclipseContext context) {
        if (!this.participating) {
            return false;
        }
        this.evaluate();
        return this.participating;
    }

    public void evaluate() {
        boolean value = this.cache;
        this.evaluate((IEvaluationContext)new ExpressionContext(this.context));
        if (!this.postingChanges) {
            return;
        }
        if (!this.hasRun) {
            this.getListener().propertyChange(new PropertyChangeEvent((Object)this, this.getProperty(), null, (Object)this.cache));
        } else if (!this.participating) {
            this.getListener().propertyChange(new PropertyChangeEvent((Object)this, this.getProperty(), (Object)value, null));
        }
        if (value != this.cache) {
            this.getListener().propertyChange(new PropertyChangeEvent((Object)this, this.getProperty(), (Object)value, (Object)this.cache));
        }
        this.hasRun = true;
    }

    public IPropertyChangeListener getListener() {
        return this.listener;
    }

    public String getProperty() {
        return this.property;
    }

    public void setPostingChanges(boolean b) {
        this.postingChanges = b;
    }

    public boolean isPostingChanges() {
        return this.postingChanges;
    }

    class Runner
    implements ISafeRunnable {
        public IEvaluationContext localContext;

        Runner() {
        }

        public void run() throws Exception {
            try {
                EvaluationReference.this.cache = EvaluationReference.this.expression.evaluate(this.localContext) != EvaluationResult.FALSE;
            }
            catch (CoreException e) {
                Activator.trace((String)"/trace/commands", (String)"Failed to calculate active", (Throwable)e);
            }
        }

        public void handleException(Throwable exception) {
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            Activator.trace((String)"/trace/commands", (String)("Failed with throwable: " + EvaluationReference.this.expression), (Throwable)exception);
        }
    }
}

