/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParserFactory;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.util.Pair;
import com.ibm.gsk.ikeyman.util.SettingLoaderFactory;
import com.ibm.gsk.ikeyman.util.SettingValidatorFactory;
import com.ibm.gsk.ikeyman.util.Settings;
import com.ibm.security.x509.CertificateVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;

public class KeymanSettings {
    public static final Locale LOCALE;
    public static final String PROGRAM_VERSION;
    public static final X509Version X509_VERSION_DEFAULT;
    public static final String TARGET_DEFAULT;
    public static final Locale LOCALE_DEFAULT;
    public static final String PASSWORDLESS_CMS_PASSWORD;
    public static final CertificateVersion DEFAULT_CERTIFICATE_VERSION;
    public static final String DEFAULT_SIGNATURE_ALGORITHM;
    public static final NumberRange VALID_PASSWORD_EXPIRY_RANGE;
    private static final String MAJOR_MINOR_VERSION = "iKeyman 8.0";
    private static Boolean isCLI;

    public static boolean isCLI() {
        return isCLI;
    }

    public static void setCLI(boolean value) {
        isCLI = value;
    }

    public static String getPropertyFileName() {
        return Settings.getBundleFileName();
    }

    static {
        try {
            String buildNumber;
            LOCALE = Locale.getDefault();
            LOCALE_DEFAULT = Locale.ENGLISH;
            X509_VERSION_DEFAULT = X509Version.THREE;
            TARGET_DEFAULT = "cert.arm";
            PASSWORDLESS_CMS_PASSWORD = "\u0001\u0002\u0003\u0004\u0005\u0001\u0002\u0003\u0004\u0005";
            DEFAULT_CERTIFICATE_VERSION = new CertificateVersion(2);
            DEFAULT_SIGNATURE_ALGORITHM = "SHA1WithRSA";
            VALID_PASSWORD_EXPIRY_RANGE = new NumberRange(0, 7300);
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.gsk.ikeyman.buildNumber");
                buildNumber = new Integer(bundle.getString("formatted.build.number")).toString();
            }
            catch (Exception e) {
                buildNumber = "0";
            }
            PROGRAM_VERSION = "iKeyman 8.0." + buildNumber;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        isCLI = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NumberRange
    extends Pair<Integer, Integer> {
        public NumberRange(Integer first, Integer second) {
            super(first, second);
        }

        public int getMaximumDigits() {
            return new Double(Math.ceil(Math.log10(((Integer)this.getSecond()).intValue()))).intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Setting {
        CMSPasswordRequired("DEFAULT_CMS_PASSWORD_REQUIRED", true, null),
        SANEnabled("DEFAULT_SUBJECT_ALTERNATIVE_NAME_SUPPORT", true, null),
        ResourceWarningEnabled("RESOURCE_WARNING_ENABLED", false, null),
        DefaultCryptoModule("DEFAULT_CRYPTOGRAPHIC_MODULE", "*", null),
        DefaultFileLocation("DEFAULT_FILE_LOCATION", ".", null),
        DefaultCMSFileLocation("DEFAULT_CMS_FILE_LOCATION", null, SettingLoaderFactory.getAlternativeKeyLoader(SettingLoaderFactory.getFileOrSystemPropertySettingLoader(), "DEFAULT_KEYDB_LOCATION_CMS"), null),
        DefaultJKSFileLocation("DEFAULT_JKS_FILE_LOCATION", null, null),
        DefaultPKCS12FileLocation("DEFAULT_PKCS12_FILE_LOCATION", null, null),
        DefaultJCEKSFileLocation("DEFAULT_JCEKS_FILE_LOCATION", null, null),
        DefaultCMSFileName("DEFAULT_CMS_FILE_NAME", "key", SettingLoaderFactory.getAlternativeKeyLoader(SettingLoaderFactory.getFileOrSystemPropertySettingLoader(), "DEFAULT_KEYDB_NAME_CMS"), null),
        DefaultJKSFileName("DEFAULT_JKS_FILE_NAME", "key", null),
        DefaultPKCS12FileName("DEFAULT_PKCS12_FILE_NAME", "key", null),
        DefaultJCEKSFileName("DEFAULT_JCEKS_FILE_NAME", "key", null),
        DefaultCMSFileNameExt("DEFAULT_CMS_FILE_NAME_EXT", ".kdb", SettingLoaderFactory.getAlternativeKeyLoader(SettingLoaderFactory.getFileOrSystemPropertySettingLoader(), "DEFAULT_KEYDB_NAME_EXT_CMS"), null),
        DefaultJKSFileNameExt("DEFAULT_JKS_FILE_NAME_EXT", ".jks", null),
        DefaultPKCS12FileNameExt("DEFAULT_PKCS12_FILE_NAME_EXT", ".p12", null),
        DefaultJCEKSFileNameExt("DEFAULT_JCEKS_FILE_NAME_EXT", ".jck", null),
        UseLastOpenedLocationCMS("USE_LAST_OPENED_LOCATION_CMS", true, null),
        UseLastOpenedLocationJKS("USE_LAST_OPENED_LOCATION_JKS", true, null),
        UseLastOpenedLocationPKCS12("USE_LAST_OPENED_LOCATION_PCKS12", true, null),
        UseLastOpenedLocationJCEKS("USE_LAST_OPENED_LOCATION_JCEKS", true, null),
        DefaultCertReqName("DEFAULT_CERTREQ_NAME", "certreq.arm", null),
        DefaultCertificateNameArm("DEFAULT_CERTIFICATE_NAME_ARM", "cert.arm", null),
        DefaultCertificateNameDer("DEFAULT_CERTIFICATE_NAME_DER", "cert.der", null),
        DefaultCryptoSecondaryDb("DEFAULT_CRYPTOGRAPHIC_TOKEN_SECONDARY_KEYDB", null, null),
        DefaultPasswordStashingState("DEFAULT_PASSWORD_STASHING_STATE", false, null),
        DefaultSSCertBasicConstraints("DEFAULT_SSCERT_BASIC_CONSTRAINTS", false, null),
        DefaultFIPSModeProcessing("DEFAULT_FIPS_MODE_PROCESSING", false, null),
        ViewHiddenFiles("VIEW_HIDDEN_FILES", false, null),
        DefaultCMSPassword("DEFAULT_CMS_PASSWORD", null, null),
        DefaultKeySize("DEFAULT_CERTIFICATE_KEYSIZE", 1024, null),
        DefaultECKeySize("DEFAULT_CERTIFICATE_KEYSIZE", 192, null),
        DefaultListOption("DEFAULT_CERTIFICATE_LIST_OPTION", Constants.ListFilter.All.toString(), null),
        DefaultCertDefault("DEFAULT_CERTIFICATE_DEFAULT", null, null),
        DefaultCertTrust("DEFAULT_CERTIFICATE_TRUST", null, null),
        DefaultCertExpire("DEFAULT_CERTIFICATE_EXPIRE", 365, null),
        DefaultCertFormat("DEFAULT_CERTIFICATE_FORMAT", "ascii", null),
        DefaultEnglishErrorMessages("DEFAULT_ENGLISH_ERROR_MESSAGE", false, null),
        SecretKeyFunctionEnabled("SECRET_KEY_FUNCTION_ENABLED", true, null),
        RenameCertFunctionEnabled("RENAME_CERT_FUNCTION_ENABLED", true, null),
        SignatureAlgorithmFunctionEnabled("SIGNATURE_ALGORITHM_FUNCTION_ENABLED", true, null),
        NoDefaultCertsFunctionEnabled("NO_DEFAULT_CERTS_FUNCTION_ENABLED", true, null),
        DefaulFileCreatePermission("DEFAULT_FILE_CREATE_PERMISSION", "", null),
        DebugModeEnabled("keyman.debug", false, SettingLoaderFactory.getSystemPropertySettingLoader(), null),
        LoggingModeEnabled("keyman.logging", false, SettingLoaderFactory.getSystemPropertySettingLoader(), null);

        private final String propertyKey;
        private final Object defaultValue;
        private final SettingLoaderFactory.SettingLoader settingLoader;
        private final SettingValidatorFactory.SettingValidator settingValidator;
        private Object value = null;

        private <T> Setting(String propertyKey, Object defaultValue, SettingValidatorFactory.SettingValidator validator) {
            this(propertyKey, defaultValue, SettingLoaderFactory.getFileOrSystemPropertySettingLoader(), validator);
        }

        private <T> Setting(String propertyKey, Object defaultValue, SettingLoaderFactory.SettingLoader loader, SettingValidatorFactory.SettingValidator validator) {
            this.propertyKey = propertyKey;
            this.defaultValue = defaultValue;
            this.settingLoader = loader;
            this.settingValidator = validator;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public Object getDefault() {
            return this.defaultValue;
        }

        public Boolean getBoolean() {
            return Setting.getSetting(this, Boolean.class);
        }

        public String getString() {
            return Setting.getSetting(this, String.class);
        }

        public int getInteger() {
            return Setting.getSetting(this, Integer.class);
        }

        public <T> T getValue(Class<T> c, ParserFactory.ParserDelegate<T> parser) {
            if (this.value == null) {
                String value = this.settingLoader.getSetting(this.propertyKey);
                try {
                    if (value == null) {
                        this.value = this.defaultValue;
                    } else {
                        if (this.settingValidator != null) {
                            this.settingValidator.validateValue(value);
                        }
                        this.value = parser.parse(value);
                    }
                }
                catch (Exception e) {
                    this.value = this.defaultValue;
                }
            }
            return (T)this.value;
        }

        public static void reset() {
            for (Setting setting : Setting.values()) {
                setting.value = null;
            }
        }

        private static <T> T getSetting(Setting setting, Class<T> c) {
            if (setting.value == null) {
                String value = setting.settingLoader.getSetting(setting.propertyKey);
                try {
                    if (value == null) {
                        setting.value = setting.defaultValue;
                    } else {
                        if (setting.settingValidator != null) {
                            setting.settingValidator.validateValue(value);
                        }
                        Constructor<T> constructor = c.getConstructor(String.class);
                        setting.value = constructor.newInstance(value);
                    }
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method method = c.getMethod("valueOf", String.class);
                        setting.value = method.invoke(null, value);
                    }
                    catch (Exception ex) {
                        setting.value = setting.defaultValue;
                    }
                }
                catch (Exception e) {
                    setting.value = setting.defaultValue;
                }
            }
            return (T)setting.value;
        }
    }
}

