/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.sequence;

import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.SequenceIterator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SequenceFactory {
    private SequenceFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static <E> Sequence<E> newSequence(E ... a) throws NullPointerException {
        if (a == null) {
            throw new NullPointerException();
        }
        return new ArraySequence<E>(a);
    }

    public static <E> Sequence<E> newSequence(List<E> l) throws NullPointerException {
        if (l == null) {
            throw new NullPointerException();
        }
        return new ListSequence<E>(l);
    }

    public static <E> Sequence<E> newConstantSequence(E constant, int length) throws IllegalArgumentException {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        return new ConstantSequence<E>(constant, length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArraySequence<E>
    implements Sequence<E> {
        private static final long serialVersionUID = 2L;
        private final E[] a;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        ArraySequence(E ... a) {
            this.a = a;
        }

        @Override
        public E get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.a.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.a[index];
        }

        @Override
        public int length() {
            return this.a.length;
        }

        @Override
        public Sequence<E> append(Sequence<E> sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (this.a.length == 0) {
                return sequence;
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeSequence<E>(this, sequence);
        }

        @Override
        public Sequence<E> getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.a.length || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new SubSequence(this, fromPosition, toPosition);
        }

        @Override
        public int indexOf(E e) {
            for (int i = 0; i < this.a.length; ++i) {
                if (!(this.a[i] == null ? e == null : this.a[i].equals(e))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int indexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.a.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasNext()) {
                int itPosition = it.getPosition();
                Object x = it.next();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(E e) {
            for (int i = this.a.length - 1; i >= 0; --i) {
                if (!(this.a[i] == null ? e == null : this.a[i].equals(e))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.a.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasPrevious()) {
                E x = it.previous();
                int itPosition = it.getPosition();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.a.length == 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator(final int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.a.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new SequenceIterator<E>(){
                private int pos;
                {
                    this.pos = position;
                }

                @Override
                public final boolean hasNext() {
                    return this.pos != ArraySequence.this.a.length;
                }

                @Override
                public final E next() {
                    if (this.pos == ArraySequence.this.a.length) {
                        throw new NoSuchElementException();
                    }
                    return ArraySequence.this.a[this.pos++];
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos != 0;
                }

                @Override
                public E previous() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    return ArraySequence.this.a[--this.pos];
                }

                @Override
                public int getPosition() {
                    return this.pos;
                }
            };
        }

        @Override
        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (int i = 0; i < this.a.length; ++i) {
                    sb.append(this.a[i]);
                    if (i == this.a.length - 1) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Sequence)) {
                return false;
            }
            Sequence s = (Sequence)o;
            if (s.length() != this.a.length) {
                return false;
            }
            Iterator<E> it1 = this.iterator();
            Iterator it2 = s.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                E se1 = it1.next();
                Object se2 = it2.next();
                if (!(se1 == null ? se2 != null : !se1.equals(se2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                for (E e : this) {
                    if (e == null) continue;
                    result = result * 461 + e.hashCode();
                }
                this.hc = result;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeSequence<E>
    implements Sequence<E> {
        private static final long serialVersionUID = 2L;
        private final Sequence<E> seq1;
        private final Sequence<E> seq2;
        private final int len1;
        private final int len2;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        CompositeSequence(Sequence<E> seq1, Sequence<E> seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
            this.len1 = seq1.length();
            this.len2 = seq2.length();
        }

        @Override
        public E get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.len1 + this.len2) {
                throw new IndexOutOfBoundsException();
            }
            if (index < this.len1) {
                return this.seq1.get(index);
            }
            return this.seq2.get(index - this.len1);
        }

        @Override
        public int length() {
            return this.len1 + this.len2;
        }

        @Override
        public Sequence<E> append(Sequence<E> sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeSequence<E>(this, sequence);
        }

        @Override
        public Sequence<E> getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.len1 + this.len2 || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new SubSequence(this, fromPosition, toPosition);
        }

        @Override
        public int indexOf(E e) {
            int index1 = this.seq1.indexOf(e);
            if (index1 == -1) {
                int index2 = this.seq2.indexOf(e);
                return index2 == -1 ? -1 : index2 + this.len1;
            }
            return index1;
        }

        @Override
        public int indexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.len1 + this.len2) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasNext()) {
                int itPosition = it.getPosition();
                Object x = it.next();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(E e) {
            int index1 = this.seq2.lastIndexOf(e);
            if (index1 == -1) {
                return this.seq1.lastIndexOf(e);
            }
            return index1 + this.seq1.length();
        }

        @Override
        public int lastIndexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.len1 + this.len2) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasPrevious()) {
                E x = it.previous();
                int itPosition = it.getPosition();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator(final int position) throws IndexOutOfBoundsException {
            final int len = this.len1 + this.len2;
            if (position < 0 || position > len) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new SequenceIterator<E>(){
                private int pos;
                {
                    this.pos = position;
                }

                @Override
                public final boolean hasNext() {
                    return this.pos != len;
                }

                @Override
                public final E next() {
                    if (this.pos == len) {
                        throw new NoSuchElementException();
                    }
                    if (this.pos < CompositeSequence.this.len1) {
                        return CompositeSequence.this.seq1.get(this.pos++);
                    }
                    return CompositeSequence.this.seq2.get(this.pos++ - CompositeSequence.this.len1);
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos != 0;
                }

                @Override
                public E previous() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    if (this.pos <= CompositeSequence.this.len1) {
                        return CompositeSequence.this.seq1.get(--this.pos);
                    }
                    return CompositeSequence.this.seq2.get(--this.pos - CompositeSequence.this.len1);
                }

                @Override
                public int getPosition() {
                    return this.pos;
                }
            };
        }

        @Override
        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                Iterator it1 = this.seq1.iterator();
                Iterator it2 = this.seq2.iterator();
                while (it1.hasNext()) {
                    sb.append(it1.next());
                    if (!it1.hasNext() && !it2.hasNext()) continue;
                    sb.append("][");
                }
                while (it2.hasNext()) {
                    sb.append(it2.next());
                    if (!it2.hasNext()) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Sequence)) {
                return false;
            }
            Sequence s = (Sequence)o;
            if (s.length() != this.len1 + this.len2) {
                return false;
            }
            Iterator<E> it1 = this.iterator();
            Iterator it2 = s.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                E se1 = it1.next();
                Object se2 = it2.next();
                if (!(se1 == null ? se2 != null : !se1.equals(se2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                for (E e : this) {
                    if (e == null) continue;
                    result = result * 461 + e.hashCode();
                }
                this.hc = result;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstantSequence<E>
    implements Sequence<E> {
        private static final long serialVersionUID = 2L;
        private final E constant;
        private final int length;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        ConstantSequence(E constant, int length) {
            this.constant = constant;
            this.length = length;
        }

        @Override
        public E get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.length) {
                throw new IndexOutOfBoundsException();
            }
            return this.constant;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public Sequence<E> append(Sequence<E> sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeSequence<E>(this, sequence);
        }

        @Override
        public Sequence<E> getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.length || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new SubSequence(this, fromPosition, toPosition);
        }

        @Override
        public int indexOf(E e) {
            return e == this.constant ? 0 : -1;
        }

        @Override
        public int indexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasNext()) {
                int itPosition = it.getPosition();
                Object x = it.next();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(E e) {
            return e == this.constant ? this.length - 1 : -1;
        }

        @Override
        public int lastIndexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasPrevious()) {
                E x = it.previous();
                int itPosition = it.getPosition();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator(final int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new SequenceIterator<E>(){
                private int pos;
                {
                    this.pos = position;
                }

                @Override
                public boolean hasNext() {
                    return this.pos != ConstantSequence.this.length;
                }

                @Override
                public E next() throws NoSuchElementException {
                    if (this.pos == ConstantSequence.this.length) {
                        throw new NoSuchElementException();
                    }
                    ++this.pos;
                    return ConstantSequence.this.constant;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos != 0;
                }

                @Override
                public E previous() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.pos;
                    return ConstantSequence.this.constant;
                }

                @Override
                public int getPosition() {
                    return this.pos;
                }
            };
        }

        @Override
        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (int i = 0; i < this.length; ++i) {
                    sb.append(this.constant);
                    if (i == this.length - 1) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Sequence)) {
                return false;
            }
            Sequence s = (Sequence)o;
            Object e = s.get(0);
            return s.length() == this.length && (e == null ? this.constant == null : e.equals(this.constant));
        }

        @Override
        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                if (this.constant != null) {
                    result = result * 461 + this.constant.hashCode();
                }
                this.hc = result = result * 461 + this.length;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListSequence<E>
    implements Sequence<E> {
        private static final long serialVersionUID = 2L;
        private final List<E> l;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        ListSequence(List<E> l) {
            this.l = l;
        }

        @Override
        public E get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.l.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.l.get(index);
        }

        @Override
        public int length() {
            return this.l.size();
        }

        @Override
        public Sequence<E> append(Sequence<E> sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (this.l.size() == 0) {
                return sequence;
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeSequence<E>(this, sequence);
        }

        @Override
        public Sequence<E> getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.l.size() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new SubSequence(this, fromPosition, toPosition);
        }

        @Override
        public int indexOf(E e) {
            return this.l.indexOf(e);
        }

        @Override
        public int indexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.l.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasNext()) {
                int itPosition = it.getPosition();
                Object x = it.next();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(E e) {
            return this.l.lastIndexOf(e);
        }

        @Override
        public int lastIndexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.l.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasPrevious()) {
                E x = it.previous();
                int itPosition = it.getPosition();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.l.size() == 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator(final int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.l.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new SequenceIterator<E>(){
                private int pos;
                private final ListIterator<E> it;
                {
                    this.pos = position;
                    this.it = ListSequence.this.l.listIterator(position);
                }

                @Override
                public final boolean hasNext() {
                    return this.pos != ListSequence.this.l.size();
                }

                @Override
                public final E next() {
                    if (this.pos == ListSequence.this.l.size()) {
                        throw new NoSuchElementException();
                    }
                    ++this.pos;
                    return this.it.next();
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos != 0;
                }

                @Override
                public E previous() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.pos;
                    return this.it.previous();
                }

                @Override
                public int getPosition() {
                    return this.pos;
                }
            };
        }

        @Override
        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                int counter = 0;
                for (E e : this.l) {
                    sb.append(e);
                    if (counter++ == this.l.size() - 1) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Sequence)) {
                return false;
            }
            Sequence s = (Sequence)o;
            if (s.length() != this.l.size()) {
                return false;
            }
            Iterator<E> it1 = this.iterator();
            Iterator it2 = s.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                E se1 = it1.next();
                Object se2 = it2.next();
                if (!(se1 == null ? se2 != null : !se1.equals(se2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                for (E e : this) {
                    if (e == null) continue;
                    result = result * 461 + e.hashCode();
                }
                this.hc = result;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubSequence<E>
    implements Sequence<E> {
        private static final long serialVersionUID = 2L;
        private final Sequence<E> sequence;
        private final int fromPosition;
        private final int toPosition;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        SubSequence(Sequence<E> sequence, int fromPosition, int toPosition) {
            this.sequence = sequence;
            this.fromPosition = fromPosition;
            this.toPosition = toPosition;
        }

        @Override
        public E get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.toPosition - this.fromPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index + this.fromPosition);
        }

        @Override
        public int length() {
            return this.toPosition - this.fromPosition;
        }

        @Override
        public Sequence<E> append(Sequence<E> sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (this.toPosition - this.fromPosition == 0) {
                return sequence;
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeSequence<E>(this, sequence);
        }

        @Override
        public Sequence<E> getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.toPosition - this.fromPosition || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new SubSequence<E>(this, fromPosition, toPosition);
        }

        @Override
        public int indexOf(E e) {
            for (int i = this.fromPosition; i < this.toPosition; ++i) {
                E x = this.sequence.get(i);
                if (!(x == null ? e == null : x.equals(e))) continue;
                return i - this.fromPosition;
            }
            return -1;
        }

        @Override
        public int indexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.toPosition - this.fromPosition) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasNext()) {
                int itPosition = it.getPosition();
                Object x = it.next();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(E e) {
            for (int i = this.toPosition - 1; i >= this.fromPosition; --i) {
                E x = this.sequence.get(i);
                if (!(x == null ? e == null : x.equals(e))) continue;
                return i - this.fromPosition;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(int position, E e) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.toPosition - this.fromPosition) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            SequenceIterator<E> it = this.getIterator(position);
            while (it.hasPrevious()) {
                E x = it.previous();
                int itPosition = it.getPosition();
                if (!(x == null ? e == null : x.equals(e))) continue;
                return itPosition;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.toPosition - this.fromPosition == 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator() {
            return this.getIterator(0);
        }

        @Override
        public SequenceIterator<E> getIterator(final int position) throws IndexOutOfBoundsException {
            final int len = this.toPosition - this.fromPosition;
            if (position < 0 || position > len) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new SequenceIterator<E>(){
                private int pos;
                {
                    this.pos = position;
                }

                @Override
                public boolean hasNext() {
                    return this.pos != len;
                }

                @Override
                public E next() throws NoSuchElementException {
                    if (this.pos == len) {
                        throw new NoSuchElementException();
                    }
                    return SubSequence.this.sequence.get(SubSequence.this.fromPosition + this.pos++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos != 0;
                }

                @Override
                public E previous() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    return SubSequence.this.sequence.get(SubSequence.this.fromPosition + --this.pos);
                }

                @Override
                public int getPosition() {
                    return this.pos;
                }
            };
        }

        @Override
        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (int i = this.fromPosition; i < this.toPosition; ++i) {
                    sb.append(this.sequence.get(i));
                    if (i == this.toPosition - 1) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Sequence)) {
                return false;
            }
            Sequence s = (Sequence)o;
            if (s.length() != this.toPosition - this.fromPosition) {
                return false;
            }
            Iterator<E> it1 = this.iterator();
            Iterator it2 = s.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                E se1 = it1.next();
                Object se2 = it2.next();
                if (!(se1 == null ? se2 != null : !se1.equals(se2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                for (E e : this) {
                    if (e == null) continue;
                    result = result * 461 + e.hashCode();
                }
                this.hc = result;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }
}

