/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.password.KeymanPasswordCallback;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DatabaseDescriptorFactory {
    public static DatabaseDescriptor getDatabaseDescriptor(CommandParameters params, CallbackHandler handler, DescriptorType descriptorType) throws KeyManagerException {
        switch (descriptorType) {
            case Source: {
                return DatabaseDescriptorFactory.getSourceDescriptor(params, handler);
            }
            case Target: {
                return DatabaseDescriptorFactory.getTargetDescriptor(params, handler);
            }
            case Secondary: {
                return DatabaseDescriptorFactory.getSecondaryDescriptor(params, handler);
            }
        }
        return null;
    }

    public static DatabaseDescriptor getDatabaseDescriptor(DatabaseDescriptor descriptor, Constants.DatabaseType newType) throws KeyManagerException {
        switch (newType) {
            case CMS: {
                return CMSDatabaseDescriptorImpl.getDescriptor(descriptor);
            }
            case PKCS12: {
                return PKCS12DatabaseDescriptorImpl.getDescriptor(descriptor, Constants.DatabaseType.PKCS12);
            }
            case PKCS12S2: {
                return PKCS12DatabaseDescriptorImpl.getDescriptor(descriptor, Constants.DatabaseType.PKCS12S2);
            }
        }
        return DatabaseDescriptorImpl.getDescriptor(descriptor, newType);
    }

    private static DatabaseDescriptor getSecondaryDescriptor(CommandParameters params, CallbackHandler handler) throws KeyManagerException {
        Constants.DatabaseType type = params.isParameterPresent(Constants.Parameter.SecondaryDbType) ? params.getSecondaryDbType() : DatabaseDescriptorFactory.deriveDatabaseType(new FileName(params.getSecondaryDb()));
        switch (type) {
            case CMS: {
                return CMSDatabaseDescriptorImpl.getSecondaryDescriptor(params, handler);
            }
            case PKCS11Direct: 
            case PKCS11Config: {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_OPERATION, "PKCS11Direct db cannot be secondary");
            }
            case PKCS12: 
            case PKCS12S2: {
                return PKCS12DatabaseDescriptorImpl.getSecondaryDescriptor(params, handler);
            }
        }
        return DatabaseDescriptorImpl.getSecondaryDescriptor(params, handler);
    }

    private static DatabaseDescriptor getTargetDescriptor(CommandParameters params, CallbackHandler handler) throws KeyManagerException {
        Constants.DatabaseType type;
        if (params.isParameterPresent(Constants.Parameter.TargetType)) {
            type = params.getTargetType();
        } else if (params.isParameterPresent(Constants.Parameter.Target)) {
            type = DatabaseDescriptorFactory.deriveDatabaseType(new FileName(params.getTarget()));
        } else if (params.isParameterPresent(Constants.Parameter.Crypto)) {
            type = params.isParameterPresent(Constants.Parameter.RelativeSlotNumber) ? Constants.DatabaseType.PKCS11Direct : Constants.DatabaseType.PKCS11Config;
        } else {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NO_TARGET_DATABASE_SPECIFIED, new String[0]);
        }
        switch (type) {
            case CMS: {
                return CMSDatabaseDescriptorImpl.getTargetDescriptor(params, handler);
            }
            case PKCS11Direct: {
                return PKCS11ImplDatabaseDescriptorDirectImpl.getDescriptor(params, handler, DescriptorType.Target);
            }
            case PKCS11Config: {
                return PKCS11ImplDatabaseDescriptorConfigImpl.getDescriptor(params, handler, DescriptorType.Target);
            }
            case PKCS12: {
                return PKCS12DatabaseDescriptorImpl.getTargetDescriptor(params, handler, Constants.DatabaseType.PKCS12);
            }
            case PKCS12S2: {
                return PKCS12DatabaseDescriptorImpl.getTargetDescriptor(params, handler, Constants.DatabaseType.PKCS12S2);
            }
        }
        return DatabaseDescriptorImpl.getTargetDescriptor(params, handler, type);
    }

    private static DatabaseDescriptor getSourceDescriptor(CommandParameters params, CallbackHandler handler) throws KeyManagerException {
        Constants.DatabaseType type;
        if (params.isParameterPresent(Constants.Parameter.Type)) {
            type = params.getType();
        } else if (params.isParameterPresent(Constants.Parameter.OldFormat)) {
            type = params.getOldFormat();
        } else if (params.isParameterPresent(Constants.Parameter.DatabaseName)) {
            type = DatabaseDescriptorFactory.deriveDatabaseType(new FileName(params.getDatabaseName()));
        } else if (params.isParameterPresent(Constants.Parameter.Crypto)) {
            type = params.isParameterPresent(Constants.Parameter.RelativeSlotNumber) ? Constants.DatabaseType.PKCS11Direct : Constants.DatabaseType.PKCS11Config;
        } else if (params.isParameterPresent(Constants.Parameter.File)) {
            type = Constants.DatabaseType.PKCS12;
        } else {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NO_SOURCE_DATABASE_SPECIFIED, new String[0]);
        }
        if (params.isParameterPresent(Constants.Parameter.Pfx) && params.isPfx() && type != Constants.DatabaseType.PKCS12 && type != Constants.DatabaseType.PKCS12S2) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_PFX_OPTION);
        }
        switch (type) {
            case CMS: {
                return CMSDatabaseDescriptorImpl.getDescriptor(params, handler);
            }
            case PKCS11Direct: {
                return PKCS11ImplDatabaseDescriptorDirectImpl.getDescriptor(params, handler, DescriptorType.Source);
            }
            case PKCS11Config: {
                return PKCS11ImplDatabaseDescriptorConfigImpl.getDescriptor(params, handler, DescriptorType.Source);
            }
            case PKCS12: {
                return PKCS12DatabaseDescriptorImpl.getDescriptor(params, handler, Constants.DatabaseType.PKCS12);
            }
            case PKCS12S2: {
                return PKCS12DatabaseDescriptorImpl.getDescriptor(params, handler, Constants.DatabaseType.PKCS12S2);
            }
        }
        return DatabaseDescriptorImpl.getDescriptor(params, handler, type);
    }

    public static Constants.DatabaseType deriveDatabaseType(FileName name) {
        String extension = name.getFileExtension();
        Constants.DatabaseType type = Constants.DatabaseType.getTypeForExtension(extension);
        if (type == Constants.DatabaseType.UNKNOWN) {
            return Constants.DatabaseType.getDefaultType();
        }
        return type;
    }

    private static abstract class AbstractPKCS11ImplDatabaseDescriptor
    extends DatabaseDescriptorImpl
    implements PKCS11ImplDatabaseDescriptor {
        private DatabaseDescriptor secondaryDb;

        public AbstractPKCS11ImplDatabaseDescriptor(String fileName, String password, CallbackHandler handler, Constants.DatabaseType type, DatabaseDescriptor secondaryDb, DescriptorType descriptorType) throws KeyManagerException {
            super(fileName, password, handler, type, descriptorType);
            this.secondaryDb = secondaryDb;
        }

        public DatabaseDescriptor getSecondaryDescriptor() {
            return this.secondaryDb;
        }

        public ParameterMap getDatabaseParameters(boolean isTarget) throws KeyManagerException {
            ParameterMap params = new ParameterMap();
            params.put(Constants.Parameter.Crypto, this.getFileNameString());
            if (isTarget) {
                params.put(Constants.Parameter.SecondPassword, this.getPassword());
                params.setTargetDescriptor(this);
            } else {
                params.put(Constants.Parameter.Password, this.getPassword());
                params.setSourceDescriptor(this);
            }
            return params;
        }

        public boolean allowsAction(Constants.CommandType action) {
            switch (action) {
                case ConvertDB: 
                case ChangeDBPassword: 
                case ExportCert: {
                    return false;
                }
            }
            return super.allowsAction(action);
        }

        public String getProvider() {
            return "IBMPKCS11Impl";
        }
    }

    public static interface CMSDatabaseDescriptor
    extends DatabaseDescriptor {
        public boolean isUseStash();

        public void setPasswordExpiryTimeSinceEpoch(int var1);

        public int getPasswordExpiryTime();

        public void setStash(boolean var1);
    }

    private static class CMSDatabaseDescriptorImpl
    extends DatabaseDescriptorImpl
    implements CMSDatabaseDescriptor {
        private boolean useStash = false;
        private int passwordExpiryTime = 0;

        public CMSDatabaseDescriptorImpl(String fileName, String password, CallbackHandler handler, boolean useStash, int passwordExpiry, DescriptorType descriptorType) throws KeyManagerException {
            super(fileName, password, handler, Constants.DatabaseType.CMS, descriptorType);
            this.useStash = useStash;
            if (passwordExpiry != 0) {
                this.setPasswordExpiryTime(passwordExpiry);
            } else {
                this.passwordExpiryTime = passwordExpiry;
            }
        }

        public CMSDatabaseDescriptorImpl(DatabaseDescriptor descriptor) throws KeyManagerException {
            this(descriptor.getFileNameString(), descriptor.getPassword(), null, false, 0, DescriptorType.Source);
        }

        private void setPasswordExpiryTime(int days) {
            if (days == 0) {
                this.passwordExpiryTime = 0;
            } else {
                Calendar tempCal = Calendar.getInstance();
                tempCal.add(6, days);
                this.passwordExpiryTime = (int)(tempCal.getTimeInMillis() / 1000L);
            }
        }

        public boolean isUseStash() {
            return this.useStash;
        }

        public int getPasswordExpiryTime() {
            return this.passwordExpiryTime;
        }

        public static CMSDatabaseDescriptor getDescriptor(CommandParameters params, CallbackHandler handler) throws KeyManagerException {
            int expire = params.isParameterPresent(Constants.Parameter.Expire) ? params.getExpire() : 0;
            boolean stash = params.isParameterPresent(Constants.Parameter.StashPassword) ? params.isStash() : KeymanSettings.Setting.DefaultPasswordStashingState.getBoolean().booleanValue();
            if (stash) {
                if (params.isParameterPresent(Constants.Parameter.Password)) {
                    return new CMSDatabaseDescriptorImpl(params.getDatabaseName(), params.getPassword(), handler, true, expire, DescriptorType.Source);
                }
                return new CMSDatabaseDescriptorImpl(params.getDatabaseName(), null, handler, true, expire, DescriptorType.Source);
            }
            if (params.isParameterPresent(Constants.Parameter.Password)) {
                return new CMSDatabaseDescriptorImpl(params.getDatabaseName(), params.getPassword(), handler, false, expire, DescriptorType.Source);
            }
            return new CMSDatabaseDescriptorImpl(params.getDatabaseName(), null, handler, false, expire, DescriptorType.Source);
        }

        public static CMSDatabaseDescriptor getDescriptor(DatabaseDescriptor descriptor) throws KeyManagerException {
            return new CMSDatabaseDescriptorImpl(descriptor);
        }

        public static DatabaseDescriptor getSecondaryDescriptor(CommandParameters params, CallbackHandler handler) throws KeyManagerException {
            if (params.isParameterPresent(Constants.Parameter.SecondaryDbPassword)) {
                return new CMSDatabaseDescriptorImpl(params.getSecondaryDb(), params.getSecondaryDbPassword(), handler, false, 0, DescriptorType.Secondary);
            }
            return new CMSDatabaseDescriptorImpl(params.getSecondaryDb(), null, handler, false, 0, DescriptorType.Secondary);
        }

        public static DatabaseDescriptor getTargetDescriptor(CommandParameters params, CallbackHandler handler) throws KeyManagerException {
            if (params.isParameterPresent(Constants.Parameter.TargetPassword)) {
                return new CMSDatabaseDescriptorImpl(params.getTarget(), params.getTargetPassword(), handler, false, 0, DescriptorType.Target);
            }
            return new CMSDatabaseDescriptorImpl(params.getTarget(), null, handler, false, 0, DescriptorType.Target);
        }

        public boolean allowsAction(Constants.CommandType action) {
            switch (action) {
                case StashDBPassword: {
                    return this.isPasswordProtected();
                }
                case DisplayDBPasswordExpiry: {
                    return true;
                }
            }
            return super.allowsAction(action);
        }

        protected void updateDescriptor(ParameterMap map) {
            super.updateDescriptor(map);
            if (map.containsKey(Constants.Parameter.StashPassword)) {
                this.useStash = (Boolean)map.get(Constants.Parameter.StashPassword);
            }
            if (map.containsKey(Constants.Parameter.Expire)) {
                this.setPasswordExpiryTime((Integer)map.get(Constants.Parameter.Expire));
            }
        }

        public void setPassword(CommandParameters params) throws KeyManagerException {
            super.setPassword(params);
            this.useStash = params.isParameterPresent(Constants.Parameter.StashPassword) ? params.isStash() : KeymanSettings.Setting.DefaultPasswordStashingState.getBoolean().booleanValue();
            if (params.isParameterPresent(Constants.Parameter.Expire)) {
                this.setPasswordExpiryTime(params.getExpire());
            }
        }

        public void setStash(boolean value) {
            this.useStash = value;
        }

        public void setPasswordExpiryTimeSinceEpoch(int time) {
            this.passwordExpiryTime = time;
        }
    }

    public static interface DatabaseDescriptor {
        public String getPassword(boolean var1, boolean var2) throws KeyManagerException, CancelledException;

        public boolean isPasswordProtected();

        public void setPasswordProtected(boolean var1);

        public String getPassword();

        public Constants.DatabaseType getType();

        public String getFileNameString();

        public FileName getFileName();

        public void setFileName(String var1);

        public void setType(Constants.DatabaseType var1);

        public ParameterMap getDatabaseParameters(boolean var1) throws KeyManagerException;

        public void setPassword(String var1);

        public boolean allowsAction(Constants.CommandType var1);

        public void setPassword(CommandParameters var1) throws KeyManagerException;
    }

    private static class DatabaseDescriptorImpl
    implements DatabaseDescriptor {
        private FileName fileName;
        private String fileNameString;
        private String password;
        private CallbackHandler passwordCallbackHandler;
        private Constants.DatabaseType type;
        private DescriptorType descriptorType;
        private boolean isPasswordProtected = true;

        public boolean equals(Object o) {
            if (o.getClass().equals(this.getClass())) {
                return ((DatabaseDescriptorImpl)o).fileName.equals(this.fileName);
            }
            return false;
        }

        public int hashCode() {
            return this.getClass().hashCode() + this.fileName.hashCode() + (this.password == null ? 0 : this.password.hashCode());
        }

        public DatabaseDescriptorImpl(String fileName, String password, CallbackHandler handler, Constants.DatabaseType type, DescriptorType descriptorType) throws KeyManagerException {
            this.fileNameString = fileName;
            this.fileName = new FileName(fileName);
            this.password = password;
            this.passwordCallbackHandler = handler;
            this.type = type;
            this.descriptorType = descriptorType;
        }

        public DatabaseDescriptorImpl(DatabaseDescriptor descriptor, Constants.DatabaseType newType) throws KeyManagerException {
            this(descriptor.getFileNameString(), descriptor.getPassword(), null, newType, DescriptorType.Source);
        }

        public String getPassword(boolean promptIfNull, boolean create) throws KeyManagerException, CancelledException {
            if (this.password == null && promptIfNull) {
                KeymanPasswordCallback callback = new KeymanPasswordCallback(this.type, this.descriptorType, this.fileNameString, create);
                try {
                    this.passwordCallbackHandler.handle(new Callback[]{callback});
                }
                catch (IOException e) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
                }
                catch (UnsupportedCallbackException e) {
                    throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_CALLBACK, (Throwable)e);
                }
                ParameterMap map = callback.getPasswordMap();
                if (map == null) {
                    throw new CancelledException();
                }
                if (((String)map.get(Constants.Parameter.Password)).length() == 0) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.PASSWORD_CANNOT_BE_NULL);
                }
                this.updateDescriptor(map);
            }
            return this.password;
        }

        public boolean isPasswordProtected() {
            return this.isPasswordProtected;
        }

        public void setPasswordProtected(boolean value) {
            this.isPasswordProtected = value;
        }

        protected void updateDescriptor(ParameterMap map) {
            this.password = (String)map.get(Constants.Parameter.Password);
        }

        public String getPassword() {
            return this.password;
        }

        public Constants.DatabaseType getType() {
            return this.type;
        }

        public String getFileNameString() {
            return this.fileNameString;
        }

        public FileName getFileName() {
            return this.fileName;
        }

        public static DatabaseDescriptor getDescriptor(CommandParameters params, CallbackHandler handler, Constants.DatabaseType type) throws KeyManagerException {
            String password = null;
            if (params.isParameterPresent(Constants.Parameter.Password)) {
                password = params.getPassword();
            }
            return new DatabaseDescriptorImpl(params.getDatabaseName(), password, handler, type, DescriptorType.Source);
        }

        public static DatabaseDescriptor getDescriptor(DatabaseDescriptor descriptor, Constants.DatabaseType newType) throws KeyManagerException {
            return new DatabaseDescriptorImpl(descriptor, newType);
        }

        public static DatabaseDescriptor getTargetDescriptor(CommandParameters params, CallbackHandler handler, Constants.DatabaseType type) throws KeyManagerException {
            String password = null;
            if (params.isParameterPresent(Constants.Parameter.TargetPassword)) {
                password = params.getTargetPassword();
            }
            return new DatabaseDescriptorImpl(params.getTarget(), password, handler, type, DescriptorType.Target);
        }

        public static DatabaseDescriptor getSecondaryDescriptor(CommandParameters params, CallbackHandler handler) throws KeyManagerException {
            String password = null;
            if (params.isParameterPresent(Constants.Parameter.SecondaryDbPassword)) {
                password = params.getSecondaryDbPassword();
            }
            return new DatabaseDescriptorImpl(params.getSecondaryDb(), password, handler, params.getSecondaryDbType(), DescriptorType.Secondary);
        }

        public void setFileName(String name) {
            this.fileNameString = name;
            this.fileName = new FileName(name);
        }

        public void setType(Constants.DatabaseType newType) {
            this.type = newType;
        }

        public ParameterMap getDatabaseParameters(boolean isTarget) throws KeyManagerException {
            ParameterMap params = new ParameterMap();
            if (isTarget) {
                params.put(Constants.Parameter.Target, this.getFileNameString());
                params.put(Constants.Parameter.TargetPassword, this.getPassword());
                params.put(Constants.Parameter.TargetType, this.getType());
            } else {
                params.put(Constants.Parameter.DatabaseName, this.getFileNameString());
                params.put(Constants.Parameter.Password, this.getPassword());
                params.put(Constants.Parameter.Type, this.getType());
            }
            return params;
        }

        public String toString() {
            return Messages.getString("Label.Database") + " " + this.fileName;
        }

        public void setPassword(String newPassword) {
            this.password = newPassword;
        }

        public boolean allowsAction(Constants.CommandType action) {
            switch (action) {
                case ConvertDB: 
                case ChangeDBPassword: {
                    return true;
                }
                case StashDBPassword: 
                case DisplayDBPasswordExpiry: {
                    return false;
                }
            }
            return true;
        }

        public void setPassword(CommandParameters params) throws KeyManagerException {
            if (params.isParameterPresent(Constants.Parameter.NewPassword)) {
                this.password = params.getNewPassword();
            }
        }
    }

    public static interface DescriptorContainer
    extends DatabaseDescriptor {
        public DatabaseDescriptor getSecondaryDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DescriptorType {
        Source,
        Target,
        Secondary;


        public String toString() {
            return Messages.getString("Message." + this.name());
        }
    }

    public static interface PKCS11ImplDatabaseDescriptor
    extends DescriptorContainer {
        public String getName();

        public String getProvider();
    }

    public static interface PKCS11ImplDatabaseDescriptorConfig
    extends PKCS11ImplDatabaseDescriptor {
        public String getTokenLabel();
    }

    private static class PKCS11ImplDatabaseDescriptorConfigImpl
    extends AbstractPKCS11ImplDatabaseDescriptor
    implements PKCS11ImplDatabaseDescriptorConfig {
        private String tokenLabel;

        public PKCS11ImplDatabaseDescriptorConfigImpl(String fileName, String password, String tokenLabel, CallbackHandler handler, DatabaseDescriptor secondaryDb, DescriptorType descriptorType) throws KeyManagerException {
            super(fileName, password, handler, Constants.DatabaseType.PKCS11Config, secondaryDb, descriptorType);
            this.tokenLabel = tokenLabel;
        }

        public String getTokenLabel() {
            return this.tokenLabel;
        }

        public String getName() {
            return this.tokenLabel;
        }

        public static PKCS11ImplDatabaseDescriptorConfigImpl getDescriptor(CommandParameters params, CallbackHandler handler, DescriptorType descriptorType) throws KeyManagerException {
            String password;
            String fileName = params.getCrypto();
            String tokenLabel = params.getTokenLabel();
            try {
                password = params.getCryptoPassword();
            }
            catch (KeyManagerException e) {
                password = null;
            }
            DatabaseDescriptor secondary = null;
            if (params.isParameterPresent(Constants.Parameter.SecondaryDb)) {
                secondary = DatabaseDescriptorFactory.getDatabaseDescriptor(params, handler, DescriptorType.Secondary);
            }
            return new PKCS11ImplDatabaseDescriptorConfigImpl(fileName, password, tokenLabel, handler, secondary, descriptorType);
        }

        public ParameterMap getDatabaseParameters(boolean isTarget) throws KeyManagerException {
            ParameterMap params = super.getDatabaseParameters(isTarget);
            params.put(Constants.Parameter.TokenLabel, this.tokenLabel);
            params.put(Constants.Parameter.Crypto, this.getFileNameString());
            params.put(Constants.Parameter.TokenLabel, this.tokenLabel);
            if (isTarget) {
                params.put(Constants.Parameter.SecondPassword, this.getPassword());
                params.setTargetDescriptor(this);
            } else {
                params.put(Constants.Parameter.Password, this.getPassword());
                params.setSourceDescriptor(this);
            }
            return params;
        }

        public String toString() {
            return Messages.getString("Label.CryptoToken") + " " + this.tokenLabel;
        }

        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof PKCS11ImplDatabaseDescriptorConfigImpl) {
                return ((PKCS11ImplDatabaseDescriptorConfigImpl)o).tokenLabel == this.tokenLabel;
            }
            return false;
        }

        public int hashCode() {
            return this.getClass().hashCode() + this.tokenLabel.hashCode();
        }

        public String getProvider() {
            return super.getProvider() + "-" + this.tokenLabel;
        }
    }

    public static interface PKCS11ImplDatabaseDescriptorDirect
    extends PKCS11ImplDatabaseDescriptor {
        public int getSlotNumber();
    }

    private static class PKCS11ImplDatabaseDescriptorDirectImpl
    extends AbstractPKCS11ImplDatabaseDescriptor
    implements PKCS11ImplDatabaseDescriptorDirect {
        private int slotNumber;

        public PKCS11ImplDatabaseDescriptorDirectImpl(String fileName, String password, int slotNumber, CallbackHandler handler, DatabaseDescriptor secondaryDb, DescriptorType descriptorType) throws KeyManagerException {
            super(fileName, password, handler, Constants.DatabaseType.PKCS11Direct, secondaryDb, descriptorType);
            this.slotNumber = slotNumber;
        }

        public int getSlotNumber() {
            return this.slotNumber;
        }

        public String getName() {
            return MessageFormat.format(Messages.getString("Label.Slot"), this.slotNumber);
        }

        public static PKCS11ImplDatabaseDescriptorDirectImpl getDescriptor(CommandParameters params, CallbackHandler handler, DescriptorType descriptorType) throws KeyManagerException {
            String password;
            String fileName;
            if (params.getCrypto().trim().equals("")) {
                if (KeymanSettings.Setting.DefaultCryptoModule.getString().trim().equals("")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_CRYPTO_MODULE_SPECIFIED, KeymanSettings.Setting.DefaultCryptoModule.getPropertyKey());
                }
                fileName = KeymanSettings.Setting.DefaultCryptoModule.getString();
            } else {
                fileName = params.getCrypto();
            }
            int slotNumber = params.getRelativeSlotNumber();
            try {
                password = params.getCryptoPassword();
            }
            catch (KeyManagerException e) {
                password = null;
            }
            DatabaseDescriptor secondary = null;
            if (params.isParameterPresent(Constants.Parameter.SecondaryDb)) {
                secondary = DatabaseDescriptorFactory.getDatabaseDescriptor(params, handler, DescriptorType.Secondary);
            }
            return new PKCS11ImplDatabaseDescriptorDirectImpl(fileName, password, slotNumber, handler, secondary, descriptorType);
        }

        public ParameterMap getDatabaseParameters(boolean isTarget) throws KeyManagerException {
            ParameterMap params = new ParameterMap();
            params.put(Constants.Parameter.Crypto, this.getFileNameString());
            params.put(Constants.Parameter.RelativeSlotNumber, this.slotNumber);
            if (isTarget) {
                params.put(Constants.Parameter.SecondPassword, this.getPassword());
                params.setTargetDescriptor(this);
            } else {
                params.put(Constants.Parameter.Password, this.getPassword());
                params.setSourceDescriptor(this);
            }
            return params;
        }

        public String toString() {
            return Messages.getString("Label.CryptoToken") + " " + this.slotNumber;
        }

        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof PKCS11ImplDatabaseDescriptorDirectImpl) {
                return ((PKCS11ImplDatabaseDescriptorDirectImpl)o).slotNumber == this.slotNumber;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + this.slotNumber;
        }
    }

    public static interface PKCS12DatabaseDescriptor
    extends DatabaseDescriptor {
        public boolean isPfxFile();

        public boolean isUseStash();

        public void setStash(boolean var1);
    }

    private static class PKCS12DatabaseDescriptorImpl
    extends DatabaseDescriptorImpl
    implements PKCS12DatabaseDescriptor {
        private boolean isPfxFile;
        private boolean useStash = false;

        protected PKCS12DatabaseDescriptorImpl(String fileName, String password, CallbackHandler handler, boolean isPfx, DescriptorType descriptorType, Constants.DatabaseType type) throws KeyManagerException {
            super(fileName, password, handler, type, descriptorType);
            this.isPfxFile = isPfx;
        }

        public PKCS12DatabaseDescriptorImpl(DatabaseDescriptor descriptor, Constants.DatabaseType type) throws KeyManagerException {
            this(descriptor.getFileNameString(), descriptor.getPassword(), null, false, DescriptorType.Source, type);
        }

        public boolean isPfxFile() {
            return this.isPfxFile;
        }

        public static PKCS12DatabaseDescriptor getDescriptor(CommandParameters params, CallbackHandler handler, Constants.DatabaseType type) throws KeyManagerException {
            String fileName = params.isParameterPresent(Constants.Parameter.DatabaseName) ? params.getDatabaseName() : params.getFile();
            String password = null;
            if (params.isParameterPresent(Constants.Parameter.Password)) {
                password = params.getPassword();
            }
            boolean isPfx = params.isParameterPresent(Constants.Parameter.Pfx) && params.isPfx() || DatabaseDescriptorFactory.deriveDatabaseType(new FileName(fileName)) == Constants.DatabaseType.PFX;
            return new PKCS12DatabaseDescriptorImpl(fileName, password, handler, isPfx, DescriptorType.Source, type);
        }

        public static DatabaseDescriptor getTargetDescriptor(CommandParameters params, CallbackHandler handler, Constants.DatabaseType type) throws KeyManagerException {
            String fileName = params.getTarget();
            String password = null;
            if (params.isParameterPresent(Constants.Parameter.TargetPassword)) {
                password = params.getTargetPassword();
            }
            return new PKCS12DatabaseDescriptorImpl(fileName, password, handler, false, DescriptorType.Target, type);
        }

        public static PKCS12DatabaseDescriptor getDescriptor(DatabaseDescriptor descriptor, Constants.DatabaseType type) throws KeyManagerException {
            return new PKCS12DatabaseDescriptorImpl(descriptor, type);
        }

        public static PKCS12DatabaseDescriptor getSecondaryDescriptor(CommandParameters params, CallbackHandler handler, Constants.DatabaseType type) throws KeyManagerException {
            String password = null;
            if (params.isParameterPresent(Constants.Parameter.SecondaryDbPassword)) {
                password = params.getSecondaryDbPassword();
            }
            return new PKCS12DatabaseDescriptorImpl(params.getSecondaryDb(), password, handler, false, DescriptorType.Secondary, type);
        }

        public boolean allowsAction(Constants.CommandType action) {
            switch (action) {
                case StashDBPassword: {
                    return this.isPasswordProtected();
                }
            }
            return super.allowsAction(action);
        }

        protected void updateDescriptor(ParameterMap map) {
            super.updateDescriptor(map);
            if (map.containsKey(Constants.Parameter.StashPassword)) {
                this.useStash = (Boolean)map.get(Constants.Parameter.StashPassword);
            }
        }

        public void setStash(boolean value) {
            this.useStash = value;
        }

        public boolean isUseStash() {
            return this.useStash;
        }
    }
}

